function(add_cxx_compiler_flags)
  set(CMAKE_REQUIRED_QUIET true)
  include(CheckCXXCompilerFlag)
  set(flags ${CMAKE_CXX_FLAGS})
  foreach(flag ${ARGV})
    string(REGEX REPLACE "[^_A-Za-z0-9]" "_" stripped_flag "${flag}")
    set(var "CXX_COMPILER_FLAG_${stripped_flag}")
    check_cxx_compiler_flag("${flag}" "${var}")
    if(${var})
      set(flags "${flags} ${flag}")
    endif()
  endforeach()
  set(CMAKE_CXX_FLAGS ${flags} PARENT_SCOPE)
endfunction()
