WORK_NUMBERS: dict[str, dict[str, str]] = {
    "0001": {"001": "Argonautica", "002": "Fragmenta", "003": "Epigramma"},
    "0002": {
        "001": "Elegiae",
        "002": "Fragmenta sedis incertae",
        "003": "Fragmenta dubia",
        "004": "Epigrammata",
    },
    "0003": {"001": "Historiae", "002": "Epigramma"},
    "0004": {"001": "Vitae philosophorum", "002": "Epigrammata"},
    "0005": {
        "001": "Idyllia",
        "002": "Epigrammata",
        "003": "Syrinx",
        "004": "Fragmentum",
        "005": "Epigrammata",
    },
    "0006": {
        "001": "Fragmenta",
        "002": "Fragmenta papyracea",
        "003": "Epinicium in Alcibiadem (fragmenta)",
        "004": "Fragmenta Phaethontis",
        "005": "Fragmenta Antiopes",
        "006": "Fragmenta Alexandri",
        "007": "Fragmenta Hypsipyles",
        "008": "Fragmenta Phrixei (P. Oxy. 34.2685)",
        "009": "Fragmenta fabulae incertae",
        "010": "Fragmenta",
        "011": "Fragmenta Oenei",
        "012": "Epigrammata",
        "013": "Fragmenta Phaethontis incertae sedis",
        "014": "Fragmenta",
        "015": "Cyclops",
        "016": "Alcestis",
        "017": "Medea",
        "018": "Heraclidae",
        "019": "Hippolytus",
        "020": "Andromacha",
        "021": "Hecuba",
        "022": "Supplices",
        "023": "Electra",
        "024": "Hercules",
        "025": "Troiades",
        "026": "Iphigenia Taurica",
        "027": "Ion",
        "028": "Helena",
        "029": "Phoenisae",
        "030": "Orestes",
        "031": "Bacchae",
        "032": "Iphigenia Aulidensis",
        "033": "Rhesus",
    },
    "0007": {
        "001": "Theseus",
        "002": "Romulus",
        "003": "Comparatio Thesei et Romuli",
        "004": "Lycurgus",
        "005": "Numa",
        "006": "Comparatio Lycurgi et Numae",
        "007": "Solon",
        "008": "Publicola",
        "009": "Comparatio Solonis et Publicolae",
        "010": "Themistocles",
        "011": "Camillus",
        "012": "Pericles",
        "013": "Fabius Maximus",
        "014": "Comparatio Periclis et Fabii Maximi",
        "015": "Alcibiades",
        "016": "Marcius Coriolanus",
        "017": "Comparatio Alcibiadis et Marcii Coriolani",
        "018": "Timoleon",
        "019": "Aemilius Paullus",
        "020": "Comparatio Aemilii Paulli et Timoleontis",
        "021": "Pelopidas",
        "022": "Marcellus",
        "023": "Comparatio Pelopidae et Marcelli",
        "024": "Aristides",
        "025": "Cato Maior",
        "026": "Comparatio Aristidis et Catonis",
        "027": "Philopoemen",
        "028": "Titus Flamininus",
        "029": "Comparatio Philopoemenis et Titi Flaminini",
        "030": "Pyrrhus",
        "031": "Marius",
        "032": "Lysander",
        "033": "Sulla",
        "034": "Comparatio Lysandri et Sullae",
        "035": "Cimon",
        "036": "Lucullus",
        "037": "Comparatio Cimonis et Luculli",
        "038": "Nicias",
        "039": "Crassus",
        "040": "Comparatio Niciae et Crassi",
        "041": "Eumenes",
        "042": "Sertorius",
        "043": "Comparatio Eumenis et Sertorii",
        "044": "Agesilaus",
        "045": "Pompeius",
        "046": "Comparatio Agesilai et Pompeii",
        "047": "Alexander",
        "048": "Caesar",
        "049": "Phocion",
        "050": "Cato Minor",
        "051": "Agis et Cleomenes",
        "052": "Tiberius et Gaius Gracchus",
        "053": "Comparatio Agidis et Cleomenis cum Tiberio et Gaio Graccho",
        "054": "Demosthenes",
        "055": "Cicero",
        "056": "Comparatio Demosthenis et Ciceronis",
        "057": "Demetrius",
        "058": "Antonius",
        "059": "Comparatio Demetrii et Antonii",
        "060": "Dion",
        "061": "Brutus",
        "062": "Comparatio Dionis et Bruti",
        "063": "Aratus",
        "064": "Artaxerxes",
        "065": "Galba",
        "066": "Otho",
        "067": "De liberis educandis [Sp.] (1a-14c)",
        "068": "Quomodo adolescens poetas audire debeat (14d-37b)",
        "069": "De recta ratione audiendi (37b-48d)",
        "070": "Quomodo adulator ab amico internoscatur (48e-74e)",
        "071": "Quomodo quis suos in virtute sentiat profectus (75a-86a)",
        "072": "De capienda ex inimicis utilitate (86b-92f)",
        "073": "De amicorum multitudine (93a-97b)",
        "074": "De fortuna (97c-100a)",
        "075": "De virtute et vitio (100b-101e)",
        "076": "Consolatio ad Apollonium [Sp.] (101f-122a)",
        "077": "De tuenda sanitate praecepta (122b-137e)",
        "078": "Conjugalia praecepta (138a-146a)",
        "079": "Septem sapientium convivium (146b-164d)",
        "080": "De superstitione (164e-171f)",
        "081": "Regum et imperatorum apophthegmata [Sp.",
        "082": "Apophthegmata Laconica [Sp.",
        "083": "Mulierum virtutes (242e-263c)",
        "084": "Aetia Romana et Graeca (263d-304f)",
        "085": "Parallela minora [Sp.] (305a-316b)",
        "086": "De fortuna Romanorum (316c-326c)",
        "087": "De Alexandri magni fortuna aut virtute (326d-345b)",
        "088": "De gloria Atheniensium (345c-351b)",
        "089": "De Iside et Osiride (351c-384c)",
        "090": "De E apud Delphos (384d-394c)",
        "091": "De Pythiae oraculis (394d-409d)",
        "092": "De defectu oraculorum (409e-438d)",
        "093": "An virtus doceri possit (439a-440c)",
        "094": "De virtute morali (440d-452d)",
        "095": "De cohibenda ira (452f-464d)",
        "096": "De tranquillitate animi (464e-477f)",
        "097": "De fraterno amore (478a-492d)",
        "098": "De amore prolis (493a-497e)",
        "099": "An vitiositas ad infelicitatem sufficiat (498a-500a)",
        "100": "Animine an corporis affectiones sint peiores (500b-502a)",
        "101": "De garrulitate (502b-515a)",
        "102": "De curiositate (515b-523b)",
        "103": "De cupiditate divitiarum (523c-528b)",
        "104": "De vitioso pudore (528c-536d)",
        "105": "De invidia et odio (536e-538e)",
        "106": "De laude ipsius (539a-547f)",
        "107": "De sera numinis vindicta (548a-568a)",
        "108": "De fato [Sp.] (568b-574f)",
        "109": "De genio Socratis (575a-598f)",
        "110": "De exilio (599a-607f)",
        "111": "Consolatio ad uxorem (608a-612b)",
        "112": "Quaestiones convivales (612c-748d)",
        "113": "Amatorius (748e-771e)",
        "114": "Amatoriae narrationes [Sp.] (771e-775e)",
        "115": "Maxime cum principibus philosopho esse disserendum (776a-779c)",
        "116": "Ad principem ineruditum (779d-782f)",
        "117": "An seni respublica gerenda sit (783b-797f)",
        "118": "Praecepta gerendae reipublicae (798a-825f)",
        "119": "De unius in republica dominatione, populari statu, et paucorum imperio (826a-827c)",
        "120": "De vitando aere alieno (827d-832a)",
        "121": "Vitae decem oratorum [Sp.] (832b-852e)",
        "122": "Comparationis Aristophanis et Menandri compendium (853a-854d)",
        "123": "De Herodoti malignitate (854e-874c)",
        "124": "Aetia physica (911c-919e)",
        "125": "De facie in orbe lunae (920b-945e)",
        "126": "De primo frigido (945f-955c)",
        "127": "Aquane an ignis sit utilior [Sp.] (955d-958e)",
        "128": "De sollertia animalium (959a-985c)",
        "129": "Bruta animalia ratione uti (985d-992e)",
        "130": "De esu carnium i (993a-996c)",
        "131": "De esu carnium ii (996d-999b)",
        "132": "Platonicae quaestiones (999c-1011e)",
        "133": "De animae procreatione in Timaeo (1012b-1030c)",
        "134": "Epitome libri de animae procreatione in Timaeo (1030d-1032f)",
        "135": "De Stoicorum repugnantiis (1033a-1057b)",
        "136": "Stoicos absurdiora poetis dicere (1057c-1058e)",
        "137": "De communibus notitiis adversus Stoicos (1058e-1086b)",
        "138": "Non posse suaviter vivi secundum Epicurum (1086c-1107c)",
        "139": "Adversus Colotem (1107d-1127e)",
        "140": "De latenter vivendo (1128a-1130e)",
        "141": "De libidine et aegritudine",
        "142": "Parsne an facultas animi sit vita passiva",
        "143": "Fragmenta",
        "144": "Παροιμίαι αἷς Ἀλεξανδρεῖς ἐχρῶντο",
        "145": "Ἐκλογὴ περὶ τῶν ἀδυνάτων",
        "146": "Fragmenta",
        "147": "De proverbiis Alexandrinorum [Sp.]",
    },
    "0008": {
        "001": "Deipnosophistae",
        "002": "Fragmentum",
        "003": "Deipnosophistae (epitome)",
    },
    "0009": {
        "001": "Fragmenta",
        "002": "Epigrammata",
        "003": "Fragmenta",
        "004": "Fragmentis addenda",
    },
    "0010": {
        "001": "In Euthynum (orat. 21)",
        "002": "In Callimachum (orat. 18)",
        "003": "In Lochitem (orat. 20)",
        "004": "De bigis (orat. 16)",
        "005": "Trapeziticus (orat. 17)",
        "006": "Aegineticus (orat. 19)",
        "007": "Ad Demonicum (orat. 1)",
        "008": "In sophistas (orat. 13)",
        "009": "Helenae encomium (orat. 10)",
        "010": "Busiris (orat. 11)",
        "011": "Panegyricus (orat. 4)",
        "012": "Plataicus (orat. 14)",
        "013": "Ad Nicoclem (orat. 2)",
        "014": "Nicocles (orat. 3)",
        "015": "Evagoras (orat. 9)",
        "016": "Archidamus (orat. 6)",
        "017": "De pace (orat. 8)",
        "018": "Areopagiticus (orat. 7)",
        "019": "Antidosis (orat. 15)",
        "020": "Philippus (orat. 5)",
        "021": "Panathenaicus (orat. 12)",
        "022": "Ad Dionysium (epist. 1)",
        "023": "Ad filios Jasonis (epist. 6)",
        "024": "Ad Archidamum (epist. 9)",
        "025": "Ad reges Mytilenaeos (epist. 8)",
        "026": "Ad Timotheum (epist. 7)",
        "027": "Ad Philippum (epist. 2)",
        "028": "Ad Alexandrum (epist. 5)",
        "029": "Ad Antipatrum (epist. 4)",
        "030": "Ad Philippum (epist. 3)",
        "031": "Fragmenta",
    },
    "0011": {
        "001": "Trachiniae",
        "002": "Antigone",
        "003": "Ajax",
        "004": "Oedipus tyrannus",
        "005": "Electra",
        "006": "Philoctetes",
        "007": "Oedipus Coloneus",
        "008": "Fragmenta",
        "009": "Fragmenta",
        "010": "Fragmenta",
    },
    "0012": {"001": "Ilias", "002": "Odyssea", "003": "Epigrammata"},
    "0013": {
        "001": "Fragmenta hymni in Bacchum",
        "002": "In Cererem",
        "003": "In Apollinem (fort. auctore Cynaetho Chio)",
        "004": "In Mercurium",
        "005": "In Venerem",
        "006": "In Venerem",
        "007": "In Bacchum",
        "008": "In Martem",
        "009": "In Dianam",
        "010": "In Venerem",
        "011": "In Minervam",
        "012": "In Junonem",
        "013": "In Cererem",
        "014": "In matrem deorum",
        "015": "In Herculem",
        "016": "In Aesculapium",
        "017": "In Dioscuros",
        "018": "In Mercurium",
        "019": "In Pana",
        "020": "In Volcanum",
        "021": "In Apollinem",
        "022": "In Neptunum",
        "023": "In Jovem",
        "024": "In Vestam",
        "025": "In Musas et Apollinem",
        "026": "In Bacchum",
        "027": "In Dianam",
        "028": "In Minervam",
        "029": "In Vestam",
        "030": "In Tellurem matrem omnium",
        "031": "In Solem",
        "032": "In Lunam",
        "033": "In Dioscuros",
        "034": "Εἰς ξένους",
    },
    "0014": {
        "001": "Olynthiaca 1",
        "002": "Olynthiaca 2",
        "003": "Olynthiaca 3",
        "004": "Philippica 1",
        "005": "De pace",
        "006": "Philippica 2",
        "007": "De Halonneso",
        "008": "De Chersoneso",
        "009": "Philippica 3",
        "010": "Philippica 4 [Sp.]",
        "011": "In epistulam Philippi [Sp.]",
        "012": "[Philippi] epistula",
        "013": "Περὶ συντάξεως [Sp.]",
        "014": "Περὶ τῶν συμμοριῶν",
        "015": "De Rhodiorum libertate",
        "016": "Pro Megalopolitanis",
        "017": "Περὶ τῶν πρὸς Ἀλέξανδρον συνθηκῶν [Sp.]",
        "018": "De corona",
        "019": "De falsa legatione",
        "020": "Adversus Leptinem",
        "021": "In Midiam",
        "022": "Adversus Androtionem",
        "023": "In Aristocratem",
        "024": "In Timocratem",
        "025": "In Aristogitonem 1",
        "026": "In Aristogitonem 2",
        "027": "In Aphobum 1",
        "028": "In Aphobum 2",
        "029": "Contra Aphobum",
        "030": "Contra Onetorem 1",
        "031": "Contra Onetorem 2",
        "032": "Contra Zenothemin",
        "033": "Contra Apatourium [Sp.]",
        "034": "Contra Phormionem",
        "035": "Contra Lacritum [Sp.]",
        "036": "Pro Phormione",
        "037": "Contra Pantaenetum",
        "038": "Contra Nausimachum et Xenopeithea",
        "039": "Contra Boeotum 1",
        "040": "Contra Boeotum 2 [Sp.]",
        "041": "Contra Spudiam",
        "042": "Contra Phaenippum [Sp.]",
        "043": "Contra Macartatum [Sp.]",
        "044": "Contra Leocharem [Sp.]",
        "045": "In Stephanum 1",
        "046": "In Stephanum 2 [Sp.]",
        "047": "In Evergum et Mnesibulum [Sp.]",
        "048": "In Olympiodorum [Sp.]",
        "049": "Contra Timotheum [Sp.]",
        "050": "Contra Polyclem [Sp.]",
        "051": "De corona trierarchiae",
        "052": "Contra Callippum [Sp.]",
        "053": "Contra Nicostratum",
        "054": "In Cononem",
        "055": "Contra Calliclem",
        "056": "In Dionysodorum [Sp.]",
        "057": "Contra Eubulidem",
        "058": "In Theocrinem [Sp.]",
        "059": "In Neaeram [Sp.]",
        "060": "Epitaphius",
        "061": "Eroticus [Sp.]",
        "062": "Exordia",
        "063": "Epistulae",
        "064": "Fragmenta",
    },
    "0015": {"001": "Ab excessu divi Marci"},
    "0016": {"001": "Historiae"},
    "0017": {
        "001": "De Cleonymo",
        "002": "De Menecle",
        "003": "De Pyrrho",
        "004": "De Nicostrato",
        "005": "De Dicaeogene",
        "006": "De Philoctemone",
        "007": "De Apollodoro",
        "008": "De Cirone",
        "009": "De Astyphilo",
        "010": "De Aristarcho",
        "011": "De Hagnia",
        "012": "Pro Euphileto",
        "013": "Fragmenta",
    },
    "0018": {
        "001": "De opificio mundi",
        "002": "Legum allegoriarum libri i-iii",
        "003": "De cherubim",
        "004": "De sacrificiis Abelis et Caini",
        "005": "Quod deterius potiori insidiari soleat",
        "006": "De posteritate Caini",
        "007": "De gigantibus",
        "008": "Quod deus sit immutabilis",
        "009": "De agricultura",
        "010": "De plantatione",
        "011": "De ebrietate",
        "012": "De sobrietate",
        "013": "De confusione linguarum",
        "014": "De migratione Abrahami",
        "015": "Quis rerum divinarum heres sit",
        "016": "De congressu eruditionis gratia",
        "017": "De fuga et inventione",
        "018": "De mutatione nominum",
        "019": "De somniis (lib. i-ii)",
        "020": "De Abrahamo",
        "021": "De Josepho",
        "022": "De vita Mosis (lib. i-ii)",
        "023": "De decalogo",
        "024": "De specialibus legibus (lib. i-iv)",
        "025": "De virtutibus",
        "026": "De praemiis et poenis % De exsecrationibus",
        "027": "Quod omnis probus liber sit",
        "028": "De vita contemplativa",
        "029": "De aeternitate mundi",
        "030": "In Flaccum",
        "031": "Legatio ad Gaium",
        "032": "Hypothetica sive Apologia pro Judaeis",
        "033": "De providentia",
        "034": "Quaestiones in Genesim (fragmenta)",
        "035": "Quaestiones in Exodum (fragmenta)",
        "036": "De ebrietate ii",
        "037": "Περὶ ἀριθμῶν sive Ἀριθμητικά (fragmenta)",
        "038": "Fragmenta",
        "039": "De deo (P. Berol. inv. 17027)",
        "040": "Fragmenta incerti operis (P. Oxy. 18.2158)",
    },
    "0019": {
        "001": "Acharnenses",
        "002": "Equites",
        "003": "Nubes",
        "004": "Vespae",
        "005": "Pax",
        "006": "Aves",
        "007": "Lysistrata",
        "008": "Thesmophoriazusae",
        "009": "Ranae",
        "010": "Ecclesiazusae",
        "011": "Plutus",
        "012": "Fragmenta",
        "013": "Fragmenta",
        "014": "Fragmenta",
        "015": "Fragmenta",
        "016": "Fragmenta",
        "017": "Fragmenta",
        "018": "Fragmenta",
    },
    "0020": {
        "001": "Theogonia",
        "002": "Opera et dies",
        "003": "Scutum",
        "004": "Fragmenta",
        "005": "Testimonia",
        "006": "Fragmenta astronomica",
        "007": "Fragmenta",
        "008": "Fragmentum (ap. Maximum Tyrium)",
    },
    "0022": {
        "001": "Theriaca",
        "002": "Alexipharmaca",
        "003": "Fragmenta",
        "004": "Fragmenta",
        "005": "Epigrammata",
    },
    "0023": {"001": "Halieutica"},
    "0024": {"001": "Cynegetica"},
    "0026": {
        "001": "In Timarchum",
        "002": "De falsa legatione",
        "003": "In Ctesiphontem",
        "004": "Epistulae [Sp.]",
    },
    "0027": {
        "001": "De mysteriis",
        "002": "De reditu suo",
        "003": "De pace",
        "004": "In Alcibiadem [Sp.]",
        "005": "Fragmenta",
    },
    "0028": {
        "001": "In novercam",
        "002": "Tetralogia 1",
        "003": "Tetralogia 2",
        "004": "Tetralogia 3",
        "005": "De caede Herodis",
        "006": "De choreuta",
        "007": "Fragmenta",
        "008": "Fragmenta",
        "009": "Fragmenta",
    },
    "0029": {
        "001": "In Demosthenem",
        "002": "In Aristogitonem",
        "003": "In Philoclem",
        "004": "Fragmenta",
        "005": "Fragmenta incertae sedis",
    },
    "0030": {
        "001": "In Demosthenem",
        "002": "Pro Lycophrone",
        "003": "Pro Euxenippo",
        "004": "In Philippidem",
        "005": "In Athenogenem",
        "006": "Epitaphius",
        "007": "Fragmenta",
    },
    "0031": {
        "001": "Evangelium secundum Matthaeum",
        "002": "Evangelium secundum Marcum",
        "003": "Evangelium secundum Lucam",
        "004": "Evangelium secundum Joannem",
        "005": "Acta apostolorum",
        "006": "Epistula Pauli ad Romanos",
        "007": "Epistula Pauli ad Corinthios i",
        "008": "Epistula Pauli ad Corinthios ii",
        "009": "Epistula Pauli ad Galatas",
        "010": "Epistula Pauli ad Ephesios",
        "011": "Epistula Pauli ad Philippenses",
        "012": "Epistula Pauli ad Colossenses",
        "013": "Epistula Pauli ad Thessalonicenses i",
        "014": "Epistula Pauli ad Thessalonicenses ii",
        "015": "Epistula Pauli ad Timotheum i",
        "016": "Epistula Pauli ad Timotheum ii",
        "017": "Epistula Pauli ad Titum",
        "018": "Epistula Pauli ad Philemonem",
        "019": "Epistula Pauli ad Hebraeos",
        "020": "Epistula Jacobi",
        "021": "Epistula Petri i",
        "022": "Epistula Petri ii",
        "023": "Epistula Joannis i",
        "024": "Epistula Joannis ii",
        "025": "Epistula Joannis iii",
        "026": "Epistula Juda",
        "027": "Apocalypsis Joannis",
    },
    "0032": {
        "001": "Hellenica",
        "002": "Memorabilia",
        "003": "Oeconomicus",
        "004": "Symposium",
        "005": "Apologia Socratis",
        "006": "Anabasis",
        "007": "Cyropaedia",
        "008": "Hiero",
        "009": "Agesilaus",
        "010": "De republica Lacedaemoniorum",
        "011": "De vectigalibus",
        "012": "Hipparchicus",
        "013": "De re equestri",
        "014": "Cynegeticus",
        "015": "Atheniensium respublica [Sp.]",
    },
    "0033": {
        "001": "Olympia",
        "002": "Pythia",
        "003": "Nemea",
        "004": "Isthmia",
        "005": "Fragmenta",
    },
    "0034": {"001": "Oratio in Leocratem", "002": "Fragmenta"},
    "0035": {
        "001": "Eros drapeta",
        "002": "Europa",
        "003": "Epitaphius Bionis [Sp.]",
        "004": "Megara [Sp.]",
        "005": "Fragmenta",
        "006": "Epigrammata",
    },
    "0036": {
        "001": "Epitaphius Adonis",
        "002": "Epithalamium Achillis et Deidameiae [Sp.]",
        "003": "Fragmenta",
    },
    "0037": {"001": "Epistulae"},
    "0038": {"001": "Epistula"},
    "0039": {"001": "Epistula"},
    "0040": {"001": "Epistula"},
    "0041": {"001": "Epistulae"},
    "0042": {"001": "Epistulae"},
    "0043": {"001": "Epistulae"},
    "0044": {"001": "Epistulae"},
    "0045": {"001": "Epistulae"},
    "0046": {"001": "Epistula"},
    "0047": {"001": "Epistulae"},
    "0048": {"001": "Epistulae"},
    "0049": {"001": "Epistula"},
    "0050": {"001": "Epistulae"},
    "0051": {"001": "Fragmentum epistulae ad Clearetam"},
    "0052": {"001": "Epistula [Sp.]"},
    "0053": {"001": "Epistulae"},
    "0054": {"001": "Fragmenta"},
    "0055": {"001": "Epistulae"},
    "0056": {"001": "Epistula"},
    "0057": {
        "001": "Adhortatio ad artes addiscendas",
        "002": "De optima doctrina",
        "003": "Quod optimus medicus sit quoque philosophus",
        "004": "De sectis ad eos qui introducuntur",
        "005": "In Platonis Timaeum commentarii fragmenta (e cod. Paris. gr. 2838)",
        "006": "De constitutione artis medicae ad Patrophilum",
        "007": "Ars medica",
        "008": "De elementis ex Hippocrate libri ii",
        "009": "De temperamentis libri iii",
        "010": "De naturalibus facultatibus",
        "011": "De anatomicis administrationibus libri ix",
        "012": "De ossibus ad tirones",
        "013": "De venarum arteriarumque dissectione",
        "014": "De nervorum dissectione",
        "015": "De instrumento odoratus",
        "016": "De uteri dissectione",
        "017": "De usu partium",
        "018": "De motu musculorum libri ii",
        "019": "De victu attenuante",
        "020": "De utilitate respirationis liber",
        "021": "De semine libri ii",
        "022": "De foetuum formatione libellus",
        "023": "An in arteriis natura sanguis contineatur",
        "024": "De optima corporis nostri constitutione",
        "025": "De bono habitu liber",
        "026": "De propriis placitis fragmenta inedita",
        "027": "Quod animi mores corporis temperamenta sequantur",
        "028": "De propriorum animi cuiuslibet affectuum dignotione et curatione",
        "029": "De animi cuiuslibet peccatorum dignotione et curatione (",
        "030": "De atra bile",
        "031": "De usu pulsuum",
        "032": "De placitis Hippocratis et Platonis",
        "033": "Thrasybulus sive utrum medicinae sit an gymnasticae hygieine",
        "034": "De parvae pilae exercitio",
        "035": "De venereis (ap. Oribasium)",
        "036": "De sanitate tuenda libri vi",
        "037": "De alimentorum facultatibus libri iii",
        "038": "De rebus boni malique suci",
        "039": "De ptisana",
        "040": "De dignotione ex insomniis",
        "041": "De morborum differentiis",
        "042": "De causis morborum liber",
        "043": "De symptomatum differentiis liber",
        "044": "De symptomatum causis libri iii",
        "045": "De differentiis febrium libri ii",
        "046": "De morborum temporibus liber",
        "047": "De totius morbi temporibus liber",
        "048": "De typis liber",
        "049": "Adversus eos qui de typis scripserunt vel de circuitibus",
        "050": "De plenitudine liber",
        "051": "De tremore, palpitatione, convulsione et rigore liber",
        "052": "De comate secundum Hippocratem liber",
        "053": "De marcore liber",
        "054": "De tumoribus praeter naturam",
        "055": "De inaequali intemperie liber",
        "056": "De difficultate respirationis libri iii",
        "057": "De locis affectis libri vi",
        "058": "De pulsibus libellus ad tirones",
        "059": "De differentia pulsuum libri iv",
        "060": "De dignoscendis pulsibus libri iv",
        "061": "De causis pulsuum libri iv",
        "062": "De praesagitione ex pulsibus libri iv",
        "063": "Synopsis librorum suorum de pulsibus",
        "064": "De crisibus libri iii",
        "065": "De diebus decretoriis libri iii",
        "066": "De methodo medendi libri xiv",
        "067": "Ad Glauconem de medendi methodo libri ii",
        "068": "De venae sectione adversus Erasistratum",
        "069": "De venae sectione adversus Erasistrateos Romae degentes",
        "070": "De curandi ratione per venae sectionem",
        "071": "De hirundinibus, revulsione, cucurbitula, incisione et scarificatione",
        "072": "De purgantium medicamentorum facultate",
        "073": "Quos quibus catharticis medicamentis et quando purgare oporteat (ap. Oribasium)",
        "074": "Pro puero epileptico consilium",
        "075": "De simplicium medicamentorum temperamentis ac facultatibus libri xi",
        "076": "De compositione medicamentorum secundum locos libri x",
        "077": "De compositione medicamentorum per genera libri vii",
        "078": "De antidotis libri ii",
        "079": "De theriaca ad Pisonem",
        "080": "De septimestri partu",
        "081": "Institutio logica",
        "082": "De sophismatis seu captionibus penes dictionem",
        "083": "De praenotione ad Posthumum (Epigenem)",
        "084": "De substantia facultatum naturalium fragmentum (",
        "085": "In Hippocratis de natura hominis librum commentarii iii",
        "086": "In Hippocratis vel Polybi opus de salubri victus ratione privatorum commentarius (",
        "087": "In Hippocratis de victu acutorum commentaria iv",
        "088": "In Hippocratis prorrheticum i commentaria iii",
        "089": "In Hippocratis librum primum epidemiarum commentarii iii",
        "090": "In Hippocratis librum iii epidemiarum commentarii iii",
        "091": "In Hippocratis librum vi epidemiarum commentarii vi",
        "092": "In Hippocratis aphorismos commentarii vii",
        "093": "Adversus Lycum libellus",
        "094": "Adversus ea quae a Juliano in Hippocratis aphorismos enuntiata sunt libellus",
        "095": "In Hippocratis librum de articulis et Galeni in eum commentarii iv",
        "096": "De humero iis modis prolapso quos Hippocrates non vidit",
        "097": "In Platonis Timaeum commentarii fragmenta (e cod. Scorial. Φ III 11 [230 Revilla])",
        "098": "In Hippocratis prognosticum commentaria iii",
        "099": "In Hippocratis librum de fracturis commentarii iii",
        "100": "In Hippocratis librum de officina medici commentarii iii",
        "101": "De musculorum dissectione ad tirones",
        "102": "De consuetudinibus",
        "103": "De libris propriis liber",
        "104": "De ordine librorum suorum ad Eugenianum",
        "105": "Linguarum seu dictionum exoletarum Hippocratis explicatio",
        "106": "De experientia medica",
        "107": "Quod qualitates incorporeae sint",
        "108": "De causis respirationis",
        "109": "Quomodo morborum simulantes sint deprehendendi",
        "110": "De melancholia (ap. Aëtium)",
    },
    "0058": {"001": "Poliorcetica"},
    "0059": {
        "001": "Euthyphro",
        "002": "Apologia Socratis",
        "003": "Crito",
        "004": "Phaedo",
        "005": "Cratylus",
        "006": "Theaetetus",
        "007": "Sophista",
        "008": "Politicus",
        "009": "Parmenides",
        "010": "Philebus",
        "011": "Symposium",
        "012": "Phaedrus",
        "013": "Alcibiades i [Sp.]",
        "014": "Alcibiades ii [Sp.]",
        "015": "Hipparchus [Sp.]",
        "016": "Amatores [Sp.]",
        "017": "Theages [Sp.]",
        "018": "Charmides",
        "019": "Laches",
        "020": "Lysis",
        "021": "Euthydemus",
        "022": "Protagoras",
        "023": "Gorgias",
        "024": "Meno",
        "025": "Hippias major [Dub.]",
        "026": "Hippias minor",
        "027": "Ion",
        "028": "Menexenus",
        "029": "Clitophon [Dub.]",
        "030": "Respublica",
        "031": "Timaeus",
        "032": "Critias",
        "033": "Minos [Sp.]",
        "034": "Leges",
        "035": "Epinomis [Dub.] (fort. auctore Philippo Opuntio)",
        "036": "Epistulae [Dub.]",
        "037": "Definitiones [Sp.]",
        "038": "Spuria",
        "039": "Epigrammata",
        "040": "Fragmenta tragica",
        "041": "Epigrammata",
    },
    "0060": {
        "001": "Bibliotheca historica (lib. 1-20)",
        "002": "Fragmenta sedis incertae",
        "003": "Bibliotheca historica (lib. 21-40)",
    },
    "0061": {
        "001": "Asinus",
        "002": "Amores",
        "003": "Demosthenis encomium",
        "004": "Halcyon",
        "005": "Ocypus",
        "006": "Cynicus",
        "007": "Philopatris",
        "008": "Charidemus",
        "009": "Epigramma",
        "010": "Epigrammata",
    },
    "0062": {
        "001": "Phalaris",
        "002": "Hippias",
        "003": "Bacchus",
        "004": "Hercules",
        "005": "Electrum",
        "006": "Muscae encomium",
        "007": "Nigrinus",
        "008": "Demonax",
        "009": "De domo",
        "010": "Patriae encomium",
        "011": "Macrobii",
        "012": "Verae historiae",
        "013": "Calumniae non temere credendum",
        "014": "Lis consonantium (",
        "015": "Symposium",
        "016": "Cataplus",
        "017": "Juppiter confutatus",
        "018": "Juppiter tragoedus",
        "019": "Gallus",
        "020": "Prometheus",
        "021": "Icaromenippus",
        "022": "Timon",
        "023": "Charon sive contemplantes",
        "024": "Vitarum auctio",
        "025": "Revivescentes sive piscator",
        "026": "Bis accusatus sive tribunalia",
        "027": "De sacrificiis",
        "028": "Adversus indoctum et libros multos ementem",
        "029": "Somnium sive vita Luciani",
        "030": "De parasito sive artem esse parasiticam",
        "031": "Philopseudes sive incredulus",
        "032": "Dearum judicium",
        "033": "De mercede conductis potentium familiaribus",
        "034": "Anacharsis",
        "035": "Menippus sive necyomantia",
        "036": "De luctu",
        "037": "Rhetorum praeceptor",
        "038": "Alexander",
        "039": "Imagines",
        "040": "Pro imaginibus",
        "041": "De Syria dea",
        "042": "De morte Peregrini",
        "043": "Fugitivi",
        "044": "Toxaris vel amicitia",
        "045": "De saltatione",
        "046": "Lexiphanes",
        "047": "Eunuchus",
        "048": "De astrologia",
        "049": "Pseudologista",
        "050": "Deorum concilium",
        "051": "Tyrannicida",
        "052": "Abdicatus",
        "053": "Quomodo historia conscribenda sit",
        "054": "Dipsades",
        "055": "Saturnalia",
        "056": "Herodotus",
        "057": "Zeuxis",
        "058": "Pro lapsu inter salutandum",
        "059": "Apologia",
        "060": "Harmonides",
        "061": "Hesiodus",
        "062": "Scytha",
        "063": "Hermotimus",
        "064": "Prometheus es in verbis",
        "065": "Navigium",
        "066": "Dialogi mortuorum",
        "067": "Dialogi marini",
        "068": "Dialogi deorum",
        "069": "Dialogi meretricii",
        "070": "Soloecista",
        "071": "Podagra",
    },
    "0063": {
        "001": "Ars grammatica",
        "002": "Testimonium",
        "003": "Fragmentum",
        "004": "Fragmenta",
    },
    "0064": {"001": "Periplus Hannonis"},
    "0065": {"001": "Periplus Scylacis", "002": "Testimonia", "003": "Fragmenta"},
    "0066": {"001": "Fragmenta"},
    "0067": {
        "001": "De mari Erythraeo (excerpta)",
        "002": "Testimonia",
        "003": "Fragmenta",
        "004": "Fragmenta sedis incertae",
    },
    "0068": {
        "001": "Ad Nicomedem regem, vv. 1-980 (sub titulo Orbis descriptio)",
        "002": "Ad Nicomedem regem, vv. 722-1026",
    },
    "0069": {"001": "Descriptio Graeciae"},
    "0071": {"001": "Anonymi (Arriani, ut fertur) periplus maris Erythraei"},
    "0072": {
        "001": "Supplementa artis Dionysianae vetusta",
        "002": "Fragmentum grammaticum (P. Yale 1.25 [inv. 446]) (fort. epitome operis Comani)",
        "003": "Fragmentum grammaticum (P. Lit. Lond. 182 ",
        "004": "Fragmentum grammaticum (P. Heid. Siegmann 197 [inv. 1893])",
        "005": "Fragmentum grammaticum (PSI sine numero [inv. 505])",
        "006": "Fragmentum grammaticum (P. Brooklyn inv. 47.218.36)",
        "007": "Fragmentum grammaticum (P. Oslo 2.13)",
        "008": "Fragmentum grammaticum (P. Iand. 83a [inv. 664])",
        "009": "Fragmentum grammaticum (P. Harr. 59 [inv. 172b % 182h])",
        "010": "Fragmentum grammaticum (P. Heid. Siegmann 198 [inv. 201a])",
        "011": "Fragmentum grammaticum (P. Iand. 5.83 [inv. 555])",
        "012": "Fragmentum grammaticum (P. Amh. 2.21)",
        "013": "Fragmentum grammaticum (P. Ant. 2.68)",
        "014": "Fragmentum grammaticum (PSI 7.761)",
        "015": "Compendium catholicae Herodiani (P. Ant. 2.67)",
        "016": "Commentarium in anonymi opus περὶ κλίσεως ὀνομάτων (P. Oxy. 15.1801v)",
        "017": "Compendium Herodiani operis περὶ κλίσεως ὀνομάτων (P. Flor. inv. 3005)",
        "018": "De participiis (P. Rain. 1.19 [inv. 29772])",
        "019": "Fragmentum grammaticum (PSI 7.849)",
        "020": "Fragmentum grammaticum (P. Oxy. 3.469)",
        "021": "Fragmentum grammaticum (P. Iand. 1.5 [inv. 2])",
        "022": "Περὶ Αἰολίδος (",
    },
    "0074": {
        "001": "Alexandri anabasis",
        "002": "Historia Indica",
        "003": "Cynegeticus",
        "004": "Periplus ponti Euxini",
        "005": "Tactica",
        "006": "Acies contra Alanos",
        "007": "Fragmenta de rebus physicis",
        "008": "Epistula ad Lucium Gellium",
        "009": "Bithynicorum fragmenta",
        "010": "Parthicorum fragmenta",
        "011": "Historia successorum Alexandri (fragmenta ap. Photium, Bibl. cod. 92)",
        "012": "Fragmentum ex historia Alanica (",
        "013": "Fragmenta incerta (utrum e Parthicis an ex historia successorum Alexandri desumpta sint)",
        "014": "Fragmentum (PSI 12.1284)",
        "015": "Parthicorum fragmenta (ap. Joannem Lydum et Syncellum)",
        "016": "Historia successorum Alexandri (fragmenta ap. Photium, Bibl. cod. 82)",
        "017": "Testimonia",
        "018": "Fragmenta",
    },
    "0075": {"001": "Anonymi (Arriani, ut fertur) periplus ponti Euxini"},
    "0077": {"001": "Stadiasmus sive periplus Maris Magni"},
    "0079": {"001": "Fragmenta"},
    "0081": {
        "001": "Antiquitates Romanae",
        "002": "De antiquis oratoribus",
        "003": "De Lysia",
        "004": "De Isocrate",
        "005": "De Isaeo",
        "006": "De Demosthenis dictione",
        "007": "Libri secundi de antiquis oratoribus reliquiae",
        "008": "Ad Ammaeum",
        "009": "De Dinarcho",
        "010": "De Thucydide",
        "011": "De Thucydidis idiomatibus (epistula ad Ammaeum)",
        "012": "De compositione verborum",
        "013": "De compositione verborum (epitome)",
        "014": "De imitatione (fragmenta)",
        "015": "Epistula ad Pompeium Geminum",
        "016": "Ars rhetorica [Sp.]",
        "017": "Testimonium",
        "018": "Fragmenta",
    },
    "0082": {
        "001": "De pronominibus",
        "002": "De adverbiis",
        "003": "De conjunctionibus",
        "004": "De constructione",
    },
    "0083": {"001": "Titulus", "002": "Per Bosporum navigatio"},
    "0084": {
        "001": "Orbis descriptio",
        "002": "Lithiaca vel lithica (fragmenta)",
        "003": "Ixeuticon sive De aucupio (paraphrasis) (olim sub auctore Eutecnio)",
    },
    "0085": {
        "001": "Supplices",
        "002": "Persae",
        "003": "Prometheus vinctus",
        "004": "Septem contra Thebas",
        "005": "Agamemnon",
        "006": "Choephoroe",
        "007": "Eumenides",
        "008": "Fragmenta",
        "009": "Fragmentum",
        "010": "Epigrammata",
        "011": "Fragmenta",
    },
    "0086": {
        "001": "Analytica priora et posteriora",
        "002": "De anima",
        "003": "Ἀθηναίων πολιτεία",
        "004": "De audibilibus",
        "005": "De caelo",
        "006": "Categoriae",
        "007": "De coloribus",
        "008": "De divinatione per somnum",
        "009": "Ethica Eudemia",
        "010": "Ethica Nicomachea",
        "011": "Epistulae",
        "012": "De generatione animalium",
        "013": "De generatione et corruptione",
        "014": "Historia animalium",
        "015": "De incessu animalium",
        "016": "De insomniis",
        "017": "De interpretatione",
        "018": "De juventute et senectute % De vita et morte",
        "019": "De lineis insecabilibus",
        "020": "De longitudine et brevitate vitae",
        "021": "De motu animalium",
        "022": "Magna moralia",
        "023": "Mechanica",
        "024": "De memoria et reminiscentia",
        "025": "Metaphysica",
        "026": "Meteorologica",
        "027": "Mirabilium auscultationes",
        "028": "De mundo",
        "029": "Oeconomica",
        "030": "De partibus animalium",
        "031": "Physica",
        "032": "Physiognomonica",
        "033": "Protrepticus",
        "034": "Poetica",
        "035": "Politica",
        "036": "Problemata",
        "037": "De respiratione",
        "038": "Rhetorica",
        "039": "Sophistici elenchi",
        "040": "De sensu et sensibilibus",
        "041": "De somno et vigilia",
        "042": "De spiritu",
        "043": "Topica",
        "044": "De virtutibus et vitiis",
        "045": "De ventorum situ et nominibus",
        "046": "De Xenophane, de Zenone, de Gorgia",
        "047": "Divisiones Aristoteleae",
        "048": "Fragmenta",
        "049": "Fragmentum",
        "050": "Fragmenta varia",
        "051": "De anima (codicis E fragmenta recensionis a vulgata diversae)",
        "052": "De anima (codicis P lectiones quae valde a lectionibus ceterorum codicum distant)",
        "053": "Physicorum libri octavi textus alter (post 267b26)",
        "054": "Testimonia",
        "055": "Fragmenta",
    },
    "0087": {
        "001": "De prosodia catholica",
        "002": "De enclisi (epitome ap. Arcadium)",
        "003": "Περὶ κυρίων καὶ ἐπιθέτων καὶ προσηγορικῶν μονόβιβλον",
        "004": "Περὶ διχρόνων",
        "005": "Περὶ πνευμάτων",
        "006": "Περὶ Ἀττικῆς προσῳδίας",
        "007": "Περὶ Ἰλιακῆς προσῳδίας",
        "008": "Περὶ Ὀδυσσειακῆς προσῳδίας",
        "009": "Περὶ παθῶν",
        "010": "Περὶ συντάξεως τῶν στοιχείων",
        "011": "Περὶ ὀρθογραφίας",
        "012": "Περὶ ὀνομάτων",
        "013": "Περὶ κλίσεως ὀνομάτων",
        "014": "Εἰς τὸ περὶ γενῶν Ἀπολλωνίου ὑπόμνημα",
        "015": "Μονόβιβλον περὶ τοῦ ὕδωρ",
        "016": "Περὶ τοῦ ζώς",
        "017": "Περὶ συζυγιῶν",
        "018": "Μονόβιβλον περὶ τοῦ μὴ πάντα τὰ ῥήματα κλίνεσθαι εἰς πάντας τοὺς χρόνους",
        "019": "Περὶ μετοχῶν",
        "020": "Μονόβιβλον περὶ τοῦ ἦν",
        "021": "Περὶ ῥημάτων",
        "022": "Περὶ τῶν εἰς ",
        "023": "Περὶ ἀντωνυμιῶν",
        "024": "Περὶ ἐπιρρημάτων",
        "025": "De figuris (",
        "026": "Περὶ παρωνύμων",
        "027": "Περὶ ῥηματικῶν ὀνομάτων",
        "028": "Περὶ μονοσυλλάβων",
        "029": "Περὶ γάμου καὶ συμβιώσεως",
        "030": "Συμπόσιον",
        "031": "Προτάσεις",
        "032": "Εἰς τὴν Ἀπολλωνίου εἰσαγωγήν",
        "033": "Περὶ μονήρους λέξεως",
        "034": "Περὶ παθῶν (supplementum)",
        "035": "De figuris (",
        "036": "Partitiones (",
        "037": "Philetaerus [Sp.",
        "038": "De locutionum pravitatibus (posterior pars operis) [Sp.] (fort. auctore Corneliano) (e cod. Paris. suppl. gr. 123",
        "039": "Excerpta e Herodiano [Sp.] (e codd. Paris. gr. 2650 % 2662 % Paris. suppl. 70)",
        "040": "De versibus",
        "041": "Schematismi Homerici",
        "042": "Περὶ ἀριθμῶν (ap. Stephanum)",
        "043": "Περὶ αὐθυποτάκτων καὶ ἀνυποτάκτων",
        "044": "Περὶ σολοικισμοῦ καὶ βαρβαρισμοῦ",
        "045": "Περὶ παραγωγῶν γενικῶν ἀπὸ διαλέκτων (e cod. Barroc. 76)",
        "046": "Excerpta e Herodiano [Sp.] (e cod. Paris. gr. 2552)",
        "047": "De locutionum pravitatibus (prior pars operis) [Sp.] (fort. auctore Corneliano) (e codd. Barocc. 76 % Laur. VI-2",
        "048": "Περὶ λέξεως τῶν στίχων",
        "049": "Παρεκβολαὶ τοῦ μεγάλου ῥήματος",
        "050": "Fragmentum grammaticum quod incipit a vocibus ζητοῦμεν καὶ τὴν τοῦ Ἄρης [Sp.] (e cod. Barocc. 76)",
    },
    "0088": {
        "001": "Elementa harmonica",
        "002": "Elementa rhythmica (lib. 1)",
        "003": "Elementa rhythmica (lib. 2)",
        "004": "Fragmenta Parisina (e cod. bibl. imp. Par. 3027)",
        "005": "Fragmentum (P. Oxy. 1.9)",
        "006": "Fragmenta",
    },
    "0089": {"001": "Fragmenta"},
    "0090": {"001": "Geographiae informatio"},
    "0092": {"001": "Geographiae expositio compendiaria"},
    "0093": {
        "001": "Historia plantarum",
        "002": "De causis plantarum (lib. 1)",
        "003": "De sensu et sensibilibus (",
        "004": "De lapidibus (",
        "005": "De igne (",
        "006": "Metaphysica (",
        "007": "De pietate",
        "008": "Physicorum opiniones",
        "009": "Characteres",
        "010": "Fragmenta",
        "011": "De causis plantarum (lib. 2-6)",
        "012": "De eligendis magistratibus (fragmenta)",
    },
    "0094": {
        "001": "De fluviis",
        "002": "De musica (1131b-1147a)",
        "003": "Placita philosophorum (874d-911c)",
    },
    "0095": {
        "001": "Testimonia et fragmenta",
        "002": "De Platone (fort. auctore Hermodoro Syracusano)",
    },
    "0096": {
        "001": "Paroemiae",
        "002": "Fabulae",
        "003": "Fabulae tabulis ceratis Assendelftianis servatae",
        "004": "Fabulae Dosithei",
        "005": "Fabulae Libanii",
        "006": "Fabulae Aphthonii rhetoris",
        "007": "Fabulae Themistii rhetoris",
        "008": "Fabulae Theophylacti Simocattae scholastici",
        "009": "Fabulae Syntipae philosophi",
        "010": "Fabulae rhetoris anonymi Brancatiani",
        "011": "Fabula Nicephori",
        "012": "Fabulae (P. Ryl. 493)",
        "013": "Fabulae ap. Dionem Chrysostomum",
        "014": "Epigramma",
        "015": "Fabulae (dodecasyllabi)",
        "016": "Sententiae",
        "017": "Proverbia",
    },
    "0097": {
        "001": "Paroemiae (epitome operis sub nomine Diogeniani) (e cod. Mazarinco)",
        "002": "Paroemiae (epitome operis sub nomine Diogeniani) (e cod. Vindob. 133)",
    },
    "0098": {"001": "Epitome collectionum Lucilli Tarrhaei et Didymi"},
    "0099": {"001": "Geographica", "002": "Testimonia", "003": "Fragmenta"},
    "0116": {"001": "Fragmenta"},
    "0125": {"001": "Epistula"},
    "0127": {"001": "Epigramma"},
    "0131": {"001": "Epigramma", "002": "Fragmentum de Hieronis II navigio"},
    "0137": {"001": "Epigrammata", "002": "Fragmenta"},
    "0141": {"001": "Epigramma", "002": "Fragmenta"},
    "0146": {"001": "Epigramma", "002": "Titulus"},
    "0165": {"001": "Epigrammata", "002": "Titulus"},
    "0174": {"001": "Epigrammata", "002": "Fragmentum et titulus", "003": "Fragmentum"},
    "0186": {
        "001": "Ad Marcum Caesarem et invicem (lib. 1)",
        "002": "Ad Marcum Caesarem et invicem (lib. 2)",
        "003": "Ad amicos (lib. 1)",
        "004": "Additamentum epistularum variarum acephalum",
        "005": "Epigrammata",
    },
    "0197": {"001": "Fragmentum"},
    "0198": {"001": "Epigrammata", "002": "Fragmentum et titulus"},
    "0199": {
        "001": "Dithyrambi",
        "002": "Dithyramborum fragmenta",
        "003": "Epinicia",
        "004": "Epinicorum fragmenta",
        "005": "Hymnorum fragmenta",
        "006": "Paeanes (fragmenta)",
        "007": "Prosodia (fragmenta)",
        "008": "Partheneia (titulus solum)",
        "009": "Hyporchemata (fragmenta)",
        "010": "Erotica (fragmenta)",
        "011": "Encomia (fragmenta)",
        "012": "Fragmenta ex operibus incertis",
        "013": "Fragmenta dubia",
        "014": "Epigrammata",
    },
    "0200": {"001": "Mantissa proverbiorum"},
    "0201": {"001": "Fragmenta (IG 4.950)"},
    "0202": {"001": "Paean in Apollinem et Aesculapium (IG 3.1.171b)"},
    "0203": {"001": "Paean Delphicus ii et prosodium in Apollinem"},
    "0204": {"001": "Paean in Apollinem", "002": "Hymnus in Vestam"},
    "0205": {
        "001": "Paean in Dionysum",
        "002": "Paean in Dionysum (fragmenta incerti ordinis)",
    },
    "0206": {"001": "Ithyphalli"},
    "0207": {"001": "Ithyphalli"},
    "0208": {"001": "Βωμός", "002": "Epigramma"},
    "0209": {"001": "Ἱλαρὰ ᾄσματα"},
    "0210": {"001": "Priapeia"},
    "0211": {"001": "Fragmenta", "002": "Epigrammata"},
    "0212": {
        "001": "Fragmenta",
        "002": "Fragmenta poetica",
        "003": "Fragmenta grammatica",
        "004": "Fragmenta",
    },
    "0213": {"001": "Fragmenta", "002": "Testimonia", "003": "Fragmenta"},
    "0214": {"001": "Fragmenta"},
    "0215": {"001": "Epigrammata", "002": "Epigrammata"},
    "0216": {"001": "Fragmenta", "002": "Epigrammata", "003": "Fragmenta"},
    "0217": {"001": "Fragmentum"},
    "0218": {"001": "Fragmenta", "002": "Epigrammata"},
    "0219": {
        "001": "Fragmenta",
        "002": "Epigrammata",
        "003": "Fragmentum et titulus",
        "004": "Testimonia",
        "005": "Fragmenta",
        "006": "Fragmenta",
    },
    "0220": {"001": "Fragmenta", "002": "Epigrammata"},
    "0221": {"001": "Fragmenta", "002": "Fragmenta", "003": "Epigrammata"},
    "0222": {
        "001": "Catasterismi",
        "002": "Fragmenta",
        "003": "Fragmentum Eratosthenicum",
        "004": "Fragmenta",
        "005": "De circa exornatione stellarum et etymologia de quibus videntur",
    },
    "0227": {"001": "Hymnus Curetum"},
    "0228": {"001": "Hymnus in Dactylos Idaeos (IG 12.9.259)"},
    "0230": {"001": "Fragmenta lyrica"},
    "0231": {"001": "Fragmenta"},
    "0232": {"001": "Fragmenta", "002": "Fragmenta lyrica", "003": "Epigrammata"},
    "0233": {"001": "Fragmenta"},
    "0234": {"001": "Fragmenta"},
    "0235": {"001": "Fragmenta"},
    "0236": {"001": "Fragmentum"},
    "0237": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Epigrammata",
    },
    "0238": {"001": "Fragmenta"},
    "0239": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Epigramma",
        "004": "Fragmenta",
    },
    "0240": {"001": "Fragmentum"},
    "0241": {"001": "Fragmentum"},
    "0242": {"001": "Fragmentum elegiacum", "002": "Fragmenta epica"},
    "0243": {"001": "Fragmenta"},
    "0244": {"001": "Fragmenta"},
    "0245": {"001": "Fragmenta", "002": "Epigrammata"},
    "0246": {"001": "Fragmenta"},
    "0247": {"001": "Fragmenta"},
    "0248": {"001": "Fragmentum"},
    "0249": {"001": "Fragmentum"},
    "0250": {"001": "Fragmenta"},
    "0251": {"001": "Fragmenta"},
    "0252": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Fragmenta",
        "005": "Fragmentum (P. Oxy. 13.1611)",
    },
    "0253": {"001": "Margites (fragmenta)"},
    "0254": {"001": "Fragmentum", "002": "Titulus"},
    "0255": {"001": "Fragmenta", "002": "Epigramma", "003": "Fragmenta"},
    "0256": {"001": "Fragmenta"},
    "0257": {"001": "Fragmentum"},
    "0258": {"001": "Fragmentum"},
    "0259": {"001": "Fragmenta", "002": "Testimonia", "003": "Fragmentum"},
    "0260": {"001": "Fragmenta", "002": "Testimonia"},
    "0261": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Epigrammata",
        "004": "Testimonium",
        "005": "Fragmenta",
    },
    "0262": {"001": "Fragmenta"},
    "0263": {"001": "Fragmenta"},
    "0264": {"001": "Fragmentum", "002": "Fragmentum", "003": "Fragmentum"},
    "0265": {"001": "Fragmenta", "002": "Fragmenta", "003": "Epigramma"},
    "0266": {"001": "Fragmenta", "002": "Fragmenta"},
    "0267": {
        "001": "Fragmenta",
        "002": "Fragmenta (Silli et De natura)",
        "003": "Epigramma",
        "004": "Testimonium",
        "005": "Testimonia",
        "006": "Fragmenta",
    },
    "0268": {"001": "Fragmenta", "002": "Epigrammata"},
    "0269": {
        "001": "Fragmentum (P. Oxy. 3.425)",
        "002": "Ad Rhodios ventos (P. Oxy. 11.1383)",
    },
    "0271": {"001": "Fragmentum (P. Cairo inv. 67860)"},
    "0272": {"001": "Fragmenta (P. Heidelb. 222)"},
    "0273": {"001": "Fragmenta (P. Oxy. 15.1795)", "002": "Fragmenta (P. Oxy. 1.15)"},
    "0275": {"001": "Fragmentum (Brit. Mus. inv. 2208)"},
    "0276": {"001": "Fragmentum (Brit. Mus. inv. 2103)"},
    "0277": {"001": "Mirmillonis amatrix (P. Ryl. 1.15)"},
    "0278": {"001": "Fragmentum (P. Giss. 1.1)"},
    "0279": {"001": "Fragmentum (P. Med.)"},
    "0280": {"001": "Fragmentum"},
    "0281": {"001": "De piscibus fragmentum"},
    "0282": {"001": "Carminis de viribus herbarum fragmentum"},
    "0283": {"001": "Fragmenta", "002": "Fragmenta et titulus"},
    "0284": {
        "001": "Εἰς Δία",
        "002": "Ἀθηνᾶ",
        "003": "Ἰσθμικὸς εἰς Ποσειδῶνα",
        "004": "Διόνυσος",
        "005": "Ἡρακλῆς",
        "006": "Λαλιὰ εἰς Ἀσκληπιόν",
        "007": "Ἀσκληπιάδαι",
        "008": "Εἰς τὸν Σάραπιν",
        "009": "Εἰς βασιλέα [Sp.]",
        "010": "Ἀπελλᾶ γενεθλιακός",
        "011": "Εἰς Ἐτεωνέα ἐπικήδειος",
        "012": "Ἐπὶ Ἀλεξάνδρῳ ἐπιτάφιος",
        "013": "Παναθηναϊκός",
        "014": "Ῥώμης ἐγκώμιον",
        "015": "Σμυρναϊκὸς πολιτικός",
        "016": "Πανηγυρικὸς ἐν Κυζίκῳ περὶ τοῦ ναοῦ",
        "017": "Εἰς τὸ Αἰγαῖον πέλαγος",
        "018": "Εἰς τὸ φρέαρ τοῦ Ἀσκληπιοῦ",
        "019": "Ἐλευσίνιος",
        "020": "Μονῳδία ἐπὶ Σμύρνῃ",
        "021": "Παλινῳδία ἐπὶ Σμύρνῃ καὶ τῷ ταύτης ἀνοικισμῷ",
        "022": "Προσφωνητικός Σμυρναϊκός",
        "023": "Ἱεροὶ λόγοι α",
        "024": "Ἱεροὶ λόγοι β",
        "025": "Ἱεροὶ λόγοι γ",
        "026": "Ἱεροὶ λόγοι δ",
        "027": "Ἱεροὶ λόγοι ε",
        "028": "Ἱεροὶ λόγοι ς",
        "029": "Περὶ τοῦ πέμπειν βοήθειαν τοῖς ἐν Σικελίᾳ",
        "030": "Εἰς τὸ ἐναντίον",
        "031": "Ὑπὲρ τῆς πρὸς Λακεδαιμονίους εἰρήνης",
        "032": "Ὑπὲρ τῆς πρὸς Ἀθηναίους εἰρήνης",
        "033": "Λευκτρικὸς α",
        "034": "Λευκτρικὸς β",
        "035": "Λευκτρικὸς γ",
        "036": "Λευκτρικὸς δ",
        "037": "Λευκτρικὸς ε",
        "038": "Συμμαχικὸς α",
        "039": "Συμμαχικὸς β",
        "040": "Συμβουλευτικὸς περὶ τοῦ μὴ δεῖν κωμῳδεῖν",
        "041": "Ἐπιστολὴ περὶ Σμύρνης",
        "042": "Περὶ ὁμονοίας ταῖς πόλεσιν",
        "043": "Ῥοδιακός [Sp.]",
        "044": "Ῥοδίοις περὶ ὁμονοίας",
        "045": "Πρὸς Πλάτωνα περὶ ῥητορικῆς",
        "046": "Πρὸς Πλάτωνα ὑπὲρ τῶν τεττάρων",
        "047": "Πρὸς Καπίτωνα",
        "048": "Αἰγύπτιος",
        "049": "Περὶ τοῦ παραφθέγματος",
        "050": "Κατὰ τῶν ἐξορχουμένων",
        "051": "Πρὸς τοὺς αἰτιωμένους ὅτι μὴ μελετῴη",
        "052": "Πρεσβευτικὸς πρὸς Ἀχιλλέα",
        "053": "Πρὸς Δημοσθένη περὶ ἀτελείας",
        "054": "Πρὸς Λεπτίνην ὑπὲρ ἀτελείας",
        "055": "Πανηγυρικὸς ἐπὶ τῷ ὕδατι ἐν Περγάμῳ",
        "056": "Ars rhetorica [Sp.]",
        "057": "Fragmenta poetica",
    },
    "0286": {"001": "Fragmentum"},
    "0288": {"001": "Heraclea (fragmenta)", "002": "Epigramma"},
    "0289": {"001": "Fragmentum", "002": "Epigramma"},
    "0290": {"001": "Fragmentum (P. Berol. 9799)"},
    "0291": {"001": "Fragmenta", "002": "Fragmenta"},
    "0292": {"001": "Fragmenta", "002": "Fragmenta"},
    "0293": {"001": "Fragmenta", "002": "Fragmenta"},
    "0294": {"001": "Fragmenta"},
    "0295": {"001": "Fragmenta"},
    "0296": {"001": "Fragmenta"},
    "0297": {"001": "Fragmenta"},
    "0298": {
        "001": "Fragmentum",
        "002": "Fragmenta",
        "003": "Testimonia",
        "004": "Corinthiaca (fragmenta)",
        "005": "Fragmenta epica",
    },
    "0299": {
        "001": "Fragmenta (fort. auctore Terpandro)",
        "002": "Fragmentum (fort. auctore Terpandro)",
    },
    "0300": {"001": "Acta Alexandrinorum"},
    "0301": {"001": "Fragmenta"},
    "0302": {"001": "Fragmenta"},
    "0303": {"001": "Fragmenta"},
    "0304": {"001": "Acta et martyrium Apollonii"},
    "0305": {"001": "Fragmenta"},
    "0306": {"001": "Fragmenta"},
    "0307": {"001": "Fragmenta"},
    "0308": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Fragmentum",
        "005": "Tituli",
        "006": "Testimonia",
        "007": "Fragmenta",
        "008": "Testimonia",
        "009": "Fragmenta",
    },
    "0309": {"001": "Fragmenta"},
    "0310": {"001": "Fragmentum"},
    "0311": {"001": "Fragmenta"},
    "0312": {"001": "Fragmenta"},
    "0313": {"001": "Fragmentum"},
    "0314": {"001": "Fragmentum"},
    "0315": {"001": "Fragmentum", "002": "Fragmentum"},
    "0316": {"001": "Fragmentum"},
    "0317": {"001": "Acta Joannis", "002": "Acta Joannis (recensio)"},
    "0318": {"001": "Fragmenta"},
    "0319": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Testimonia",
        "004": "Fragmenta",
        "005": "Pirithous (fragmenta) (P. Oxy. 17.2078 % 50.3531)",
    },
    "0320": {"001": "Fragmentum"},
    "0321": {"001": "Fragmentum", "002": "Testimonium", "003": "Titulus"},
    "0322": {"001": "Fragmenta"},
    "0323": {"001": "Fragmenta"},
    "0324": {"001": "Fragmenta"},
    "0325": {"001": "Fragmenta"},
    "0326": {"001": "Fragmentum"},
    "0327": {"001": "Fragmenta"},
    "0328": {"001": "Fragmenta"},
    "0329": {"001": "Fragmenta"},
    "0330": {"001": "Fragmenta", "002": "Testimonium"},
    "0331": {"001": "Fragmentum"},
    "0332": {"001": "Fragmenta"},
    "0333": {"001": "Fragmentum"},
    "0334": {"001": "Fragmenta"},
    "0335": {"001": "Fragmentum"},
    "0336": {
        "001": "Fragmentum",
        "002": "Fragmenta",
        "003": "Epigrammata",
        "004": "Fragmenta et titulus",
    },
    "0337": {"001": "Fragmentum"},
    "0338": {"001": "Fragmenta"},
    "0339": {"001": "Fragmenta"},
    "0340": {"001": "Fragmenta"},
    "0341": {"001": "Fragmenta", "002": "Alexandra"},
    "0342": {"001": "Fragmenta"},
    "0343": {"001": "Ἐξαγωγή"},
    "0344": {"001": "Fragmentum"},
    "0345": {"001": "Fragmenta"},
    "0346": {"001": "Fragmentum"},
    "0347": {"001": "Fragmentum"},
    "0348": {"001": "Fragmentum"},
    "0349": {"001": "Fragmenta"},
    "0350": {"001": "Fragmentum"},
    "0351": {"001": "Fragmenta"},
    "0352": {"001": "Fragmenta"},
    "0353": {"001": "Fragmenta"},
    "0354": {"001": "Fragmentum"},
    "0355": {"001": "Fragmentum"},
    "0357": {"001": "Mensurae marmorum ac lignorum"},
    "0358": {
        "001": "Introductio arithmetica",
        "002": "Harmonicum enchiridion",
        "003": "Theologoumena arithmeticae",
        "004": "Excerpta",
    },
    "0359": {"001": "Hymni in Isim"},
    "0360": {"001": "Fragmenta"},
    "0361": {"001": "Introductio harmonica"},
    "0363": {
        "001": "Syntaxis mathematica",
        "002": "Phaseis",
        "003": "Hypotheses",
        "004": "Inscriptio Canobi",
        "005": "Προχείρων κανόνων διάταξις καὶ ψηφοφορία",
        "006": "De analemmate",
        "007": "Apotelesmatica (",
        "008": "De judicandi facultate et animi principatu",
        "009": "Geographia (lib. 1-3)",
        "010": "Harmonica",
        "011": "Musica",
        "012": "Fragmenta",
        "013": "Geographia (lib. 4-8)",
    },
    "0364": {"001": "Danaïs vel Danaïdes (fragmentum)"},
    "0365": {"001": "Fragmentum"},
    "0366": {"001": "Fragmentum", "002": "Tituli"},
    "0367": {"001": "Fragmentum"},
    "0368": {"001": "Fragmentum"},
    "0369": {"001": "Fragmenta"},
    "0370": {"001": "Fragmenta"},
    "0371": {"001": "Fragmenta"},
    "0372": {"001": "Fragmenta"},
    "0373": {"001": "Fragmenta"},
    "0374": {"001": "Fragmenta", "002": "Titulus"},
    "0375": {"001": "Fragmentum", "002": "Titulus"},
    "0376": {"001": "Fragmenta", "002": "Tituli"},
    "0377": {"001": "Fragmenta", "002": "Titulus"},
    "0378": {"001": "Fragmentum"},
    "0379": {"001": "Fragmenta", "002": "Tituli"},
    "0380": {"001": "Fragmenta", "002": "Fragmentum [Sp.]"},
    "0381": {"001": "Fragmenta"},
    "0382": {"001": "Fragmentum", "002": "Fragmenta"},
    "0383": {"001": "Fragmenta", "002": "Fragmentis addenda", "003": "Fragmenta"},
    "0384": {
        "001": "Acta Justini et septem sodalium (recensio A)",
        "002": "Acta Justini et septem sodalium (recensio B)",
        "003": "Acta Justini et septem sodalium (recensio C)",
    },
    "0385": {
        "001": "Historiae Romanae",
        "002": "Historiae Romanae (versio 1 in volumine 1)",
        "003": "Historiae Romanae (versio 1 in volumine 2)",
        "004": "Historiae Romanae (versio 1 in volumine 3)",
        "005": "Historiae Romanae (versio 2 in volumine 1)",
        "006": "Historiae Romanae (versio 2 in volumine 2)",
        "007": "Historiae Romanae (versio 2 in volumine 3)",
        "008": "Historiae Romanae (versio 3 in volumine 1)",
        "009": "Reliquiae incertae sedis",
        "010": "Historiae Romanae (Xiphilini epitome)",
        "011": "Historiae Romanae (Petri Patricii excerpta Vaticana sive Maiana)",
        "012": "Historiae Romanae (excerpta Planudea)",
        "013": "Historiae Romanae (Joannis Antiocheni excerpta e Dione derivata)",
        "014": "Historiae Romanae (excerpta Salmasiana)",
        "015": "Historiae Romanae (excerpta Constantiniana cum Dionis verbis composita)",
        "016": "Historiae Romanae (ap. Photium, Bibl. cod. 71)",
        "017": "Testimonia",
    },
    "0386": {"001": "Epistula"},
    "0387": {"001": "Fragmenta", "002": "Fragmenta"},
    "0388": {
        "001": "Acta Pauli",
        "002": "Martyrium Pauli",
        "003": "Pauli et Corinthiorum epistulae (P. Bodmer 10)",
        "004": "Acta Pauli et Theclae",
        "005": "Acta Pauli et Theclae (partis finalis recensio e codice G)",
    },
    "0389": {"001": "Martyrium Petri"},
    "0390": {"001": "Martyrium sanctorum Carpi, Papyli et Agathonicae"},
    "0391": {"001": "Acta Scillitanorum martyrum sive Passio Sperati et sociorum"},
    "0392": {
        "001": "Testimonia",
        "002": "Fragmenta",
        "003": "Testimonia",
        "004": "Fragmenta",
    },
    "0394": {"001": "Fragmenta"},
    "0395": {"001": "Fragmentum", "002": "Fragmenta"},
    "0396": {"001": "Fragmentum"},
    "0397": {"001": "Titulus"},
    "0398": {"001": "Fragmentum", "002": "Fragmentum"},
    "0399": {"001": "Fragmenta", "002": "Tituli"},
    "0400": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmentum",
        "004": "Fragmentum",
    },
    "0401": {"001": "Fragmenta", "002": "Fragmenta"},
    "0402": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmentum",
        "004": "Tituli",
        "005": "Fragmenta",
        "006": "Fragmenta",
    },
    "0403": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmentum",
        "004": "Tituli",
    },
    "0404": {"001": "Fragmenta", "002": "Fragmenta"},
    "0405": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmentum",
        "004": "Fragmentum",
    },
    "0406": {"001": "Fragmenta", "002": "Fragmenta"},
    "0407": {"001": "Fragmenta", "002": "Fragmenta"},
    "0408": {"001": "Fragmenta incertorum poetarum", "002": "Fragmenta"},
    "0409": {"001": "Fragmenta", "002": "Fragmenta"},
    "0410": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Fragmenta",
        "005": "Fragmenta",
    },
    "0411": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmentum",
        "004": "Fragmentum",
    },
    "0412": {"001": "Fragmenta", "002": "Fragmenta"},
    "0413": {"001": "Fragmenta", "002": "Fragmenta"},
    "0414": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmentum",
        "004": "Tituli",
    },
    "0415": {"001": "Fragmenta", "002": "Fragmenta", "003": "Tituli"},
    "0416": {"001": "Fragmenta", "002": "Fragmenta"},
    "0417": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Tituli",
    },
    "0418": {"001": "Fragmenta", "002": "Fragmenta"},
    "0419": {"001": "Fragmenta", "002": "Fragmenta", "003": "Tituli"},
    "0420": {"001": "Fragmenta", "002": "Fragmenta"},
    "0421": {"001": "Fragmenta", "002": "Fragmenta"},
    "0422": {"001": "Fragmentum", "002": "Fragmentum"},
    "0423": {"001": "Fragmenta", "002": "Fragmenta", "003": "Titulus"},
    "0424": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0425": {"001": "Fragmenta", "002": "Fragmenta"},
    "0426": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Titulus",
        "005": "Fragmenta",
    },
    "0427": {"001": "Fragmenta", "002": "Fragmentum"},
    "0428": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Titulus",
    },
    "0429": {"001": "Fragmenta", "002": "Fragmenta"},
    "0430": {"001": "Fragmentum", "002": "Fragmentum"},
    "0431": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0432": {"001": "Fragmenta", "002": "Fragmenta"},
    "0433": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Fragmentum",
        "005": "Fragmenta",
    },
    "0434": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Fragmenta",
        "005": "Fragmenta",
        "006": "Fragmenta",
    },
    "0435": {"001": "Fragmenta", "002": "Fragmenta"},
    "0436": {"001": "Fragmenta", "002": "Fragmenta"},
    "0437": {"001": "Fragmenta", "002": "Fragmenta"},
    "0438": {"001": "Fragmenta", "002": "Fragmenta"},
    "0439": {"001": "Fragmenta", "002": "Fragmenta", "003": "Tituli"},
    "0440": {"001": "Fragmentum", "002": "Fragmentum"},
    "0441": {"001": "Fragmentum", "002": "Fragmentum"},
    "0442": {"001": "Fragmentum", "002": "Fragmentum"},
    "0443": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmentum",
        "004": "Fragmenta",
    },
    "0444": {"001": "Fragmenta", "002": "Fragmenta"},
    "0445": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0446": {"001": "Fragmenta", "002": "Fragmenta"},
    "0447": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmenta"},
    "0448": {"001": "Fragmenta", "002": "Fragmenta"},
    "0449": {"001": "Fragmenta", "002": "Fragmenta", "003": "Titulus"},
    "0450": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0451": {"001": "Fragmenta", "002": "Fragmenta"},
    "0452": {"001": "Fragmenta", "002": "Fragmenta"},
    "0453": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0454": {"001": "Fragmenta", "002": "Fragmenta"},
    "0455": {"001": "Fragmenta", "002": "Fragmenta"},
    "0456": {"001": "Fragmentum", "002": "Fragmenta"},
    "0457": {"001": "Fragmentum", "002": "Fragmentum"},
    "0458": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Titulus",
        "005": "Fragmentum",
        "006": "Fragmentum",
    },
    "0459": {"001": "Fragmentum", "002": "Fragmentum"},
    "0460": {"001": "Fragmenta", "002": "Fragmenta"},
    "0461": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Fragmenta",
        "005": "Fragmenta",
    },
    "0462": {"001": "Fragmenta", "002": "Fragmenta"},
    "0463": {"001": "Fragmentum", "002": "Fragmentum", "003": "Fragmentum"},
    "0464": {"001": "Fragmenta", "002": "Fragmenta"},
    "0465": {"001": "Fragmenta", "002": "Fragmenta"},
    "0466": {"001": "Fragmentum", "002": "Fragmentum"},
    "0467": {"001": "Tituli"},
    "0468": {"001": "Fragmenta", "002": "Fragmenta"},
    "0469": {"001": "Fragmenta", "002": "Fragmenta"},
    "0470": {"001": "Fragmentum", "002": "Fragmentum", "003": "Fragmentum"},
    "0471": {"001": "Fragmentum", "002": "Fragmentum"},
    "0472": {"001": "Fragmenta", "002": "Fragmenta", "003": "Titulus"},
    "0473": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmenta"},
    "0474": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0475": {"001": "Fragmenta", "002": "Fragmenta"},
    "0476": {"001": "Fragmenta", "002": "Fragmenta"},
    "0477": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0478": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0479": {"001": "Fragmentum", "002": "Fragmentum"},
    "0480": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmenta"},
    "0481": {"001": "Fragmenta", "002": "Fragmentum"},
    "0482": {"001": "Fragmenta", "002": "Fragmenta"},
    "0483": {"001": "Fragmenta", "002": "Fragmenta"},
    "0484": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmentum",
        "004": "Titulus",
        "005": "Fragmenta",
    },
    "0485": {"001": "Fragmenta", "002": "Fragmenta"},
    "0486": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Fragmentum",
        "005": "Fragmentum",
        "006": "Fragmenta",
    },
    "0487": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Fragmenta",
        "005": "Titulus",
        "006": "Fragmentum",
        "007": "Epigramma",
        "008": "Fragmenta",
    },
    "0488": {"001": "Fragmenta", "002": "Fragmenta"},
    "0489": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0490": {"001": "Fragmenta", "002": "Fragmenta"},
    "0491": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0492": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmenta"},
    "0493": {"001": "Fragmentum", "002": "Fragmentum"},
    "0494": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Titulus",
    },
    "0495": {"001": "Fragmenta", "002": "Fragmenta", "003": "Titulus"},
    "0496": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Tituli",
        "005": "Fragmentum",
    },
    "0497": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Fragmenta",
        "005": "Epigramma",
        "006": "Fragmentum",
        "007": "Fragmenta",
    },
    "0498": {"001": "Fragmenta", "002": "Fragmenta"},
    "0499": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0500": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0501": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Titulus",
    },
    "0502": {"001": "Fragmenta", "002": "Fragmenta"},
    "0503": {"001": "Fragmenta", "002": "Fragmenta"},
    "0504": {"001": "Fragmentum", "002": "Fragmentum"},
    "0505": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0506": {"001": "Fragmentum", "002": "Fragmentum"},
    "0507": {"001": "Fragmentum", "002": "Fragmentum", "003": "Fragmentum"},
    "0508": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Fragmenta",
        "005": "Fragmenta",
    },
    "0509": {"001": "Epistula ad Phyllidem"},
    "0510": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmenta"},
    "0511": {"001": "Fragmenta", "002": "Fragmenta", "003": "Titulus"},
    "0512": {"001": "Fragmenta", "002": "Fragmenta"},
    "0513": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Titulus",
    },
    "0514": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmentum"},
    "0515": {
        "001": "Fragmenta",
        "002": "Fragmenta",
        "003": "Fragmenta",
        "004": "Fragmentum",
    },
    "0516": {"001": "Fragmenta", "002": "Tituli", "003": "Fragmenta"},
    "0517": {"001": "Fragmenta", "002": "Fragmenta"},
    "0518": {"001": "Fragmenta", "002": "Fragmenta"},
    "0519": {"001": "Fragmentum", "002": "Fragmentum"},
    "0520": {"001": "Fragmentum"},
    "0521": {
        "001": "Fragmenta Epicharmi",
        "002": "Fragmenta Pseudepicharmea",
        "003": "Fragmenta",
        "004": "Fragmenta Epicharmi",
        "005": "Fragmenta Pseudepicharmea",
        "006": "Fragmentum Epicharmi",
        "007": "Testimonia",
        "008": "Fragmenta",
    },
    "0522": {"001": "Fragmenta"},
    "0523": {"001": "Titulus", "002": "Titulus", "003": "Fragmentum"},
    "0524": {"001": "Fragmenta", "002": "Fragmenta"},
    "0525": {"001": "Graeciae descriptio"},
    "0526": {
        "001": "Antiquitates Judaicae",
        "002": "Josephi vita",
        "003": "Contra Apionem (",
        "004": "De bello Judaico libri vii",
    },
    "0527": {
        "001": "Genesis",
        "002": "Exodus",
        "003": "Leviticus",
        "004": "Numeri",
        "005": "Deuteronomium",
        "006": "Josue (Cod. Vaticanus % Cod. Alexandrinus)",
        "007": "Josue (Cod. Alexandrinus)",
        "008": "Judices (Cod. Alexandrinus)",
        "009": "Judices (Cod. Vaticanus)",
        "010": "Ruth",
        "011": "Regnorum i (Samuelis i in textu Masoretico)",
        "012": "Regnorum ii (Samuelis ii in textu Masoretico)",
        "013": "Regnorum iii (Regum i in textu Masoretico)",
        "014": "Regnorum iv (Regum ii in textu Masoretico)",
        "015": "Paralipomenon i sive Chronicon i",
        "016": "Paralipomenon ii sive Chronicon ii",
        "017": "Esdras i (liber apocryphus)",
        "018": "Esdras ii (Ezra et Nehemias in textu Masoretico)",
        "019": "Esther",
        "020": "Judith",
        "021": "Tobias (Cod. Vaticanus % Cod. Alexandrinus)",
        "022": "Tobias (Cod. Sinaiticus)",
        "023": "Machabaeorum i",
        "024": "Machabaeorum ii",
        "025": "Machabaeorum iii",
        "026": "Machabaeorum iv",
        "027": "Psalmi",
        "028": "Odae",
        "029": "Proverbia",
        "030": "Ecclesiastes",
        "031": "Canticum",
        "032": "Job",
        "033": "Sapientia Salomonis",
        "034": "Ecclesiasticus sive Siracides (Sapientia Jesu filii Sirach)",
        "035": "Psalmi Salomonis",
        "036": "Osee",
        "037": "Amos",
        "038": "Michaeas",
        "039": "Joel",
        "040": "Abdias",
        "041": "Jonas",
        "042": "Nahum",
        "043": "Habacuc",
        "044": "Sophonias",
        "045": "Aggaeus",
        "046": "Zacharias",
        "047": "Malachias",
        "048": "Isaias",
        "049": "Jeremias",
        "050": "Baruch",
        "051": "Threni seu Lamentationes",
        "052": "Epistula Jeremiae",
        "053": "Ezechiel",
        "054": "Susanna (translatio Graeca)",
        "055": "Susanna (Theodotionis versio)",
        "056": "Daniel (translatio Graeca)",
        "057": "Daniel (Theodotionis versio)",
        "058": "Bel et Draco (translatio Graeca)",
        "059": "Bel et Draco (Theodotionis versio)",
    },
    "0528": {
        "001": "De placitis reliquiae (Stobaei excerpta)",
        "002": "De placitis reliquiae (Theodoreti et Nemesii excerpta)",
    },
    "0529": {
        "001": "Physica (fragmenta)",
        "002": "Liber de philosophorum sectis (epitome ap. Stobaeum)",
    },
    "0530": {
        "001": "De causa affectionum",
        "002": "An animal sit quod est in utero",
        "003": "Λέξεις βοτανῶν",
        "004": "De fasciis liber",
        "005": "Ad Gaurum quomodo animetur fetus",
        "006": "De humoribus liber",
        "007": "Introductio seu medicus",
        "008": "De partibus philosophiae",
        "009": "De ponderibus et mensuris",
        "010": "Praesagitio omnino vera expertaque",
        "011": "Prognostica de decubitu ex mathematica scientia",
        "012": "De pulsibus ad Antonium disciplinae studiosum ac philosophum",
        "013": "De remediis parabilibus libri iii",
        "014": "De succedaneis liber",
        "015": "De theriaca ad Pamphilianum",
        "016": "De urinis",
        "017": "De urinis compendium",
        "018": "De urinis ex Hippocrate, Galeno et aliis quibusdam",
        "019": "De venae sectione",
        "020": "De victus ratione in morbis acutis ex Hippocratis sententia liber",
        "021": "Definitiones medicae",
        "022": "De historia philosophica",
        "023": "De optima secta ad Thrasybulum liber",
        "024": "De affectuum renibus insidentium dignotione et curatione liber",
        "025": "De signis ex urinis (fort. auctore Magno Emeseno)",
    },
    "0531": {"001": "Irrisio gentilium philosophorum"},
    "0532": {"001": "Leucippe et Clitophon"},
    "0533": {
        "001": "Epigrammata",
        "002": "Epigrammata",
        "003": "Fragmenta et titulus",
        "004": "Aetia",
        "005": "Iambi",
        "006": "Lyrica",
        "007": "Hecala",
        "008": "Carmina epica et elegiaca minora",
        "009": "Epigrammatum fragmenta",
        "010": "Fragmenta grammatica",
        "011": "Fragmenta incertae sedis",
        "012": "Fragmenta incerti auctoris (fort. auctore Callimacho)",
        "013": "In Jovem (hymn. 1)",
        "014": "In Apollinem (hymn. 2)",
        "015": "In Dianam (hymn. 3)",
        "016": "In Delum (hymn. 4)",
        "017": "In lavacrum Palladis (hymn. 5)",
        "018": "In Cererem (hymn. 6)",
    },
    "0534": {
        "001": "Testimonia",
        "002": "Fragmenta",
        "003": "Testimonium et fragmentum",
    },
    "0535": {"001": "Fragmenta", "002": "Testimonium", "003": "Fragmentum"},
    "0536": {"001": "Testimonia", "002": "Fragmenta", "003": "Fragmenta"},
    "0537": {
        "001": "Epistula ad Herodotum",
        "002": "Epistula ad Pythoclem",
        "003": "Epistula ad Menoeceum",
        "004": "Ratae sententiae",
        "005": "Gnomologium Vaticanum Epicureum",
        "006": "Deperditorum librorum reliquiae",
        "007": "Epistularum fragmenta",
        "008": "Incertae sedis fragmenta",
    },
    "0538": {"001": "Testimonia", "002": "Fragmenta", "003": "Fragmenta"},
    "0539": {
        "001": "Testimonia",
        "002": "Fragmenta",
        "003": "Fragmentum (P. Oxy. 26.2442)",
    },
    "0540": {
        "001": "De caede Eratosthenis",
        "002": "Epitaphius [Sp.]",
        "003": "Contra Simonem",
        "004": "Περὶ τραύματος ἐκ προνοίας ὑπὲρ οὗ καὶ πρὸς ὃν ",
        "005": "Pro Callia",
        "006": "In Andocidem [Sp.]",
        "007": "Areopagiticus",
        "008": "Κατηγορία πρὸς τοὺς συνουσιαστὰς κακολογιῶν [Sp.]",
        "009": "Pro milite [Sp.]",
        "010": "In Theomnestum 1",
        "011": "In Theomnestum 2 [Sp.]",
        "012": "In Eratosthenem",
        "013": "In Agoratum",
        "014": "In Alcibiadem 1",
        "015": "In Alcibiadem 2",
        "016": "Pro Mantitheo",
        "017": "Πρὸς τὸ δημόσιον περὶ τῶν Ἐράτωνος χρημάτων",
        "018": "Περὶ τῆς δημεύσεως ",
        "019": "Ὑπὲρ τῶν Ἀριστοφάνους χρημάτων, πρὸς τὸ δημόσιον",
        "020": "Pro Polystrato [Sp.]",
        "021": "Ἀπολογία δωροδοκίας ἀπαράσημος",
        "022": "Κατὰ τῶν σιτοπωλῶν",
        "023": "In Pancleonem",
        "024": "[Δήμου καταλύσεως] ἀπολογία",
        "025": "In Epicratem",
        "026": "In Ergoclem",
        "027": "In Philocratem",
        "028": "In Nicomachum",
        "029": "In Philonem",
        "030": "In Diogitonem",
        "031": "Olympiacus",
        "032": "Περὶ τοῦ μὴ καταλῦσαι τὴν πάτριον πολιτείαν Ἀθήνησι",
        "033": "Fragmenta",
        "034": "Fragmenta",
    },
    "0541": {
        "001": "Aspis",
        "002": "Aspidis fragmenta aliunde nota",
        "003": "Georgus",
        "004": "Georgi fragmenta aliunde nota",
        "005": "Dis exapaton",
        "006": "Dis exapatontis fragmenta aliunde nota",
        "007": "Dyscolus",
        "008": "Epitrepontum fragmenta",
        "009": "Epitrepontes",
        "010": "Heros",
        "011": "Herois fragmenta aliunde nota",
        "012": "Theophorumene",
        "013": "Theophorumenae fragmentum dubium",
        "014": "Theophorumenae fragmenta aliunde nota",
        "015": "Carchedonius",
        "016": "Carchedonii fragmenta aliunde nota",
        "017": "Citharista",
        "018": "Citharistae fragmenta aliunde nota",
        "019": "Colax",
        "020": "Colacis fragmenta aliunde nota",
        "021": "Coneazomenae",
        "022": "Coneazomenarum fragmentum aliunde notum",
        "023": "Misumenus",
        "024": "Misumeni fragmenta",
        "025": "Periciromene",
        "026": "Periciromenae fragmenta aliunde nota",
        "027": "Perinthia",
        "028": "Perinthiae fragmenta aliunde nota",
        "029": "Samia",
        "030": "Samiae fragmentum aliunde notum",
        "031": "Sicyonius",
        "032": "Sicyonii fragmenta aliunde nota",
        "033": "Phasma",
        "034": "Fabula incerta",
        "035": "Fragmentum dubium (P. Oxy. 31.2533)",
        "036": "Fragmenta longiora apud alios auctores servata",
        "037": "Fragmenta",
        "038": "Misumeni nova fragmenta",
        "039": "Fragmenta",
        "040": "Fragmenta",
        "041": "Fragmenta",
        "042": "Sententiae e codicibus Byzantinis",
        "043": "Epigrammata",
        "044": "Fragmenta",
        "045": "Epigramma",
        "046": "Sententiae",
        "047": "Sententiae e papyris",
        "048": "Fragmenta",
    },
    "0542": {"001": "Onomasticon"},
    "0543": {
        "001": "Historiae",
        "002": "Fragmenta ex incertis libris",
        "003": "Testimonium",
    },
    "0544": {"001": "Pyrrhoniae hypotyposes", "002": "Adversus mathematicos"},
    "0545": {
        "001": "De natura animalium",
        "002": "Varia historia",
        "003": "Epistulae rusticae",
        "004": "Fragmenta",
        "005": "Titulus",
    },
    "0546": {"001": "Tactica"},
    "0547": {
        "001": "Ars rhetorica vulgo Rhetorica ad Alexandrum",
        "002": "Testimonia",
        "003": "Fragmenta",
    },
    "0548": {"001": "Bibliotheca (sub nomine Apollodori)"},
    "0549": {"001": "Fragmenta", "002": "Fragmenta"},
    "0550": {"001": "Conica"},
    "0551": {
        "001": "Prooemium",
        "002": "Basilica (fragmenta)",
        "003": "Italica (fragmenta)",
        "004": "Samnitica (fragmenta)",
        "005": "Celtica (fragmenta)",
        "006": "Sicelica (fragmenta)",
        "007": "Iberica",
        "008": "Annibaica",
        "009": "Libyca",
        "010": "Numidica (fragmenta)",
        "011": "Macedonica (fragmenta)",
        "012": "Illyrica",
        "013": "Syriaca",
        "014": "Mithridatica",
        "015": "Fragmenta historiae Romanae",
        "016": "Appiani ad Frontonem epistula",
        "017": "Bellum civile",
        "018": "Testimonium",
    },
    "0552": {
        "001": "De sphaera et cylindro",
        "002": "Dimensio circuli",
        "003": "De conoidibus et sphaeroidibus",
        "004": "De lineis spiralibus",
        "005": "De planorum aequilibriis",
        "006": "Arenarius",
        "007": "Quadratura parabolae",
        "008": "De corporibus fluitantibus",
        "009": "Stomachion",
        "010": "Ad Eratosthenem methodus",
        "011": "Liber assumptorum",
        "012": "Problema bovinum",
        "013": "Fragmenta",
        "014": "Problema bovinum [Dub.]",
    },
    "0553": {"001": "Onirocriticon"},
    "0554": {"001": "De Chaerea et Callirhoe"},
    "0555": {
        "001": "Protrepticus",
        "002": "Paedagogus",
        "003": "Hymnus Christi servatoris",
        "004": "Stromata",
        "005": "Eclogae propheticae",
        "006": "Quis dives salvetur",
        "007": "Excerpta ex Theodoto",
        "008": "Fragmenta",
    },
    "0556": {"001": "Tactica"},
    "0557": {
        "001": "Dissertationes ab Arriano digestae",
        "002": "Enchiridion",
        "003": "Dissertationum Epictetearum sive ab Arriano sive ab aliis digestarum fragmenta",
        "004": "Gnomologium Epicteteum (e Stobaei libris 1-2)",
        "005": "Gnomologium Epicteteum (e Stobaei libris 3-4)",
        "006": "Arriani epistula ad Lucium Gellium",
    },
    "0558": {
        "001": "Fragmenta Florentina (PSI 13.1304)",
        "002": "Fragmenta Londinensia (P. Oxy. 5.842)",
        "003": "Fragmenta Londinensia incertae sedis (P. Oxy. 5.842)",
        "004": "Fragmenta (P. Oxy. 5.842)",
        "005": "Fragmentum (P. Cairo inv. 26",
    },
    "0559": {
        "001": "Pneumatica",
        "002": "De automatis",
        "003": "Fragmenta de horoscopiis",
        "004": "Mechanicorum fragmenta",
        "005": "Catoptrica",
        "006": "Metrica",
        "007": "Dioptra",
        "008": "Definitiones",
        "009": "Geometrica",
        "010": "Stereometrica",
        "011": "De mensuris",
        "012": "Belopoeica",
        "013": "Χειροβαλλίστρας κατασκευὴ καὶ συμμετρία",
        "014": "Fragmenta Heroniana",
        "015": "Geodaesia [Sp.]",
        "016": "Liber geeponicus [Sp.]",
    },
    "0560": {"001": "De sublimitate"},
    "0561": {"001": "Daphnis et Chloe"},
    "0562": {"001": "Τὰ εἰς ἑαυτόν"},
    "0563": {"001": "Dialexeis"},
    "0564": {
        "001": "De renum et vesicae morbis",
        "002": "De satyriasmo et gonorrhoea",
        "003": "De corporis humani appellationibus",
        "004": "De partibus corporis humani",
        "005": "De ossibus",
        "006": "Quaestiones medicinales",
        "007": "Synopsis de pulsibus",
    },
    "0565": {
        "001": "Gynaeciorum libri iv",
        "002": "De signis fracturarum",
        "003": "De fasciis",
        "004": "Vita Hippocratis",
    },
    "0566": {
        "001": "Testimonia",
        "002": "Fragmenta",
        "003": "Fragmentum (P. Colon. 5861)",
    },
    "0568": {
        "001": "Historiarum mirabilium collectio",
        "002": "Epigramma",
        "003": "Fragmenta",
        "004": "Fragmentum et titulus",
    },
    "0569": {"001": "Historiae mirabiles"},
    "0570": {"001": "Epigramma", "002": "Fragmenta"},
    "0571": {"001": "Fragmentum", "002": "Fragmenta"},
    "0572": {"001": "Fragmenta"},
    "0574": {"001": "Fragmenta", "002": "Fragmenta"},
    "0576": {"001": "Tituli"},
    "0577": {"001": "Fragmenta"},
    "0578": {"001": "Fragmenta"},
    "0579": {
        "001": "Hymni",
        "002": "Argonautica",
        "003": "Lithica",
        "004": "Fragmentum astrologicum",
        "005": "Fragmenta",
        "006": "Testimonia",
        "007": "Fragmenta",
        "008": "Lithica",
        "009": "Lithica kerygmata",
        "010": "Fragmenta (P. Derveni)",
    },
    "0580": {"001": "Mirabilia de aquis"},
    "0581": {"001": "Admiranda"},
    "0582": {"001": "Admiranda"},
    "0583": {
        "001": "Testimonia",
        "002": "Fragmenta",
        "003": "Fragmentum (P. Oslo 1662)",
    },
    "0584": {"001": "Fragmenta", "002": "Fragmenta"},
    "0585": {"001": "De mirabilibus", "002": "Testimonia", "003": "Fragmenta"},
    "0586": {"001": "Fragmenta", "002": "Testimonium et fragmenta"},
    "0587": {"001": "Fragmenta"},
    "0591": {"001": "Declamationes (fragmenta)", "002": "Fragmenta varia"},
    "0592": {
        "001": "Progymnasmata [Dub.]",
        "002": "Περὶ στάσεων",
        "003": "Περὶ εὑρέσεως [Sp.]",
        "004": "Περὶ ἰδεῶν λόγου",
        "005": "Περὶ μεθόδου δεινότητος [Sp.]",
        "006": "Testimonia",
    },
    "0593": {"001": "Testimonium", "002": "Testimonia", "003": "Fragmenta"},
    "0594": {"001": "Περὶ ῥητορικῶν ἀφορμῶν (fragmenta)", "002": "De figuris"},
    "0595": {"001": "Testimonia", "002": "Fragmenta"},
    "0597": {
        "001": "Περὶ συνηθείας (e cod. Paris. suppl. gr. 1164 [olim cod. Athon.])"
    },
    "0598": {
        "001": "Περὶ μεγαλοπρεπείας (P. Oxy. 3.410)",
        "002": "Περὶ τρόπων",
        "003": "Excerpta de arte rhetorica (olim sub auctore Joanne Doxapatre)",
        "004": "Prolegomena in artem rhetoricam",
        "005": "Prolegomena in artem rhetoricam (olim sub auctore Joanne Doxapatre)",
        "006": "Prolegomena in artem rhetoricam",
        "007": "Prolegomena de inventione",
        "008": "Σημειῶδες εἰς τὰς εὑρέσεις",
        "009": "In librum περὶ ἰδεῶν",
        "010": "Progymnasmata",
        "011": "Περὶ τῶν τεσσάρων μερῶν τοῦ τελείου λόγου (e cod. Paris. gr. 2918)",
        "012": "Περὶ τῶν ὀκτὼ μερῶν τοῦ ῥητορικοῦ λόγου (e cod. Paris. 2918)",
        "013": "Epitome artis rhetoricae (e cod. Ven. 444)",
        "014": "Epitome artis rhetoricae",
        "015": "Expositio artis rhetoricae",
        "016": "Problemata rhetorica in status",
        "017": "Περὶ τῶν τοῦ λόγου σχημάτων",
        "018": "De synecdoche",
        "019": "De figuris",
        "020": "Περὶ τῶν σχημάτων τοῦ λόγου",
        "021": "Περὶ ποιητικῶν τρόπων",
        "022": "Declamatio Paridis ad senatum Troianum",
    },
    "0601": {"001": "Fragmenta"},
    "0602": {"001": "Fragmenta comicorum anonymorum", "002": "Fragmenta"},
    "0603": {"001": "Titulus"},
    "0604": {"001": "Titulus"},
    "0605": {"001": "Fragmenta de figuris", "002": "De barbarismo et soloecismo"},
    "0606": {"001": "Ars rhetorica"},
    "0607": {"001": "Progymnasmata"},
    "0608": {"001": "Vita Euripidis (P. Oxy. 9.1176)", "002": "Fragmenta"},
    "0609": {"001": "Περὶ τρόπων", "002": "Περὶ παθῶν", "003": "Fragmenta"},
    "0610": {"001": "Fragmenta"},
    "0611": {"001": "Tituli"},
    "0612": {"001": "Orationes", "002": "Encomium comae", "003": "Fragmenta"},
    "0613": {"001": "De elocutione"},
    "0614": {"001": "Mythiambi Aesopici"},
    "0615": {"001": "In ethica Nichomachea commentaria"},
    "0616": {
        "001": "Strategemata",
        "002": "Excerpta Polyaeni",
        "003": "Testimonia",
        "004": "Fragmenta",
    },
    "0617": {"001": "Testimonia", "002": "Fragmenta"},
    "0618": {"001": "Epistula"},
    "0619": {
        "001": "Apotelesmata [Sp.]",
        "002": "De horis diei et noctis (fragmenta e cod. Berol. 26) [Sp.]",
        "003": "Apollonii epistulae [Dub.]",
    },
    "0620": {"001": "Testimonia", "002": "Fragmenta"},
    "0621": {"001": "Titulus"},
    "0622": {"001": "Epistula"},
    "0623": {"001": "Epistulae"},
    "0624": {"001": "Fragmenta"},
    "0625": {"001": "Tituli"},
    "0626": {"001": "Testimonia", "002": "Fragmenta"},
    "0627": {
        "001": "De prisca medicina",
        "002": "De aëre aquis et locis",
        "003": "Prognosticon",
        "004": "De diaeta in morbis acutis",
        "005": "De diaeta acutorum [Sp.]",
        "006": "De morbis popularibus (",
        "007": "De capitis vulneribus",
        "008": "De officina medici",
        "009": "De fracturis",
        "010": "De articulis",
        "011": "Vectiarius",
        "012": "Aphorismi",
        "013": "Jusjurandum",
        "014": "Lex",
        "015": "De humoribus",
        "016": "Prorrheticon",
        "017": "Coa praesagia",
        "018": "De arte",
        "019": "De natura hominis",
        "020": "De diaeta salubri",
        "021": "De flatibus",
        "022": "De humidorum usu",
        "023": "De morbis i-iii",
        "024": "De semine, de natura pueri, de morbis iv",
        "025": "De affectionibus",
        "026": "De locis in homine",
        "027": "De morbo sacro",
        "028": "De ulceribus",
        "029": "De haemorrhoidibus",
        "030": "De fistulis",
        "031": "De diaeta i-iv",
        "032": "De affectionibus interioribus",
        "033": "De natura muliebri",
        "034": "De septimestri partu",
        "035": "De octimestri partu",
        "036": "De mulierum affectibus i-iii",
        "037": "De virginum morbis",
        "038": "De superfetatione",
        "039": "De exsectione foetus",
        "040": "De anatome",
        "041": "De dentitione",
        "042": "De glandulis",
        "043": "De carnibus",
        "044": "De septimanis (",
        "045": "De corde",
        "046": "De alimento",
        "047": "De visu",
        "048": "De ossium natura",
        "049": "De medico",
        "050": "De decente habitu",
        "051": "Praeceptiones",
        "052": "De judicationibus",
        "053": "De diebus judicatoriis",
        "054": "De purgantibus (",
        "055": "Epistulae",
        "056": "De septimestri partu [Sp.]",
        "057": "Jusjurandum metricum",
    },
    "0628": {
        "001": "Dissertationum a Lucio digestarum reliquiae",
        "002": "Fragmenta minora",
        "003": "Epistulae spuriae",
        "004": "Fragmentum",
    },
    "0629": {"001": "Epistulae [Sp.]"},
    "0630": {"001": "Testimonia", "002": "Fragmenta"},
    "0631": {"001": "Fragmentum", "002": "Epigramma"},
    "0632": {
        "001": "Carmen aureum",
        "002": "Fragmenta",
        "003": "Fragmenta astrologica",
        "004": "Epigramma",
        "005": "Testimonia",
        "006": "Fragmenta astrologica",
    },
    "0633": {"001": "Epistula ad Hipparchum", "002": "Testimonia"},
    "0634": {"001": "Testimonia, doctrina et fragmenta"},
    "0635": {"001": "Testimonia et fragmenta", "002": "Fragmenta"},
    "0636": {"001": "Epistulae"},
    "0637": {"001": "Epistulae"},
    "0638": {
        "001": "Vita Apollonii",
        "002": "Vitae sophistarum",
        "003": "Heroicus",
        "004": "Nero",
        "005": "Epistulae et dialexeis",
        "006": "De gymnastica",
        "007": "Epigramma",
    },
    "0639": {"001": "Epistula [Sp.]"},
    "0640": {"001": "Epistulae"},
    "0641": {"001": "Ephesiaca", "002": "Testimonium"},
    "0643": {
        "001": "Iatrica (fort. auctore Menone) (Brit. Mus. inv. 137)",
        "002": "Fragmenta",
    },
    "0644": {
        "001": "Aristophanis historiae animalium epitome subjunctis Aeliani Timothei aliorumque eclogis",
        "002": "Nomina aetatum (fragmentum Parisinum)",
        "003": "Fragmenta",
        "004": "Paroemiae (fragmenta)",
        "005": "Commentaria in Callimachi pinaces (fragmenta)",
        "006": "Ceteri Aristophanis libri (fragmenta)",
        "007": "Argumenta fabularum Aristophani tributa (fragmenta)",
        "008": "Testimonia",
        "009": "Fragmenta",
        "010": "De suspectis apud veteres verbis (fragmenta)",
        "011": "Nomina aetatum (fragmenta)",
    },
    "0645": {
        "001": "Apologia",
        "002": "Apologia secunda",
        "003": "Dialogus cum Tryphone",
        "004": "Fragmenta operum deperditorum",
    },
    "0646": {
        "001": "Oratio ad gentiles",
        "002": "Cohortatio ad gentiles",
        "003": "De monarchia",
        "004": "Epistula ad Diognetum",
        "005": "De resurrectione",
        "006": "Expositio rectae fidei",
        "007": "Epistula ad Zenam et Serenum",
        "008": "Confutatio dogmatum quorundam Aristotelicorum",
        "009": "Quaestiones et responsiones ad orthodoxos",
        "010": "Quaestiones Christianorum ad gentiles",
        "011": "Quaestiones gentilium ad Christianos",
        "012": "Fragmenta",
    },
    "0647": {"001": "Ἅλωσις Ἰλίου"},
    "0648": {"001": "Strategicus"},
    "0649": {"001": "Πολιτικός", "002": "Προτρεπτικὸς A", "003": "Προτρεπτικὸς B"},
    "0650": {"001": "Mimiambi"},
    "0651": {"001": "Metamorphoseon synagoge"},
    "0652": {"001": "Imagines"},
    "0653": {
        "001": "Phaenomena",
        "002": "Fragmentum (e cod. Vat. gr. 2130)",
        "003": "Epigrammata",
        "004": "Fragmentum (e cod. Matrit. 4616)",
        "005": "Fragmenta et tituli",
    },
    "0654": {"001": "De natura deorum"},
    "0655": {
        "001": "Narrationes amatoriae",
        "002": "Poesis reliquiae",
        "003": "Fragmenta et tituli",
    },
    "0656": {
        "001": "De materia medica",
        "002": "Euporista vel De simplicibus medicinis",
        "003": "De materia medica (recensiones e codd. Vindob. med. gr. 1 % suppl. gr. 28",
        "004": "Περὶ παιωνίας καὶ ὅσα ποιεῖν δύναται (e cod. Matrit. Bibl. Nat. 4616, fol. 159)",
    },
    "0657": {"001": "Fragmenta"},
    "0658": {"001": "Aethiopica", "002": "Epigrammata"},
    "0659": {
        "001": "Adespota veteris comoediae",
        "002": "Adespota novae comoediae",
        "003": "Fragmenta incertae comoediae",
        "004": "Adespota dubia",
        "005": "Fragmentum incerti poetae Dorici",
    },
    "0660": {"001": "In Hippocratis de articulis commentarius"},
    "0661": {"001": "Fragmenta", "002": "Fragmenta inedita"},
    "0662": {
        "001": "Adespota Doriensium comoediae",
        "002": "Adespota veteris comoediae",
        "003": "Adespota novae comoediae",
        "004": "Excerpta, florilegia et sententiae",
        "005": "Argumenta metrica",
        "006": "Argumenta comica",
        "007": "Λέξεις κωμικαί",
        "008": "Κωμῳδούμενοι",
        "009": "Dubia",
    },
    "0663": {"001": "Praecepta salubria"},
    "0666": {"001": "Declamatio"},
    "0667": {"001": "De pulsibus"},
    "0668": {"001": "Aegimius (fragmenta)"},
    "0671": {"001": "De venenatis animalibus eorumque remediis"},
    "0673": {"001": "Fragmenta", "002": "Fragmenta"},
    "0676": {"001": "Adversus suffusiones incipientes", "002": "Fragmentum"},
    "0679": {"001": "Epigramma", "002": "Fragmenta et tituli"},
    "0683": {"001": "Aethiopis (fragmenta)"},
    "0686": {"001": "Fragmenta"},
    "0687": {"001": "Fragmentum"},
    "0688": {"001": "Fragmentum", "002": "Fragmenta"},
    "0690": {"001": "Testimonia et fragmenta"},
    "0691": {"001": "Epistula"},
    "0693": {
        "001": "Epitome doctrinae Platonicae sive Διδασκαλικός",
        "002": "Introductio in Platonem",
    },
    "0695": {"001": "Fragmenta"},
    "0696": {"001": "Alcmaeonis (fragmenta)"},
    "0697": {"001": "Fragmenta"},
    "0698": {"001": "Fragmenta et titulus"},
    "0700": {"001": "Tituli"},
    "0703": {"001": "Fragmenta et tituli"},
    "0706": {"001": "Fragmentum"},
    "0707": {"001": "Fragmenta"},
    "0708": {"001": "De adfinium vocabulorum differentia (", "002": "De impropriis ("},
    "0710": {"001": "Fragmentum"},
    "0713": {"001": "Testimonia", "002": "Fragmenta"},
    "0714": {"001": "Testimonia", "002": "Fragmenta"},
    "0715": {"001": "Epitomae medicae libri septem"},
    "0716": {"001": "Vocum Hippocraticarum collectio", "002": "Fragmenta"},
    "0717": {
        "001": "Hypsiclis liber sive elementorum liber xiv qui fertur",
        "002": "Anaphoricus",
    },
    "0718": {
        "001": "Iatricorum liber i",
        "002": "Iatricorum liber ii",
        "003": "Iatricorum liber iii",
        "004": "Iatricorum liber iv",
        "005": "Iatricorum liber v",
        "006": "Iatricorum liber vi",
        "007": "Iatricorum liber vii",
        "008": "Iatricorum liber viii",
        "009": "Iatricorum liber ix",
        "010": "Iatricorum liber xi",
        "011": "Iatricorum liber xii",
        "012": "Iatricorum liber xiii",
        "013": "Iatricorum liber xv",
        "014": "Iatricorum liber xvi",
    },
    "0719": {
        "001": "De causis et signis acutorum morborum (lib. 1)",
        "002": "De causis et signis acutorum morborum (lib. 2)",
        "003": "De curatione acutorum morborum libri duo",
        "004": "De curatione diuturnorum morborum libri duo",
    },
    "0720": {"001": "Titulus"},
    "0721": {
        "001": "Ὀνομασίαι τῶν κατὰ ἄνθρωπον (lib. 1)",
        "002": "Ὀνοματοποιία τῆς ἀνθρώπου φύσεως",
        "003": "Περὶ χροιᾶς τοῦ αἵματος τοῦ ἀπὸ φλεβοτομίας ἐκ τῆς ἰατρικῆς τῶν Περσῶν",
        "004": "De generatione et semine",
        "005": "De corporis hominis natura",
        "006": "De natura hominis",
        "007": "Mensium adornatio",
        "008": "De duodecim mensium natura",
        "009": "De diaeta",
        "010": "De alimentis",
        "011": "Περὶ λυκανθρωπίας",
        "012": "De urinis secundum Syros",
        "013": "De urinis secundum Persos",
        "014": "Commentatio de urinis",
        "015": "De pulsibus",
        "016": "De urinis in febribus",
        "017": "De cibis",
        "018": "Περὶ τῆς τῶν πυρετῶν διαφορᾶς",
        "019": "Περὶ τροφῶν δυνάμεως",
        "020": "In aphorismos [Hippocratis]",
        "021": "Physiognomonica",
        "022": "Ὀνόματα τῶν ἰατρικῶν ἐργαλείων κατὰ στοιχεῖα οἷς ἐν ταῖς χειρουργίαις χρώμεθα",
        "023": "Fragmenta varia",
        "024": "Διάγνωσις περὶ τῶν ὀξέων καὶ χρονίων νοσημάτων",
    },
    "0722": {
        "001": "Collectiones medicae (lib. 1-16, 24-25, 43-50)",
        "002": "Collectiones medicae (libri incerti)",
        "003": "Eclogae medicamentorum",
        "004": "Synopsis ad Eustathium filium",
        "005": "Libri ad Eunapium (lib. 1-4)",
        "006": "Testimonia",
    },
    "0723": {"001": "De natura hominum synopsis", "002": "Conspectus medicinae"},
    "0724": {
        "001": "Commentarii in priorem Galeni librum therapeuticum ad Glauconem",
        "002": "Scholia in Hippocratis prognosticon",
        "003": "Collyrium ophthalmicum (olim sub auctore Stephano Archiatro)",
        "004": "Scholia in Hippocratis de fracturis",
    },
    "0725": {"001": "Testimonia", "002": "Fragmenta"},
    "0726": {
        "001": "Commentarii in Hippocratis librum sextum de morbis popularibus",
        "002": "Synopsis de febribus",
        "003": "Περὶ βρώσεως καὶ πόσεως",
        "004": "Scholia in Hippocratis de fracturis",
    },
    "0727": {"001": "Commentarii in Hippocratis librum de natura pueri"},
    "0728": {"001": "Commentarii in Hippocratis aphorismos"},
    "0729": {
        "001": "De urinis",
        "002": "De excrementis",
        "003": "De pulsibus",
        "004": "De corporis humani fabrica libri quinque",
    },
    "0730": {
        "001": "De natura hominis",
        "002": "Hypothesis ad opus De natura hominis (e cod. Barocciano 131)",
    },
    "0731": {
        "001": "Physiognomonica",
        "002": "De ventis",
        "003": "Physiognomonica (epitome Matritensis)",
    },
    "0732": {
        "001": "De mixtione",
        "002": "Problemata (lib. 1-2) [Sp.]",
        "003": "De febribus [Sp.]",
        "004": "In Aristotelis metaphysica commentaria",
        "005": "In Aristotelis analyticorum priorum librum i commentarium",
        "006": "In Aristotelis topicorum libros octo commentaria",
        "007": "In librum de sensu commentarium",
        "008": "In Aristotelis meteorologicorum libros commentaria",
        "009": "De anima",
        "010": "De anima libri mantissa (",
        "011": "Ἀπορίαι καὶ λύσεις [Sp.]",
        "012": "Ἠθικὰ προβλήματα [Sp.]",
        "013": "De fato",
        "014": "In analytica posteriora commentariorum fragmenta",
        "015": "Fragmenta",
        "016": "Problemata (lib. 3-4) [Sp.]",
    },
    "0733": {"001": "Quaestiones medicae et problemata physica"},
    "0734": {"001": "Σκευασία ἁλατίου"},
    "0736": {"001": "In Magni sophistae librum de urinis"},
    "0737": {"001": "Lex de medicis"},
    "0738": {
        "001": "Hippiatrica Berolinensia",
        "002": "Appendices ad hippiatrica Berolinensia",
        "003": "Hippiatrica Parisina",
        "004": "Fragmenta Anatolii",
        "005": "Fragmenta Timothei Gazaei",
        "006": "Hippiatrica Cantabrigiensia",
        "007": "Additamenta Londinensia ad hippiatrica Cantabrigiensia",
        "008": "Excerpta Lugdunensia",
        "009": "Fragmenta Anatolii de equis",
        "010": "Fragmenta Anatolii de bubus",
    },
    "0740": {"001": "Jusjurandum medicum"},
    "0742": {
        "001": "Naassenorum carmina",
        "002": "Christianorum carmina",
        "003": "Carminis de mundi creatione exordium",
        "004": "Hymnus in Jovem",
        "005": "Hymnus in Isim (PSI 7.844)",
        "006": "Hymnus in Sarapidem (P. Schubart 12)",
        "007": "Aretalogia Sarapidis (P. Berol. 10525)",
        "008": "Hymnus in Apollinem",
        "009": "Paean in Apollinem (P. Berol. 6870v)",
        "010": "Hymnus in Asclepium",
        "011": "Hymnus in Hecatam",
        "012": "Hymnus in Fortunam (P. Berol. Mus. 9734v)",
        "013": "Hymnus in Dionysum (P. Ross. Georg. 1.11)",
        "014": "Carmen mystarum (P. Argent. 1313)",
        "015": "Descensus ad inferos (Brit. Mus. inv. 1192)",
        "016": "Hymni e papyris magicis collecti",
        "017": "Hymnus in omnes deos",
        "018": "Hymnus in Apollinem",
    },
    "0743": {"001": "De natura hominis"},
    "0744": {
        "001": "Dedicatio ad Cosman",
        "002": "De febribus",
        "003": "Therapeutica",
        "004": "Epistula de lumbricis",
        "005": "De oculis libri tres",
    },
    "0745": {
        "001": "De nutriendi methodo",
        "002": "Πῶς ὀφείλει διαιτᾶσθαι ἄνθρωπος ἐφ",
    },
    "0746": {"001": "De febrium differentia"},
    "0748": {"001": "De instrumentis infusoriis seu clysteribus ad Timotheum"},
    "0749": {"001": "Ἐκ τοῦ περὶ κλυσμῶν ὅτι διὰ τρεῖς αἰτίας παραλαμβάνονται"},
    "0750": {"001": "Ἰταλικὰ θαύματα", "002": "Fragmenta"},
    "0751": {
        "001": "Epistula ad Ptolemaeum regem",
        "002": "Epistula ad Ptolemaeum regem de hominis fabrica",
        "003": "Περὶ διαφόρων καὶ παντοίων τροφῶν",
        "004": "Περὶ διαφορᾶς τροφῶν πρὸς Πτολεμαῖον",
        "005": "Ἑρμηνεία περὶ ἐνεργῶν λίθων",
    },
    "0752": {
        "001": "Paraphrasis in Nicandri theriaca",
        "002": "Paraphrasis in Nicandri alexipharmaca",
        "003": "Paraphrasis in Oppiani cynegetica (fort. auctore Eutecnio)",
        "004": "Paraphrasis in Oppiani halieutica (fort. auctore Eutecnio)",
    },
    "0766": {"001": "Testimonia", "002": "Fragmenta"},
    "0816": {"001": "Titulus"},
    "0825": {"001": "Titulus"},
    "0833": {"001": "Titulus"},
    "0845": {
        "001": "Testimonia",
        "002": "Fragmenta",
        "003": "Fragmentum (P. Oxy. 24.2389)",
    },
    "0856": {"001": "Fragmentum"},
    "0876": {"001": "Tituli"},
    "0888": {"001": "Fragmentum"},
    "0889": {"001": "Tituli"},
    "0897": {"001": "Fragmentum"},
    "0900": {"001": "Titulus"},
    "0918": {"001": "Titulus"},
    "0971": {"001": "Titulus"},
    "0981": {"001": "Titulus"},
    "1004": {
        "001": "De virtutibus herbarum (e cod. Paris. gr. 2502 % Vindob. med. gr. 23)",
        "002": "De virtutibus herbarum (e cod. Matrit. Bibl. Nat. 4631 [olim 110])",
        "003": "De virtutibus herbarum (e cod. Monac. 542)",
        "004": "De virtutibus herbarum (e codd. Paris. gr. 2502 % Vindob. med. gr. 23 % Londin. reg. 16 C II)",
        "005": "De virtutibus herbarum (e codd. Paris. gr. 2256 % Venet. App. cl. V 13 % Mosq. 415)",
    },
    "1016": {
        "001": "Ὀστάνου φιλοσόφου πρὸς Πετάσιον περὶ τῆς ἱερᾶς ταύτης καὶ θείας τέχνης (e cod. Venet. Marc. 299,"
    },
    "1021": {"001": "Meropis (fragmenta) (P. Köln 3.126 [inv. 5604, 17])"},
    "1052": {"001": "Fragmenta", "002": "Testimonia", "003": "Fragmenta"},
    "1083": {"001": "Fragmenta"},
    "1087": {"001": "Tituli"},
    "1094": {"001": "Tituli"},
    "1096": {"001": "Tituli"},
    "1105": {"001": "Fragmentum"},
    "1115": {"001": "Titulus"},
    "1118": {
        "001": "De venenis eorumque praecautione et medicatione (",
        "002": "De iis, quae virus ejaculantur, animalibus libellus, in quo et de rabioso cane (",
        "003": "De lapidibus",
    },
    "1121": {"001": "Epistulae"},
    "1123": {"001": "Fragmenta"},
    "1124": {
        "001": "De passionibus (lib. 1) [Sp.]",
        "002": "De passionibus (lib. 2) [Sp.]",
    },
    "1125": {"001": "Fragmenta"},
    "1127": {"001": "Anonyma de musica scripta Bellermanniana"},
    "1128": {
        "001": "Commentarius in Platonis Theaetetum (fort. auctore Eudoro Alexandrino) (P. Berol. inv. 9782)"
    },
    "1129": {
        "001": "De barbarismo et soloecismo",
        "002": "De barbarismo et soloecismo",
    },
    "1131": {"001": "Ad Avircium Marcellum contra Cataphrygas"},
    "1132": {"001": "Fragmenta"},
    "1133": {"001": "Fragmenta"},
    "1134": {"001": "Fragmenta"},
    "1135": {"001": "Fragmenta"},
    "1136": {"001": "Fragmentum"},
    "1138": {"001": "Fragmenta"},
    "1139": {
        "001": "Enchiridion (P. Ryl. 22)",
        "002": "Heraclis historia (Tabula Albana) (IG 14.1293)",
        "003": "Anonymi ex historiis Polybii",
        "004": "Fragmenta historica",
        "005": "Alexandri historia (P. Oxy. 15.1798)",
        "006": "Alexandri historia (e cod. Sabbaitico 29)",
        "007": "De historia Alexandri",
        "008": "De historia diadochorum (epitome Heidelbergensis)",
        "009": "De Pyrrho (testimonium)",
        "010": "Belli Syrii tertii annales (P. Petrie 2.45",
        "011": "De Hannibale",
        "012": "De Marco Aurelio Antonino (testimonium)",
        "013": "De bello Parthico",
        "014": "Anonymus Corinthius",
        "015": "Anonymus Milesius",
        "016": "Anonymus philosophus",
        "017": "Chronicon Romanum (IG 14.1297)",
        "018": "Chronicon Oxyrhynchi (P. Oxy. 1.12)",
        "019": "Chronicon Olympicum (fort. auctore Phlegonte)",
        "020": "Chronicon Archontum (P. Oxy. 13.1613)",
        "021": "Εὐμολπιδῶν πάτρια (testimonium)",
        "022": "Εὐπατριδῶν πάτρια (fragmentum)",
        "023": "De sacris Atheniensibus",
        "024": "Anonymus periegeta (P. Hawara 80",
        "025": "De finibus urbis",
        "026": "Victores Olympici (fort. auctore Phlegonte vel Eratosthene) (P. Oxy. 2.222)",
        "027": "Chronicon Pergamenum",
        "028": "Anagraphe Sicyonia",
        "029": "Anonymus de conditu Hermopolis",
        "030": "Apophthegmata Romana",
        "031": "De agrimensore Syriae (fort. auctore Xenophonte quodam)",
        "032": "Anonymus exegeta",
        "033": "De Lesbo",
        "034": "De Nilo",
        "035": "Scriptores de Athenis",
        "036": "De Theramene (P. Mich. 5982)",
        "037": "Philippica (P. Ryl. 3.490)",
        "038": "Alexandri historia (P. Oxy. 17.2081)",
        "039": "Alexandri historia (P. Hamb. 652)",
        "040": "Victores olympici (P. Oxy. 23.2381)",
    },
    "1141": {"001": "Fragmentum [Dub.]", "002": "Fragmentum"},
    "1143": {"001": "Fragmenta"},
    "1145": {"001": "Fragmenta"},
    "1146": {"001": "Testimonia et fragmenta"},
    "1147": {
        "001": "Fragmenta",
        "002": "Testimonia",
        "003": "Fragmenta",
        "004": "Fragmenta",
    },
    "1148": {
        "001": "De incredibilibus (fragmentum) (PSI 10.1177)",
        "002": "De incredibilibus (fragmentum) (P. Oxy. 42.3012)",
        "003": "De incredibilibus vel Herpyllis (",
    },
    "1149": {"001": "Epistula ad commune Asiae"},
    "1150": {"001": "Epigramma", "002": "Tituli"},
    "1152": {
        "001": "Fragmenta de glossis Homericis",
        "002": "Fragmenta de glossis Homericis",
        "003": "Fragmenta",
    },
    "1153": {"001": "Νυχθήμερον (fort. auctore Apollonio Tyanensi)"},
    "1154": {"001": "Apocalypsis Baruchi Graece (iii Baruch)"},
    "1155": {"001": "Fragmentum"},
    "1156": {"001": "Fragmenta"},
    "1157": {"001": "Apocalypsis Esdrae", "002": "Apocalypsis Esdrae quarta"},
    "1158": {
        "001": "Apocalypsis apocrypha Joannis",
        "002": "Apocalypsis apocrypha Joannis (versio altera)",
        "003": "Apocalypsis apocrypha Joannis (versio tertia)",
    },
    "1160": {"001": "Fragmentum"},
    "1161": {"001": "Fragmenta"},
    "1162": {"001": "Fragmenta"},
    "1163": {"001": "Fragmenta"},
    "1164": {"001": "Fragmenta"},
    "1165": {"001": "Poliorcetica"},
    "1166": {"001": "Fragmenta"},
    "1167": {"001": "Vita Aeschinis"},
    "1168": {"001": "Lexicon Homericum"},
    "1170": {"001": "Fragmenta"},
    "1171": {"001": "Fragmenta ex libro adversus Cataphrygas seu Montanistas"},
    "1172": {"001": "Fragmenta"},
    "1173": {"001": "Fragmenta"},
    "1174": {"001": "Fragmenta"},
    "1175": {"001": "Fragmenta", "002": "Fragmenta et tituli"},
    "1176": {"001": "Fragmenta"},
    "1177": {"001": "Fragmenta"},
    "1178": {"001": "Fragmentum"},
    "1179": {"001": "Fragmentum"},
    "1180": {"001": "Fragmenta"},
    "1181": {"001": "De magnitudinibus et distantiis solis et lunae"},
    "1182": {"001": "Fragmenta epica"},
    "1183": {"001": "Aristeae epistula ad Philocratem"},
    "1184": {
        "001": "Fragmenta (P. Oxy. 15.1778)",
        "002": "Fragmenta (P. Lond. 2486)",
        "003": "Fragmenta",
    },
    "1186": {"001": "Fragmenta"},
    "1188": {"001": "Fragmenta"},
    "1189": {"001": "Fragmenta"},
    "1190": {"001": "Fragmenta"},
    "1191": {"001": "Fragmentum"},
    "1192": {"001": "Fragmenta"},
    "1193": {"001": "Testimonia et fragmenta", "002": "Fragmenta"},
    "1194": {
        "001": "De signis Odysseae",
        "002": "De signis Iliadis",
        "003": "Testimonia",
        "004": "Fragmentum",
    },
    "1196": {"001": "Fragmentum (P. Oxy. 27.2463)", "002": "Fragmenta"},
    "1197": {"001": "Fragmenta"},
    "1199": {"001": "Fragmenta"},
    "1200": {"001": "Fragmenta"},
    "1201": {"001": "Fragmenta"},
    "1202": {"001": "Fragmentum"},
    "1203": {
        "001": "Paean Erythraeus in Aesculapium",
        "002": "Paean Erythraeus ad urbem Dium repertus",
        "003": "Fragmentum Erythraeum paeanis in Apollinem",
        "004": "Fragmentum Erythraeum paeanis in Seleucum",
        "005": "Paean Delphicus i in Apollinem",
        "006": "Fragmentum paeanis in Titum Flamininum",
    },
    "1204": {"001": "De machinis"},
    "1205": {
        "001": "Legatio sive Supplicatio pro Christianis",
        "002": "De resurrectione",
    },
    "1206": {"001": "Fragmenta"},
    "1207": {"001": "Fragmenta Aratea"},
    "1208": {"001": "Fragmenta"},
    "1210": {"001": "De sphaera quae movetur", "002": "De ortibus et occasibus"},
    "1211": {"001": "Fragmentum"},
    "1212": {"001": "Fragmentum"},
    "1213": {"001": "Epigrammata"},
    "1216": {"001": "Barnabae epistula"},
    "1218": {"001": "Fragmenta"},
    "1219": {"001": "Fragmenta"},
    "1220": {
        "001": "Batrachomyomachia",
        "002": "Batrachomyomachia (prosodia Byzantina)",
    },
    "1222": {"001": "Fragmenta"},
    "1223": {"001": "Fragmentum", "002": "Testimonium"},
    "1224": {"001": "Fragmenta", "002": "Fragmenta"},
    "1225": {"001": "Fragmenta"},
    "1226": {"001": "Κατασκευαὶ πολεμικῶν ὀργάνων καὶ καταπαλτικῶν"},
    "1227": {"001": "Fragmentum"},
    "1228": {"001": "Fragmenta"},
    "1229": {"001": "Fragmentum"},
    "1230": {"001": "Fragmentum", "002": "Testimonia"},
    "1231": {"001": "Fragmentum"},
    "1232": {"001": "Fragmentum"},
    "1237": {"001": "Fragmenta"},
    "1239": {"001": "Fragmenta"},
    "1240": {"001": "Fragmenta"},
    "1241": {"001": "Carmen Naupactium (fragmenta)"},
    "1242": {"001": "Canon librorum"},
    "1244": {
        "001": "Philistas (lib. ii) (P. Herc. 1027)",
        "002": "Fragmenta (P. Herc. 1027)",
    },
    "1245": {"001": "Fragmenta"},
    "1247": {"001": "Cebetis tabula"},
    "1248": {"001": "Ἀληθὴς λόγος"},
    "1249": {"001": "Fragmenta"},
    "1250": {"001": "Fragmenta"},
    "1251": {"001": "Fragmenta", "002": "Fragmenta"},
    "1252": {
        "001": "Certamen Homeri et Hesiodi (P. Petrie 25)",
        "002": "Certamen Homeri et Hesiodi",
    },
    "1254": {"001": "Fragmenta"},
    "1256": {"001": "Sententiae", "002": "Sententiae"},
    "1257": {"001": "Fragmentum"},
    "1258": {"001": "Fragmenta"},
    "1259": {"001": "Fragmentum"},
    "1260": {"001": "Fragmentum epicum [Dub.] (fort. auctore Callippo)"},
    "1262": {"001": "Fragmentum", "002": "Fragmentum et titulus"},
    "1263": {
        "001": "Tituli (P. Oxy. 11.1399)",
        "002": "Fragmenta et tituli",
        "003": "Fragmenta dubia (fort. auctore Choerilo Iasensi)",
        "004": "Fragmenta epica",
    },
    "1264": {
        "001": "Fragmenta logica et physica",
        "002": "Fragmenta moralia",
        "003": "Fragmenta quae ad explicationem carminum Homericorum pertinent",
        "004": "Fragmenta ad singulos libros relata",
        "005": "Fragmenta poetica",
        "006": "Fragmentum (P. Ant. 2.61)",
    },
    "1266": {"001": "Fragmenta"},
    "1268": {"001": "Fragmenta"},
    "1269": {"001": "Fragmenta", "002": "Testimonia et fragmenta"},
    "1270": {"001": "Fragmenta"},
    "1271": {
        "001": "Epistula i ad Corinthios",
        "002": "Epistula ii ad Corinthios [Sp.]",
        "003": "Epistula Petri ad Jacobum [Sp.]",
        "004": "Contestatio [Sp.]",
        "005": "Epistula Clementis ad Jacobum [Sp.]",
        "006": "Homiliae [Sp.]",
        "007": "Recognitiones [Sp.]",
        "008": "Recognitiones (ex Eusebio) [Sp.]",
        "009": "Recognitiones (e Pseudo-Caesario) [Sp.]",
        "010": "Epistulae de virginitate [Sp.]",
        "011": "Pseudo-Clementina (epitome altera auctore Symeone Metaphrasta) [Sp.]",
        "012": "Pseudo-Clementina (epitome de gestis Petri praemetaphrastica) [Sp.]",
    },
    "1272": {"001": "De motu circulari corporum caelestium"},
    "1273": {"001": "Fragmentum", "002": "Fragmenta et titulus"},
    "1274": {"001": "Fragmenta", "002": "Epigrammata"},
    "1275": {"001": "Testimonia", "002": "Fragmenta", "003": "Astrologia (fragmentum)"},
    "1276": {"001": "Fragmenta"},
    "1277": {"001": "Fragmenta", "002": "Testimonia"},
    "1278": {"001": "Sententiae"},
    "1281": {"001": "Fragmenta"},
    "1282": {"001": "Fragmenta"},
    "1285": {"001": "Fragmenta"},
    "1286": {
        "001": "Poimandres",
        "002": "Dialogus (sine titulo)",
        "003": "Hieros logos",
        "004": "Πρὸς Τὰτ ὁ κρατὴρ ἢ μονάς",
        "005": "Πρὸς Τὰτ υἱὸν ὅτι ἀφανὴς θεὸς φανερώτατός ἐστιν",
        "006": "Ὅτι ἐν μόνῳ τῷ θεῷ τὸ ἀγαθόν ἐστιν, ἀλλαχόθι δὲ οὐδαμοῦ ",
        "007": "Ὅτι μέγιστον κακὸν ἐν ἀνθρώποις ἡ περὶ τοῦ θεοῦ ἀγνωσία",
        "008": "Ὅτι οὐδὲν τῶν ὄντων ἀπόλλυται, ἀλλὰ τὰς μεταβολὰς ἀπωλείας καὶ θανάτους πλανώμενοι λέγουσιν",
        "009": "Περὶ νοήσεως καὶ αἰσθήσεως. [ὅτι ἐν μόνῳ τῷ θεῷ τὸ καλὸν καὶ ἀγαθόν ἐστιν, ἀλλαχόθι δὲ ο",
        "010": "Κλείς",
        "011": "Νοῦς πρὸς Ἑρμῆν",
        "012": "Περὶ νοῦ κοινοῦ πρὸς Τάτ",
        "013": "Πρὸς τὸν υἱὸν Τὰτ ἐν ὄρει λόγος ἀπόκρυφος, περὶ παλιγγενεσίας καὶ σιγῆς ἐπαγγελίας",
        "014": "Ἀσκληπιῷ εὖ φρονεῖν",
        "015": "Ὅροι Ἀσκληπιοῦ πρὸς Ἄμμωνα βασιλέα",
        "016": "Dialogus (sine titulo)",
        "017": "Περὶ τῆς ὑπὸ τοῦ πάθους τοῦ σώματος ἐμποδιζομένης ψυχῆς",
        "018": "Asclepius (verba Graeca solum)",
        "019": "Fragmenta",
        "020": "Fragmenta varia (verba Graeca solum)",
        "021": "Ἐκ τοῦ ὕμνου πρὸς τὸν παντοκράτορα (fragmentum)",
    },
    "1287": {"001": "Fragmenta", "002": "Fragmenta et titulus"},
    "1288": {"001": "Fragmenta"},
    "1289": {"001": "Fragmenta"},
    "1291": {"001": "Fragmentum"},
    "1292": {"001": "Fragmentum"},
    "1293": {"001": "Fragmenta"},
    "1294": {"001": "Fragmenta"},
    "1296": {"001": "Cypria (fragmenta)"},
    "1297": {"001": "Fragmenta"},
    "1298": {"001": "Epistula"},
    "1301": {"001": "Fragmenta et titulus"},
    "1302": {
        "001": "Formae epistolicae",
        "002": "Formae epistolicae (duo exempla spuria)",
    },
    "1303": {"001": "Fragmenta"},
    "1304": {"001": "Testimonia", "002": "Fragmenta"},
    "1305": {"001": "Fragmentum"},
    "1306": {
        "001": "Περὶ συμπαθειῶν καὶ ἀντιπαθειῶν (sub nomine Democriti)",
        "002": "Physica et mystica (fort. opus Χειρόμηκτα) (sub nomine Democriti) (e cod. Venet. Marc. 299, fol. 66v)",
        "003": "Ad Leucippem (sub nomine Democriti) [Sp.] (e cod. Paris. B.N. gr. 2327, fol. 258r)",
        "004": "Testimonia",
        "005": "Fragmenta",
        "006": "Testimonium",
    },
    "1307": {"001": "Fragmenta"},
    "1308": {"001": "Fragmenta", "002": "Fragmenta"},
    "1309": {"001": "Fragmenta"},
    "1310": {"001": "Testimonia", "002": "Fragmenta"},
    "1311": {"001": "Διδαχαὶ τῶν ἀποστολῶν"},
    "1312": {
        "001": "In Demosthenem (P. Berol. 9780)",
        "002": "De dubiis apud Platonem lectionibus [Sp.]",
    },
    "1313": {"001": "Fragmenta"},
    "1314": {"001": "Fragmentum", "002": "Fragmenta"},
    "1315": {"001": "Fragmentum", "002": "Tituli"},
    "1316": {"001": "Fragmenta"},
    "1318": {"001": "Fragmentum de viris duobus"},
    "1319": {"001": "Testimonia", "002": "Fragmenta"},
    "1320": {"001": "Testimonia et fragmenta"},
    "1321": {"001": "Fragmenta"},
    "1322": {"001": "Fragmenta"},
    "1323": {"001": "Ἀττικὰ ὀνόματα"},
    "1324": {"001": "Fragmenta"},
    "1325": {"001": "Epistulae"},
    "1326": {"001": "Fragmenta"},
    "1327": {"001": "Epistulae"},
    "1328": {"001": "Fragmenta"},
    "1329": {"001": "Fragmenta"},
    "1332": {"001": "Fragmenta"},
    "1334": {"001": "Fragmenta"},
    "1337": {
        "001": "Fragmenta Graeca",
        "002": "Fragmenta e Hephaestionis Ἀποτελεσματικῶν libris hausta",
        "003": "Fragmenta alia antiqua",
    },
    "1338": {"001": "Fragmenta"},
    "1339": {"001": "Fragmenta", "002": "Fragmenta"},
    "1340": {"001": "Fragmentum"},
    "1341": {"001": "Περὶ βασιλείας (fragmenta) [Sp.]", "002": "Testimonia"},
    "1342": {"001": "Epigramma", "002": "Testimonia", "003": "Fragmenta"},
    "1343": {"001": "Fragmentum"},
    "1344": {"001": "Epica adespota"},
    "1345": {"001": "Fragmenta", "002": "Fragmentum"},
    "1346": {"001": "De miraculo Clementis Romani"},
    "1347": {
        "001": "Testimonia",
        "002": "Fragmenta",
        "003": "Testimonia",
        "004": "Fragmenta",
        "005": "Fragmentum (P. Oxy. 26.2442)",
    },
    "1349": {"001": "Fragmentum epistulae a martyribus Lugdunensibus"},
    "1350": {"001": "Epistula ad Diognetum"},
    "1351": {"001": "Epigoni (fragmenta)"},
    "1352": {"001": "Epistula ecclesiarum apud Lugdunum et Viennam"},
    "1353": {"001": "Epitaphium"},
    "1354": {"001": "Fragmentum"},
    "1355": {"001": "Fragmenta", "002": "Epigrammata", "003": "Fragmenta et titulus"},
    "1357": {"001": "Fragmenta"},
    "1358": {"001": "Fragmenta", "002": "Ars astronomica [Sp.] (P. Par. 1)"},
    "1360": {"001": "Fragmentum"},
    "1361": {"001": "Titulus"},
    "1362": {"001": "Fragmentum", "002": "Testimonia"},
    "1364": {"001": "Evangelium Aegyptium"},
    "1365": {
        "001": "Περὶ ἐλαιῶν τοῦ σώματος πρὸς Πτολεμαῖον βασιλέα",
        "002": "Περὶ παλμῶν ἀρχομένου ἀπὸ κεφαλῆς ἕως ποδῶν (e cod. Berol. 1577)",
        "003": "Περὶ παλμῶν μαντικὴ πρὸς Πτολεμαῖον βασιλέα (versio A)",
        "004": "Περὶ παλμῶν τί σημαίνουσιν ἐν ἑκάστῳ μέρει (versio P)",
    },
    "1366": {
        "001": "Evangelium Bartholomaei",
        "002": "Fragmenta evangelii Bartholomaei",
    },
    "1367": {"001": "Epistulae"},
    "1368": {"001": "Evangelium Ebionitum"},
    "1369": {"001": "Evangelium Mariae"},
    "1371": {"001": "Evangelium Petri"},
    "1372": {"001": "Evangelium Evae"},
    "1373": {"001": "Evangelium Philippi"},
    "1374": {"001": "Evangelium secundum Hebraeos"},
    "1375": {"001": "Evangelium Thomae"},
    "1376": {"001": "Περὶ λέξεων ῥητορικῶν (excerpta)"},
    "1377": {"001": "Fragmenta"},
    "1379": {
        "001": "Tractatus alchemicus (fragmenta) (P. Leid. 10)",
        "002": "Tractatus alchemicus (fragmenta) (P. Holm.)",
        "003": "Fragmentum alchemicum (P. Oxy. 3.467)",
        "004": "Fragmentum alchemicum (P. Iand. 3.85 [inv. 212])",
        "005": "Fragmentum alchemicum (P. Flor.)",
        "006": "Fragmentum alchemicum (P. Leid. 5)",
        "007": "Dedicatio ad Theodorum (e cod. Venet. Marc. 299, fol. 5v)",
        "008": "Lexicon alchemicum (",
        "009": "Περὶ τοῦ ὠοῦ οἱ παλαιοί φασιν οὕτως (e cod. Venet. Marc. 299, fol. 106v)",
        "010": "Ὀνοματοποιία τοῦ ὠοῦ",
        "011": "Ὁ οὐροβόρος δράκων (versio 1) (sine titulo) (e cod. Paris. B.N. gr. 2327, fol. 196r)",
        "012": "Ὁ οὐροβόρος δράκων (versio 2) (sine titulo) (e cod. Paris. B.N. gr. 2327, fol. 279r)",
        "013": "Ἑρμοῦ τρισμεγίστου ὄργανον (e cod. Paris. B.N. gr. 2327, fol. 293r)",
        "014": "Ἐκ τῶν μεταλλικῶν (e cod. Paris. B.N. gr. 2327, fol. 280r)",
        "015": "Ὀνόματα τῶν χρυσοποιητῶν (sine titulo) (e cod. Paris. B.N. gr. 2327, fol. 195v)",
        "016": "Περὶ τοῦ μεταλλικοῦ λιθοῦ ἐν οἷς τοῖς τόποις ἐκείνοις κατασκευάζεται (e cod. Paris. B.N. gr. 2327,",
        "017": "Ὅρκος τοῦ φιλοσόφου (e cod. Venet. Marc. 299, fol. 128v)",
        "018": "Ποῖον εἶναι χρὴ τοῖς ἤθεσι τὸν μετιόντα τὴν ἐπιστήμην (e cod. Venet. Marc. 299, fol. 128r)",
        "019": "Περὶ συνάξεως τῶν φιλοσόφων (e cod. Paris. B.N. gr. 2327, fol. 233r)",
        "020": "Περὶ ποιήσεως ἀσήμου (e cod. Venet. Marc. 299, fol. 106r)",
        "021": "Περὶ ποιήσεως κινναβάρεως (e cod. Venet. Marc. 299, fol. 106r)",
        "022": "Λαβύρινθος ἥνπερ Σολομὼν ἐτεκτήνατο (e cod. Venet. Marc. 299, fol. 102v)",
        "023": "Περὶ τῆς τιμιωτάτης καὶ πολυφήμου χρυσοχοϊκῆς (e cod. Paris. B.N. gr. 2327, fol. 280r)",
        "024": "De quattuor elementis (tractatus qui incipit a vocibus ἀρχὴ τῆς κατὰ πλάτος τοῦ ἔργου ἐξηγήσεως) (e c",
        "025": "Περὶ βαφῆς σιδήρου (e cod. Venet. Marc. 299, fol. 104r)",
        "026": "Βαφὴ τοῦ παρὰ Πέρσαις ἐξευρημένου χαλκοῦ γραφεῖσα ἀπὸ ἀρχῆς Φιλίππου (e cod. Venet. Marc. 299, ",
        "027": "Βαφὴ τοῦ ἰνδικοῦ σιδήρου γραφεῖσα ἀπὸ ἀρχῆς Φιλίππου (e cod. Venet. Marc. 299, fol. 118v)",
        "028": "Ποίησις κρυσταλλίων (e cod. Venet. Marc. 299, fol. 116r)",
        "029": "Καταβαφὴ λίθων καὶ σμαράγδων καὶ λιχνιτῶν καὶ ὑακίνθων (e cod. Paris. B.N. gr. 2327, fol. 147r)",
        "030": "De margaritis (collectio excerptorum quae incipit a vocibus Σμῆξις καὶ λάμπρυνσις μαργάρων ᾗ πολλάκις ο",
        "031": "Περὶ ζύθων ποιήσεως (e cod. Venet. Marc. 299, fol. 162r)",
        "032": "Στάκτης ποίησις (e cod. Venet. Marc. 299, fol. 162v)",
        "033": "Πόσος ὁ τῶν βαπτομένων ἐρίων σταθμὸς ὤφειλεν καὶ πόσος ὁ τῆς κομάρεως καὶ πόσος ὁ τῶν βεβαμμε",
        "034": "Τίς ἡ τοῦ μέλανος ξηρίου κατασκευή (e cod. Venet. Marc. 299, fol. 128r)",
        "035": "Τίς ἡ τῆς κομάρεως σύνθεσις (e cod. Venet. Marc. 299, fol. 128r)",
        "036": "Τίς ἡ μετὰ τὴν ἴωσιν οἰκονομία (e cod. Venet. Marc. 299, fol. 128r)",
        "037": "Εἰ θέλεις ποιῆσαι φούρμας καὶ τύλους ἀπὸ βροντησίου, ποίει οὕτως (e cod. Venet. Marc. 299, fol. 12",
        "038": "Διαφοραὶ μολίβδου καὶ χρυσοπετάλου (e cod. Venet. Marc. 299, fol. 130r)",
        "039": "Περὶ τοῦ ποιῆσαι τυρόκολλαν (e cod. Paris. B.N. gr. 2327, fol. 7r)",
        "040": "Περὶ τοῦ ποιῆσαι ὀξυγγοσάπουνον (e cod. Paris. B.N. gr. 2327, fol. 7v)",
        "041": "Excerptum de mensibus (sine titulo) (e cod. Paris. B.N. gr. 2327, fol. 240v)",
        "042": "Χρυσοῦ ποίησις (e cod. Paris. B.N. gr. 2327, fol. 232r)",
        "043": "Σκευασία ἀφρονίτρου τοῦ ζητουμένου εἰς τὰς κολλήσεις χρυσοῦ καὶ ἀργύρου καὶ χαλκοῦ (e cod. Paris",
        "044": "Κινναβάρεως σκευασία (e cod. Paris. B.N. gr. 2327, fol. 232r)",
        "045": "Χρῆσις Ἰουστινιανοῦ βασιλέως (sine titulo) (e cod. Paris. B.N. gr. 2327, fol. 240v)",
        "046": "Διάγραμμα τῆς μεγάλης ἡλιουργίας παραβαλλόμενον εἰς τὴν οἰκονομίαν τοῦ παντός (e cod. Venet. Marc.",
        "047": "Εὐχὴ εἰς τὸ μελίσσιον (e cod. Venet. Marc. 299, fol. 3r)",
        "048": "Ποίησις ἀργύρου (e cod. Venet. Marc. 299, fol. 194v)",
        "049": "Περὶ τοῦ ὀρειχάλκου (e cod. Paris. B.N. gr. 2329, fol. 184v)",
        "050": "Περὶ τοῦ θείου ἀκαύστου (e cod. Paris. B.N. gr. 2327, fol. 279r)",
        "051": "Λεύκωσις ὕδατος, δι",
        "052": "Περὶ λευκώσεως τοῦ ἀρσενικοῦ τοῦ σχιστοῦ (e cod. Paris. B.N. gr. 2327, fol. 279v)",
        "053": "Περὶ τοῦ χρυσῶσαι σίδηρον (e cod. Paris. B.N. gr. 2327, fol. 295r)",
        "054": "Ὅτι σύνθετον καὶ οὐχ ἁπλοῦν τὸ εἶδος καὶ τίς ἡ οἰκονομία (e cod. Venet. Marc. 299, fol. 96r)",
        "055": "Ποίησις μᾶλλον τοῦ παντός (e cod. Venet. Marc. 299, fol. 97r)",
        "056": "Ἡ οἰκονομία (e cod. Venet. Marc. 299, fol. 98v)",
        "057": "Τίς ἡ τῶν ἀρχαίων ἄσβεστος (e cod. Venet. Marc. 299, fol. 99r)",
        "058": "Fragmentum alchemicum (sine titulo) (e cod. Venet. Marc. 299, fol. 99v)",
        "059": "Οἰκονομία τῆς ἀσβέστου (e cod. Venet. Marc. 299, fol. 99v)",
        "060": "Ποίησις ἀσβέστου (e cod. Venet. Marc. 299, fol. 99v)",
        "061": "Fragmentum alchemicum (sine titulo) (e cod. Venet. Marc. 299, fol. 100r)",
        "062": "Fragmentum alchemicum (sine titulo) (e cod. Venet. Marc. 299, fol. 100v)",
        "063": "Fragmentum alchemicum (sine titulo) (e cod. Venet. Marc. 299, fol. 100v)",
        "064": "Ἡ ποίησις (e cod. Venet. Marc. 299, fol. 100v)",
        "065": "Ἡ ἀγωγή (e cod. Venet. Marc. 299, 101r)",
        "066": "Συμπέρασμα τῆς ποιήσεως (e cod. Venet. Marc. 299, fol. 101r)",
        "067": "Περὶ τῆς θείας καὶ ἱερᾶς τέχνης τῶν φιλοσόφων (e cod. Paris. B.N. gr. 2327, fol. 230r)",
        "068": "Fragmentum περὶ λευκώσεως (χαλκοῦ) (sine titulo) (e cod. Paris. gr. 2327, fol. 231v)",
        "069": "Ὁ λίθος τῆς φιλοσοφίας (fort. auctore Zosimo) (e cod. B.N. gr. 2327, fol. 215v)",
        "070": "Περὶ τοῦ λίθου τῶν φιλοσόφων (e cod. B.N. gr. 2327, fol. 216r)",
    },
    "1381": {"001": "Fragmentum epistulae"},
    "1382": {"001": "Fragmentum teliambicum (P. Oxy. 1.15)"},
    "1383": {
        "001": "Elementa astronomiae",
        "002": "Calendarium [Sp.",
        "003": "Fragmenta optica [Dub.]",
    },
    "1386": {
        "001": "Recensio α sive Recensio vetusta",
        "002": "Recensio β",
        "003": "Recensio γ (lib. 1)",
        "004": "Recensio γ (lib. 2)",
        "005": "Recensio γ (lib. 3)",
        "006": "Recensio ε",
        "007": "Recensio λ (lib. 3)",
        "008": "Recensio λ (Pseudo-Methodius, redactio 1)",
        "009": "Recensio λ (Pseudo-Methodius, redactio 2)",
        "010": "Recensio β (e cod. Leidensi Vulc. 93)",
        "011": "Recensio β (e cod. Paris. gr. 1685 et cod. Messinensi 62)",
        "012": "Recensio F (cod. Flor. Laurentianus Ashburn 1444)",
        "013": "Recensio E (cod. Eton College 163)",
        "014": "Recensio V (cod. Vind. theol. gr. 244)",
        "015": "Recensio K (cod. 236 Kutlumussiu-Kloster des Athos)",
        "016": "Recensio φ",
        "017": "Recensio Byzantina poetica (cod. Marcianus 408)",
        "018": "Recensio poetica (recensio R)",
        "019": "Recensio δ (e cod. Vat. gr. 1700, 88v-89r)",
    },
    "1387": {"001": "Fragmenta"},
    "1388": {"001": "Fragmenta"},
    "1389": {"001": "Lexicon in decem oratores Atticos"},
    "1390": {
        "001": "Testimonia",
        "002": "Fragmenta",
        "003": "Testimonia",
        "004": "Fragmenta",
    },
    "1391": {
        "001": "Epigramma",
        "002": "Titulus",
        "003": "Testimonium",
        "004": "Fragmentum",
    },
    "1392": {"001": "Fragmenta"},
    "1393": {"001": "Fragmenta", "002": "Fragmenta et titulus", "003": "Fragmenta"},
    "1395": {"001": "Atthis (fragmentum spurium) (fort. auctore Callippo)"},
    "1397": {"001": "Fragmenta"},
    "1398": {"001": "Fragmenta (ex incerto libro)"},
    "1399": {"001": "Titulus"},
    "1400": {"001": "Fragmenta"},
    "1402": {
        "001": "Enchiridion de metris",
        "002": "Introductio metrica",
        "003": "De poematis",
        "004": "De signis",
        "005": "Fragmenta Hephaestionea",
    },
    "1405": {"001": "Descriptio Graeciae (sub auctore Dicaearcho vel Athenaeo)"},
    "1406": {"001": "Fragmenta"},
    "1407": {"001": "Excerpta politiarum", "002": "Fragmenta"},
    "1408": {
        "001": "Fragmenta",
        "002": "Περὶ δυσκλίτων ῥημάτων (fragmentum) (P. Rain. 3.33A ",
    },
    "1409": {"001": "Fragmenta"},
    "1411": {"001": "Epistulae"},
    "1412": {"001": "Epistulae"},
    "1413": {"001": "De incredibilibus"},
    "1414": {"001": "Allegoriae ("},
    "1416": {
        "001": "De diversis verborum significationibus (",
        "002": "De adfinium vocabulorum differentia (lexeis additae e similibus epitomis operis ejusdem cum titulis aliis e codic",
        "003": "De propria dictione (",
        "004": "De aetatum cognitione (",
        "005": "Testimonia",
        "006": "Fragmenta",
        "007": "De diversis verborum significationibus (",
        "008": "Fragmenta",
    },
    "1419": {
        "001": "Pastor",
        "002": "Fragmenta (ap. Antiochum)",
        "003": "Fragmenta (P. Oxy. 3.404)",
        "004": "Fragmentum in F (cod. Paris. gr. 1143)",
    },
    "1420": {"001": "Fragmentum"},
    "1421": {"001": "Fragmenta", "002": "Titulus"},
    "1425": {"001": "Fragmenta"},
    "1426": {"001": "Περὶ πολιτείας [Dub.]"},
    "1427": {"001": "Fragmenta"},
    "1428": {"001": "Fragmenta"},
    "1429": {
        "001": "Ἠθικὴ στοιχείωσις",
        "002": "Fragmenta ethica (ap. Stobaeum)",
        "003": "Fragmenta (ap. Sudam)",
    },
    "1430": {"001": "Fragmenta"},
    "1431": {
        "001": "Fragmenta geographica",
        "002": "In Arati et Eudoxi phaenomena commentariorum libri iii",
    },
    "1432": {"001": "Fragmentum"},
    "1433": {"001": "Fragmenta"},
    "1434": {
        "001": "Testimonia",
        "002": "Fragmenta",
        "003": "Testimonia",
        "004": "Fragmenta",
    },
    "1435": {"001": "Fragmentum"},
    "1436": {"001": "Fragmenta [Sp.]", "002": "Testimonia"},
    "1437": {"001": "Testimonia", "002": "Fragmenta"},
    "1438": {"001": "Fragmenta"},
    "1439": {"001": "Fragmenta"},
    "1441": {"001": "Babyloniaca"},
    "1442": {"001": "Fragmenta"},
    "1443": {
        "001": "Epistulae vii genuinae (recensio media)",
        "002": "Epistulae interpolatae et epistulae suppositiciae (recensio longior) [Sp.]",
        "003": "Fragmenta (e cod. Florent. Laur. 6.4) [Sp.]",
    },
    "1444": {"001": "Ilias parva (fragmenta)"},
    "1445": {"001": "Iliu persis (fragmenta)"},
    "1446": {"001": "Fragmentum", "002": "Epigramma"},
    "1447": {
        "001": "Adversus haereses (libri 1-2)",
        "002": "Adversus haereses (liber 3)",
        "003": "Adversus haereses 5.3-13 (P. Jena)",
        "004": "Adversus haereses 3.9 (P. Oxy. 3.405)",
        "005": "Fragmenta deperditorum operum",
        "006": "Adversus haereses (liber 4)",
        "007": "Adversus haereses (liber 5)",
    },
    "1450": {"001": "Fragmentum (P. Oxy. 26.2442)", "002": "Fragmenta"},
    "1451": {"001": "Confessio et precatio Aseneth"},
    "1452": {"001": "Fragmenta"},
    "1459": {"001": "Fragmenta"},
    "1460": {"001": "De figuris"},
    "1461": {"001": "Testimonia", "002": "Fragmenta"},
    "1462": {"001": "Fragmentum"},
    "1463": {
        "001": "Apocalypsis Enochi",
        "002": "Apocalypsis Enochi (recensio ap. Syncellum)",
    },
    "1464": {"001": "Fragmenta"},
    "1466": {
        "001": "Φοινικικά (fragmenta) (P. Colon. inv. 3328)",
        "002": "Φοινικικά (fragmenta) (P. Colon. inv. 3328)",
        "003": "Φοινικικά (fragmentum) (P. Oxy. 11.1368)",
    },
    "1469": {"001": "Fragmentum"},
    "1470": {"001": "Fragmenta", "002": "Fragmenta"},
    "1471": {"001": "Fragmenta"},
    "1475": {"001": "Aretalogia (IG 11.4.1299)"},
    "1476": {"001": "Epigramma"},
    "1477": {"001": "Fragmenta"},
    "1479": {
        "001": "Epistula ad senatum, qua testatur Christianos victoriae causam fuisse"
    },
    "1482": {"001": "Cyranides"},
    "1483": {"001": "Fragmenta"},
    "1484": {"001": "Epistula ecclesiae Smyrnensis de martyrio sancti Polycarpi"},
    "1485": {"001": "Martyrium Ptolemaei et Lucii"},
    "1486": {"001": "Convivium Atticum", "002": "Fragmenta", "003": "Fragmenta"},
    "1487": {"001": "Περὶ καταρχῶν", "002": "Περὶ καταρχῶν (epitome)"},
    "1488": {"001": "Fragmentum ex libro de materia"},
    "1489": {"001": "Fragmenta"},
    "1490": {"001": "Fragmentum"},
    "1491": {"001": "Fragmenta"},
    "1493": {"001": "Εἰς Ῥώμην"},
    "1494": {"001": "Testimonia", "002": "Fragmenta"},
    "1495": {
        "001": "De pascha (P. Beatty 8 % P. Bodmer 13 % P. Oxy. 13.1600)",
        "002": "Fragmentum (P. Bodmer 12)",
        "003": "Fragmenta",
    },
    "1496": {"001": "Fragmenta"},
    "1498": {"001": "Fragmenta"},
    "1499": {"001": "Fragmenta"},
    "1500": {"001": "Fragmentum et titulus"},
    "1503": {"001": "Fragmenta"},
    "1504": {"001": "Fragmenta et titulus"},
    "1505": {"001": "Fragmentum"},
    "1506": {"001": "Fragmenta"},
    "1507": {"001": "Fragmenta"},
    "1508": {"001": "Fragmenta", "002": "Testimonia", "003": "Fragmenta"},
    "1509": {"001": "Fragmentum"},
    "1511": {"001": "Fragmenta"},
    "1512": {"001": "Minyas (fragmenta)"},
    "1514": {"001": "Fragmenta", "002": "Fragmenta"},
    "1515": {"001": "Lexicon Atticum"},
    "1516": {"001": "Fragmenta"},
    "1521": {"001": "Vita Secundi", "002": "Sententiae"},
    "1523": {"001": "Fragmenta"},
    "1524": {"001": "Fragmentum"},
    "1525": {"001": "Fragmenta"},
    "1526": {"001": "Fragmenta"},
    "1527": {"001": "Περὶ τῶν κατὰ ἀντιπάθειαν καὶ συμπάθειαν"},
    "1529": {"001": "Fragmenta"},
    "1530": {"001": "Fragmenta"},
    "1533": {"001": "Epigrammata", "002": "Fragmentum"},
    "1534": {"001": "Fragmenta"},
    "1535": {"001": "Fragmenta"},
    "1541": {"001": "Nostoi (fragmenta)"},
    "1542": {"001": "Fragmenta"},
    "1544": {"001": "Fragmenta"},
    "1545": {
        "001": "De universi natura [Sp.]",
        "002": "Fragmenta [Sp.]",
        "003": "Testimonia",
    },
    "1546": {"001": "Oechaliae halosis (fragmenta) (fort. auctore Creophylo)"},
    "1547": {"001": "Oedipodea (fragmentum) (fort. auctore Cinaethone)"},
    "1548": {"001": "Fragmenta"},
    "1549": {"001": "Fragmenta"},
    "1550": {"001": "Oracula (fragmenta) (olim sub auctore Juliano Theurgo)"},
    "1551": {"001": "Oracula", "002": "Fragmenta"},
    "1552": {"001": "Fragmenta"},
    "1553": {"001": "De incredibilibus", "002": "Fragmenta"},
    "1555": {"001": "Fragmenta", "002": "Testimonium", "003": "Fragmentum"},
    "1556": {"001": "Fragmenta", "002": "Epigrammata"},
    "1557": {"001": "Fragmenta epica", "002": "Fragmenta epica"},
    "1558": {"001": "Fragmenta"},
    "1559": {"001": "Fragmentum bucolicum"},
    "1560": {"001": "Matthiae traditiones"},
    "1562": {"001": "Testimonia", "002": "Fragmenta"},
    "1566": {"001": "Fragmenta", "002": "Fragmentum"},
    "1567": {"001": "Epigrammata"},
    "1568": {"001": "Fragmentum"},
    "1569": {"001": "Ἀττικῶν ὀνομάτων συναγωγή"},
    "1570": {"001": "Epitaphium"},
    "1571": {"001": "Fragmenta"},
    "1572": {"001": "Fragmenta"},
    "1574": {"001": "Fragmenta"},
    "1576": {"001": "Fragmentum"},
    "1577": {"001": "Epigrammata", "002": "Fragmentum"},
    "1578": {"001": "Fragmenta"},
    "1580": {"001": "Fragmentum", "002": "Fragmentum"},
    "1583": {"001": "Fragmenta"},
    "1584": {"001": "Fragmenta"},
    "1585": {"001": "Epistula"},
    "1587": {"001": "Fragmentum"},
    "1588": {"001": "Fragmenta"},
    "1590": {"001": "Fragmenta"},
    "1591": {"001": "Fragmenta"},
    "1594": {"001": "Fragmenta"},
    "1595": {"001": "Περὶ εὐσεβείας (pars i) (P. Herc. 229, 247"},
    "1596": {"001": "Testimonia", "002": "Fragmenta", "003": "Fragmenta [Sp.]"},
    "1597": {"001": "Titulus"},
    "1599": {"001": "Belopoeica", "002": "Parasceuastica et poliorcetica"},
    "1600": {"001": "Imagines"},
    "1602": {"001": "Fragmenta"},
    "1603": {"001": "Fragmenta"},
    "1604": {"001": "Sententiae", "002": "Epigramma"},
    "1605": {"001": "Sententiae"},
    "1606": {"001": "Fragmenta"},
    "1607": {"001": "Phoronis (fragmenta)"},
    "1608": {
        "001": "Praeparatio sophistica (epitome)",
        "002": "Eclogae",
        "003": "Eclogae (familia q)",
        "004": "Eclogae (familia T)",
        "005": "Praeparatio sophistica (fragmenta)",
    },
    "1609": {"001": "Testimonia", "002": "Fragmenta", "003": "Fragmentum"},
    "1611": {"001": "Fragmenta"},
    "1613": {"001": "Epistula"},
    "1615": {"001": "Fragmenta de comoedia Graeca"},
    "1617": {"001": "Declamationes", "002": "Fragmentum physiognomonicum"},
    "1622": {"001": "Epistula ad Philippenses"},
    "1623": {"001": "Fragmenta"},
    "1625": {"001": "Testimonia", "002": "Fragmenta"},
    "1626": {"001": "Fragmentum synodicae epistulae"},
    "1627": {"001": "Fragmentum"},
    "1629": {
        "001": "Περὶ ἀλόγου καταφρονήσεως (P. Herc. 336",
        "002": "Fragmenta (P. Herc. 346)",
    },
    "1632": {"001": "Epigrammata", "002": "Fragmenta et tituli"},
    "1633": {"001": "Epigramma"},
    "1634": {"001": "Testimonia", "002": "Fragmenta"},
    "1635": {"001": "Testimonia", "002": "Fragmenta", "003": "Fragmentum"},
    "1636": {"001": "Fragmenta"},
    "1637": {"001": "Protevangelium Jacobi"},
    "1638": {"001": "Fragmenta"},
    "1639": {"001": "Fragmenta"},
    "1641": {"001": "Epistula ad Floram"},
    "1642": {"001": "Fructus sive centiloquium"},
    "1643": {
        "001": "De differentia vocabulorum (",
        "002": "De differentia vocabulorum (",
    },
    "1645": {"001": "Fragmenta"},
    "1646": {"001": "Fragmenta"},
    "1648": {"001": "Fragmentum"},
    "1649": {"001": "Fragmenta"},
    "1650": {"001": "Fragmenta"},
    "1651": {"001": "Fragmenta"},
    "1654": {"001": "Fragmenta", "002": "Titulus"},
    "1661": {"001": "Fragmentum (P. Oxy. 27.2465)"},
    "1662": {"001": "Fragmentum"},
    "1663": {"001": "Fragmenta"},
    "1664": {"001": "Fragmenta"},
    "1665": {"001": "Reliquiae plurium anonymorum"},
    "1666": {"001": "Sententiae Sexti"},
    "1667": {
        "001": "Testimonia",
        "002": "Apophthegmata (ex collectione Demetrii Phalerei) (ap. Stobaeum)",
        "003": "Sententiae",
        "004": "Praecepta (sub auctore Sosiade) (ap. Stobaeum)",
        "005": "Apophthegmata (ap. auctores diversos)",
    },
    "1670": {"001": "Fragmenta"},
    "1675": {"001": "Fragmenta"},
    "1676": {"001": "Fragmenta", "002": "Fragmenta"},
    "1678": {"001": "Fragmenta"},
    "1679": {"001": "Fragmenta"},
    "1680": {"001": "Fragmentum"},
    "1681": {"001": "Epistulae"},
    "1682": {"001": "Fragmenta"},
    "1683": {"001": "Fragmenta"},
    "1685": {"001": "Fragmentum (P. Oxy. 24.2389)", "002": "Fragmenta"},
    "1687": {"001": "Fragmenta"},
    "1688": {"001": "Fragmenta", "002": "Titulus"},
    "1690": {"001": "Fragmenta"},
    "1691": {"001": "Fragmenta"},
    "1692": {
        "001": "Epistulae [Sp.]",
        "002": "Epistula ad Philippum regem [Sp.]",
        "003": "Epigramma",
        "004": "Fragmenta",
    },
    "1693": {"001": "Fragmenta"},
    "1695": {"001": "Fragmentum"},
    "1696": {"001": "Fragmenta"},
    "1698": {"001": "Fragmenta"},
    "1699": {
        "001": "Περὶ τοῦ δοκεῖν καὶ τοῦ εἶναι",
        "002": "Περὶ αὐταρκείας",
        "003": "Περὶ φυγῆς",
        "004": "Περὶ συγκρίσεως πενίας καὶ πλούτου (ap. Stobaeum)",
        "005": "Περὶ συγκρίσεως πενίας καὶ πλούτου (ap. Stobaeum)",
        "006": "Περὶ τοῦ μὴ εἶναι τέλος ἡδονήν",
        "007": "Περὶ περιστάσεων",
        "008": "Περὶ ἀπαθείας",
    },
    "1700": {"001": "Testamenta xii patriarcharum"},
    "1701": {
        "001": "Testamentum Abrahae (recensio A) (olim partim sub auctore Hesychio Hierosolymitano)",
        "002": "Testamentum Abrahae (recensio B)",
    },
    "1702": {"001": "Testamentum Jobi"},
    "1703": {
        "001": "De duodecim signis (Rhetorii Aegyptii excerpta) (e cod. Berol. 173)",
        "002": "De sideribus consurgentibus (fragmenta) (e cod. Danensi 2)",
    },
    "1704": {"001": "Fragmenta"},
    "1705": {"001": "Epistulae", "002": "Testimonia", "003": "Fragmenta"},
    "1706": {"001": "Fragmenta"},
    "1709": {"001": "Fragmenta"},
    "1710": {"001": "Fragmenta"},
    "1711": {"001": "Fragmentum"},
    "1712": {"001": "Thebaïs (fragmenta)"},
    "1713": {"001": "Fragmentum"},
    "1714": {"001": "Fragmentum", "002": "Fragmentum"},
    "1715": {"001": "Epigrammata", "002": "Fragmenta et tituli"},
    "1719": {
        "001": "Sphaerica",
        "002": "De habitationibus",
        "003": "De diebus et noctibus",
    },
    "1720": {"001": "Fragmenta"},
    "1723": {"001": "Fragmentum"},
    "1724": {"001": "De utilitate mathematicae"},
    "1725": {"001": "Ad Autolycum"},
    "1726": {"001": "Fragmentum", "002": "Fragmentum"},
    "1727": {"001": "Fragmenta"},
    "1728": {"001": "Fragmenta"},
    "1729": {"001": "Testimonia", "002": "Fragmenta"},
    "1732": {"001": "Fragmenta et tituli"},
    "1733": {"001": "Testimonia", "002": "Fragmenta", "003": "Fragmenta"},
    "1734": {"001": "Fragmenta et titulus [Sp.]", "002": "Testimonia"},
    "1735": {"001": "Epigrammata", "002": "Fragmenta et tituli"},
    "1736": {"001": "Fragmenta"},
    "1737": {"001": "Titanomachia (fragmenta)"},
    "1738": {"001": "Fragmenta", "002": "Fragmenta", "003": "Fragmenta"},
    "1746": {"001": "Valentini hymnus"},
    "1747": {"001": "Vita Adam et Evae (sub titulo Apocalypsis Mosis)"},
    "1748": {"001": "Testimonium"},
    "1749": {"001": "Vitae Hesiodi particula"},
    "1750": {
        "001": "De prophetarum vita et obitu (Dorothei recensio)",
        "002": "De prophetarum vita et obitu (recensio anonyma)",
        "003": "De prophetarum vita et obitu (recensio scholiis Hesychii aliorumque patrum in prophetas adjecta)",
        "004": "Index apostolorum discipulorumque Domini (textus Pseudo-Dorothei)",
    },
    "1751": {"001": "Fragmentum", "002": "Fragmenta"},
    "1752": {"001": "Fragmenta"},
    "1753": {"001": "Fragmenta"},
    "1754": {"001": "Epistulae"},
    "1756": {"001": "Fragmenta"},
    "1757": {"001": "Fragmenta"},
    "1759": {
        "001": "Sententiae Pythagoreorum (fort. auctore vel collectore Demophilo)",
        "002": "Sententiae Pythagoreorum",
    },
    "1760": {"001": "Περὶ βλασφημιῶν καὶ πόθεν ἑκάστη", "002": "Περὶ τῶν παρ"},
    "1763": {"001": "De tropis (olim sub auctore Gregorio Corinthio)"},
    "1764": {"001": "Anthologiarum libri ix"},
    "1765": {
        "001": "Vita G (e cod. 397 Bibliothecae Pierponti Morgan) (recensio 3)",
        "002": "Vita W (vita Aesopi Westermanniana) (recensio 2)",
        "003": "Vita Pl vel Accursiana (sub auctore Maximo Planude) (recensio 1)",
        "004": "Vita (fort. auctore Aphthonio)",
        "005": "Βιβλίον μυθικὸν τοῦ Αἰσώπου, εἰκονίζον ἀπὸ τῶν ἀλόγων ζῴων πρὸς τὰς τῆς ἀνθρωπίνης φύσεως ",
    },
    "1766": {"001": "Oratio ad Graecos", "002": "Diatesseron"},
    "1771": {"001": "Oracula"},
    "1772": {"001": "Paraleipomena Jeremiou"},
    "1775": {"001": "Epigramma"},
    "1779": {
        "001": "Fragmenta (P. Herc. 176)",
        "002": "Fragmenta (ad P. Herc. 176 pertinentia)",
    },
    "1780": {"001": "Titulus", "002": "Titulus"},
    "1781": {"001": "Fragmentum", "002": "Fragmentum"},
    "1782": {"001": "Fragmentum", "002": "Tituli"},
    "1783": {"001": "Titulus", "002": "Titulus"},
    "1784": {"001": "Titulus", "002": "Titulus"},
    "1785": {"001": "Tituli"},
    "1786": {"001": "Titulus"},
    "1787": {"001": "Tituli", "002": "Tituli"},
    "1788": {"001": "Fragmentum", "002": "Titulus"},
    "1791": {
        "001": "Comparatio Menandri et Philistionis",
        "002": "Sententiae Menandri et Philistionis",
    },
    "1792": {"001": "Tituli"},
    "1793": {"001": "Titulus"},
    "1794": {"001": "Titulus"},
    "1795": {"001": "Titulus"},
    "1797": {
        "001": "Anonymus in turpilucrum (fort. auctore Cercida)",
        "002": "Fragmenta choliambica",
    },
    "1799": {
        "001": "Elementa",
        "002": "Elementa (demonstrationes alterae, lib. 1-3)",
        "003": "Elementa (demonstrationes alterae, lib. 5-9)",
        "004": "Elementa (demonstrationes alterae, lib. 10)",
        "005": "Elementa (demonstrationes alterae, lib. 11-13)",
        "006": "Elementa (recensio altera, lib. 11.36-12.17)",
        "007": "Data",
        "008": "Data (demonstrationes alterae)",
        "009": "Optica",
        "010": "Opticorum recensio Theonis",
        "011": "Catoptrica (recensio Theonis",
        "012": "Phaenomena",
        "013": "Phaenomena (recensio b)",
        "014": "Phaenomena (demonstrationes alterae recensionis b)",
        "015": "Sectio canonis [Sp.]",
        "016": "Fragmenta",
        "017": "Epigramma",
    },
    "1800": {"001": "Fragmenta", "002": "Fragmenta et titulus"},
    "1801": {"001": "Incertorum fragmenta", "002": "Fragmenta dubia"},
    "1802": {"001": "Ilias Homerica in cyclum inclusa (fragmentum)"},
    "1803": {"001": "Epistulae"},
    "1804": {
        "001": "Ninus (fragmenta A-B) (P. Berol. 6926)",
        "002": "Ninus (fragmenta A-B) (P. Berol. 6926)",
        "003": "Ninus (fragmentum C) (PSI 13.1305)",
        "004": "Ninus (fragmentum D) (P. Gen. 85)",
    },
    "1805": {
        "001": "Vita Herodotea",
        "002": "Vita Proculea (e Chrestomathia)",
        "003": "Vita quarta",
        "004": "Vita quinta",
        "005": "Vita sexta",
        "006": "Vita septima (Eustathii vita, Od. 1713.17)",
        "007": "Tzetzae vita (Chil. 13.626-665)",
        "008": "Eustathii vita (Il. 4.17)",
        "009": "Sudae vita",
    },
    "1811": {"001": "Testimonia"},
    "1812": {"001": "Fragmenta"},
    "1813": {"001": "Fragmentum (P. Oxy. 15.1796)"},
    "1814": {"001": "Fragmenta de musica"},
    "1815": {"001": "Fragmenta"},
    "1816": {
        "001": "Lusus verborum",
        "002": "Laudes Theonis gymnasiarchi (P. Oxy. 7.1015)",
        "003": "Fragmentum epicum (Brit. Mus. inv. 1181)",
        "004": "Exercitatio ethopoeiaca (P. Ryl. 3.487)",
        "005": "Fragmentum epicum historicum (P. Argent. 480 [",
        "006": "Mercurius mundi et Hermupolis magnae conditor (P. Argent. 481 [",
        "007": "Epithalamium (P. Ryl. 1.17)",
        "008": "Exercitationes ethopoeiacae (collectio C. Graves)",
        "009": "Encomium iambicum (P. Vindob. gr. 29788b)",
        "010": "Λόγος ἐπιβατήριος (P. Vindob. gr. 29788a)",
        "011": "Laudatio professoris Smyrnaei in universitate Beryti docentis (P. Berol. 10559 A et B)",
        "012": "Laudatio professoris in universitate Beryti docentis (P. Berol. 10558)",
        "013": "Fragmentum epicum historicum (P. Berol. 5003)",
        "014": "Encomium (PSI 2.149)",
        "015": "Encomium Heraclii ducis (PSI 3.253)",
        "016": "Encomium ducis Romani (P. Flor. 2.114)",
        "017": "Polyxena et Achilles (P. Flor. 390)",
        "018": "Exercitatio ethopoeiaca (Tab. lignea Caironensis)",
        "019": "Carmen in Nilum crescentem (PSI 7.845)",
        "020": "In Thebas (P. Berol. 5226v)",
        "021": "Fragmentum (sine titulo) (P. Berol. 5227r)",
    },
    "1817": {"001": "Fragmenta"},
    "1819": {"001": "Epigramma"},
    "1821": {"001": "Fragmenta iambica adespota", "002": "Anonymorum iambica"},
    "1828": {"001": "Fragmenta"},
    "1832": {"001": "Fragmenta", "002": "Fragmentum (P. Oxy. 32.2637)"},
    "1833": {"001": "Fragmenta", "002": "Fragmenta"},
    "1835": {"001": "Fragmenta"},
    "1836": {"001": "Anonymi aulodia (P. Oxy. 15.1795)"},
    "1838": {
        "001": "Testimonia",
        "002": "Fragmenta",
        "003": "Commentarium de Pythiis xii Pindari (P. Oxy. 31.2536)",
    },
    "1839": {"001": "Tituli"},
    "1840": {"001": "Tituli"},
    "1843": {"001": "Tituli"},
    "1844": {"001": "Titulus"},
    "1845": {"001": "Tituli"},
    "1846": {"001": "Tituli"},
    "1848": {"001": "Titulus"},
    "1849": {"001": "Titulus (% dramatis personae)"},
    "1858": {"001": "Oratio"},
    "1859": {"001": "Fragmentum"},
    "1867": {"001": "Fragmenta"},
    "1868": {"001": "Fragmenta"},
    "1871": {"001": "Fragmenta"},
    "1875": {"001": "Fragmenta"},
    "1881": {
        "001": "Testimonia",
        "002": "Fragmenta",
        "003": "Fragmentum (P. Mich. 1316)",
    },
    "1890": {"001": "Fragmenta"},
    "1896": {"001": "Fragmenta"},
    "1899": {"001": "Fragmenta"},
    "1906": {"001": "Tituli"},
    "1907": {"001": "Fragmenta"},
    "1908": {"001": "Fragmenta"},
    "1911": {"001": "Fragmenta"},
    "1912": {"001": "Fragmenta"},
    "1915": {"001": "Fragmenta"},
    "1917": {"001": "Fragmenta"},
    "1918": {"001": "Fragmenta"},
    "1923": {"001": "Fragmenta"},
    "1941": {"001": "Fragmenta"},
    "1945": {"001": "Fragmentum"},
    "1949": {"001": "Fragmenta"},
    "1953": {"001": "Fragmenta"},
    "1954": {"001": "Fragmentum"},
    "1967": {"001": "Titulus"},
    "1969": {"001": "Fragmenta"},
    "1970": {"001": "Fragmenta"},
    "1972": {"001": "Fragmenta"},
    "1976": {"001": "Fragmenta"},
    "1977": {"001": "Fragmenta"},
    "1978": {"001": "Fragmenta"},
    "1981": {"001": "Fragmenta"},
    "1987": {"001": "Titulus"},
    "1992": {"001": "Fragmentum"},
    "2000": {"001": "Enneades"},
    "2001": {
        "001": "Περὶ φιλανθρωπίας ἢ Κωνστάντιος",
        "002": "Εἰς Κωνστάντιον τὸν αὐτοκράτορα, ὅτι μάλιστα φιλόσοφος ὁ βασιλεύς, ἢ χαριστήριος",
        "003": "Πρεσβευτικὸς ὑπὲρ Κωνσταντινουπόλεως ῥηθεὶς ἐν Ῥώμῃ",
        "004": "Εἰς τὸν αὐτοκράτορα Κωνστάντιον ",
        "005": "Ὑπατικὸς εἰς τὸν αὐτοκράτορα Ἰοβιανόν",
        "006": "Φιλάδελφοι ἢ περὶ φιλανθρωπίας",
        "007": "Περὶ τῶν ἠτυχηκότων ἐπὶ Οὐάλεντος",
        "008": "Πενταετηρικός",
        "009": "Προτρεπτικὸς Οὐαλεντινιανῷ νέῳ",
        "010": "Ἐπὶ τῆς εἰρήνης Οὐάλεντι",
        "011": "Δεκετηρικὸς ἢ περὶ τῶν πρεπόντων λόγων τῷ βασιλεῖ",
        "012": "Ἐρωτικὸς ἢ περὶ κάλλους βασιλικοῦ",
        "013": "Πρεσβευτικὸς εἰς Θεοδόσιον αὐτοκράτορα",
        "014": "Εἰς Θεοδόσιον",
        "015": "Χαριστήριος τῷ αὐτοκράτορι ὑπὲρ τῆς εἰρήνης καὶ τῆς ὑπατείας τοῦ στρατηγοῦ Σατορνίνου",
        "016": "Ἐπὶ τῇ χειροτονίᾳ τῆς πολιαρχίας",
        "017": "Περὶ τῆς τοῦ βασιλέως φιληκοΐας",
        "018": "Ἐπὶ τῇ φιλανθρωπίᾳ τοῦ αὐτοκράτορος Θεοδοσίου",
        "019": "Ἐπιτάφιος ἐπὶ τῷ πατρί",
        "020": "Βασανιστὴς ἢ φιλόσοφος",
        "021": "Περὶ φιλίας",
        "022": "Σοφιστής",
        "023": "Προτρεπτικὸς Νικομηδεῦσιν εἰς φιλοσοφίαν",
        "024": "Πρὸς τὸν ἀξιώσαντα λέγειν ἐκ τοῦ παραχρῆμα",
        "025": "Περὶ τοῦ μὴ δεῖν τοῖς τόποις ἀλλὰ τοῖς ἀνδράσι προσέχειν",
        "026": "Ἡ ἐπὶ τῷ λόγῳ διάλεξις",
        "027": "Πρὸς τοὺς οὐκ ὀρθῶς ἐξηγουμένους τὸν σοφιστήν",
        "028": "Θέσις εἰ γεωργητέον",
        "029": "Περὶ προεδρίας εἰς τὴν σύγκλητον",
        "030": "Μετριοπαθὴς ἢ φιλότεκνος",
        "031": "Πρὸς τοὺς αἰτιασαμένους ἐπὶ τῷ δέξασθαι τὴν ἀρχήν",
        "032": "Περὶ ψυχῆς (fragmenta)",
        "033": "Περὶ φρονήσεως (fragmentum)",
        "034": "Analyticorum posteriorum paraphrasis",
        "035": "In Aristotelis physica paraphrasis",
        "036": "In Aristotelis libros de anima paraphrasis",
        "037": "(Sophoniae) in parva naturalia commentarium",
        "038": "Quae fertur in Aristotelis analyticorum priorum librum i paraphrasis",
    },
    "2002": {"001": "Ars rhetorica (olim sub nomine Cornuti)"},
    "2003": {
        "001": "Ἐγκώμιον εἰς τὸν αὐτοκράτορα Κωνστάντιον",
        "002": "Εὐσεβίας τῆς βασιλίδος ἐγκώμιον",
        "003": "Περὶ τῶν τοῦ αὐτοκράτορος πράξεων ἢ περὶ βασιλείας",
        "004": "Ἐπὶ τῇ ἐξόδῳ τοῦ ἀγαθωτάτου Σαλουστίου παραμυθητικὸς εἰς ἑαυτόν",
        "005": "Ἀθηναίων τῇ βουλῇ καὶ τῷ δήμῳ",
        "006": "Θεμιστίῳ φιλοσόφῳ",
        "007": "Πρὸς Ἡράκλειον κυνικὸν περὶ τοῦ πῶς κυνιστέον καὶ εἰ πρέπει τῷ κυνὶ μύθους πλάττειν",
        "008": "Εἰς τὴν μητέρα τῶν θεῶν",
        "009": "Εἰς τοὺς ἀπαιδεύτους κύνας",
        "010": "Συμπόσιον ἢ Κρόνια sive Caesares",
        "011": "Εἰς τὸν βασιλέα Ἥλιον πρὸς Σαλούστιον",
        "012": "Misopogon (sc. Ἀντιοχικὸς ἢ Μισοπώγων)",
        "013": "Epistulae",
        "014": "Poematia et fragmenta",
        "015": "Epistulae dubiae",
        "016": "Epistulae spuriae",
        "017": "Contra Galilaeos",
        "018": "Epigrammata",
        "019": "Testimonia",
        "020": "Fragmentum",
    },
    "2004": {"001": "Amelii epistula"},
    "2005": {"001": "Martyrium Pionii presbyteri et sodalium"},
    "2006": {
        "001": "Epistulae",
        "002": "Oratio de regno",
        "003": "Aegyptii sive de providentia",
        "004": "Ad Paeonium de dono astrolabii",
        "005": "De insomniis",
        "006": "Calvitii encomium",
        "007": "Dion",
        "008": "Homiliae",
        "009": "Catastases",
        "010": "Hymni",
        "011": "Epigrammata",
    },
    "2007": {"001": "Martyrium Potamiaenae et Basilidis"},
    "2008": {"001": "Martyrium Cononis"},
    "2009": {"001": "Martyrium Marini"},
    "2010": {"001": "Martyrium Dasii"},
    "2011": {"001": "Martyrium Agapae, Irenae, Chionae et sodalium"},
    "2012": {"001": "Acta Eupli"},
    "2014": {"001": "Acta Phileae (P. Bodmer 20)"},
    "2015": {"001": "Testamentum xl martyrum"},
    "2016": {"001": "Passio Perpetuae et Felicitatis"},
    "2017": {
        "001": "Ad Eustathium de sancta trinitate",
        "002": "Ad Graecos ex communibus notionibus",
        "003": "Ad Ablabium quod non sint tres dei",
        "004": "Ad Simplicium de fide",
        "005": "Adversus Arium et Sabellium de patre et filio",
        "006": "Adversus Macedonianos de spiritu sancto",
        "007": "Ad Theophilum adversus Apollinaristas",
        "008": "Antirrheticus adversus Apollinarium",
        "009": "De mortuis non esse dolendum",
        "010": "De beneficentia (vulgo De pauperibus amandis i)",
        "011": "In illud",
        "012": "Contra usurarios",
        "013": "Contra fornicarios",
        "014": "In diem luminum (vulgo In baptismum Christi oratio)",
        "015": "In sanctum pascha (vulgo In Christi resurrectionem oratio iii)",
        "016": "De tridui inter mortem et resurrectionem domini nostri Jesu Christi spatio (vulgo In Christi resurrectionem orati",
        "017": "In sanctum et salutare pascha (vulgo In Christi resurrectionem oratio iv)",
        "018": "In luciferam sanctam domini resurrectionem (vulgo In Christi resurrectionem oratio v) [Sp.]",
        "019": "In ascensionem Christi",
        "020": "De deitate adversus Evagrium (vulgo In suam ordinationem)",
        "021": "Oratio funebris in Meletium episcopum",
        "022": "Oratio consolatoria in Pulcheriam",
        "023": "Oratio funebris in Flacillam imperatricem",
        "024": "De instituto Christiano",
        "025": "De professione Christiana ad Harmonium",
        "026": "De perfectione Christiana ad Olympium monachum",
        "027": "In inscriptiones Psalmorum",
        "028": "In sextum Psalmum",
        "029": "In Ecclesiasten (homiliae 8)",
        "030": "Contra Eunomium",
        "031": "Refutatio confessionis Eunomii",
        "032": "In Canticum canticorum (homiliae 15)",
        "033": "Epistulae",
        "034": "De creatione hominis sermo primus [Sp.]",
        "035": "De creatione hominis sermo alter [Sp.]",
        "036": "De paradiso [Sp.]",
        "037": "De creatione hominis sermo primus (recensio C) [Sp.]",
        "038": "De creatione hominis sermo alter (recensio C) [Sp.]",
        "039": "De paradiso (recensio ΛF) [Sp.]",
        "040": "Encomium in sanctum Stephanum protomartyrem i",
        "041": "Vita sanctae Macrinae",
        "042": "De vita Mosis",
        "043": "De virginitate",
        "044": "De virginitate (recensio altera)",
        "045": "Oratio catechetica magna",
        "046": "De oratione dominica orationes v",
        "047": "In Basilium fratrem",
        "048": "Oratio in diem natalem Christi",
        "049": "In annuntiationem [Sp.]",
        "050": "Inventio imaginis in Camulianis [Sp.]",
        "051": "Orationes viii de beatitudinibus",
        "052": "Ad imaginem dei et ad similitudinem [Sp.]",
        "053": "Dialogus de anima et resurrectione",
        "054": "Testimonia adversus Judaeos [Sp.]",
        "055": "Adversus eos qui castigationes aegre ferunt",
        "056": "De iis qui baptismum differunt",
        "057": "Decem syllogismi contra Manichaeos [Sp.]",
        "058": "De deitate filii et spiritus sancti",
        "059": "De spiritu sancto sive In pentecosten",
        "060": "Encomium in sanctum Stephanum protomartyrem ii",
        "061": "De sancto Theodoro",
        "062": "Encomium in xl martyres i",
        "063": "Encomium in xl martyres ii",
        "064": "In sanctum Ephraim",
        "065": "De vita Gregorii Thaumaturgi",
        "066": "Epistula xxvi ad Evagrium monachum [Sp.]",
        "067": "Sermo in illud",
        "068": "Sermo in Mariam et Joseph (ap. Joannem Damascenum, Sacra parallela) (fragmentum)",
        "069": "De occursu domini [Sp.]",
        "070": "Tractatus ad Xenodorum (fragmentum)",
        "071": "Sermo in sanctum Romanum (ap. Joannem Damascenum, Sacra parallela) (fragmentum)",
        "072": "Epistula canonica ad Letoium",
        "073": "Liber de cognitione dei (",
        "074": "Apologia in hexaemeron",
        "075": "De opificio hominis",
        "076": "Epistula ad Philippum monachum (ap. Joannem Damascenum, Contra Jacobitas) (fragmentum)",
        "077": "In illud",
        "078": "Contra fatum",
        "079": "De infantibus praemature abreptis",
        "080": "De pythonissa ad Theodosium episcopum",
    },
    "2018": {
        "001": "Praeparatio evangelica",
        "002": "Historia ecclesiastica",
        "003": "De martyribus Palaestinae (recensio brevior)",
        "004": "De martyribus Palaestinae (recensio prolixior)",
        "005": "Demonstratio evangelica",
        "006": "Demonstratio evangelica (fragmenta libri xv)",
        "007": "Contra Marcellum",
        "008": "Epistula ad Flacillum",
        "009": "De ecclesiastica theologia",
        "010": "De theophania (fragmenta)",
        "011": "Onomasticon",
        "012": "In cantica canticorum interpretatio",
        "013": "Epistula ad Carpianum ad canones evangeliorum praemissa",
        "014": "Epistula ad Caesarienses",
        "015": "Epistula ad Alexandrum Alexandrinum",
        "016": "Epistula ad Euphrationem",
        "017": "Contra Hieroclem",
        "018": "De mensuris et ponderibus (fragmenta)",
        "019": "Commentarius in Isaiam",
        "020": "Vita Constantini",
        "021": "Constantini imperatoris oratio ad coetum sanctorum",
        "022": "De laudibus Constantini",
        "023": "Generalis elementaria introductio (",
        "024": "Generalis elementaria introductio (fragmenta)",
        "025": "Antiquorum martyriorum collectio (fragmenta)",
        "026": "Passio sanctorum decem martyrum Aegyptiorum (fragmenta)",
        "027": "Epistula ad Constantiam Augustam",
        "028": "Quaestiones evangelicae ad Stephanum",
        "029": "Quaestiones evangelicae ad Marinum",
        "030": "Supplementa ad quaestiones ad Stephanum",
        "031": "Supplementa ad quaestiones ad Marinum",
        "032": "Supplementa minora ad quaestiones ad Marinum",
        "033": "De vitis prophetarum (fragmenta)",
        "034": "Commentaria in Psalmos",
        "035": "Fragmenta in proverbia",
        "036": "Fragmenta in Danielem",
        "037": "Fragmenta in Lucam",
        "038": "Fragmenta in Hebraeos",
        "039": "De solemnitate paschali",
    },
    "2019": {
        "001": "Πελαγίου φιλοσόφου περὶ τῆς θείας ταύτης καὶ ἱερᾶς τέχνης (e cod. Venet. Marc. 299, fol. 62v)"
    },
    "2020": {
        "001": "Canones isagogici de flexione nominum",
        "002": "Canones isagogici de flexione verborum",
        "003": "Περὶ γραμματικῆς [Sp.] (fort. auctore Theodoro Prodromo)",
        "004": "Περὶ τόνου [Sp.] (fort. auctore Theodoro Prodromo)",
        "005": "Epitome catholicae Herodiani [Sp.] (fort. auctore quodam Theodosio Byzantio)",
        "006": "Περὶ κλίσεως τῶν εἰς ",
        "007": "Περὶ κλίσεως τῶν εἰς ",
        "008": "De dialectis [Sp.] (fort. auctore Theodosio alio vel anonymo)",
    },
    "2021": {
        "001": "Ancoratus",
        "002": "Panarion (",
        "003": "Anacephalaeosis [Sp.]",
        "004": "De xii gemmis",
        "005": "De xii gemmis (fragmenta ap. Anastasium Sinaïtam, Quaestiones et responsiones)",
        "006": "De xii gemmis (fragmenta alia ap. Anastasium Sinaïtam, Quaestiones et responsiones)",
        "007": "Epistula ad Eusebium, Marcellum, Vivianum, Carpum et ad Aegyptios (fragmentum)",
        "008": "Tractatus contra eos qui imagines faciunt (fragmenta)",
        "009": "Epistula ad Theodosium imperatorem (fragmenta)",
        "010": "Testamentum ad cives (fragmenta)",
        "011": "Epistula ad Joannem Hierosolymitanum (fragmentum)",
        "012": "Homilia in festo palmarum [Sp.]",
        "013": "Homilia in divini corporis sepulturam [Sp.]",
        "014": "Homilia in Christi resurrectionem (inc. Ὁ τῆς δικαιοσύνης) [Sp.]",
        "015": "Homilia in assumptionem Christi [Sp.]",
        "016": "Homilia in laudes Mariae deiparae [Sp.]",
        "017": "Homilia in festo palmarum (fragmentum) [Sp.]",
        "018": "Tractatus de numerorum mysteriis [Sp.]",
        "019": "Fragmenta precationis et exorcismi [Sp.]",
        "020": "Enumeratio lxxii prophetarum et prophetissarum [Sp.]",
        "021": "De prophetarum vita et obitu (recensio prior) [Sp.]",
        "022": "De prophetarum vita et obitu (recensio altera) [Sp.]",
        "023": "Index apostolorum [Sp.]",
        "024": "Index discipulorum [Sp.]",
        "025": "Nomina apostolorum [Sp.]",
        "026": "Testimonia ex divinis et sacris scripturis (",
        "027": "Notitiae episcopatuum [Sp.]",
        "028": "Apophthegmata (ap. Apophthegmata patrum) [Sp.]",
        "029": "De fide (fragmentum) [Sp.]",
        "030": "De trinitate (fragmentum) [Sp.]",
        "031": "Liturgia praesanctificatorum",
        "032": "Anaphora Graeca (fragmenta) [Sp.]",
        "033": "De mensuris et ponderibus",
        "034": "De mensuris et ponderibus (excerptum Graecum 2)",
        "035": "De mensuris et ponderibus (excerptum Graecum 3)",
        "036": "De mensuris et ponderibus (excerptum Graecum 4)",
        "037": "De mensuris et ponderibus (ap. Cosmam) (excerptum Graecum 6)",
        "038": "De mensuris et ponderibus (ap. Chronicon paschale) (excerptum Graecum 7)",
        "039": "De mensuris et ponderibus (ap. Joannem Damascenum) (excerptum Graecum 8)",
        "040": "Homilia in Christi resurrectionem (inc. Νῦν τὸ πένθος) [Sp.]",
        "041": "Appendices ad indices apostolorum discipulorumque",
    },
    "2022": {
        "001": "Epistulae",
        "002": "Epistulae theologicae",
        "003": "Christus patiens [Dub.] (fort. auctore Constantino Manasse)",
        "004": "De vita sua",
        "005": "Funebris in laudem Caesarii fratris oratio (orat. 7)",
        "006": "Funebris oratio in laudem Basilii Magni Caesareae in Cappadocia episcopi (orat. 43)",
        "007": "Adversus Eunomianos (orat. 27)",
        "008": "De theologia (orat. 28)",
        "009": "De filio (orat. 29)",
        "010": "De filio (orat. 30)",
        "011": "De spiritu sancto (orat. 31)",
        "012": "Comparatio vitarum (",
        "013": "De testamentis et adventu Christi (",
        "014": "Alphabeticum paraeneticum 1 (e cod. Patm. 33)",
        "015": "In sanctum pascha et in tarditatem (orat. 1)",
        "016": "Apologetica (orat. 2)",
        "017": "Ad eos qui ipsum acciverant nec occurrerant (orat. 3)",
        "018": "Contra Julianum imperatorem 1 (orat. 4)",
        "019": "Contra Julianum imperatorem 2 (orat. 5)",
        "020": "De pace 1 (orat. 6)",
        "021": "In laudem sororis Gorgoniae (orat. 8)",
        "022": "Apologeticus ad patrem (orat. 9)",
        "023": "In seipsum ad patrem et Basilium magnum (orat. 10)",
        "024": "Ad Gregorium Nyssenum (orat. 11)",
        "025": "Ad patrem (orat. 12)",
        "026": "In consecratione Eulalii Doarensium episcopi (orat. 13)",
        "027": "De pauperum amore (orat. 14)",
        "028": "In Machabaeorum laudem (orat. 15)",
        "029": "In patrem tacentem (orat. 16)",
        "030": "Ad cives Nazianzenos (orat. 17)",
        "031": "Funebris oratio in patrem (orat. 18)",
        "032": "Ad Julianum tributorum exaequatorem (orat. 19)",
        "033": "De dogmate et constitutione episcoporum (orat. 20)",
        "034": "In laudem Athanasii (orat. 21)",
        "035": "De pace 2 (orat. 22)",
        "036": "De pace 3 (orat. 23)",
        "037": "In laudem Cypriani (orat. 24)",
        "038": "In laudem Heronis philosophi (orat. 25)",
        "039": "In seipsum, cum rure rediisset, post ea quae a Maximo perpetrata fuerant (orat. 26)",
        "040": "De moderatione in disputando (orat. 32)",
        "041": "Contra Arianos et de seipso (orat. 33)",
        "042": "In Aegyptiorum adventum (orat. 34)",
        "043": "De martyribus et adversus Arianos (orat. 35) [Sp.]",
        "044": "De seipso et ad eos qui ipsum cathedram Constantinopolitanam affectare dicebant (orat. 36)",
        "045": "In dictum evangelii",
        "046": "In theophania (orat. 38)",
        "047": "In sancta lumina (orat. 39)",
        "048": "In sanctum baptisma (orat. 40)",
        "049": "In pentecosten (orat. 41)",
        "050": "Supremum vale (orat. 42)",
        "051": "In novam Dominicam (orat. 44)",
        "052": "In sanctum pascha (orat. 45)",
        "053": "Significatio in Ezechielem [Sp.]",
        "054": "Fragmentum ex oratione contra astronomos [Sp.]",
        "055": "Liturgia sancti Gregorii [Sp.]",
        "056": "Ἁλάτιον σκευασθὲν ὑπὸ τῆς ἐνεργείας τοιάσδε",
        "057": "Epigrammata",
        "058": "Testamentum",
        "059": "Carmina dogmatica",
        "060": "Carmina moralia",
        "061": "Carmina de se ipso",
        "062": "Carmina quae spectant ad alios",
        "063": "Alphabeticum A [Sp.]",
        "064": "Ὁ προτρεπτικὸς εἰς ὑπομονὴν ἢ πρὸς τοὺς νεωστὶ βεβαπτισμένους",
    },
    "2023": {
        "001": "De vita Pythagorica",
        "002": "Protrepticus",
        "003": "De communi mathematica scientia",
        "004": "In Nicomachi arithmeticam introductionem",
        "005": "Theologoumena arithmeticae",
        "006": "De mysteriis",
    },
    "2025": {"001": "Περὶ τῶν ἀλύτων ἀντιθέσεων (fort. auctore Maximo Byzantio)"},
    "2027": {"001": "Ars rhetorica", "002": "Περὶ τῶν ἐσχηματισμένων προβλημάτων"},
    "2029": {"001": "Anonymi summaria ratio geographiae in sphaera intelligendae"},
    "2030": {"001": "Fragmenta"},
    "2031": {
        "001": "Διαίρεσις ζητημάτων",
        "002": "Scholia ad Hermogenis status seu artem rhetoricam",
        "003": "Prolegomena in Aristidem",
    },
    "2032": {
        "001": "Synagoge",
        "002": "Commentaria in Ptolemaei syntaxin mathematicam 5-6",
    },
    "2033": {
        "001": "Commentaria in Ptolemaei syntaxin mathematicam i-iv",
        "002": "Εἰς τοὺς προχείρους κανόνας (commentarium parvum)",
        "003": "Testimonia",
        "004": "Epigrammata",
        "005": "Ὑπόμνημα εἰς τοὺς προχείρους Πτολεμαίου κανόνας (commentarium magnum) (lib. 1-3)",
    },
    "2034": {
        "001": "Vita Plotini",
        "002": "Vita Pythagorae",
        "003": "De abstinentia",
        "004": "De antro nympharum",
        "005": "Ad Marcellam",
        "006": "Isagoge sive quinque voces",
        "007": "In Aristotelis categorias expositio per interrogationem et responsionem",
        "008": "Sententiae ad intelligibilia ducentes",
        "009": "In Platonis Timaeum commentaria (fragmenta)",
        "010": "Chronica",
        "011": "De philosophia ex oraculis",
        "012": "Περὶ ἀγαλμάτων",
        "013": "Epistula ad Anebonem",
        "014": "Quaestionum Homericarum ad Iliadem pertinentium reliquiae",
        "015": "Zetemata codicis Vaticani",
        "016": "Quaestionum Homericarum ad Odysseam pertinentium reliquiae",
        "017": "Quaestionum Homericarum liber i (recensio V)",
        "018": "Quaestionum Homericarum liber i (recensio Χ)",
        "019": "Quaestionum Homericarum liber i (recensio T)",
        "020": "Quaestionum Homericarum liber i (recensio B)",
        "021": "Εἰς τὰ ἁρμονικὰ Πτολεμαίου ὑπόμνημα",
        "022": "Commentarium in Platonis Timaeum (fragmentum incertum)",
        "023": "Contra Christianos (fragmenta)",
        "024": "Testimonia",
        "025": "Fragmenta",
        "026": "Historia philosophiae (fragmenta)",
        "027": "In Platonis Parmenidem commentaria (fragmenta)",
    },
    "2035": {
        "001": "Contra gentes",
        "002": "De incarnatione verbi",
        "003": "De decretis Nicaenae synodi",
        "004": "De sententia Dionysii",
        "005": "Apologia contra Arianos sive Apologia secunda",
        "006": "Epistula encyclica",
        "007": "Epistula ad Serapionem de morte Arii",
        "008": "Epistula ad monachos",
        "009": "Historia Arianorum",
        "010": "De synodis Arimini in Italia et Seleuciae in Isauria",
        "011": "Apologia ad Constantium imperatorem",
        "012": "Apologia de fuga sua",
        "013": "Epistula ad Amun",
        "014": "Epistula festalis xxxix (fragmentum in collectione canonum)",
        "015": "Epistula ad Rufinianum",
        "016": "De non participando divinis mysteriis sine discrimine [Sp.]",
        "017": "In illud",
        "018": "Homilia in illud",
        "019": "Homilia in illud",
        "020": "Sermo in ramos palmarum [Sp.]",
        "021": "Homilia de jejunio et de passione Christi [Sp.]",
        "022": "Sermo major de fide [Sp.]",
        "023": "Quaestio 136 e quaestionibus ad Antiochum ducem (e cod. Paris. 635) [Sp.]",
        "024": "Quaestio 136 e quaestionibus ad Antiochum ducem (e cod. Guelferbytano-Gudiano 51) [Sp.]",
        "025": "Doctrina ad Antiochum ducem [Sp.]",
        "026": "De sancta trinitate (dialogi 2 and 4) [Sp.]",
        "027": "Epistula ad imperatorem Jovianum [Sp.]",
        "028": "De virginitate [Sp.]",
        "029": "Commentarius de templo Athenarum [Sp.]",
        "030": "Sermo major (collatio cod. Laurentiani gr. 4.23) [Sp.]",
        "031": "Commentarius de templo Athenarum (cod. Bodleianus Roe 5) [Sp.]",
        "032": "Epistula ad Liberium [Sp.]",
        "033": "Dialogus Athanasii et Zacchaei [Sp.]",
        "034": "De morbo et valetudine (fragmenta)",
        "035": "Oratio in resurrectionem et in recens baptizatos [Sp.]",
        "036": "De fallacia diaboli (",
        "037": "Sermo exhortatorius [Sp.] (e cod. Paris. gr. 769)",
        "038": "In illud",
        "039": "Epistula ad Dracontium",
        "040": "Epistula ad episcopos Aegypti et Libyae",
        "041": "Orationes tres contra Arianos",
        "042": "Epistulae quattuor ad Serapionem",
        "043": "In illud",
        "044": "Tomus ad Antiochenos",
        "045": "Petitiones Arianorum",
        "046": "Vita Antonii",
        "047": "Epistula ad Afros episcopos",
        "048": "Epistula ad Adelphium",
        "049": "Epistula ad Maximum",
        "050": "Epistula ad Joannem et Antiochum presbyteros",
        "051": "Epistula ad Palladium",
        "052": "Fragmenta varia",
        "053": "Epistula ad monachos",
        "054": "Sermo de patientia [Sp.]",
        "055": "Scholia in Acta (fort. ex libris Contra Novatianos)",
        "056": "De azymis [Sp.]",
        "057": "Epistula ad Marcellinum de interpretatione Psalmorum",
        "058": "Argumentum in Psalmos [Sp.]",
        "059": "Expositiones in Psalmos",
        "060": "Scholia in cantica canticorum",
        "061": "Homilia in Canticum canticorum [Sp.]",
        "062": "Testimonia e scriptura (de communi essentia patris et filii et spiritus sancti) [Sp.]",
        "063": "Epistula catholica [Sp.]",
        "064": "Refutatio hypocriseos Meletii et Eusebii [Sp.]",
        "065": "Contra Sabellianos [Sp.]",
        "066": "De sabbatis et circumcisione [Sp.]",
        "067": "Homilia de semente [Sp.]",
        "068": "Homilia de passione et cruce domini [Sp.]",
        "069": "Synopsis scripturae sacrae [Sp.]",
        "070": "Disputatio contra Arium [Sp.]",
        "071": "Sermo contra omnes haereses [Sp.]",
        "072": "Historia de Melchisedech [Sp.]",
        "073": "Liber de definitionibus [Sp.]",
        "074": "Sermo ad Antiochum ducem [Sp.]",
        "075": "Quaestiones ad Antiochum ducem [Sp.]",
        "076": "Quaestiones in evangelia [Sp.]",
        "077": "Fragmentum sermonis de imaginibus [Sp.]",
        "078": "Quaestiones in scripturam sacram [Sp.]",
        "079": "Quaestiones aliae [Sp.]",
        "080": "Narratio de cruce seu imagine Berytensi [Sp.]",
        "081": "Sermo contra Latinos [Sp.]",
        "082": "Vitae monasticae institutio [Sp.]",
        "083": "Epistulae ad Castorem [Sp.]",
        "084": "In nativitatem praecursoris [Sp.]",
        "085": "Sermo in annuntiationem deiparae [Sp.]",
        "086": "Sermo de descriptione deiparae [Sp.]",
        "087": "Sermo in nativitatem Christi [Sp.]",
        "088": "Homilia in occursum domini [Sp.]",
        "089": "In caecum a nativitate [Sp.]",
        "090": "Homilia in sanctos patres et prophetas [Sp.]",
        "091": "Dialogi duo contra Macedonianos [Sp.]",
        "092": "Syntagma ad quendam politicum [Sp.]",
        "093": "Sermo pro iis qui saeculo renuntiarunt [Sp.]",
        "094": "Doctrina ad monachos [Sp.]",
        "095": "De corpore et anima [Sp.]",
        "096": "Vita sanctae Syncleticae [Sp.]",
        "097": "Epistula ad episcopum Persarum [Sp.]",
        "098": "Symbolum ",
        "099": "De trinitate [Sp.]",
        "100": "De sancta trinitate (dialogi 1, 3, 5) [Sp.]",
        "101": "Epistula ad Epictetum",
        "102": "Quaestio cxii ad Antiochum ducem in collectione canonum",
        "103": "Scholia in Job",
        "104": "Scholia in Job (e cod. Vat. Pii II)",
        "105": "Oratio quarta contra Arianos [Sp.]",
        "106": "Syntagma ad monachos (e cod. Vossiano gr., fol. 46) [Sp.]",
        "107": "Epistula ad Jovianum",
        "108": "Epistula ad monachos",
        "109": "Epistula ad Epiphanium (fragmentum ap. Chronicon paschale)",
        "110": "Homilia in illud",
        "111": "Epistula ad Eupsychium (fragmenta)",
        "112": "De incarnatione contra Apollinarium libri ii [Sp.]",
        "113": "Homilia de passione et cruce domini (additamenta)",
        "114": "Didascalia cccxviii patrum Nicaenorum [Sp.]",
        "115": "Syntagma ad monachos (e cod. Vat. gr. 733) [Sp.]",
    },
    "2036": {"001": "In Aristotelis categorias commentarium"},
    "2037": {"001": "Anthologium"},
    "2038": {
        "001": "Acta Thomae",
        "002": "Carmen animae (De margarita) (cod. Rom. vallicellanus B 35)",
        "003": "Carmen animae (De margarita) (paraphrasis Nicetae)",
        "004": "Acta Thomae (recensio)",
        "005": "Actorum Thomae consummatio",
    },
    "2039": {
        "001": "Arithmeticorum libri sex",
        "002": "De polygonis numeris",
        "003": "Fragmentum [Sp.] (e cod. Paris. suppl. gr. 387, fol. 181r)",
        "004": "Fragmentum [Sp.] (e cod. Paris. 453)",
        "005": "Fragmentum [Sp.] (e cod. Paris. gr. 2448)",
    },
    "2040": {
        "001": "Homiliae in hexaemeron",
        "002": "De legendis gentilium libris",
        "003": "De spiritu sancto",
        "004": "Epistulae",
        "005": "Epistulae tres",
        "006": "Homilia in illud",
        "007": "Homilia in illud",
        "008": "Homilia in divites",
        "009": "Enarratio in prophetam Isaiam [Dub.]",
        "010": "Expositio fidei Nicaenae [Sp.]",
        "011": "Homilia in aquas [Sp.]",
        "012": "Homilia de virginitate [Sp.]",
        "013": "De spiritu [Sp.]",
        "014": "Homiliae super Psalmos",
        "015": "Adversus Eunomium (libri 5)",
        "016": "De jejunio (homilia 1)",
        "017": "De jejunio (homilia 2)",
        "018": "Homilia de gratiarum actione",
        "019": "Homilia in martyrem Julittam",
        "020": "Homilia dicta tempore famis et siccitatis",
        "021": "Quod deus non est auctor malorum",
        "022": "Homilia adversus eos qui irascuntur",
        "023": "Homilia de invidia",
        "024": "Homilia in principium proverbiorum",
        "025": "Homilia exhortatoria ad sanctum baptisma",
        "026": "In ebriosos",
        "027": "De fide",
        "028": "In illud",
        "029": "In Barlaam martyrem [Sp.]",
        "030": "In Gordium martyrem",
        "031": "In quadraginta martyres Sebastenses",
        "032": "De humilitate",
        "033": "Quod rebus mundanis adhaerendum non sit",
        "034": "In Mamantem martyrem",
        "035": "Contra Sabellianos et Arium et Anomoeos",
        "036": "Sermo 10 (praevia institutio ascetica) [Dub.]",
        "037": "Sermo 11 (sermo asceticus et exhortatio de renuntiatione mundi) [Dub.]",
        "038": "Sermo 12 (de ascetica disciplina) [Dub.]",
        "039": "Prologus 7 (de judicio dei)",
        "040": "Sermo 13 (sermo asceticus) [Dub.]",
        "041": "Prologus 8 (de fide)",
        "042": "Prologus 5 (sermo asceticus) [Dub.]",
        "043": "Prologus 4 (prooemium in asceticum magnum)",
        "044": "Asceticon magnum sive Quaestiones (regulae fusius tractatae)",
        "045": "Prologus 3 (prooemium in regulas brevius tractatas)",
        "046": "Asceticon magnum sive Quaestiones (regulae brevius tractatae)",
        "047": "Regulae morales",
        "048": "De baptismo libri duo",
        "049": "In Psalmum 28 (homilia 2) [Sp.]",
        "050": "Homilia in Psalmum 37 [Sp.]",
        "051": "Homilia in Psalmum 115",
        "052": "Homilia in Psalmum 132 [Sp.]",
        "053": "Homilia de spiritu sancto [Sp.]",
        "054": "Homilia dicta in Lacisis",
        "055": "In sanctam Christi generationem",
        "056": "Homilia de paenitentia [Sp.] (sub auctore Eusebio Emeseno)",
        "057": "Adversus eos qui per calumniam dicunt dici a nobis tres deos",
        "058": "Homilia in illud",
        "059": "De jejunio (homilia 3) [Sp.]",
        "060": "Orationes sive Exorcismi [Sp.]",
        "061": "Poenae in monachos delinquentes (epitimia 24) [Dub.]",
        "062": "Epitimia in canonicas (epitimia 25) [Dub.]",
        "063": "Epitimia (epitimia 26) [Sp.]",
        "064": "Consolatoria ad aegrotum [Sp.] (sub auctore Proclo)",
        "065": "Homilia de misericordia et judicio [Sp.]",
        "066": "Sermo ob sacerdotum instructionem (recensio brevior) [Sp.]",
        "067": "Liturgia (recensio brevior vetusta)",
        "068": "Sermo de contubernalibus [Sp.]",
        "069": "Oratio pro inimicis et amicis [Sp.]",
        "070": "Constitutiones asceticae [Sp.]",
        "071": "Sermones de moribus a Symeone Metaphrasta collecti",
        "072": "Sermo ob sacerdotum instructionem (recensio fusior) [Sp.]",
        "073": "Prologus 6 (prooemium ad Hypotyposin)",
        "074": "Sermo 14 (De fide) [Sp.]",
        "075": "Sermo 15 (De vita monastica) (excerptum) [Sp.]",
        "076": "Sermo 16 (De calumnia) [Sp.]",
        "077": "Canon 96 (De haereticis) (fragmentum)",
    },
    "2041": {
        "001": "Fragmenta",
        "002": "Expositio fidei",
        "003": "De incarnatione et contra Arianos",
    },
    "2042": {
        "001": "Contra Celsum",
        "002": "De principiis",
        "003": "Fragmenta de principiis",
        "004": "Fragmenta alia de principiis",
        "005": "Commentarii in evangelium Joannis (lib. 1, 2, 4, 5, 6, 10, 13)",
        "006": "Fragmenta in evangelium Joannis (in catenis)",
        "007": "Exhortatio ad martyrium",
        "008": "De oratione",
        "009": "In Jeremiam (homiliae 1-11)",
        "010": "Fragmenta in Jeremiam (in catenis)",
        "011": "Fragmenta in Lamentationes (in catenis)",
        "012": "Fragmentum in Lamentationes (in catenis)",
        "013": "De engastrimytho (",
        "014": "Fragmenta in librum primum Regnorum (in catenis)",
        "015": "Fragmentum in librum primum Regnorum (in catenis)",
        "016": "Homiliae in Lucam",
        "017": "Fragmenta in Lucam (in catenis)",
        "018": "Dialogus cum Heraclide",
        "019": "Philocalia sive Ecloga de operibus Origenis a Basilio et Gregorio Nazianzeno facta (cap. 1-27)",
        "020": "Philocalia sive Ecloga de operibus Origenis a Basilio et Gregorio Nazianzeno facta (cap. 23, 25-27)",
        "021": "In Jeremiam (homiliae 12-20)",
        "022": "Homiliae in Genesim (in catenis)",
        "023": "Homiliae in Exodum",
        "024": "Homiliae in Leviticum",
        "025": "In Jesu Nave homiliae xxvi (fragmenta e catenis)",
        "026": "Libri x in Canticum canticorum (fragmenta)",
        "027": "Homiliae in Ezechielem",
        "028": "Commentariorum series in evangelium Matthaei (Mt. 22.34-27.63)",
        "029": "Commentarium in evangelium Matthaei (lib. 10-11)",
        "030": "Commentarium in evangelium Matthaei (lib. 12-17)",
        "031": "Fragmenta ex commentariis in evangelium Matthaei",
        "032": "Fragmenta in evangelium Matthaei",
        "033": "Epistula ad Gregorium Thaumaturgum (e Philocalia)",
        "034": "Fragmenta ex commentariis in epistulam i ad Corinthios (in catenis)",
        "035": "Fragmenta ex commentariis in epistulam ad Ephesios (in catenis)",
        "036": "Commentarii in epistulam ad Romanos (I.1-XII.21) (in catenis)",
        "037": "Commentarii in epistulam ad Romanos (e cod. Vindob. gr. 166)",
        "038": "Commentarii in Romanos (III.5-V.7) (P. Cair. 88748 % cod. Vat. gr. 762)",
        "039": "Commentarii in Romanos (cod. Athon. Laura 184 B64)",
        "040": "Epistula ad ignotum (Fabianum Romanum)",
        "041": "Epistula quibusdam qui ei obtrectabant (ad Alexandrum Hierosolymitanum)",
        "042": "Scholia in Apocalypsem (scholia 1, 3-39)",
        "043": "Scholia in Apocalypsem (scholia 28-38)",
        "044": "Fragmenta in Psalmos 1-150 [Dub.]",
        "045": "Epistula ad Africanum",
        "046": "De resurrectione libri ii (fragmenta)",
        "047": "Commentarii in Genesim (fragmenta)",
        "048": "Selecta in Genesim (fragmenta e catenis)",
        "049": "Fragmenta ex commentariis in Exodum (",
        "050": "Selecta in Exodum (fragmenta e catenis)",
        "051": "Selecta in Leviticum (fragmenta e catenis)",
        "052": "Selecta in Numeros",
        "053": "Selecta in Deuteronomium (fragmenta e catenis)",
        "054": "Selecta in Jesu Nave (fragmenta e catenis)",
        "055": "Selecta in Judices (fragmenta e catenis)",
        "056": "In Ruth (fragmentum)",
        "057": "Homiliae in Job (fragmenta in catenis, typus I) (e codd. Paris.)",
        "058": "Selecta in Psalmos [Dub.] (fragmenta e catenis)",
        "059": "Fragmenta ex commentariis in Proverbia",
        "060": "In Canticum canticorum (libri duo quos scripsit in adulescentia)",
        "061": "Fragmenta ex commentariis in Ezechielem",
        "062": "Selecta in Ezechielem (fragmenta e catenis)",
        "063": "Fragmentum ex commentariis in Osee",
        "064": "Fragmentum ex homiliis in Acta apostolorum",
        "065": "In epistulam ad Hebraeos homiliae (fragmenta ap. Eusebium, HE 6.25.11-14)",
        "066": "Adnotationes in Genesim",
        "067": "Adnotationes in Exodum",
        "068": "Adnotationes in Leviticum (fragmenta e catenis)",
        "069": "Adnotationes in Numeros",
        "070": "Adnotationes in Deuteronomium (fragmenta e catenis)",
        "071": "Adnotationes in Jesu filium Nave (fragmenta e catenis)",
        "072": "Adnotationes in Judices",
        "073": "Homiliae in Job (fragmenta in catenis, typus II) (e codd. Marc. gr. 21, 538)",
        "074": "Excerpta in Psalmos [Dub.]",
        "075": "Expositio in Proverbia (fragmenta e catenis)",
        "076": "Scholia in Canticum canticorum",
        "077": "Scholia in Matthaeum",
        "078": "Scholia in Lucam (fragmenta e cod. Venet. 28)",
        "079": "Commentarii in evangelium Joannis (lib. 19, 20, 28, 32)",
        "080": "Fragmenta in Jeremiam (e Philocalia)",
        "081": "Homiliae in Job (fragmenta in catenis, typus I%II) (e codd. Vat.)",
    },
    "2043": {
        "001": "Apotelesmatica",
        "002": "Apotelesmatica (epitomae quattuor)",
        "003": "Excerptum (e cod. Paris. gr. 2506)",
        "004": "Excerptum (e cod. Marcian. gr. 334)",
        "005": "Excerptum (e cod. Vat. gr. 1056)",
    },
    "2045": {
        "001": "Dionysiaca",
        "002": "Paraphrasis sancti evangelii Joannei (fort. auctore Nonno alio)",
        "003": "Epigramma",
    },
    "2046": {"001": "Posthomerica"},
    "2047": {"001": "Scholia ad Hermogenis librum περὶ στάσεων"},
    "2048": {"001": "Historia ecclesiastica"},
    "2049": {"001": "De deis et mundo"},
    "2050": {"001": "Vitae sophistarum", "002": "Fragmenta historica"},
    "2051": {
        "001": "Declamationes et orationes",
        "002": "Fragmenta ex incertis orationibus",
        "003": "Fragmenta (P. Oslo inv. 1478)",
    },
    "2052": {"001": "Hieroglyphica (translatio Philippi)", "002": "Testimonia"},
    "2053": {"001": "Elementa apotelesmatica", "002": "Anacephalaeosis"},
    "2054": {"001": "De musica"},
    "2055": {"001": "De sectione cylindri", "002": "De sectione coni"},
    "2057": {"001": "Historia ecclesiastica"},
    "2058": {
        "001": "Historia ecclesiastica (fragmenta ap. Photium)",
        "002": "Historia ecclesiastica (fragmenta e vita Constantini) (cod. Angelic. 22)",
        "003": "Historia ecclesiastica (fragmenta e passione Artemii)",
    },
    "2059": {"001": "Tractatus de placitis Manichaeorum"},
    "2060": {"001": "Homiliae 1-14", "002": "Homilia 9 (ex Symeone Metaphraste)"},
    "2061": {
        "001": "Commentarii in Psalmos (homiliae 31)",
        "002": "Fragmenta in Psalmos (in catenis)",
    },
    "2062": {
        "001": "Ad Theodorum lapsum (lib. 2) (",
        "002": "Ad Theodorum lapsum (lib. 1)",
        "003": "Adversus oppugnatores vitae monasticae (lib. 1-3)",
        "004": "Ad Demetrium de compunctione (lib. 1)",
        "005": "Ad Stelechium de compunctione (lib. 2)",
        "006": "Ad Stagirium a daemone vexatum (lib. 1-3)",
        "007": "Contra eos qui subintroductas habent virgines",
        "008": "Quod regulares feminae viris cohabitare non debeant",
        "009": "De virginitate",
        "010": "Ad viduam juniorem",
        "011": "De non iterando conjugio",
        "012": "De incomprehensibili dei natura (",
        "013": "De beato Philogonio (",
        "014": "De consubstantiali (",
        "015": "De petitione matris filiorum Zebedaei (",
        "016": "In quatriduanum Lazarum (",
        "017": "De Christi precibus (",
        "018": "Contra Anomoeos (homilia 11)",
        "019": "De Christi divinitate (",
        "020": "Adversus Judaeos (orationes 1-8)",
        "021": "In Kalendas",
        "022": "De Lazaro (homiliae 1-7)",
        "023": "Ad populum Antiochenum (homiliae 1-21)",
        "024": "Ad illuminandos catecheses 1-2 (series prima et secunda)",
        "025": "De diabolo tentatore (homiliae 1-3)",
        "026": "De paenitentia (homiliae 1-9)",
        "027": "In diem natalem",
        "028": "De baptismo Christi",
        "029": "De proditione Judae (homiliae 1-2)",
        "030": "De coemeterio et de cruce",
        "031": "De cruce et latrone (homilia 1)",
        "032": "De cruce et latrone (homilia 2)",
        "033": "De resurrectione mortuorum",
        "034": "Adversus ebriosos et de resurrectione domini nostri Jesu Christi",
        "035": "In ascensionem domini nostri Jesu Christi",
        "036": "De sancta pentecoste (homiliae 1-2)",
        "037": "De sancto Meletio Antiocheno",
        "038": "In sanctum Lucianum martyrem",
        "039": "De sancto hieromartyre Babyla",
        "040": "In Juventinum et Maximum martyres",
        "041": "De sancta Pelagia virgine et martyre",
        "042": "In sanctum Ignatium martyrem",
        "043": "In sanctum Eustathium Antiochenum",
        "044": "In sanctum Romanum (homilia 1)",
        "045": "De Maccabeis (homiliae 1-3)",
        "046": "De sanctis Bernice et Prosdoce",
        "047": "In quatriduanum Lazarum",
        "048": "De sanctis martyribus",
        "049": "Non esse ad gratiam concionandum",
        "050": "Homilia in martyres",
        "051": "In sanctum Julianum martyrem",
        "052": "In sanctum Barlaam martyrem",
        "053": "De sancta Droside martyre",
        "054": "In martyres Aegyptios",
        "055": "De sancto hieromartyre Phoca",
        "056": "De sanctis martyribus",
        "057": "De terrae motu",
        "058": "De fato et providentia (orationes 1-6)",
        "059": "De decem millium talentorum debitore",
        "060": "In illud",
        "061": "In paralyticum demissum per tectum",
        "062": "In principium Actorum (homiliae 1-4)",
        "063": "De mutatione nominum (homiliae 1-4)",
        "064": "De gloria in tribulationibus",
        "065": "In illud",
        "066": "In illud",
        "067": "In illud",
        "068": "In illud",
        "069": "De libello repudii",
        "070": "Quales ducendae sint uxores (",
        "071": "In dictum Pauli",
        "072": "In dictum Pauli",
        "073": "De eleemosyna",
        "074": "In illud",
        "075": "In illud",
        "076": "De profectu evangelii",
        "077": "In illud",
        "078": "In Heliam et viduam",
        "079": "De futurae vitae deliciis",
        "080": "Peccata fratrum non evulganda",
        "081": "Non esse desperandum",
        "082": "In illud",
        "083": "De sacerdotio (lib. 1-6)",
        "084": "Quod nemo laeditur nisi a se ipso",
        "085": "Ad eos qui scandalizati sunt",
        "086": "Epistulae ad Olympiadem (epist. 1-17)",
        "087": "In Eutropium",
        "088": "Cum Saturninus et Aurelianus acti essent in exsilium",
        "089": "Sermo antequam iret in exsilium",
        "090": "Sermo cum iret in exsilium",
        "091": "Post reditum a priore exsilio (sermo 2)",
        "092": "Ad Innocentium papam (epist. 1)",
        "093": "Ad Innocentium papam (epist. 2)",
        "094": "Epistula ad episcopos, presbyteros et diaconos",
        "095": "Epistulae 18-242",
        "096": "Laus Diodori episcopi",
        "097": "In sanctum pascha",
        "098": "In ascensionem (sermo 1) [Sp.]",
        "099": "De Chananaea [Dub.]",
        "100": "In ascensionem (sermo 2) [Sp.]",
        "101": "In ascensionem (sermo 3) [Sp.]",
        "102": "In ascensionem (sermo 4) [Sp.]",
        "103": "In ascensionem (sermo 5) [Sp.]",
        "104": "In pentecosten (sermo 1) [Sp.]",
        "105": "In pentecosten (sermo 2) [Sp.]",
        "106": "De adoratione pretiosae crucis [Sp.]",
        "107": "De confessione pretiosae crucis [Sp.]",
        "108": "In Genesim (homiliae 1-67)",
        "109": "In Genesim (sermones 1-9)",
        "110": "De Anna (sermones 1-5)",
        "111": "De Davide et Saule (homiliae 1-3)",
        "112": "Comparatio regis et monachi [Dub.]",
        "113": "Ascetam facetiis uti non debere [Sp.]",
        "114": "De jejunio et eleemosyna [Sp.]",
        "115": "De sacerdotio (lib. 7) [Sp.]",
        "116": "Christi discipulum benignum esse debere [Sp.]",
        "117": "De fugienda simulata specie [Sp.]",
        "118": "Contra Judaeos, gentiles et haereticos et in illud",
        "119": "De sancta trinitate [Sp.]",
        "120": "In Romanum martyrem (homilia 2) [Sp.]",
        "121": "In proditionem Judae [Sp.]",
        "122": "In Bassum martyrem [Dub.]",
        "123": "In sanctos Petrum et Heliam [Sp.]",
        "124": "De beato Abraham [Sp.]",
        "125": "De sancta Thecla martyre [Sp.]",
        "126": "De precatione (orat. 1-2) [Sp.]",
        "127": "In oraculum Zachariae redditum [Sp.] (fort. sub auctore Proclo)",
        "128": "In laudem conceptionis sancti Joannis Baptistae [Sp.] (fort. sub auctore Proclo)",
        "129": "In annuntiationem beatae virginis [Sp.]",
        "130": "In illud",
        "131": "In sanctum Joannem praecursorem [Sp.]",
        "132": "In sanctam theophaniam seu baptismum Christi [Sp.]",
        "133": "De occursu domini, de deipara et Symeone [Sp.]",
        "134": "In sancta et magna parasceve [Sp.]",
        "135": "In venerabilem crucem sermo [Sp.]",
        "136": "In triduanam resurrectionem domini [Sp.]",
        "137": "De angusta porta et in orationem dominicam [Sp.]",
        "138": "Homilia de capto Eutropio [Dub.]",
        "139": "Expositiones in Psalmos",
        "140": "In illud",
        "141": "In Psalmum 145",
        "142": "In illud Isaiae",
        "143": "In illud",
        "144": "De prophetiarum obscuritate (homiliae 1-2)",
        "145": "In illud",
        "146": "In Matthaeum (homiliae 1-90)",
        "147": "In Joannem (homiliae 1-88)",
        "148": "In Acta apostolorum (homiliae 1-55)",
        "149": "In epistulam ad Romanos (homiliae 1-32)",
        "150": "In epistulam i ad Corinthios (homiliae 1-44)",
        "151": "In epistulam ii ad Corinthios (homiliae 1-30)",
        "152": "In epistulam ad Galatas commentarius",
        "153": "In epistulam ad Ephesios (homiliae 1-24)",
        "154": "In epistulam ad Philippenses (homiliae 1-15)",
        "155": "In epistulam ad Colossenses (homiliae 1-12)",
        "156": "In epistulam i ad Thessalonicenses (homiliae 1-11)",
        "157": "In epistulam ii ad Thessalonicenses (homiliae 1-5)",
        "158": "In epistulam i ad Timotheum (homiliae 1-18)",
        "159": "In epistulam ii ad Timotheum (homiliae 1-10)",
        "160": "In epistulam ad Titum (homiliae 1-6)",
        "161": "In epistulam ad Philemonem (homiliae 1-3)",
        "162": "In epistulam ad Hebraeos (homiliae 1-34)",
        "163": "Homilia dicta postquam reliquiae martyrum",
        "164": "Homilia dicta praesente imperatore",
        "165": "Quod frequenter conveniendum sit",
        "166": "Adversus eos qui non adfuerant",
        "167": "De studio praesentium",
        "168": "Adversus catharos",
        "169": "Contra ludos et theatra",
        "170": "Homilia dicta in templo sanctae Anastasiae",
        "171": "Homilia habita postquam presbyter Gothus concionatus fuerat",
        "172": "In illud",
        "173": "In illud",
        "174": "In illud",
        "175": "De Eleazaro et septem pueris",
        "176": "In poenitentiam Ninivitarum [Sp.]",
        "177": "Fragmenta in Job (in catenis)",
        "178": "Fragmenta in Proverbia (in catenis)",
        "179": "Fragmenta in Jeremiam (in catenis)",
        "180": "Fragmenta in epistulas catholicas",
        "181": "In Psalmum 50 [Sp.]",
        "182": "Prooemia in Psalmos (fragmenta) [Sp.]",
        "183": "In illud",
        "184": "In Psalmum 50 (homilia 1) [Sp.]",
        "185": "In Psalmum 50 (homilia 2) [Sp.]",
        "186": "In Psalmum 75 [Sp.]",
        "187": "De turture seu de ecclesia sermo [Sp.]",
        "188": "In Psalmum 92 [Sp.]",
        "189": "In Psalmum 94 [Sp.]",
        "190": "In Psalmum 100 [Sp.]",
        "191": "In Psalmos 101-107 [Sp.]",
        "192": "In Psalmum 118 (homiliae 1-3) [Sp.]",
        "193": "In Psalmum 139 [Sp.]",
        "194": "Interpretatio in Danielem prophetam [Sp.]",
        "195": "De Melchisedech [Sp.]",
        "196": "De perfecta caritate [Sp.]",
        "197": "De continentia [Sp.]",
        "198": "Synopsis scripturae sacrae [Sp.]",
        "199": "In natalem Christi diem [Dub.]",
        "200": "In Genesim (sermo 3) [Sp.]",
        "201": "Contra theatra [Sp.]",
        "202": "In Eliam prophetam [Sp.]",
        "203": "De Joseph et de castitate [Sp.]",
        "204": "De Susanna [Sp.]",
        "205": "In decollationem sancti Joannis [Sp.]",
        "206": "In praecursorem domini [Sp.]",
        "207": "In Petrum et Paulum [Sp.]",
        "208": "In duodecim apostolos [Sp.]",
        "209": "In sanctum Thomam apostolum [Sp.]",
        "210": "In sanctum Stephanum protomartyrem [Sp.]",
        "211": "In illud",
        "212": "In parabolam de filio prodigo [Sp.]",
        "213": "In saltationem Herodiadis [Sp.]",
        "214": "In illud",
        "215": "In decem virgines [Sp.]",
        "216": "In Samaritanam [Sp.]",
        "217": "De pseudoprophetis [Sp.]",
        "218": "De circo [Sp.]",
        "219": "In illud",
        "220": "In principium indictionis, in martyres [Sp.]",
        "221": "In illud",
        "222": "In parabolam de ficu [Sp.] (fort. auctore quodam Cappadoce)",
        "223": "De pharisaeo [Sp.]",
        "224": "De Lazaro et divite [Sp.]",
        "225": "In publicanum et pharisaeum [Sp.]",
        "226": "In Joannem theologum [Sp.]",
        "227": "De negatione Petri [Sp.]",
        "228": "In secundum domini adventum [Sp.]",
        "229": "Interpretatio orationis Pater noster [Sp.]",
        "230": "In principium indictionis [Sp.]",
        "231": "In venerandum crucem [Sp.]",
        "232": "In exaltationem venerandae crucis [Sp.]",
        "233": "In sanctum Stephanum [Sp.]",
        "234": "In mediam hebdomadam jejuniorum [Sp.]",
        "235": "In ramos palmarum [Sp.]",
        "236": "Contra haereticos et in sanctam deiparam [Sp.]",
        "237": "In latronem [Sp.]",
        "238": "Sermo catecheticus in pascha [Sp.]",
        "239": "In sanctum pascha (sermo 1) [Sp.] (fort. auctore Apollinare Laodicense)",
        "240": "In sanctum pascha (sermo 2) [Sp.] (fort. auctore Apollinare Laodicense)",
        "241": "In sanctum pascha (sermo 3) [Sp.] (fort. auctore Apollinare Laodicense)",
        "242": "In sanctum pascha (sermo 4) [Sp.]",
        "243": "In sanctum pascha (sermo 5) [Sp.]",
        "244": "In sanctum pascha (sermo 6) [Sp.]",
        "245": "In sanctum pascha (sermo 7) [Sp.]",
        "246": "In synaxim archangelorum [Sp.]",
        "247": "De paenitentia [Sp.]",
        "248": "De paenitentia (sermo 1) [Sp.]",
        "249": "De paenitentia (sermo 2) [Sp.]",
        "250": "De paenitentia (sermo 3) [Sp.]",
        "251": "De eleemosyna [Sp.]",
        "252": "De jejunio (sermones 1-7) [Sp.]",
        "253": "De patientia (sermo 1) [Sp.]",
        "254": "De patientia (sermo 2) [Sp.]",
        "255": "De salute animae [Sp.]",
        "256": "In catechumenos [Sp.]",
        "257": "De corruptoribus virginum [Sp.]",
        "258": "Contra haereticos [Sp.]",
        "259": "De eleemosyna [Sp.]",
        "260": "Epistula ad monachos [Sp.]",
        "261": "In annuntiationem sanctissimae deiparae [Sp.]",
        "262": "De remissione peccatorum [Sp.] (fort. auctore quodam Cappadoce)",
        "263": "De non judicando proximo [Sp.]",
        "264": "De paenitentia [Sp.]",
        "265": "De spe [Sp.]",
        "266": "De caritate [Sp.]",
        "267": "Caritatem secundum deum rem esse deo dignam [Sp.]",
        "268": "In proditionem Judae [Sp.]",
        "269": "In illud",
        "270": "In Rachelem et infantes [Sp.]",
        "271": "In Herodem et infantes [Sp.]",
        "272": "In Martham, Mariam et Lazarum [Sp.]",
        "273": "In illud",
        "274": "In meretricem et in pharisaeum [Sp.]",
        "275": "In assumptionem domini nostri Jesu Christi [Sp.]",
        "276": "In ramos palmarum [Sp.]",
        "277": "In laudem sancti Joannis theologi (homilia 1) [Sp.]",
        "278": "In laudem sancti Joannis theologi (homilia 2) [Sp.]",
        "279": "In transfigurationem [Sp.]",
        "280": "De siccitate [Sp.]",
        "281": "In Jordanem fluvium [Sp.]",
        "282": "In pharisaeum et meretricem [Sp.]",
        "283": "In Christi natalem diem [Sp.]",
        "284": "In illud",
        "285": "In mediam pentecosten [Sp.]",
        "286": "In Samaritanam, in die mediae pentecostes [Sp.]",
        "287": "In illud",
        "288": "In illud",
        "289": "In natale sancti Joannis prophetae [Sp.]",
        "290": "In natale domini nostri Jesu Christi [Sp.] (fort. auctore quodam Cappadoce)",
        "291": "In Zacchaeum publicanum [Sp.]",
        "292": "In centurionem [Sp.]",
        "293": "In illud",
        "294": "In drachmam et in illud",
        "295": "De jejunio [Sp.]",
        "296": "In filium viduae [Sp.]",
        "297": "In publicanum et pharisaeum [Sp.]",
        "298": "In ingressum sanctorum jejuniorum [Sp.]",
        "299": "De jejunio, dominica quinta jejuniorum [Sp.]",
        "300": "De jejunio [Sp.]",
        "301": "De oratione [Sp.]",
        "302": "In illud",
        "303": "Admonitiones spirituales [Sp.]",
        "304": "In principium jejuniorum [Sp.]",
        "305": "In adorationem venerandae crucis [Sp.]",
        "306": "In resurrectionem domini [Sp.]",
        "307": "In parabolam Samaritani [Sp.]",
        "308": "De jejunio [Sp.]",
        "309": "De jejunio, de Davide [Sp.]",
        "310": "In annuntiationem deiparae [Sp.]",
        "311": "De eleemosyna [Sp.]",
        "312": "De caritate [Sp.]",
        "313": "In Lazarum (homilia 1) [Sp.]",
        "314": "In Lazarum (homilia 2) [Sp.]",
        "315": "In Lazarum (homilia 3) [Sp.]",
        "316": "De mansuetudine sermo [Sp.]",
        "317": "Eclogae i-xlviii ex diversis homiliis [Sp.]",
        "318": "Epistula ad Antiochum (epist. 233) [Sp.]",
        "319": "Oratio ante lectionem [Sp.]",
        "320": "Oratio secunda [Sp.]",
        "321": "In novam dominicam et in apostolum Thomam [Sp.]",
        "322": "In sanctum Stephanum (homilia 1) [Sp.]",
        "323": "In sanctum Stephanum (homilia 2) [Sp.]",
        "324": "In sanctum Stephanum (homilia 3) [Sp.]",
        "325": "De patientia et de consummatione huius saeculi [Sp.]",
        "326": "De paenitentia et in lectionem de Davide et de uxore Uriae [Sp.]",
        "327": "De iis qui in jejunio continenter vivunt [Sp.]",
        "328": "Sermo exhortatorius de temperantia [Sp.]",
        "329": "Quod grave sit dei clementiam contemnere [Sp.]",
        "330": "In sanguinis fluxu laborantem [Sp.]",
        "331": "Quod mari similis sit haec vita [Sp.] (fort. auctore quodam Cappadoce)",
        "332": "In illud",
        "333": "In illud",
        "334": "In evangelii dictum et de virginitate [Sp.]",
        "335": "De cognitione dei et in sancta theophania [Sp.]",
        "336": "In lacum Genesareth et in sanctum Petrum apostolum [Sp.]",
        "337": "De eleemosyna [Sp.]",
        "338": "Ad eos qui magni aestimant opes [Sp.]",
        "339": "De precatione [Sp.]",
        "340": "De virtute animi [Sp.]",
        "341": "Ad Eudoxiam (epist. 1-7) [Sp.]",
        "342": "Precatio in obsessos [Sp.]",
        "343": "Precatio [Sp.]",
        "344": "Precatio [Sp.]",
        "345": "Precatio [Sp.]",
        "346": "De Babyla contra Julianum et gentiles",
        "347": "De regressu",
        "348": "Epistula ad Cyriacum (epist. 125 % recensiones)",
        "349": "De inani gloria et de educandis liberis",
        "350": "In illud",
        "351": "Catechesis de juramento (series prima)",
        "352": "Catechesis ultima ad baptizandos (series prima)",
        "353": "Catecheses ad illuminandos 1-8 (series tertia)",
        "354": "Fragmenta ex homiliis diversis",
        "355": "In sanctam Pelagiam [Sp.]",
        "356": "In natale domini et in sanctam Mariam genitricem [Sp.]",
        "357": "Visio Danielis [Sp.]",
        "358": "De cruce et latrone [Sp.] (fort. auctore Severiano)",
        "359": "In infirmos [Sp.]",
        "360": "In omnes sanctos [Sp.]",
        "361": "In magnam feriam v [Sp.]",
        "362": "De meretrice [Sp.]",
        "363": "Epistula ad abbatem [Sp.]",
        "364": "In nativitatem Joannis Baptistae [Sp.]",
        "365": "In Christi ascensionem [Sp.]",
        "366": "In illud",
        "367": "In assumptionem domini [Sp.]",
        "368": "In resurrectionem domini [Sp.]",
        "369": "Deprecatio [Sp.]",
        "370": "Epitimia lxxiii [Sp.]",
        "371": "In illud",
        "372": "In catenas sancti Petri [Sp.]",
        "373": "Stichoi [Sp.]",
        "374": "In passionem salvatoris nostri Jesu Christi [Sp.]",
        "375": "In ramos palmarum [Sp.]",
        "376": "In synaxim incorporalium [Sp.]",
        "377": "Encomium in sanctum Joannem evangelistam [Sp.]",
        "378": "In sanctum pascha [Sp.]",
        "379": "Oratio de hypapante [Sp.]",
        "380": "In illud",
        "381": "In Christi natalem [Sp.]",
        "382": "Encomium in sanctos martyres [Sp.]",
        "383": "Encomium in sanctum Polycarpum",
        "384": "Oratio de epiphania [Sp.]",
        "385": "De nativitate [Sp.]",
        "386": "In nativitatem Christi (fragmenta duo) [Sp.]",
        "387": "In sanctum Paulum apostolum (excerptum)",
        "388": "De laudibus sancti Pauli apostoli (homiliae 1-7)",
        "389": "De sancta Thecla martyre (e cod. Athon. Panteleimon 58) [Sp.]",
        "390": "De nativitate Joannis Baptistae [Sp.]",
        "391": "In sanctum pascha [Sp.]",
        "392": "In resurrectionem domini [Sp.]",
        "393": "In resurrectionem domini B [Sp.]",
        "394": "In operarios undecimae horae [Sp.]",
        "395": "In Ecclesiasten [Sp.]",
        "396": "Sermo cum presbyter fuit ordinatus",
        "397": "In Isaiam",
        "398": "In illud",
        "399": "Epistula ad Caesarium [Sp.]",
        "400": "In Psalmum 50 (homilia 1) [Sp.] (P. Berol. 6788 A)",
        "401": "De nativitate Joannis Baptistae [Sp.]",
        "402": "Commentarius in Job",
    },
    "2063": {
        "001": "In Origenem oratio panegyrica",
        "002": "Epistula canonica",
        "003": "Metaphrasis in Ecclesiasten Salamonis",
        "004": "Ad Tatianum de anima per capita disputatio [Sp.]",
        "005": "In annuntiationem sanctae virginis Mariae (homiliae 1-2) [Sp.]",
        "006": "Sermo in omnes sanctos [Sp.]",
        "007": "Fragmentum in evangelium Matthaei 6.22-23 (in catenis)",
        "008": "Fragmentum in Job (in catenis)",
        "009": "Sententiae (ap. Antonium Melissam)",
        "010": "Εἰς τὸ οὐδὲν εἴδωλον ἐν κόσμῳ (fragmentum)",
        "011": "Fragmenta in Jeremiam (in catenis)",
        "012": "De fide capitula duodecim",
    },
    "2064": {"001": "Fragmenta in epistulam ad Romanos (in catenis)"},
    "2074": {
        "001": "Fragmenta in Matthaeum (in catenis)",
        "002": "Fragmenta in Joannem (in catenis)",
        "003": "Fragmenta in epistulam ad Romanos (in catenis)",
        "004": "Fragmenta in Psalmos (in catenis)",
    },
    "2084": {"001": "De virginitate"},
    "2102": {
        "001": "Commentarii in Job (1-4)",
        "002": "Commentarii in Job (5.1-6.29)",
        "003": "Commentarii in Job (7.20c-11)",
        "004": "Commentarii in Job (12.1-16.8a) (partim in catenis)",
        "005": "Commentarii in Ecclesiasten (5-6)",
        "006": "Commentarii in Ecclesiasten (7-8.8)",
        "007": "Commentarii in Ecclesiasten (11-12)",
        "008": "De trinitate (lib. 1) [Sp.]",
        "009": "De trinitate (lib. 2.1-7) [Sp.]",
        "010": "Commentarii in Zacchariam",
        "011": "Commentarii in Ecclesiasten (1.1-8)",
        "012": "Contra Manichaeos",
        "013": "Commentarii in Octateuchum et Reges (in catenis)",
        "014": "Commentarii in Job (in catenis)",
        "015": "Commentarii in Psalmos 20-21",
        "016": "Commentarii in Psalmos 22-26.10",
        "017": "Commentarii in Psalmos 29-34",
        "018": "Commentarii in Psalmos 35-39",
        "019": "Commentarii in Psalmos 40-44.4",
        "020": "Fragmenta in Psalmos (e commentario altero)",
        "021": "Fragmenta in Proverbia",
        "022": "Fragmenta in Joannem (in catenis)",
        "023": "Fragmenta in epistulam ad Romanos (in catenis)",
        "024": "Fragmenta in epistulam i ad Corinthios (in catenis)",
        "025": "Fragmenta in epistulam ii ad Corinthios (in catenis)",
        "026": "In epistulas catholicas brevis enarratio (in catenis)",
        "027": "Ad philosophum (ap. Joannem Damascenum, Sacra parallela)",
        "028": "De incorporeo (ap. Joannem Damascenum, Sacra parallela)",
        "029": "Fragmenta (ap. Maximum Confessorem, Loci communes [Sp.])",
        "030": "Fragmenta (ap. Antonium Melissam, Loci communes)",
        "031": "Dialexis Montanistae et orthodoxi [Sp.]",
        "032": "In Genesim",
        "033": "De trinitate (lib. 2.8-27) [Sp.]",
        "034": "De trinitate (lib. 3) [Sp.]",
        "035": "Fragmentum in epistulam ad Hebraeos (in catenis)",
        "036": "Commentarii in Ecclesiasten (3-4.12)",
        "037": "Commentarii in Ecclesiasten (9.8-10.20)",
        "038": "Commentarii in Psalmos 36.15-19",
    },
    "2109": {
        "001": "Sermones 64 (collectio B)",
        "002": "Homiliae spirituales 50 (collectio H)",
        "003": "Sermones 1-22, 24-27",
        "004": "Homiliae 7 (collectio HA)",
        "005": "Epistula magna",
        "006": "Sermo 23 (recensio excerpta)",
        "007": "Sermo 23 (recensio completa)",
        "008": "Sermo 28 (recensio expletior)",
        "009": "Sermo 28 (recensio brevior)",
        "010": "Preces",
        "011": "Apophthegmata",
        "012": "Opusculum 1 (",
        "013": "Sermo 17 (excerpta)",
    },
    "2110": {
        "001": "Procatechesis",
        "002": "Mystagogiae 1-5 [Sp.]",
        "003": "Catecheses ad illuminandos 1-18",
        "004": "Additamentum ad catechesis illuminandorum sextae decimae caput tertium",
        "005": "Tituli catechesium",
        "006": "Homilia in paralyticum juxta piscinam jacentem",
        "007": "Homilia in occursum domini [Sp.]",
        "008": "Homilia aquae in vinum conversae (fragmenta) [Sp.]",
        "009": "Homilia in illud",
        "010": "Suppositarum Cyrilli et Julii pontificis epistularum compendium [Sp.]",
        "011": "Catechesis ad illuminandos 2 (exemplar alterum)",
        "012": "Catechesis ad illuminandos 2 (recensio e cod. Paris. 409)",
        "013": "Epistula ad Constantium imperatorem",
    },
    "2111": {
        "001": "Historia Lausiaca (recensio G)",
        "002": "Prooemium ad historiam Lausiacam [Sp.]",
        "003": "Epistula ad Lausum",
        "004": "Dialogus de vita Joannis Chrysostomi",
        "005": "De gentibus Indiae et Bragmanibus [Sp.]",
    },
    "2112": {
        "001": "In natalitia domini (orat. 1)",
        "002": "Iambi ad Seleucum",
        "003": "In occursum domini (orat. 2)",
        "004": "In Lazarum (orat. 3)",
        "005": "In mulierem peccatricem (orat. 4)",
        "006": "In diem sabbati sancti (orat. 5)",
        "007": "In illud",
        "008": "De recens baptizatis (orat. 7)",
        "009": "In Zacchaeum (orat. 8)",
        "010": "In illud",
        "011": "Contra haereticos",
        "012": "Oratio in resurrectionem domini [Sp.] (e cod. Vat. gr. 1936)",
        "013": "Oratio in resurrectionem domini [Sp.] (e cod. Vat. gr. 2194)",
        "014": "Encomium sancti Basilii Magni [Sp.]",
        "015": "Epistula synodalis",
        "016": "Fragmenta",
        "017": "Oratio in mesopentecosten [Sp.]",
        "018": "Fragmenta spuria",
        "019": "Expositio in illud",
        "020": "Fragmenta ex tractatu in illud",
        "021": "In Isaiam (fr. 5) [Sp.]",
        "022": "In illud",
        "023": "Fragmentum xvii [Sp.]",
        "024": "Fragmentum xx [Sp.]",
        "025": "Fragmentum xxi [Sp.]",
        "026": "Fragmenta",
    },
    "2115": {
        "001": "Contra haeresin Noeti",
        "002": "De antichristo",
        "003": "Fragmenta in Genesim",
        "004": "Fragmenta in Genesim [Sp.]",
        "005": "De benedictione Balaam (fragmentum ex Leontio)",
        "006": "In canticum Mosis",
        "007": "Ex interpretatione Ruth",
        "008": "In Helcanam et Annam",
        "009": "Fragmentum de engastrimytho [Sp.]",
        "010": "Fragmenta in Psalmos",
        "011": "Fragmenta in Psalmos [Sp.]",
        "012": "Fragmenta in Proverbia",
        "013": "Fragmenta in Proverbia [Dub.]",
        "014": "Fragmenta in Proverbia [Sp.]",
        "015": "In Ecclesiasten (fragmentum e cod. Vat. 1694)",
        "016": "Fragmentum in Ecclesiasten [Sp.]",
        "017": "In principium Isaiae",
        "018": "Fragmentum in Ezechielem",
        "019": "Fragmentum in Matthaeum 6.11 [Sp.]",
        "020": "Fragmentum de distributione talentorum (Matth. 25.24)",
        "021": "De duobus latronibus (Joh. 19.33-34)",
        "022": "In evangelium Joannis et de resurrectione Lazari [Dub.]",
        "023": "De resurrectione ad Mammaeam imperatricem (fragmenta ap. Theodoretum, Eranistes)",
        "024": "Fragmentum de resurrectione et incorruptione (ap. Anastasium Sinaïtam, Viae dux)",
        "025": "De theophania [Dub.]",
        "026": "Demonstratio temporum paschatis (in catenis)",
        "027": "Narratio de virgine Corinthiaca [Dub.]",
        "028": "De consummatione mundi [Sp.]",
        "029": "Commentarium in Danielem",
        "030": "In Canticum canticorum",
        "031": "Commentarium in Danielem 1.18",
        "032": "De benedictionibus Isaaci et Jacobi",
        "033": "De benedictione Mosis (fragmenta)",
        "034": "Fragmentum in Danielem 1.18.3",
        "035": "Chronicon",
        "036": "Chronicon (fragmentum) (P. Oxy. 6.870)",
        "037": "Fragmentum in Genesim 4.23 (e cod. Ath. Bibl. Nat. 2492)",
        "038": "Demonstratio adversus Judaeos [Sp.]",
        "039": "De universo",
        "040": "De universo (fragmenta)",
        "041": "Fragmenta in Proverbia (e cod. Coislin. 193)",
        "042": "Fragmenta in Proverbia (e Pseudo-Anastasio Sinaïta)",
        "043": "De benedictione Balaam (fragmenta ap. Irenaeum)",
        "044": "Fragmentum e traditione apostolica [Sp.]",
        "045": "De resurrectione ad Mammaeam imperatricem (cod. Achrid. Mus. nat. 86)",
        "046": "In Canticum canticorum (paraphrasis)",
        "047": "Fragmenta varia [Dub.]",
        "048": "Fragmentum in Helcanam et Annam",
        "049": "Fragmenta in Psalmos",
        "050": "Fragmenta in Proverbia",
        "051": "Traditio apostolica",
        "052": "Contra Beronem et Heliconem [Sp.]",
        "053": "Canon paschalis",
        "054": "De universo (fragmentum ap. Joannem Philoponum, De opificio mundi)",
        "055": "Syntagma (fragmentum ap. Chronicon paschale)",
        "056": "Refutatio omnium haeresium (",
    },
    "2116": {"001": "De accentibus [Sp.]"},
    "2117": {"001": "Fragmentum (P. Berol. 9734r)"},
    "2118": {"001": "Fragmentum (P. Oxy. 22.2331)"},
    "2119": {
        "001": "Fragmenta",
        "002": "Epigrammata",
        "003": "Testimonium",
        "004": "Fragmentum",
    },
    "2120": {"001": "Fragmentum"},
    "2121": {"001": "Fragmenta"},
    "2122": {"001": "Fragmenta"},
    "2127": {
        "001": "Prolegomena in Hermogenis artem rhetoricam",
        "002": "Epigramma (auctore Troilo Grammatico)",
    },
    "2130": {
        "001": "Epigrammata",
        "002": "Fragmenta in epistulam ad Romanos (in catenis)",
        "003": "Fragmenta in epistulam i ad Corinthios (in catenis)",
        "004": "Fragmenta in epistulam ii ad Corinthios (in catenis)",
        "005": "Fragmentum in epistulam ii ad Thessalonicenses (in catenis)",
        "006": "Fragmentum in epistulam i ad Timotheum (in catenis)",
        "007": "Fragmentum in epistulam ad Hebraeos (in catenis)",
        "008": "Scholia Arethae in Cyrilli apologiam xii anathematismorum contra Theodoretum et in Theodoreti impugnationem",
    },
    "2133": {"001": "Isagoga excerpta"},
    "2140": {"001": "Fragmenta alchemica (e cod. Paris. B.N. gr. 2327, fol. 266r)"},
    "2141": {"001": "Fragmenta"},
    "2148": {"001": "Fragmenta", "002": "Fragmentum (P. Oxy. 27.2469)"},
    "2151": {"001": "Fragmentum"},
    "2153": {"001": "Testimonia"},
    "2157": {"001": "Fragmentum"},
    "2158": {"001": "Fragmentum"},
    "2160": {"001": "Fragmenta"},
    "2162": {"001": "Fragmenta"},
    "2168": {"001": "Fragmenta"},
    "2169": {"001": "Fragmenta"},
    "2171": {"001": "Fragmenta"},
    "2172": {"001": "Fragmentum"},
    "2173": {"001": "Fragmenta"},
    "2175": {"001": "Fragmentum"},
    "2178": {"001": "Ars rhetorica", "002": "Excerpta", "003": "Fragmenta"},
    "2181": {
        "001": "Μωσέως δίπλωσις (e cod. Venet. Marc. 299, fol. 185r)",
        "002": "Εὐποία καὶ εὐτυχία τοῦ κτισαμένου καὶ ἐπιτυχία καμάτου καὶ μακροχρονία βίου (e cod. Paris. B.N. ",
    },
    "2182": {"001": "Fragmenta"},
    "2185": {"001": "Fragmenta"},
    "2186": {"001": "Fragmentum"},
    "2187": {"001": "Fragmenta"},
    "2189": {"001": "Testimonia", "002": "Fragmenta"},
    "2190": {"001": "Fragmenta"},
    "2192": {"001": "Fragmentum"},
    "2193": {"001": "Fragmenta"},
    "2194": {"001": "Fragmenta"},
    "2195": {"001": "Fragmenta"},
    "2196": {"001": "Fragmenta"},
    "2200": {
        "001": "Epistulae 1-1544",
        "002": "Epistulae pseudepigraphae",
        "003": "Epistularum Basilii et Libanii quod fertur commercium",
        "004": "Orationes 1-64",
        "005": "Declamationes 1-51",
        "006": "Progymnasmata",
        "007": "Argumenta orationum Demosthenicarum",
        "008": "Characteres epistolici [Sp.]",
        "009": "Fragmenta de declamationibus",
        "010": "Epigramma",
        "011": "Declamatio 3 (Legatio Menelai, Theorema)",
        "012": "Fragmenta",
    },
    "2201": {"001": "Fragmenta"},
    "2202": {"001": "Fragmenta"},
    "2203": {"001": "Fragmenta"},
    "2204": {"001": "Fragmenta"},
    "2205": {"001": "Fragmenta"},
    "2210": {"001": "Fragmenta"},
    "2212": {"001": "Titulus"},
    "2213": {"001": "Fragmenta"},
    "2215": {"001": "Fragmenta"},
    "2216": {"001": "Fragmenta"},
    "2217": {"001": "Fragmentum"},
    "2218": {"001": "Testimonia"},
    "2219": {"001": "Fragmenta"},
    "2225": {"001": "Testimonia"},
    "2226": {"001": "Testimonia"},
    "2227": {"001": "Testimonium"},
    "2228": {"001": "Testimonia"},
    "2229": {"001": "Testimonium"},
    "2230": {"001": "Testimonium"},
    "2231": {"001": "Testimonia"},
    "2232": {"001": "Testimonia", "002": "Fragmenta"},
    "2233": {"001": "Physiognomonica"},
    "2234": {"001": "Testimonia"},
    "2235": {"001": "Testimonia"},
    "2236": {"001": "Breviarium ab urbe condita (Paeanii translatio)"},
    "2237": {"001": "Testimonia"},
    "2239": {"001": "Testimonia et fragmenta"},
    "2240": {"001": "Testimonia"},
    "2241": {"001": "Testimonia"},
    "2242": {"001": "Testimonia"},
    "2243": {"001": "Apocalypsis Sedrach"},
    "2244": {"001": "Testimonium"},
    "2245": {"001": "Testimonia"},
    "2246": {"001": "Testimonia"},
    "2247": {"001": "Testimonium"},
    "2248": {"001": "Acta Xanthippae et Polyxenae (sub auctore Onesimo)"},
    "2255": {"001": "Fragmenta"},
    "2260": {"001": "Testimonia", "002": "Tituli"},
    "2265": {"001": "Fragmenta"},
    "2268": {"001": "Fragmenta"},
    "2270": {"001": "Fragmentum"},
    "2273": {"001": "Fragmentum"},
    "2274": {
        "001": "Homilia in natalem Christi (fort. pars operis Historia Romana atque omnigena)",
        "002": "Patria Constantinopoleos (",
        "003": "Patria Constantinopoleos (",
        "004": "Fragmenta",
    },
    "2275": {"001": "Testimonia"},
    "2277": {"001": "Fragmentum"},
    "2278": {"001": "Fragmenta"},
    "2282": {"001": "Fragmentum"},
    "2284": {"001": "Fragmenta"},
    "2286": {"001": "Testimonium"},
    "2287": {"001": "Fragmentum"},
    "2289": {"001": "Fragmenta"},
    "2291": {"001": "Testimonia"},
    "2294": {"001": "Fragmenta"},
    "2298": {"001": "Fragmentum"},
    "2300": {"001": "Titulus", "002": "Fragmenta"},
    "2303": {"001": "Testimonia", "002": "Fragmenta"},
    "2304": {"001": "Testimonium"},
    "2305": {"001": "Testimonia"},
    "2306": {"001": "Fragmenta"},
    "2307": {"001": "Fragmenta"},
    "2313": {"001": "Testimonia"},
    "2314": {"001": "Testimonium"},
    "2317": {"001": "In Platonis Phaedrum scholia"},
    "2319": {"001": "Testimonia"},
    "2322": {"001": "Fragmentum"},
    "2326": {"001": "Fragmentum", "002": "Fragmenta"},
    "2328": {"001": "Fragmenta"},
    "2330": {"001": "Fragmenta"},
    "2331": {"001": "Fragmenta"},
    "2333": {"001": "Titulus", "002": "Fragmenta"},
    "2334": {"001": "Testimonia", "002": "Fragmenta"},
    "2336": {"001": "Fragmenta"},
    "2339": {"001": "Fragmenta"},
    "2340": {"001": "Testimonia"},
    "2341": {"001": "Fragmenta"},
    "2345": {"001": "Fragmenta"},
    "2346": {"001": "Fragmenta"},
    "2349": {"001": "Fragmenta"},
    "2354": {"001": "Fragmenta"},
    "2355": {"001": "Testimonium"},
    "2357": {"001": "Fragmenta"},
    "2364": {"001": "Fragmenta"},
    "2367": {"001": "Fragmentum"},
    "2371": {"001": "Chronicon paschale"},
    "2372": {"001": "Fragmenta"},
    "2383": {"001": "Fragmentum"},
    "2384": {"001": "Fragmenta"},
    "2385": {"001": "Titulus"},
    "2386": {"001": "Fragmenta"},
    "2387": {"001": "Fragmenta"},
    "2391": {"001": "Fragmenta"},
    "2392": {"001": "Fragmenta"},
    "2393": {"001": "Fragmentum"},
    "2396": {"001": "Titulus", "002": "Fragmenta"},
    "2397": {"001": "Fragmenta"},
    "2398": {"001": "Fragmentum"},
    "2399": {"001": "Fragmenta"},
    "2404": {"001": "Philogelos sive Facetiae (sub auctoribus Hierocle et Philagrio)"},
    "2409": {"001": "Fragmentum", "002": "Fragmenta"},
    "2412": {"001": "Fragmentum"},
    "2417": {"001": "Fragmenta"},
    "2418": {"001": "Fragmenta"},
    "2423": {"001": "Fragmentum"},
    "2424": {"001": "Fragmenta"},
    "2426": {"001": "Fragmentum"},
    "2428": {"001": "Fragmenta"},
    "2434": {"001": "Fragmenta"},
    "2444": {"001": "Testimonia"},
    "2445": {"001": "Fragmenta"},
    "2449": {
        "001": "Κανόνες καθολικοὶ περὶ συντάξεως (e cod. Coislin. 387)",
        "002": "Excerpta ex libris de animalibus (e cod. Paris. gr. 2422)",
    },
    "2455": {"001": "Fragmenta"},
    "2456": {"001": "Testimonia", "002": "Fragmenta"},
    "2458": {"001": "Fragmenta"},
    "2460": {"001": "Fragmenta"},
    "2461": {"001": "Fragmenta"},
    "2466": {"001": "Fragmenta"},
    "2474": {"001": "Fragmenta"},
    "2475": {"001": "Fragmentum"},
    "2479": {"001": "Fragmenta"},
    "2482": {"001": "Fragmenta"},
    "2499": {"001": "Fragmentum"},
    "2506": {"001": "Fragmenta"},
    "2511": {"001": "Fragmenta"},
    "2512": {"001": "Fragmenta"},
    "2525": {"001": "Fragmenta"},
    "2531": {"001": "Fragmentum"},
    "2532": {"001": "Fragmenta"},
    "2533": {"001": "Fragmentum"},
    "2536": {"001": "Fragmenta"},
    "2539": {"001": "Fragmenta"},
    "2542": {"001": "Fragmenta"},
    "2543": {"001": "Fragmenta"},
    "2545": {"001": "Fragmenta"},
    "2546": {"001": "Fragmenta"},
    "2547": {"001": "Fragmenta"},
    "2548": {"001": "Fragmentum"},
    "2552": {"001": "Fragmenta"},
    "2555": {"001": "Fragmentum"},
    "2556": {"001": "Fragmenta"},
    "2557": {"001": "Fragmenta"},
    "2559": {"001": "Fragmentum"},
    "2560": {"001": "Fragmenta"},
    "2565": {"001": "Fragmenta"},
    "2566": {"001": "Fragmenta"},
    "2568": {"001": "Fragmenta"},
    "2571": {"001": "In aureum carmen"},
    "2573": {"001": "Fragmenta"},
    "2577": {"001": "Περὶ δεκάδος καὶ τῶν ἐντὸς αὐτῆς ἀριθμῶν"},
    "2578": {"001": "Ἔκφρασις τοῦ κοσμικοῦ πίνακος", "002": "Anacreontea"},
    "2580": {
        "001": "De magistratibus populi Romani",
        "002": "De mensibus",
        "003": "De ostentis",
    },
    "2583": {"001": "Apotelesmatica"},
    "2585": {"001": "Vita Thucydidis"},
    "2586": {
        "001": "Διαίρεσις τῶν ἐπιδεικτικῶν (olim sub auctore Genethlio)",
        "002": "Περὶ ἐπιδεικτικῶν",
    },
    "2587": {"001": "Fragmenta rhetorica"},
    "2589": {
        "001": "Εἰς τὸ κατ",
        "002": "De arte sacra (appendices e codd. Venet. Marc. 299 % Paris. B.N. gr. 2250)",
    },
    "2591": {
        "001": "Etymologicum",
        "002": "Etymologicum (excerpta e cod. regio 2610)",
        "003": "Etymologicum (excerpta e cod. regio Paris. 2630)",
        "004": "Anthologion",
        "005": "Etymologicum (excerpta e cod. Darmstadino 2773)",
        "006": "Etymologicum (excerpta e cod. Vat. gr. 1456)",
    },
    "2592": {
        "001": "Scholia in Hesiodi scutum (scholia paraphrastica Pediasimi et exegesis Joannis Tzetzae)"
    },
    "2594": {"001": "Fragmenta"},
    "2595": {"001": "De septem orbis spectaculis"},
    "2596": {"001": "De figuris (fort. auctore Phoebammone alio)"},
    "2598": {
        "001": "Catena in Canticum canticorum",
        "002": "Catena in Ecclesiasten (e cod. Marc. gr. 22)",
        "003": "Commentarii in Isaiam",
        "004": "Epistulae 1-166",
        "005": "Epistula (e cod. Barocc. gr. 131)",
        "006": "Declamationes",
        "007": "Descriptio imaginis",
        "008": "Horologium",
        "009": "Refutatio Procli (fragmentum e cod. Vat. gr. 1096)",
        "010": "Epistula (e cod. Esc. gr. 234)",
    },
    "2600": {"001": "De forma et delectu equorum", "002": "Fragmenta"},
    "2601": {"001": "De figuris Demosthenicis"},
    "2602": {"001": "Lexicon Platonicum (e cod. Coislin. 345)"},
    "2604": {"001": "Prolegomena in Demosthenis orationes Olynthiacas et Philippicas"},
    "2605": {"001": "Fragmentum"},
    "2606": {"001": "Fragmentum"},
    "2607": {"001": "Titulus"},
    "2608": {"001": "Fragmentum"},
    "2609": {"001": "Tituli"},
    "2610": {"001": "Fragmentum"},
    "2611": {"001": "Fragmentum"},
    "2612": {"001": "Titulus"},
    "2613": {"001": "Titulus"},
    "2614": {"001": "Fragmenta"},
    "2615": {"001": "Fragmentum"},
    "2616": {"001": "Titulus"},
    "2617": {"001": "Fragmentum"},
    "2618": {"001": "Titulus"},
    "2619": {"001": "Tituli"},
    "2620": {"001": "Fragmentum"},
    "2621": {"001": "Fragmentum"},
    "2622": {"001": "Epigramma"},
    "2623": {"001": "Titulus"},
    "2624": {"001": "Fragmentum"},
    "2625": {"001": "Fragmenta"},
    "2626": {"001": "Fragmenta"},
    "2627": {"001": "Optica"},
    "2628": {"001": "Titulus"},
    "2630": {
        "001": "Fragmenta et titulus",
        "002": "Epigrammata in poetas ante Alexandrinorum aetatem condita",
    },
    "2631": {"001": "Fragmentum"},
    "2632": {"001": "De lapide philosophorum (e cod. Paris. B.N. gr. 2327, fol. 74r)"},
    "2633": {"001": "Titulus"},
    "2634": {"001": "Fragmentum"},
    "2635": {"001": "Titulus"},
    "2636": {"001": "Fragmentum"},
    "2638": {"001": "Fragmentum"},
    "2639": {"001": "Titulus"},
    "2640": {"001": "Fragmenta"},
    "2641": {"001": "Titulus"},
    "2642": {"001": "Oracula", "002": "Sortes"},
    "2644": {"001": "Titulus"},
    "2645": {"001": "Fragmentum"},
    "2646": {"001": "Frustula adespota ex auctoribus"},
    "2647": {"001": "Fragmentum"},
    "2648": {
        "001": "Hexametri",
        "002": "Elegiae",
        "003": "Epigrammata",
        "004": "Miscellanea",
    },
    "2649": {"001": "Fragmenta (P. Oxy. 4.662 "},
    "2650": {"001": "Fragmentum et tituli"},
    "2651": {"001": "Tituli"},
    "2652": {"001": "Titulus"},
    "2653": {"001": "Fragmentum"},
    "2654": {"001": "Physiologus (redactio prima)"},
    "2655": {"001": "De lapidibus (e codd. Vat. gr. 578 % Ambros. 95 sup.)"},
    "2657": {
        "001": "Martyrium Ignatii Antiocheni (martyrium Antiochenum)",
        "002": "Martyrium Ignatii Antiocheni (martyrium Romanum)",
    },
    "2679": {
        "001": "Testamentum Salomonis (recensiones A et B) (mss. HILPQ)",
        "002": "Testamentum Salomonis (recensiones A et B) (mss. HIPQ)",
        "003": "Testamentum Salomonis (recensio A) (mss. HI)",
        "004": "Testamentum Salomonis (recensio A) (ms. L)",
        "005": "Testamentum Salomonis (recensio C, I.1-3) (mss. VW)",
        "006": "Testamentum Salomonis (recensio C) (mss. VWSTU)",
        "007": "Vita Salomonis (cod. 132 Monasterii sancti Dionysii in Monte Atho)",
        "008": "Conspectus titulorum",
        "009": "Sigilla anuli Salomonis",
        "010": "Narratio de propheta et sapientissimo rege Salomone (cod. Monasterii sancti Saba 290)",
    },
    "2680": {"001": "Epigrammata"},
    "2681": {"001": "Fragmentum"},
    "2691": {"001": "Testimonia", "002": "Fragmenta"},
    "2693": {"001": "Epigramma"},
    "2694": {"001": "Tituli"},
    "2695": {
        "001": "Vita Marciana (post epitomen Ptolemaeeae vitae) (cod. Marc. gr. 257)",
        "002": "Vita vulgata (post epitomen Ptolemaeeae vitae)",
    },
    "2696": {"001": "Titulus"},
    "2697": {"001": "Fragmentum"},
    "2699": {"001": "Fragmenta"},
    "2701": {
        "001": "In Heraclium ex Africa redeuntem",
        "002": "De expeditione Persica",
        "003": "In Bonum patricium",
        "004": "Bellum Avaricum",
        "005": "In restitutionem sanctae crucis",
        "006": "Heraclias",
        "007": "Heracliadis iii acroaseos fragmenta",
    },
    "2702": {
        "001": "Chronographia",
        "002": "Orationes panegyricae",
        "003": "Orationes forenses et acta",
        "004": "Oratoria minora",
        "005": "Opuscula logica, physica, allegorica, alia",
        "006": "Opuscula psychologica, theologica, daemonologica",
        "007": "Theologica",
        "008": "Poemata",
        "009": "Encomium in matrem",
        "010": "In Mariam Sclerenam",
        "011": "De Euripide et Georgio Piside judicium",
        "012": "De Heliodoro et Achille Tatio judicium",
    },
    "2703": {"001": "Alexias"},
    "2714": {
        "001": "Homilia in nativitatem Mariae (olim sub auctore Joanne Damasceno)",
        "002": "Epistulae",
        "003": "Iambi de variis argumentis",
    },
    "2718": {"001": "Carmina", "002": "Carmina inedita"},
    "2721": {
        "001": "Epithalamium fortunatissimis caesaris filiis",
        "002": "Epitaphius in Theodoram nurum Bryennii",
    },
    "2724": {"001": "Fragmenta in Joannem (in catenis)"},
    "2729": {"001": "Titulus"},
    "2733": {"001": "Historia ecclesiastica"},
    "2734": {
        "001": "Contra monophysitas",
        "002": "Epistula contra tria capitula",
        "003": "Edictum rectae fidei",
        "004": "Decretum ad abbatem montis Sinai",
        "005": "Novellae",
        "006": "Appendix constitutionum dispersarum",
        "007": "Contra Nestorianos (ap. Chronicon paschale)",
        "008": "Contra Nestorianos et Acephalos (ap. acta concilii oecumenici vi)",
        "009": "Troparium",
        "010": "Constitutio contra Anthimum, Severum, Petrum et Zooram",
        "011": "Epistula dogmatica ad Zoilum",
        "012": "Edictum contra Origenem",
        "013": "Epistula ad synodum de Origene",
        "014": "Epistula ad synodum de Theodoro Mopsuesteno et reliquis",
        "015": "Edictum de aphthartodocetismo (fragmentum)",
        "016": "Edictum de asylo",
        "017": "Edictum de asylo",
    },
    "2738": {
        "001": "Chronographia brevis (e cod. Coislin. 193)",
        "002": "Chronographia brevis (e cod. Paris. suppl. gr. 67)",
        "003": "Chronographia brevis (e cod. Monac. gr. 510)",
    },
    "2742": {
        "001": "Apophthegmata patrum (collectio alphabetica)",
        "002": "Apophthegmata (collectio anonyma) (e cod. Coislin. 126)",
        "003": "Apophthegmata patrum (collectio anonyma) (e codd. Coislin. 126, 127 % Paris. gr. 1596, 2474)",
        "004": "Apophthegma patrum (e collectione anonyma) (e codd. Vat. gr. 1599, 1632)",
        "005": "Apophthegmata patrum (collectio systematica) (cap. 1-9)",
        "006": "De meditationibus duodecim anachoretarum",
        "007": "Quaestiones et responsa senum de tentationibus",
        "008": "Dialogus de contemplatione",
    },
    "2744": {"001": "Historia monachorum in Aegypto"},
    "2762": {
        "001": "Fragmenta in epistulam ad Romanos (in catenis)",
        "002": "Fragmenta in epistulam i ad Corinthios (in catenis)",
        "003": "Fragmentum in epistulam ii ad Corinthios (in catenis)",
        "004": "Fragmenta in epistulam ad Galatas (in catenis)",
        "005": "Fragmentum in epistulam ii ad Thessalonicenses (in catenis)",
        "006": "Fragmenta in epistulam ad Hebraeos (in catenis)",
    },
    "2766": {
        "001": "De martyrio sancti Cypriani (e cod. Florent. Laurent. VII, 10)",
        "002": "Homerocentones (fort. conditore operis et auctore Patricio quodam episcopo)",
    },
    "2770": {"001": "Vita sancti Hypatii"},
    "2797": {
        "001": "Homilia i de Hypapante (homilia 1)",
        "002": "Homilia ii de Hypapante (homilia 2)",
        "003": "Homilia i in sanctum pascha (homilia 3) (e cod. Sinaitico gr. 492)",
        "004": "Homilia ii in sanctum pascha (homilia 4) (e cod. Sinaitico gr. 492)",
        "005": "Homilia i de sancta Maria deipara (homilia 5)",
        "006": "Homilia ii de sancta Maria deipara (homilia 6)",
        "007": "In sanctum Andream (homilia 7)",
        "008": "In sanctum Antonium (homilia 8)",
        "009": "In sanctum Stephanum (homilia 9)",
        "010": "In sanctos Jacobum et David (homilia 10) (e Photii Bibliotheca cod. 275)",
        "011": "Homilia i in sanctum Lazarum (homilia 11)",
        "012": "Homilia ii in sanctum Lazarum (homilia 12)",
        "013": "In sanctos Petrum et Paulum (homilia 13)",
        "014": "In sanctum Procopium (homilia 14)",
        "015": "Homilia de jejunio (homilia 15) (e cod. Sinaitico gr. 491)",
        "016": "In conceptionem venerabilis praecursoris (homilia 16)",
        "017": "In sanctos martyres (fragmentum) (homilia 17) [Dub.]",
        "018": "In Lazarum et in ramos palmarum (homilia 18) (olim sub nomine Titi Bostrensis) [Sp.]",
        "019": "Homilia i in sanctum Longinum centurionem (homilia 19) [Dub.]",
        "020": "Homilia ii in sanctum Longinum centurionem (homilia 20) [Dub.]",
        "021": "In sanctum Lucam (homilia 21) [Dub.]",
    },
    "2798": {
        "001": "De caelesti hierarchia",
        "002": "De ecclesiastica hierarchia",
        "003": "De divinis nominibus",
        "004": "De mystica theologia",
        "005": "Epistulae",
    },
    "2800": {
        "001": "Sermones xli",
        "002": "Homilia in sanctum pascha",
        "003": "Homilia in sanctum pascha et in recens illuminatos",
        "004": "Homilia in assumptionem domini",
        "005": "Homilia in sanctum Andream",
        "006": "Homilia in feriam v et in proditionem Judae",
        "007": "Homilia in passionem domini",
        "008": "Homilia in pentecosten",
        "009": "De vita et miraculis sanctae Theclae libri ii [Sp.]",
    },
    "2806": {"001": "Vita Porphyrii episcopi Gazensis"},
    "2807": {"001": "Vita Symeonis Stylitae senioris"},
    "2816": {
        "001": "Apologia concilii Chalcedonensis (excerpta Graeca)",
        "002": "Capitula xvii contra monophysitas",
        "003": "Adversus Aphthartodocetas",
        "004": "In evangelium secundum Joannem (excerpta duo) (e cod. Vallicell. E 40)",
        "005": "Adversus Manichaeos (homilia 1)",
        "006": "Adversus Manichaeos (homilia 2)",
        "007": "Disputatio cum Manichaeo",
        "008": "Syllogismi sanctoruum patrum",
    },
    "2860": {
        "001": "Inventio crucis (fort. auctore Alexandro alio)",
        "002": "Inventio crucis (epitome prioris libelli)",
        "003": "Laudatio Barnabae apostoli",
    },
    "2865": {
        "001": "Commentarii in Job",
        "002": "Commentarii in Ecclesiasten",
        "003": "Commentarii in Jeremiam (in catenis)",
        "004": "Commentarii in Lamentationes (in catenis)",
        "005": "Commentarii in Baruch (in catenis)",
        "006": "Commentarii in Jeremiae epistulam",
        "007": "Contra Severum Antiochenum (fragmentum ap. Pseudo-Anastasium Sinaitam, Contra monophysitas)",
        "008": "Fragmentum in illud",
    },
    "2866": {
        "001": "Commentarius in Apocalypsin",
        "002": "Fragmenta in epistulam ad Romanos (in catenis)",
        "003": "Fragmenta in epistulam i ad Corinthios (in catenis)",
        "004": "Fragmenta in epistulam ii ad Corinthios (in catenis)",
        "005": "Fragmenta in epistulam ad Galatas (in catenis)",
        "006": "Fragmenta in epistulam ad Ephesios (in catenis)",
        "007": "Fragmenta in epistulam ad Philippenses (in catenis)",
        "008": "Fragmenta in epistulam ad Colossenses (in catenis)",
        "009": "Fragmenta in epistulam i ad Thessalonicenses (in catenis)",
        "010": "Fragmenta in epistulam ii ad Thessalonicenses (in catenis)",
        "011": "Fragmenta in epistulam i ad Timotheum (in catenis)",
        "012": "Fragmenta in epistulam ii ad Timotheum (in catenis)",
        "013": "Fragmenta in epistulam ad Titum (in catenis)",
        "014": "Fragmentum in epistulam ad Philemonem (in catenis)",
        "015": "Fragmenta in epistulam ad Hebraeos (in catenis)",
    },
    "2871": {
        "001": "Chronographia",
        "002": "Chronologica (fort. auctore anonymo excerptorum chronologicorum)",
        "003": "Chronographia (eclogae e cod. Paris. gr. 1336)",
    },
    "2877": {
        "001": "Vita Euthymii",
        "002": "Vita Sabae",
        "003": "Vita Joannis Hesychastae",
        "004": "Vita Cyriaci",
        "005": "Vita Theodosii",
        "006": "Vita Theognii",
        "007": "Vita Abramii",
        "008": "Vita Gerasimi [Sp.]",
    },
    "2881": {
        "001": "Cantica",
        "002": "Cantica genuina",
        "003": "Cantica dubia",
        "004": "Ἀκάθιστος ὕμνος [Dub.]",
    },
    "2892": {
        "001": "Quaestiones ad Thalassium",
        "002": "Quaestiones et dubia",
        "003": "Capita de caritate",
        "004": "Mystagogia",
        "005": "Scholia in Ecclesiasten (in catenis",
        "006": "Expositio in Psalmum LIX",
        "007": "Expositio orationis dominicae",
        "008": "Liber asceticus",
        "009": "Opusculum de anima [Sp.]",
        "010": "Hymni [Sp.]",
    },
    "2894": {"001": "Constitutiones apostolorum (fort. compilatore Juliano Ariano)"},
    "2903": {"001": "Περὶ ἐπιχειρημάτων"},
    "2904": {
        "001": "Progymnasmata",
        "002": "Progymnasmata (capita περὶ συγκρίσεως, περὶ ἠθοποιίας, περὶ ἐκφράσεως, περὶ θέσεως, περὶ νόμου εἰσφ",
        "003": "Progymnasmata (caput περὶ συγκρίσεως) (e cod. Brit. Mus. addit. 11889)",
    },
    "2914": {
        "001": "In natale sancti Joannis prophetae (homilia 1)",
        "002": "In ramos palmarum (homilia 2)",
        "003": "In ramos palmarum (homilia 3) (olim sub nomine Joannis Chrysostomi)",
        "004": "In ramos palmarum (homilia 3a) (sub nomine Joannis Chrysostomi)",
        "005": "In Job (homilia 4)",
        "006": "In Job (homilia 5)",
        "007": "In uxorem Job et in proditionem Judae (homilia 6)",
        "008": "In sanctam parasceven (homilia 7)",
        "009": "In sanctum pascha (homilia 8)",
        "010": "In resurrectionem domini (homilia 9)",
        "011": "In mesopentecosten (homilia 10)",
        "012": "In pentecosten (homilia 11)",
        "013": "In nativitatem Christi (homilia 12) (olim sub nomine Joannis Chrysostomi)",
        "014": "In pentecosten (homilia 13) (olim sub nomine Joannis Chrysostomi)",
        "015": "In transfigurationem (homilia 14) (olim sub nomine Joannis Chrysostomi)",
    },
    "2934": {
        "001": "Institutio elementaris",
        "002": "Dialectica sive Capita philosophica (recensio fusior)",
        "003": "Fragmenta philosophica (e cod. Oxon. Bodl. Auct. T.1.6)",
        "004": "Expositio fidei",
        "005": "Orationes de imaginibus tres",
        "006": "De haeresibus",
        "007": "Contra Jacobitas",
        "008": "De duabus in Christo voluntatibus",
        "009": "De fide contra Nestorianos",
        "010": "Contra Nestorianos",
        "011": "Epistula de hymno trisagio",
        "012": "Contra Manichaeos",
        "013": "De natura composita sive Contra acephalos",
        "014": "Disputatio Christiani et Saraceni [Dub.]",
        "015": "Sacra parallela (recensiones secundum alphabeti litteras dispositae, quae tres libros conflant) (fragmenta e cod.",
        "016": "Sacra parallela (recensiones secundum alphabeti litteras dispositae, quae tres libros conflant) (fragmenta e cod.",
        "017": "De sacris jejuniis",
        "018": "De sancta trinitate (fragmentum) [Dub.]",
        "019": "De octo spiritibus nequitiae (fragmentum) [Sp.]",
        "020": "De virtutibus et vitiis (fragmenta) [Sp.]",
        "021": "Contra Severianos (fragmentum) [Dub.]",
        "022": "Qua ratione homo imago dei (fragmentum) [Dub.]",
        "023": "De theologia (fragmentum) [Dub.]",
        "024": "De animato (fragmentum) [Dub.]",
        "025": "De partibus animae (fragmentum) [Dub.]",
        "026": "De unione (fragmentum) [Dub.]",
        "027": "Ex thesauro orthodoxiae Nicetae Choniatae (fragmentum) [Dub.]",
        "028": "Fragmenta in Lucam (in catenis) [Dub.]",
        "029": "De mensibus Macedonicis (fragmenta) [Dub.]",
        "030": "Quid est homo",
        "031": "Oratio de his qui in fide dormierunt [Sp.]",
        "032": "Epistula ad Theophilum imperatorem de sanctis et venerandis imaginibus [Sp.]",
        "033": "De azymis (fragmenta duo) [Sp.]",
        "034": "De immaculato corpore [Sp.]",
        "035": "Commentarii in epistulas Pauli [Dub.]",
        "036": "Homilia in transfigurationem domini",
        "037": "Homilia in ficum arefactam",
        "038": "Homilia in sabbatum sanctum",
        "039": "Sermo in annuntiationem Mariae [Sp.]",
        "040": "Encomium in sanctum Joannem Chrysostomum",
        "041": "Laudatio sanctae Barbarae",
        "042": "Deprecationes i-iii [Dub.]",
        "043": "Passio sancti Artemii [Dub.]",
        "044": "Fragmenta in Matthaeum (e catena Nicetae) [Dub.]",
        "045": "Vita Barlaam et Joasaph [Sp.]",
        "046": "Dialectica sive Capita philosophica (recensio brevior)",
        "047": "Dialectica sive Capita philosophica (recensio brevior, ἕτερον κεφάλαιον)",
    },
    "2937": {"001": "Rhetorica (fragmentum e cod. Paris. suppl. gr. 670)"},
    "2945": {"001": "Gnomologium Vaticanum"},
    "2946": {"001": "Testimonia", "002": "Fragmenta"},
    "2948": {
        "001": "Acta Philippi",
        "002": "Acta Philippi (recensio)",
        "003": "Acta Philippi (recensio)",
        "004": "Acta Philippi (epitome)",
    },
    "2949": {"001": "Acta Barnabae"},
    "2950": {"001": "De recta in deum fide (olim sub auctore Origene Adamantio)"},
    "2956": {
        "001": "Cesti (fragmenta)",
        "002": "Epistula ad Origenem",
        "003": "Epistula ad Aristidem",
    },
    "2960": {"001": "Prophetia"},
    "2962": {
        "001": "Epistula canonica (e Περὶ μετανοίας) (canones 1-14)",
        "002": "De paschate ad Tricentium (fragmentum)",
    },
    "2966": {"001": "Epistula ad Thmuitanos (ap. Eusebium)"},
    "2967": {"001": "Fragmenta in Matthaeum (in catenis)"},
    "2968": {"001": "Fragmenta"},
    "2969": {"001": "Fragmenta"},
    "2970": {"001": "Περὶ ψυχῆς (fragmentum)"},
    "2971": {"001": "Hymnus (olim sub auctore Synesio)"},
    "2972": {"001": "De terrae motibus"},
    "2995": {
        "001": "Vocum Atticarum collectio (fragmenta ap. Zonarae lexicon)",
        "002": "Vocum Atticarum collectio (fragmenta ap. alios auctores et in aliis Ori scriptis)",
        "003": "Orthographia (περὶ τῆς ",
    },
    "3002": {
        "001": "De comoedia",
        "002": "De comoedia",
        "003": "De comoedia",
        "004": "De comoedia",
        "005": "De choro",
        "006": "Comoediae veterae nomina poetarum et dramata",
        "007": "De Hellenismo et Atticismo",
        "008": "De choro",
        "009": "De scoliis",
        "010": "De histrionibus",
        "011": "De partibus comoediae",
        "012": "De metro comico",
        "013": "De comoedia (Anonymus Crameri i)",
        "014": "De comoedia (Anonymus Crameri ii)",
        "015": "De poeticae generibus (fort. auctore Joanne Tzetza)",
        "016": "De comoedia",
        "017": "ἐκ τοῦ Ἡφαιστίωνος ἐπιτομὴ τῶν ἐννέα μέτρων",
        "018": "Tractatus Coislinianus (e cod. Paris. Coislin. 120)",
    },
    "3014": {"001": "Introductio in astronomiam", "002": "De zodiaco"},
    "3015": {"001": "De expugnatione Thessalonicae"},
    "3018": {"001": "Compendium historiarum"},
    "3020": {
        "001": "Epitome rerum ab Joanne et Alexio Comnenis gestarum",
        "002": "Ethopoeia",
    },
    "3023": {
        "001": "De legationibus",
        "002": "De virtutibus et vitiis",
        "003": "De insidiis",
        "004": "De sententiis",
        "005": "De strategematibus (olim sub auctore Herone Byzantio)",
        "006": "De contionibus militaribus",
        "007": "De administrando imperio",
        "008": "De thematibus",
        "009": "De cerimoniis aulae Byzantinae (lib. 1.84-2.56)",
        "010": "De cerimoniis aulae Byzantinae (lib. 1.1-92)",
        "011": "Narratio de imagine Edessena",
        "012": "Oratio de translatione Chrysostomi",
        "013": "Oratio ad milites",
    },
    "3027": {
        "001": "Prolegomena in Aphthonii progymnasmata",
        "002": "Prolegomena in Hermogenis librum περὶ στάσεων",
        "003": "Prolegomena in Hermogenis librum περὶ εὑρέσεως",
        "004": "Prolegomena in Hermogenis librum περὶ ἰδεῶν",
    },
    "3039": {
        "001": "Allegoriae in Hesiodi theogoniam",
        "002": "Allegoriae in Homeri Iliadem 4.1-4",
    },
    "3040": {"001": "Βασιλεῖαι"},
    "3043": {
        "001": "Chronicon (lib. 1-4)",
        "002": "Chronicon breve (lib. 1-6) (redactio recentior)",
    },
    "3045": {"001": "Ecloga chronographica"},
    "3047": {"001": "Annales", "002": "Annales (lectiones variae)"},
    "3051": {"001": "Chronicon (continuatio) (redactio A)"},
    "3063": {"001": "Synopsis historiarum"},
    "3064": {"001": "Continuatio Scylitzae"},
    "3069": {"001": "Historia"},
    "3070": {
        "001": "Chronicon (sub nomine Leonis Grammatici vel Theodosii Melisseni vel Julii Pollucis) (redactio A % B operis sub t"
    },
    "3074": {"001": "Compendium chronicum", "002": "Vita Oppiani"},
    "3075": {"001": "Strategicon (sub nomine Mauricii Imperatoris vel Urbicii)"},
    "3079": {"001": "Historia"},
    "3086": {
        "001": "Breviarium historicum de rebus gestis post imperium Mauricii (e cod. Vat. gr. 977)",
        "002": "Chronographia brevis [Dub.] (recensiones duae)",
        "003": "Refutatio et eversio definitionis synodalis anni 815",
    },
    "3088": {"001": "Historiae"},
    "3094": {"001": "Historia ("},
    "3100": {"001": "Epistulae", "002": "Opuscula diversa"},
    "3115": {"001": "Chronicon breve (lib. 7-8) (redactio recentior)"},
    "3120": {
        "001": "Παραστάσεις σύντομοι χρονικαί",
        "002": "Διήγησις περὶ τῆς Ἁγίας Σοφίας",
        "003": "Διήγησις περὶ τῆς Ἁγίας Σοφίας (variae lectiones)",
        "004": "De sepulcris imperatorum quae sunt in templo sanctorum apostolorum",
    },
    "3125": {"001": "De Creta capta"},
    "3127": {"001": "Scholia mythologica"},
    "3128": {"001": "Canones sive De orthographia"},
    "3130": {
        "001": "Epistulae",
        "002": "Historiae",
        "003": "Quaestiones physicae",
        "004": "De vitae termino",
    },
    "3135": {
        "001": "Epitome historiarum (lib. 1-12)",
        "002": "Epitome historiarum (lib. 13-18)",
        "003": "Epitome historiarum (lib. 12, clausula varia) [Dub.]",
    },
    "3136": {"001": "Lexicon"},
    "3139": {"001": "Historiae"},
    "3140": {"001": "Chronographia compendiaria"},
    "3141": {
        "001": "Annales",
        "002": "Historia in brevius redacta",
        "003": "Epitaphius in Irenam imperatricem",
        "004": "In imaginem beatae virginis",
        "005": "Praefatio in epistulas Theodori Lascaris",
        "006": "Carmen in magnum sabbatum",
        "007": "Epitaphius in Joannem Ducam",
        "008": "Contra Latinos",
        "009": "Epistula ad Joannem Tornicem",
        "010": "In Gregorii Nazianzeni sententias",
        "011": "Laudatio Petri et Pauli",
    },
    "3142": {
        "001": "Συγγραφικαὶ ἱστορίαι (libri vi de Michaele Palaeologo)",
        "002": "Συγγραφικαὶ ἱστορίαι (libri vii de Andronico Palaeologo)",
    },
    "3143": {"001": "Chronicon sive Minus [Sp.]"},
    "3144": {"001": "De Constantinopoli oppugnata"},
    "3145": {
        "001": "De extremo Thessalonicensi excidio narratio",
        "002": "Pro viribus acta monodia",
    },
    "3146": {"001": "Historia Turcobyzantina"},
    "3147": {
        "001": "Precatio",
        "002": "Poema",
        "003": "Epistula ad Mechemet II",
        "004": "Historiae",
    },
    "3155": {"001": "Ἐξήγησις φυσικὴ τῶν ἡμερῶν Ἡσιόδου"},
    "3156": {"001": "Exegesis in Hesiodi theogoniam"},
    "3157": {"001": "Additamenta ad Georgii Acropolitae historiam"},
    "3158": {"001": "Epistulae"},
    "3159": {"001": "Paraphrasis in Euclidis elementorum librum secundum"},
    "3168": {
        "001": "De officiis (",
        "002": "De officiis (",
        "003": "De officiis (",
        "004": "De annis ab orbe condito",
        "005": "Patria Constantinopoleos",
        "006": "Patria Constantinopoleos (variae lectiones)",
        "007": "Patria Constantinopoleos (ordo et tituli paragraphorum, quem sequitur recensio C, ejusque additamenta)",
        "008": "Patria Constantinopoleos (ordo et tituli paragraphorum, quem sequitur recensio M)",
    },
    "3169": {"001": "Historiae"},
    "3170": {"001": "Chronicon"},
    "3173": {
        "001": "Adversus iconoclastas (olim sub auctore Joanne Damasceno)",
        "002": "De sacris imaginibus contra Constantinum Cabalinum (sub nomine Joannis Syncelli) (olim sub auctore Joanne Damasce",
        "003": "Narratio",
    },
    "3176": {
        "001": "Chronicon sive Maius (partim sub auctore Macario Melisseno)",
        "002": "Chronicon sive Maius (additamenta Macarii Melisseni % lectiones variae)",
    },
    "3177": {
        "001": "De Leone Armenio (e cod. Paris. gr. 1711)",
        "002": "De Leone Armenio (e cod. Vat. gr. 2014)",
    },
    "3178": {"001": "Ῥητορικαὶ λέξεις"},
    "3181": {"001": "De velitatione bellica (sub nomine Nicephori II Phocae)"},
    "3182": {"001": "Chronographia (partim edita e cod. Paris. gr. 1712)"},
    "3185": {
        "001": "De scientia politica dialogus (olim sub auctore Petro Patricio) (e cod. Vat. gr. 1298)"
    },
    "3186": {
        "001": "Anonymus dialogus cum Judaeis (e cod. Vatoped. 236) (olim sub auctore Joanne Damasceno)"
    },
    "3187": {"001": "Anacreontea"},
    "3188": {"001": "De spiritu animali", "002": "De urinis", "003": "De diagnosi"},
    "4000": {"001": "Epistulae"},
    "4001": {
        "001": "Theophrastus sive de animarum immortalitate et corporum resurrectione dialogus",
        "002": "Epistulae",
    },
    "4003": {
        "001": "Periplus maris exteri",
        "002": "Menippi periplus maris interni (epitome Marciani)",
        "003": "Artemidori geographia (epitome Marciani)",
    },
    "4005": {"001": "Euclidis elementorum qui fertur liber xv"},
    "4013": {
        "001": "In Aristotelis quattuor libros de caelo commentaria",
        "002": "De caelo i (interpretatio Graeca ex Kc)",
        "003": "In Aristotelis categorias commentarium",
        "004": "In Aristotelis physicorum libros commentaria",
        "005": "In Aristotelis libros de anima commentaria [Sp.",
        "006": "Commentarius in Epicteti enchiridion",
    },
    "4014": {"001": "Metaphrasis in Theophrastum"},
    "4015": {
        "001": "In Aristotelis categorias commentarium",
        "002": "In Aristotelis analytica priora commentaria",
        "003": "In Aristotelis analytica posteriora commentaria (prooemium e codd. BRL)",
        "004": "In Aristotelis analytica posteriora commentaria",
        "005": "In Aristotelis meteorologicorum librum primum commentarium",
        "006": "In Aristotelis libros de generatione et corruptione commentaria",
        "007": "In libros de generatione animalium commentaria",
        "008": "In Aristotelis libros de anima commentaria",
        "009": "In Aristotelis physicorum libros commentaria",
        "010": "De aeternitate mundi",
        "011": "De opificio mundi",
        "012": "De vocabulis quae diversum significatum exhibent secundum differentiam accentus",
        "013": "De usu astrolabii eiusque constructione",
        "014": "De vocabulis quae diversum significatum exhibent secundum differentiam accentus (additamenta)",
    },
    "4016": {
        "001": "In Porphyrii isagogen sive quinque voces",
        "002": "In Aristotelis categorias commentarius",
        "003": "In Aristotelis librum de interpretatione commentarius",
        "004": "In Aristotelis analyticorum priorum librum i commentarium",
        "005": "In Aristotelis analytica priora [Sp.]",
    },
    "4017": {
        "001": "In Aristotelis metaphysica commentaria",
        "002": "Commentarium in Hermogenis librum περὶ ἰδεῶν",
        "003": "Praefatio in Hermogenis librum περὶ ἰδεῶν [Sp.] (fort. auctore Phoebammone partim)",
        "004": "Commentarium in Hermogenis librum περὶ στάσεων",
    },
    "4018": {
        "001": "In Aristotelis metaphysicorum libros A-Z commentaria",
        "002": "Commentaria in Nicomachi Geraseni Pythagorei introductionem arithmeticam",
    },
    "4019": {
        "001": "Prolegomena",
        "002": "In Aristotelis categorias commentarium",
        "003": "In Aristotelis meteora commentaria",
        "004": "In Platonis Alcibiadem commentarii",
        "005": "In Platonis Gorgiam commentaria",
        "006": "In Platonis Phaedonem commentaria",
        "007": "Scholia in Aristotelis librum de interpretatione (e cod. Vat. Urbin. gr. 35)",
    },
    "4020": {
        "001": "In Porphyrii isagogen",
        "002": "Eliae (olim Davidis) in Aristotelis categorias commentarium",
        "003": "Commentarius in Aristotelis analytica priora",
    },
    "4021": {
        "001": "Prolegomena philosophiae",
        "002": "In Porphyrii isagogen commentarium",
    },
    "4024": {"001": "Historiae"},
    "4026": {
        "001": "In Aristotelis artem rhetoricam commentarium",
        "002": "Fragmentum commentarii in Aristotelis rhetorica",
        "003": "Fragmentum paraphrasis in Aristotelis rhetorica",
    },
    "4027": {"001": "Paraphrasis categoriarum"},
    "4028": {"001": "Ethnica (epitome)", "002": "Epigramma"},
    "4029": {
        "001": "De bellis",
        "002": "Historia arcana (",
        "003": "De aedificiis (lib. 1-6)",
    },
    "4030": {"001": "In Aristotelis libros de anima paraphrasis"},
    "4031": {
        "001": "In Aristotelis analyticorum posteriorum librum secundum commentarium",
        "002": "In Aristotelis ethica Nicomachea i commentaria",
        "003": "In Aristotelis ethica Nicomachea vi commentaria",
    },
    "4032": {"001": "In primum librum analyticorum posteriorum commentarium"},
    "4033": {
        "001": "In ethica Nicomachea ii-v commentaria",
        "002": "In ethica Nicomachea vii commentaria",
        "003": "In ethica Nicomachea paraphrasis (pseudepigraphum olim a Constantino Palaeocappa confectum et olim sub auctore He",
    },
    "4034": {
        "001": "In ethica Nicomachea ix-x commentaria",
        "002": "In parva naturalia commentaria",
        "003": "In libros de partibus animalium commentaria",
        "004": "In libros de animalium motione commentarium",
        "005": "In librum de animalium incessu commentarium",
        "006": "In librum quintum ethicorum Nicomacheorum commentarium",
        "007": "In Aristotelis sophisticos elenchos commentarius (",
        "008": "In Aristotelis sophisticos elenchos commentarius (selecta) (",
    },
    "4036": {
        "001": "In Platonis rem publicam commentarii",
        "002": "Hypotyposis astronomicarum positionum",
        "003": "Epigramma",
        "004": "Theologia Platonica (lib. 1-5)",
        "005": "Institutio theologica",
        "006": "Institutio physica",
        "007": "In Platonis Alcibiadem i",
        "008": "In Platonis Parmenidem",
        "009": "In Platonis Cratylum commentaria",
        "010": "In Platonis Timaeum commentaria",
        "011": "In primum Euclidis elementorum librum commentarii",
        "012": "De decem dubitationibus circa providentiam",
        "013": "De providentia et fato et eo quod in nobis ad Theodorum mechanicum",
        "014": "De malorum subsistentia",
        "015": "Hymni 1-7",
        "016": "Hymnorum fragmenta",
        "017": "Epigrammata",
        "018": "De sacrificio et magia",
        "019": "Excerpta e Platonica Procli theologia",
        "020": "Eclogae de philosophia Chaldaica",
        "021": "Chrestomathia [Dub.] (epitome)",
    },
    "4037": {
        "001": "De incredibilibus (excerpta Vaticana)",
        "002": "Tractatus de mulieribus",
        "003": "Τίνες οἶκοι ἀνάστατοι διὰ γυναῖκας ἐγένοντο",
        "004": "De fratribus amicis",
        "005": "De amicis",
        "006": "De Cleobi et Bitone",
        "007": "De impiis",
        "008": "De transformationibus",
    },
    "4038": {"001": "Fragmenta (P. Vindob. 29788 A-C)"},
    "4039": {"001": "Descriptio Sanctae Sophiae", "002": "Descriptio ambonis"},
    "4040": {
        "001": "Bibliotheca",
        "002": "Epigramma",
        "003": "Fragmenta in epistulam ad Romanos (in catenis)",
        "004": "Fragmenta in epistulam I ad Corinthios (in catenis)",
        "005": "Fragmenta in epistulam ii ad Corinthios (in catenis)",
        "006": "Fragmenta in epistulam ad Galatas (in catenis)",
        "007": "Fragmenta in epistulam ad Ephesios (in catenis)",
        "008": "Fragmenta in epistulam ad Philippenses (in catenis)",
        "009": "Fragmenta in epistulam ad Colossenses (in catenis)",
        "010": "Fragmenta in epistulam I ad Thessalonicenses (in catenis)",
        "011": "Fragmenta in epistulam ii ad Thessalonicenses (in catenis)",
        "012": "Fragmenta in epistulam i ad Timotheum (in catenis)",
        "013": "Fragmentum in epistulam ii ad Timotheum (in catenis)",
        "014": "Fragmentum in epistulam ad Philemonem (in catenis)",
        "015": "Fragmenta in epistulam ad Hebraeos (in catenis)",
        "016": "Commentarii in Joannem (in catenis)",
        "017": "Commentarii in Matthaeum (in catenis)",
        "018": "Lexicon (Α -- Δ)",
        "019": "Lexicon (Ε -- Ω)",
    },
    "4046": {"001": "Chronographia"},
    "4061": {"001": "Topographia Christiana"},
    "4066": {
        "001": "Epigramma",
        "002": "Vita Isidori (ap. Sudam, Hesychium, Photium et e cod. Vat. 1950)",
        "003": "De principiis",
        "004": "In Parmenidem",
        "005": "In Phaedonem (versio 1)",
        "006": "In Philebum",
        "007": "Vita Isidori (ap. Photium, Bibl. codd. 181, 242)",
        "008": "In Phaedonem (versio 2)",
    },
    "4072": {
        "001": "Commentarii in libros de sphaera et cylindro",
        "002": "Commentarius in dimensionem circuli",
        "003": "Commentarius in libros de planorum aequilibriis",
        "004": "Commentaria in conica",
    },
    "4075": {"001": "Commentarium in Euclidis data"},
    "4076": {
        "001": "De legationibus Romanorum ad gentes (fragmenta ap. Constantinum Porphyrogenitum, De legationibus)",
        "002": "De legationibus gentium ad Romanos (fragmenta ap. Constantinum Porphyrogenitum, De legationibus)",
        "003": "De sententiis (ap. Constantinum Porphyrogenitum, De sententiis)",
        "004": "Fragmentum (e cod. Paris. gr. 1140A) [Dub.]",
    },
    "4080": {"001": "Geoponica"},
    "4081": {"001": "Raptio Helenae"},
    "4082": {"001": "Hero et Leander"},
    "4083": {
        "001": "Commentarii ad Homeri Iliadem",
        "002": "Commentarii ad Homeri Odysseam",
        "003": "De capta Thessalonica",
        "004": "Commentarium in Dionysii periegetae orbis descriptionem",
    },
    "4084": {"001": "Historia nova"},
    "4085": {
        "001": "Epistula ad Eulogium",
        "002": "Lexicon (Α -- Ο)",
        "003": "Lexicon (Π -- Ω)",
    },
    "4086": {
        "001": "Fragmentum alchemicum (sine titulo) (e cod. Venet. Marc. 299, fol. 95v)",
        "002": "Ἀγαθοδαίμων εἰς τὸν χρησμόν",
    },
    "4088": {
        "001": "Περὶ παραδόξων μηχανημάτων",
        "002": "Fragmentum mathematicum Bobiense",
    },
    "4089": {
        "001": "Graecarum affectionum curatio",
        "002": "Eranistes",
        "003": "Historia ecclesiastica",
        "004": "Historia religiosa (",
        "005": "Epistulae",
        "006": "Epistulae",
        "007": "Epistulae",
        "008": "Commentaria in Isaiam",
        "009": "Quaestiones et responsiones ad orthodoxos [Dub.]",
        "010": "De sancta trinitate",
        "011": "De incarnatione domini",
        "012": "Quaestiones in Octateuchum",
        "013": "Quaestiones in libros Regnorum et Paralipomenon",
        "014": "Interpretatio in Psalmos",
        "015": "Explanatio in Canticum canticorum",
        "016": "Interpretatio in Jeremiam",
        "017": "Interpretatio in Ezechielem",
        "018": "Interpretatio in Danielem",
        "019": "Interpretatio in xii prophetas minores",
        "020": "Interpretatio in xiv epistulas sancti Pauli",
        "021": "Haereticarum fabularum compendium",
        "022": "De providentia orationes decem",
        "023": "Libellus contra Nestorium ad Sporacium [Sp.]",
        "024": "Ad eos qui in Euphratesia et Osrhoena regione, Syria, Phoenicia et Cilicia vitam monasticam degunt (ex epistula 1",
        "025": "Quod unicus filius sit dominus noster Jesus Christus (ex epistula 151)",
    },
    "4090": {
        "001": "Commentarius in xii prophetas minores",
        "002": "Commentarii in Joannem",
        "003": "Fragmenta in sancti Pauli epistulam ad Romanos",
        "004": "Fragmenta in sancti Pauli epistulam i ad Corinthios",
        "005": "Fragmenta in sancti Pauli epistulam ii ad Corinthios",
        "006": "Fragmenta in sancti Pauli epistulam ad Hebraeos",
        "007": "Fragmenta homiliae de uno filio",
        "008": "Fragmenta homiliae quod unus est Christus",
        "009": "Quod homo non deiferus (homilia diversa 20) (fragmenta)",
        "010": "Sermo ad Alexandrinos (fragmentum)",
        "011": "Homiliarum incertarum fragmenta",
        "012": "Fragmenta homiliae de die novissima",
        "013": "Fragmenta ex libro contra Diodorum Tarsensem",
        "014": "Fragmenta ex libro ii contra Theodorum Mopsuestenum",
        "015": "Fragmenta ex libro iii contra Theodorum Mopsuestenum",
        "016": "Sermo prosphoneticus ad Alexandrinos de fide (homilia diversa 21) (fragmenta)",
        "017": "Adversus eos qui negant offerendum esse pro defunctis",
        "018": "Quaestio ad Cyrillum (e tractatu de dogmatum solutione)",
        "019": "Solutiones (e tractatu de dogmatum solutione)",
        "020": "Responsiones ad Tiberium diaconum sociosque suos",
        "021": "Ad Calosyrium (epist. 83)",
        "022": "De sancta trinitate dialogi i-vii",
        "023": "De incarnatione unigeniti",
        "024": "Quod unus sit Christus",
        "025": "Commentarii in Matthaeum (in catenis)",
        "026": "Commentarii in Lucam",
        "027": "Commentarii in Joannem (additamenta)",
        "028": "Epistulae paschales sive Homiliae paschales (epist. 1-30)",
        "029": "Fragmenta in Acta apostolorum et in epistulas catholicas",
        "030": "De adoratione et cultu in spiritu et veritate",
        "031": "Glaphyra in Pentateuchum",
        "032": "Fragmenta duo in Numeros",
        "033": "Fragmenta in libros Regum",
        "034": "Expositio in Psalmos",
        "035": "Fragmentum in Proverbia",
        "036": "Fragmenta in Canticum canticorum",
        "037": "Commentarius in Isaiam prophetam",
        "038": "Fragmenta in Jeremiam (in catenis)",
        "039": "Fragmentum in librum Baruch (in catenis)",
        "040": "Fragmenta in Ezechielem (in catenis)",
        "041": "Fragmenta in Danielem (in catenis)",
        "042": "Commentarii in Lucam (in catenis)",
        "043": "Thesaurus de sancta consubstantiali trinitate",
        "044": "Dialogus cum Nestorio [Sp.]",
        "045": "De synagogae defectu (fragmentum) [Sp.]",
        "046": "Ad Xystum episcopum Romae (epist. 53) (fragmentum)",
        "047": "Ad Optimum episcopum (epist. 80)",
        "048": "Commentarii in Lucam (homilia 51) (",
        "049": "Encomium in sanctam Mariam deiparam (homilia diversa 11)",
        "050": "Commentarii in Lucam (homilia 3 et 4) (",
        "051": "De exitu animi (homilia diversa 14)",
        "052": "In parabolam vineae (homilia diversa 17)",
        "053": "Fragmenta de translatione reliquiarum martyrum Cyri et Joannis (homilia diversa 18)",
        "054": "Sermo de obitu sanctorum trium puerorum (fragmenta) [Sp.]",
        "055": "De sancta trinitate [Sp.]",
        "056": "Collectio dictorum veteris testamenti [Sp.]",
        "057": "Expositio in Psalmos (prooemium)",
        "058": "Fragmentum in Psalmum 1.5",
        "059": "Fragmentum in Psalmum 2.7",
        "060": "Fragmentum in sancti Pauli epistulam i ad Corinthios",
        "061": "Thesaurus de sancta et consubstantiali trinitate (additamenta)",
        "062": "Solutiones (fragmentum e tractatu de dogmatum solutione) (e cod. Vat. gr. 447)",
        "063": "Contra Julianum imperatorem (fragmentum e libro xiv apud Joannem Thessalonicensem)",
        "064": "Contra Julianum imperatorem (fragmenta)",
        "065": "Oratio in ascensionem domini (olim sub nomine Athanasii)",
        "066": "Homilia habita in ecclesia Cyrini (fragmentum)",
        "067": "Epistula canonica ad Domnum (epist. 78)",
        "068": "Ad episcopos qui sunt in Libya et Pentapoli (epist. 79)",
        "069": "Ad Carthaginiense concilium (epist. 85)",
        "070": "Epistula ad Theodosium imperatorem (fragmenta)",
        "071": "Epistula ad Photium presbyterum (fragmentum)",
        "072": "Fragmentum incertum papyraceum (P. Johnson)",
        "073": "Contra Julianum imperatorem (fragmenta)",
        "074": "Contra Julianum (lib. 1-2)",
    },
    "4091": {"001": "Statuarum descriptiones"},
    "4093": {
        "001": "Prolegomena et scholia in Theodosii Alexandrini canones isagogicos de flexione nominum",
        "002": "Prolegomena et scholia in Theodosii Alexandrini canones isagogicos de flexione verborum",
        "003": "De orthographia (epitome) (e cod. Barocc. 50)",
        "004": "Scholia in Hephaestionem",
        "005": "Epimerismi in Psalmos",
        "006": "De spiritibus (excerpta)",
        "007": "Περὶ τρόπων ποιητικῶν [Dub.]",
        "008": "De accentibus (excerpta e Choerobosco, Aetherio, Philopono et aliis) (e codd. Urbin. 151 et Laurent. 57.34)",
    },
    "4094": {"001": "Opera", "002": "Fragmenta"},
    "4096": {"001": "Ars grammatica"},
    "4097": {
        "001": "Etymologicum genuinum (α -- ἁμωσγέπως)",
        "002": "Etymologicum genuinum (ἀνάβλησις -- βώτορες)",
        "003": "Etymologicum genuinum (littera λ)",
    },
    "4098": {
        "001": "Etymologicum Gudianum (ἀάλιον -- ζειαί)",
        "002": "Etymologicum Gudianum (ζείδωρος -- ὦμαι)",
        "003": "Additamenta in Etymologicum Gudianum (ἀάλιον -- ζειαί) (e codd. Vat. Barber. gr. 70 [olim Barber. I 70] % Pari",
        "004": "Additamenta in Etymologicum Gudianum",
    },
    "4099": {"001": "Etymologicum magnum"},
    "4100": {"001": "Progymnasmata"},
    "4101": {"001": "Etymologicum parvum"},
    "4102": {
        "001": "Catena in Matthaeum (catena integra) (e cod. Paris. Coislin. gr. 23)",
        "002": "Catena in Marcum (recensio ii) (e codd. Oxon. Bodl. Laud. 33 % Paris. Coislin. 23 % Paris. gr. 178)",
        "003": "Supplementum et varietas lectionis ad commentarium Chrysostomi in evangelium sancti Matthaei (e cod. Oxon. Bodl. ",
        "004": "Catena in Lucam (typus B) (e codd. Paris. Coislin. 23 % Oxon. Bodl. Misc. 182)",
        "005": "Catena in Joannem (catena integra) (e codd. Paris. Coislin. 23 % Oxon. Bodl. Auct. T.1.4)",
        "006": "Supplementum et varietas lectionis ad catenam in evangelium sancti Lucae (e cod. Oxon. Bodl. Laud. 33)",
        "007": "Supplementum et varietas lectionis ad catenam in evangelium sancti Joannis (e cod. Bodl. B.)",
        "008": "Catena in Acta (catena Andreae) (e cod. Oxon. coll. nov. 58)",
        "009": "Catena in epistulam ad Romanos (typus Vaticanus) (e cod. Oxon. Bodl. Auct. E.2.20 [",
        "010": "Catena in epistulam ad Romanos (typus Monacensis) (e cod. Monac. gr. 412)",
        "011": "Catena in epistulam i ad Corinthios (typus Vaticanus) (e cod. Paris. gr. 227)",
        "012": "Catena in epistulam ii ad Corinthios (catena Pseudo-Oecumenii) (e cod. Paris. gr. 223)",
        "013": "Catena in epistulam ii ad Corinthios (catena Pseudo-Oecumenii) (e cod. Paris. gr. 216)",
        "014": "Supplementum et varietas lectionis ad epistulam i ad Corinthios (catena Pseudo-Oecumenii) (e cod. Bodl. Auct. T.1",
        "015": "Supplementum et varietas lectionis ad epistulam ii ad Corinthios (catena Pseudo-Oecumenii) (e cod. Bodl. Auct. T.",
        "016": "Supplementum et varietas lectionis ad epistulam i ad Corinthios (catena Pseudo-Oecumenii) (e cod. Oxon. Bodl. Roe",
        "017": "Supplementum et varietas lectionis ad epistulam ii ad Corinthios (catena Pseudo-Oecumenii) (e cod. Oxon. Bodl. Ro",
        "018": "Catena in epistulam ad Galatas (typus Parisinus) (e cod. Coislin. 204)",
        "019": "Catena in epistulam ad Ephesios (typus Parisinus) (e cod. Coislin. 204)",
        "020": "Catena in epistulam ad Philippenses (typus Parisinus) (e cod. Coislin. 204)",
        "021": "Catena in epistulam ad Colossenses (typus Parisinus) (e cod. Coislin. 204)",
        "022": "Catena in epistulam i ad Thessalonicenses (typus Parisinus) (e cod. Coislin. 204)",
        "023": "Catena in epistulam ii ad Thessalonicenses (typus Parisinus) (e cod. Coislin. 204)",
        "024": "Supplementum et varietas lectionis in epistulam ad Galatas (catena Pseudo-Oecumenii) (e cod. Bodl. Auct. T.1.7 [%",
        "025": "Supplementum et varietas lectionis in epistulam ad Ephesios (catena Pseudo-Oecumenii) (e cod. Bodl. Auct. T.1.7 [",
        "026": "Supplementum et varietas lectionis in epistulam i ad Thessalonicenses (catena Pseudo-Oecumenii) (e cod. Bodl. Auc",
        "027": "Supplementum et varietas lectionis in epistulam ad Galatas (catena Pseudo-Oecumenii) (e cod. Oxon. Bodl. Roe 16)",
        "028": "Supplementum et varietas lectionis in epistulam ad Ephesios (catena Pseudo-Oecumenii) (e cod. Oxon. Bodl. Roe 16)",
        "029": "Supplementum et varietas lectionis in epistulam ad Philippenses (catena Pseudo-Oecumenii) (e cod. Oxon. Bodl. Roe",
        "030": "Supplementum et varietas lectionis in epistulam ad Colossenses (catena Pseudo-Oecumenii) (e cod. Oxon. Bodl. Roe ",
        "031": "Supplementum et varietas lectionis in epistulam i ad Thessalonicenses (catena Pseudo-Oecumenii) (e cod. Oxon. Bod",
        "032": "Supplementum et varietas lectionis in epistulam ii ad Thessalonicenses (catena Pseudo-Oecumenii) (e cod. Oxon. Bo",
        "033": "Catena in epistulam i ad Timotheum (e cod. Paris. Coislin. 204)",
        "034": "Catena in epistulam ii ad Timotheum (e cod. Paris. Coislin. 204)",
        "035": "Catena in epistulam ad Titum (e cod. Paris. Coislin. 204)",
        "036": "Catena in epistulam ad Philemonem (e cod. Paris. Coislin. 204)",
        "037": "Catena in epistulam ad Hebraeos (e cod. Paris. Coislin. 204)",
        "038": "Catena in epistulam ad Hebraeos (catena Nicetae) (e cod. Paris. gr. 238)",
        "039": "Catena in epistulam Jacobi (catena Andreae) (e cod. Oxon. coll. nov. 58)",
        "040": "Catena in epistulam Petri i (catena Andreae) (e cod. Oxon. coll. nov. 58)",
        "041": "Catena in epistulam Petri ii (catena Andreae) (e cod. Oxon. coll. nov. 58)",
        "042": "Catena in epistulam Joannis i (catena Andreae) (e cod. Oxon. coll. nov. 58)",
        "043": "Catena in epistulam Joannis ii (catena Andreae) (e cod. Oxon. coll. nov. 58)",
        "044": "Catena in epistulam Joannis iii (catena Andreae) (e cod. Oxon. coll. nov. 58)",
        "045": "Catena in epistulam Juda (catena Andreae) (e cod. Oxon. coll. nov. 58)",
    },
    "4105": {"001": "Commentarius in Job"},
    "4110": {
        "001": "Practicus (capita centum)",
        "002": "Gnosticus (fragmenta Graeca)",
        "003": "Sententiae ad monachos",
        "004": "Sententiae ad virginem",
        "005": "Rerum monachalium rationes",
        "006": "Capitula xxxiii (definitiones passionum animae rationalis)",
        "007": "Capita paraenetica",
        "008": "Spiritales sententiae per alphabeticum dispositae",
        "009": "Aliae sententiae",
        "010": "Tractatus ad Eulogium (sub nomine Nili Ancyrani)",
        "011": "De vitiis quae opposita sunt virtutibus (sub nomine Nili Ancyrani)",
        "012": "De malignis cogitationibus (sub nomine Nili Ancyrani)",
        "013": "De octo spiritibus malitiae (sub nomine Nili Ancyrani)",
        "014": "De oratione (sub nomine Nili Ancyrani)",
        "015": "Institutio sive Paraenesis ad monachos (recensio brevior)",
        "016": "Expositio in Proverbia Salomonis",
        "017": "Scholia in Proverbia (fragmenta e catenis)",
        "018": "Scholia in Ecclesiasten (fragmenta e catenis)",
        "019": "Εἰς τὸ πιπι [Sp.]",
        "020": "De magistris et discipulis (sub nomine Nili Ancyrani) (fragmenta e codd. Paris. gr. 1188 % 1066)",
    },
    "4115": {
        "001": "Fragmenta in Matthaeum (in catenis)",
        "002": "Fragmenta in Joannem (in catenis)",
    },
    "4117": {
        "001": "De engastrimytho contra Origenem",
        "002": "De anima contra philosophos (ap. Joannem Damascenum, Sacra parallela) (fragmenta)",
        "003": "In inscriptione titulorum (fragmenta)",
        "004": "De anima contra Arianos (fragmenta)",
        "005": "Oratio in illud",
        "006": "Oratio in inscriptione psalmorum graduum (fragmenta)",
        "007": "Commentarius in Psalmum 92 (fragmenta)",
        "008": "Orationes contra Arianos (fragmenta)",
        "009": "De fide contra Arianos (fragmenta)",
        "010": "De Melchisedech (fragmenta)",
        "011": "De hebraismo (fragmenta)",
        "012": "In Joseph (fragmenta)",
        "013": "In Samaritanum (fragmenta e cod. Paris. gr. 1115)",
        "014": "In Proverbia (fragmenta)",
        "015": "In Ecclesiasten (fragmenta e catenis)",
        "016": "Ἐκ τοῦ πανεκκλησιαστοῦ (fragmenta)",
        "017": "Sermo catecheticus [Sp.] (fragmentum)",
        "018": "Commentarius in evangelium secundum Joannem [Sp.] (fragmentum)",
        "019": "In Genesim de creatione [Sp.] (fragmenta)",
        "020": "Fragmenta varia [Sp.] (fragmenta)",
        "021": "Commentarius in Psalmum 15 [Sp.] (fragmenta)",
        "022": "Commentarius in hexaemeron [Sp.]",
        "023": "Homilia christologica in Lazarum, Mariam et Martham [Sp.]",
        "024": "Allocutio ad imperatorem Constantinum [Sp.]",
    },
    "4124": {
        "001": "Fragmenta in epistulam ad Romanos (in catenis)",
        "002": "Fragmenta in epistulam ad Galatas (in catenis)",
        "003": "Fragmentum in epistulam i ad Corinthios (in catenis) [Dub.]",
    },
    "4126": {
        "001": "Fragmenta in Matthaeum (in catenis)",
        "002": "Fragmenta in Joannem (in catenis)",
    },
    "4134": {"001": "Fragmenta in epistulam ad Romanos (in catenis)"},
    "4135": {
        "001": "Fragmenta in Matthaeum (in catenis)",
        "002": "Fragmenta in epistulam ad Romanos (in catenis)",
        "003": "Fragmenta in epistulam i ad Corinthios (in catenis)",
        "004": "Fragmenta in epistulam ii ad Corinthios (in catenis)",
        "005": "Fragmenta in epistulam ad Hebraeos (in catenis)",
    },
    "4138": {
        "001": "Sermo de virtutibus et vitiis",
        "002": "Reprehensio sui ipsius atque Confessio",
        "003": "Ad eversionem superbiae",
        "004": "Sermo compunctorius",
        "005": "Sermo asceticus",
        "006": "Ad imitationem proverbiorum",
        "007": "Ad correctionem eorum qui vitiose vivunt et honores appetunt",
        "008": "Reprehensio sui ipsius et Confessio",
        "009": "De passionibus animi",
        "010": "De paenitentia",
        "011": "De compunctione",
        "012": "Sermo compunctorius",
        "013": "Sermo alius compunctorius",
        "014": "Sermo paraeneticus",
        "015": "Sermo in patres defunctos",
        "016": "Sermo alius in patres defunctos",
        "017": "Sermo tetrasyllabus",
        "018": "Sermo heptasyllabus",
        "019": "De timore animarum",
        "020": "Precatio",
        "021": "Hypomnesticon, sive Epistula",
        "022": "Quomodo anima cum lacrymis debeat orare deum, quando tentatur ab inimico",
        "023": "Confessio seu Precatio ad deum",
        "024": "De virtute, ad novitium monachum (capita quattuor)",
        "025": "De virtute (capita x)",
        "026": "In illud",
        "027": "Quod non oporteat ridere et extollli, sed plangere potius et nos ipsos et nos ipsos deflere",
        "028": "Consilium de vita spiritali, ad monachum novitium (capita xcvi)",
        "029": "Beautitudines, capita quinquaginta quinque",
        "030": "Beautitudines aliae, capita viginti",
        "031": "Capita centum. Quomodo quis humilitatem sibi comparet",
        "032": "De morbo linguae et prauis affectibus",
        "033": "De iudicio et compunctione",
        "034": "Epistula ad Ioannem monachum de patientia, et de cavendo nequis decipiatur cogitationibus praetextu iustification",
        "035": "De recta vivendi ratione (capita xc)",
        "036": "Sermones paraenetici ad monachos Aegypti",
        "037": "De octo cogitationibus",
        "038": "De statu spirituali",
        "039": "De patientia",
        "040": "De beatitudinibus atque infelicitatibus",
        "041": "De fide",
        "042": "Paraenesis ad ascetas (ordine alphabetico)",
        "043": "Paraenesis",
        "044": "De quibusdam interrogationibus",
        "045": "Paraenesis de patientia et animae compunctione",
        "046": "Adhortatio sive Catechesis ad monachos",
        "047": "De perfectione monachi",
        "048": "In secundum adventum domini nostri Iesu Christi",
        "049": "Sermo in secundum adventum domini nostri Iesu Christi",
        "050": "Sermo de communi resurrectione, de paenitentia et de caritate, et in secundum adventum domini nostri Iesu Christi",
        "051": "Interrogationes et responsiones",
        "052": "Sermo in adventum domini, et de consummatione saeculi, et in adventum antichristi",
        "053": "Sermo in pretiosam et vivificam crucem, et in secundum adventum, et de caritate et eleemosyna",
        "054": "De patientia et consummatione huius saeculi, ac de secundo aduentu",
        "055": "In aduentum domini (sermo i)",
        "056": "In aduentum domini (sermo ii)",
        "057": "In aduentum domini (sermo iii)",
        "058": "Sermo de iudicio et resurrectione",
        "059": "Sermo paraeneticus de secundo aduentu domini, et de paenitentia",
        "060": "Sermo de secundo aduentu et iudicio",
        "061": "Sermo de paenitentia et iudicio et separatione animae et corporis",
        "062": "De recordatione mortis et de uirtute ac de diuitiis",
        "063": "De resurrectione mortuorum sermo",
        "064": "De iis, qui dicunt resurrectionem mortuorum non esse",
        "065": "Duo erunt in agro",
        "066": "De his, quae haec vita continet",
        "067": "De mansionibus beatis",
        "068": "De locis beatis",
        "069": "De paenitentia",
        "070": "Sermo de paenitentia",
        "071": "De paenitentia et patientia",
        "072": "De patientia et compunctione. Sermo adhortatorius",
        "073": "In sermonem, quem dixit dominus, quod",
        "074": "Sermo de habenda semper in mente die exitus uitae",
        "075": "Oratio in uanam uitam, et de paenitentia",
        "076": "De paenitentia",
        "077": "Sermo animae utilis",
        "078": "De paenitentia et compunctione",
        "079": "De caritate",
        "080": "De psalmo",
        "081": "De oratione",
        "082": "De amore pauperum",
        "083": "De ieiunio",
        "084": "De non suscipiendis rebus hisce momentaneis, et ne patiamur nos decipi huius vitae oblectamentis",
        "085": "Ode optime fluens, in eos qui cotidie peccant et cotidie paenitentiam agunt",
        "086": "De non scandalizando proximo, et de recta vitae ratione, adhortatio",
        "087": "De vera renuntiatione, et quo pacto anima deum inveniat, quam ob causam ad nos venit dominus",
        "088": "Sermo asceticus perutilis",
        "089": "De diuina gratia",
        "090": "Sermo de uirginitate",
        "091": "Aduersus improbas mulieres",
        "092": "De his, qui animas ad impudicitiam pelliciunt, cum dicant nihil mali esse",
        "093": "De abstinendo a cupiditatibus carnalibus, et de certamine ac de multa securitate, ad fratrem qui excidit",
        "094": "De abstinendo ab omni consuetudine perniciosa, et de continentia",
        "095": "Quod ludicris rebus abstinendum sit christianis",
        "096": "De monachis",
        "097": "Adhortatio ad fratres",
        "098": "De conuersatione fratrum mutua in concordia et dilectione",
        "099": "Sermo ad renuntiantes",
        "100": "Institutio ad monachos",
        "101": "Sermo de operatione peruersi daemonis",
        "102": "Institutio de exercitatione bonorum operum, et de dei patientia",
        "103": "De directione uirtutis",
        "104": "Septem sunt occupationes monachi",
        "105": "Interpretatio",
        "106": "De uirtutibus et passionibus",
        "107": "Diuisio affectionum",
        "108": "Modi dei prouidentiae",
        "109": "De nostra libertate et quod liber factus est homo",
        "110": "De humilitate",
        "111": "De oratione",
        "112": "Ad animam neglegentem",
        "113": "De panoplia, ad monachos",
        "114": "Adhortatio de silentio et quiete",
        "115": "De continentia ac de non aemulandis peccatoribus qui se temporis praetextu excusant",
        "116": "In Loth, et de securitate",
        "117": "Sermo in sanctum Eliam prophetam",
        "118": "Sermo in Danielem prophetam, et in sanctos tres pueros",
        "119": "Sermo de sacerdotio",
        "120": "Apologia ad fratrem quendam, de Heli sacerdote",
        "121": "De festis diebus",
        "122": "Sermo in eos, qui in Christo obdormierunt",
        "123": "De Iuliano asceta",
        "124": "Sermo adversus haereticos, in quo tum ex margaritae tum ex aliorum claris argumentis ostenditur credendum esse sa",
        "125": "Ad Ioannem monachum, ut abstineat a Nestorii insania et blasphemia",
        "126": "De iis, qui filii dei naturam scrutantur",
        "127": "Aduersus eos, qui dicunt terrae motus a terrae inflatione fieri",
        "128": "Ne decipiamur gentilium erroribus",
        "129": "Interrogationes ac responsiones",
        "130": "Fragmenta paraenetica",
        "131": "Precationes e sacris scripturis collectae, quarum pleraequae sunt Sancti Ephraim, pro iis qui uolunt suam ipsorum",
        "132": "Sermo in transfigurationem domini et dei salvatoris nostri Iesu Christi",
        "133": "Sermo de passione Saluatoris",
        "134": "In sanctam parasceuen, et in latronem et crucem",
        "135": "Sermo de resurrectione, in consecrationibus, et de tumulo sancto (e cod. 244 MPT Athen. Nat. Bibl., fol. 60r)",
        "136": "Sermo in crucem, in consecrationibus, et de sancto ligno crucis (e cod. Athen. Nat. Bibl. 244 MPT, fol. 62v)",
        "137": "De latrone in crucem (e cod. Sinaiticus 493, fol. 220)",
        "138": "Quomodo latro ante resurrectionem in paradisum intrauit (e cod. 115 Monasterii sancti Dochiarii in Monte Athonis,",
        "139": "Homilia in meretricem",
        "140": "Encomium in Petrum et Paulum et Andream, Thomam et Lucam et Ioannem, et in lectionem euangelii secundum Ioannem",
        "141": "Encomium in sanctos quadraginta martyres",
        "142": "Encomium in gloriosos martyres, qui in toto mundo martyrium sunt passi",
        "143": "Encomium in martyres",
        "144": "Sermo in martyrium sancti Bonifatii magnimartyris (e cod. 4887.767 Monasterii Iberonum in Monte Athonis, fol. 44v",
        "145": "Sermo de Cain, et de Abel caedo (e cod. 99 Monasterii Pantocratoris in Monte Athonis, fol. 375r)",
        "146": "Sermo in Abraham et Isaac (i)",
        "147": "Sermo in Abraham et Isaac (ii) (e cod. 163 MPT Athen. Nat. Bibl., fol. 8v-17r)",
        "148": "Sermo in Abraham",
        "149": "Sermo in pulcherrimum Ioseph",
        "150": "Sermo in Ionam prophetam et de paenitentia Niniuitarum",
        "151": "Encomium in magnum Basilium",
        "152": "In vitam beati Abrahamii et neptis eius Mariae",
        "153": "Beati Ephraem Testamentum",
        "154": "Sermo unde magi in Hierosolymam ineunt (e cod. 284 Mosq. [Vlad. 215], fol. 101v)",
    },
    "4139": {
        "001": "In Genesim (sermo 1) (olim sub auctore Joanne Chrysostomo)",
        "002": "In Job (sermones 1-4) (olim sub auctore Joanne Chrysostomo)",
        "003": "Fragmenta in epistulam ad Romanos (in catenis)",
        "004": "Fragmenta in epistulam i ad Corinthios (in catenis)",
        "005": "Fragmenta in epistulam ii ad Corinthios (in catenis)",
        "006": "Fragmenta in epistulam ad Galatas (in catenis)",
        "007": "Fragmenta in epistulam ad Ephesios (in catenis)",
        "008": "Fragmenta in epistulam ad Philippenses (in catenis)",
        "009": "Fragmenta in epistulam ad Colossenses (in catenis)",
        "010": "Fragmenta in epistulam i ad Thessalonicenses (in catenis)",
        "011": "Fragmenta in epistulam ii ad Thessalonicenses (in catenis)",
        "012": "Fragmenta in epistulam i ad Timotheum (in catenis)",
        "013": "Fragmenta in epistulam ii ad Timotheum (in catenis)",
        "014": "Fragmenta in epistulam ad Titum (in catenis)",
        "015": "Fragmentum in epistulam ad Philemonem (in catenis)",
        "016": "Fragmenta in epistulam ad Hebraeos (in catenis)",
        "017": "De tribus pueris (olim sub auctore Joanne Chrysostomo)",
        "018": "De caeco nato (olim sub auctore Joanne Chrysostomo)",
        "019": "De caeco et Zacchaeo (olim sub auctore Joanne Chrysostomo)",
        "020": "In illud",
    },
    "4145": {"001": "Historia Romana"},
    "4147": {"001": "Florilegium Cyrillianum"},
    "4149": {
        "001": "Excerpta ex Joannis Characis commentariis in Theodosii Alexandrini canones"
    },
    "4150": {"001": "Anacreontea"},
    "4153": {"001": "Chronographia (lib. 1-6)"},
    "4157": {
        "001": "Prolegomena in Hermogenis librum περὶ εὑρέσεως (olim sub auctore Georgio Diaereta)"
    },
    "4161": {
        "001": "Excerptum praefationis in phaenomena (",
        "002": "Vita Arati (",
        "003": "Vita Arati (",
        "004": "Arati genus (",
        "005": "Vita Arati (",
        "006": "Prolegomena in Aratum (e cod. Paris. suppl. gr. 607A)",
        "007": "Prolegomena in Aratum (",
        "008": "De zodiaco (olim sub auctore Leontio Mechanico)",
        "009": "Epistula ad Julianum quendam data (olim sub auctore Theone Alexandrino Math.)",
        "010": "Excerpta varia de phaenomenis Arati",
        "011": "Astronomica (in appendice cod. Scorialensis Σ III 3)",
        "012": "Ἐξ ἑτέρων σχολίων εἰσαγωγή (",
        "013": "Prooemium in Arati phaenomena",
        "014": "Sphaera (olim sub auctore Empedocle)",
    },
    "4163": {"001": "Telegonia (fragmentum)"},
    "4165": {
        "001": "Commentarium in librum de interpretatione (e cod. Paris. gr. 2064) (fort. auctore quodam Alexandrino vel Constant"
    },
    "4166": {"001": "Vitae Aeschinis"},
    "4167": {"001": "De sphaerae Arateae constructione"},
    "4170": {"001": "Vitae Pindari et varia de Pindaro"},
    "4171": {"001": "In Oppiani halieutica exegesis (e cod. Paris. gr. 2735)"},
    "4172": {
        "001": "Vita Oppiani Anazarbensis (e cod. phil. gr. 135 in Bibl. nat. in Vindob.)",
        "002": "Vita Oppiani (Vita α)",
        "003": "Vita Oppiani (Vita β)",
        "004": "Vita Tzetziana (e codd. Laur. gr. 31.3, Ambros. gr. C 222 inf., Vat. gr. 1345)",
    },
    "4173": {"001": "Vita Dionysii"},
    "4174": {
        "001": "In Dionysii periegetae orbis descriptionem",
        "002": "In Dionysii periegetae orbis descriptionem",
    },
    "4175": {
        "001": "Prolegomena Vossiana",
        "002": "Commentarius (sub auctore Melampode vel Diomede)",
        "003": "Commentarius (sub auctore Heliodoro)",
        "004": "Scholia Vaticana (partim excerpta ex Georgio Choerobosco, Georgio quodam, Porphyrio, Melampode, Stephano, Diomede",
        "005": "Scholia Marciana (partim excerpta ex Heliodoro, Tryphone, Diomede, Stephano, Georgio Choerobosco, Gregorio Corint",
        "006": "Scholia Londinensia (partim excerpta ex Heliodoro)",
        "007": "Commentariolus Byzantinus",
    },
    "4184": {"001": "Epistulae"},
    "4187": {
        "001": "Commentarium in Aristotelis sophisticos elenchos (excerpta e cod. Vat. gr. 244)",
        "002": "Commentarium in Aristotelis sophisticos elenchos (excerpta praecipue e cod. Vat. gr. 244)",
        "003": "Commentarium in Aristotelis categorias (excerptum e cod. Vat. gr. 244)",
    },
    "4193": {
        "001": "Scholia in sophisticos elenchos (",
        "002": "Scholia in sophisticos elenchos (excerpta e codd. Hierosol. S. Sepulchri 150, Paris. Coislin. 327, Vat. Reg. gr. ",
        "003": "Scholia in sophisticos elenchos (excerpta) (",
        "004": "Concisa traditio modorum sophisticarum importunitatum",
        "005": "Commentarium in sophisticos elenchos (",
        "006": "In Aristotelis sophisticos elenchos paraphrasis",
    },
    "4201": {
        "001": "In Aristotelis sophisticos elenchos (excerpta e codd. Bolon., B.U. gr. 3637"
    },
    "4227": {
        "001": "Prolegomena philosophiae Platonicae (fort. auctore Elia, olim sub auctore Olympiodoro)"
    },
    "4235": {
        "001": "Prolegomena in Hermogenis librum περὶ ἰδεῶν",
        "002": "Commentarium in Hermogenis librum περὶ ἰδεῶν",
    },
    "4236": {"001": "Prolegomena in artem rhetoricam"},
    "4237": {"001": "Prolegomena in Aphthonii progymnasmata"},
    "4238": {"001": "Prolegomena in Hermogenis librum περὶ στάσεων (epitome)"},
    "4239": {"001": "Narrationes et ethopoeiae"},
    "4242": {"001": "Περὶ διαφορᾶς στάσεως"},
    "4282": {"001": "Περὶ τῆς γέννης τοῦ σώματος αὐτοῦ ("},
    "4286": {
        "001": "Lexicon syntacticum (specimen tantum)",
        "002": "Lexicon syntacticum (",
        "003": "Lexicon syntacticum (e cod. Laur. 59,16)",
        "004": "Lexicon syntacticum (",
    },
    "4287": {"001": "Etymologia alphabeti"},
    "4288": {"001": "Lexicon αἱμωδεῖν ("},
    "4289": {
        "001": "Anonymus antatticista (e cod. Coislin. 345)",
        "002": "De syntacticis (e cod. Coislin. 345)",
        "003": "Δικῶν ὀνόματα (e cod. Coislin. 345)",
        "004": "Glossae rhetoricae (e cod. Coislin. 345)",
        "005": "Collectio verborum utilium e differentibus rhetoribus et sapientibus multis (Σ",
        "006": "Collectio verborum utilium e differentibus rhetoribus et sapientibus multis (",
    },
    "4290": {"001": "Lexicon artis grammaticae (e cod. Coislin. 345)"},
    "4291": {
        "001": "Verba in scripturis de Christi natale, epiphaniis et pentecoste (fort. auctore quodam Theodosio monacho) (e codd."
    },
    "4292": {"001": "De Atticis nominibus (", "002": "De Atticis nominibus ("},
    "4293": {
        "001": "Lexicon (fragmentum) (fort. auctore Nicephoro Gregora) (e cod. Paris. gr. 3027)"
    },
    "4294": {
        "001": "Lexicon Vindobonense (auctore Andrea Lopadiota) (e cod. phil. gr. Vindob. 169)"
    },
    "4300": {"001": "Lexicon Sabbaiticum (e cod. Sabbaitico 137)"},
    "4301": {
        "001": "Lexicon rhetoricum Cantabrigiense (e cod. Cantabr. Univ. D d 4,63 in marginibus)"
    },
    "4302": {"001": "Lexicon Patmense ("},
    "4303": {
        "001": "Lexicon in orationes Gregorii Nazianzeni (",
        "002": "Lexicon in carmina Gregorii Nazianzeni (",
        "003": "Lexicon in carmina Gregorii Nazianzeni (ordine versuum)",
        "004": "Lexicon in carmina Gregorii Nazianzeni (ordine alphabetico) (e cod. Paris. Coislin. 394)",
    },
    "4304": {"001": "Glossae in Herodotum (", "002": "Glossae in Herodotum ("},
    "4305": {
        "001": "Παρὰ τοῖς Ἀττικοῖς ῥήτορσι ζητούμενα (fragmentum) (e cod. Paris. suppl. gr. 1164 [olim cod. Athon.])"
    },
    "4307": {
        "001": "Excerptum Casanatense sive Ecloga διαφόρων λέξεων (e cod. bibl. Casanatense 264)",
        "002": "De differentia vocabulorum (",
        "003": "Differentiae verborum (e cod. Paris. suppl. gr. 1238 servante litteram α tantum)",
    },
    "4311": {
        "001": "Etymologicum Symeonis (α -- ἁμωσγέπως)",
        "002": "Etymologicum Symeonis (ἀνακωχῆς -- βώτορες)",
    },
    "4318": {"001": "Vita Sophoclis"},
    "4319": {
        "001": "Περὶ ὀργάνων καὶ καμίνων γνήσια ὑπομνήματα περὶ τοῦ ω στοιχείου (e cod. Venet. Marc. 299, fol. 189r",
        "002": "Ζωσίμου τοῦ θείου περὶ ἀρετῆς ",
        "003": "Ζώσιμος λέγει περὶ τῆς ἀσβέστου (e codd. Venet. Marc. 299, fol. 95r % Paris. B.N. gr. 2327, fol. 8v)",
        "004": "Ζωσίμου πρᾶξις β",
        "005": "Ποίημα Ζωσίμου (πρᾶξις γ",
        "006": "Ζωσίμου τοῦ θείου περὶ ἀρετῆς καὶ ἑρμηνείας (e cod. Paris. B.N. gr. 2327, fol. 168v)",
        "007": "Περὶ τῆς ἐξατμίσεως ὕδατος θείου (e cod. Venet. Marc. 299, fol. 112r)",
        "008": "Περὶ τοῦ θείου ὕδατος (e cod. Venet. Marc. 299, fol. 113v)",
        "009": "Περὶ τοῦ θείου ὕδατος (",
        "010": "Παραινέσεις συστατικαὶ τῶν ἐγχειρούντων τὴν τέχνην (e cod. Venet. Marc. 299, fol. 115r)",
        "011": "Ζωσίμου τοῦ Πανοπολίτου γνησία γραφὴ περὶ τῆς ἱερᾶς καὶ θείας τέχνης, τῆς του χρυσοῦ καὶ ἀργύ",
        "012": "Περὶ τῶν ὑποστάτων καὶ τῶν δ",
        "013": "Περὶ διαφορᾶς χαλκοῦ κεκαυμένου (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 144r)",
        "014": "Περὶ τοῦ ὅτι πάντων τῶν ὑγρῶν τὸ θεῖον ὕδωρ καλοῦσιν",
        "015": "Περὶ τοῦ ἐν παντὶ καιρῷ ἀρκτέον τὸ ἔργον (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 29",
        "016": "Περὶ τῆς κατὰ πλάτος ἐκδόσεως τὸ ἔργον (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, f",
        "017": "Περὶ τοῦ τί ἐστιν κατὰ τὴν τέχνην, οὐσία καὶ ἀνουσία (fort. pars operis Χειρόμηκτα) (e cod. Ve",
        "018": "Περὶ τοῦ ὅτι πάντα περὶ μιᾶς βαφῆς ἡ τέχνη λελάληκεν (fort. pars operis Χειρόμηκτα) (e cod. Ven",
        "019": "Περὶ τοῦ τροφὴν εἶναι τὰ δ",
        "020": "Περὶ τοῦ χρηστέον στυπτηρίᾳ στρογγύλῃ ἀντίλογος (fort. pars operis Χειρόμηκτα) (e cod. Venet. Mar",
        "021": "Περὶ θείων (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 152r)",
        "022": "Περὶ σταθμῶν (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 153r)",
        "023": "Περὶ καύσεως σωμάτων (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 154r)",
        "024": "Περὶ σταθμοῦ ξανθώσεως ",
        "025": "Περὶ θείου ὕδατος (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 156r)",
        "026": "Περὶ σκευασίας ὤχρας (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 157r)",
        "027": "Περὶ οἰκονομίας τοῦ τῆς μαγνησίας σώματος (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, ",
        "028": "Περὶ σώματος μαγνησίας καὶ οἰκονομίας (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. ",
        "029": "Περὶ τοῦ λίθου τῆς φιλοσοφίας (fort. pars operis Χειρόμηκτα) (e cod. Paris. B.N. gr. 2327, fol. 136v)",
        "030": "Περὶ ἀφορμῶν συνθέσεως (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 161v)",
        "031": "Περὶ ξηρίου (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 136v)",
        "032": "Περὶ ἰοῦ (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 136v)",
        "033": "Excerptum de vinctione virginis (sine titulo) (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 1",
        "034": "Excerptum περὶ χαλκανθρώπων (sine titulo) (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 1",
        "035": "Καδμίας πλύσις (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 137r)",
        "036": "Περὶ βαφῆς (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 137v)",
        "037": "Περὶ ξανθώσεως (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 137v)",
        "038": "Τὸ ἀέριον ὕδωρ (fort. pars operis Χειρόμηκτα) (e cod. Paris. B.N. gr. 2327, fol. 111r)",
        "039": "Περὶ λευκώσεως (fort. pars operis Χειρόμηκτα) (e cod. Venet. Marc. 299, fol. 118r)",
        "040": "Βίβλος ἀληθὴς Σοφὲ Αἰγυπτίου καὶ θείου Ἑβραίων κυρίου τῶν δυνάμεων Σαβαώθ. Ζωσίμου Θηβαίο",
        "041": "Βίβλος ἀληθὴς Σοφὲ Αἰγυπτίου καὶ θείου Ἑβραίων κυρίου τῶν δυνάμεων Σαβαώθ (e cod. Paris. B.N",
        "042": "Ζωσίμου πρὸς Θεόδωρον κεφάλαια (e cod. Venet. Marc. 299, fol. 179r)",
        "043": "Excerptum de partibus alchimiae (sine titulo) (e codd. Paris. B.N. gr. 2327, fol. 238v % Venet. Marc. 299, fol. ",
        "044": "Ὑδραργύρου ποίησις (e cod. Venet. Marc. 299, fol. 107r)",
        "045": "Περὶ διαφορᾶς χαλκοῦ κεκαυμένου (e cod. Paris. B.N. gr. 2327, fol. 249v)",
        "046": "Ζωσίμου περὶ ὀργάνων καὶ καμίνων (e cod. Venet. Marc. 299, fol. 186r)",
        "047": "Ποίησις ἐκ τουτίας ἀργύρου (e cod. Venet. Marc. 299, fol. 188r)",
        "048": "Ζωσίμου περὶ ὀργάνων καὶ καμίνων γνήσια ὑπομνήματα περὶ τοῦ ω στοιχείου (e cod. Venet. Marc. 299, ",
        "049": "Περὶ τοῦ τριβίκου καὶ τοῦ σωλῆνος (e cod. Venet. Marc. 299, fol. 194r)",
        "050": "Τὸ πρῶτον βιβλίον τῆς τελευταίας ἀποχῆς Ζωσίμου Θηβαίου (e cod. Paris. B.N. gr. 2327, fol. 251v)",
        "051": "Ἑρμηνεία περὶ πάντων ἁπλῶς καὶ περὶ τῶν φώτων (e cod. Paris. B.N. gr. 2327, fol. 264r)",
        "052": "Excerptum de cerussa (sine titulo) (e cod. Paris. B.N. gr. 2327, fol. 265)",
        "053": "Περὶ λευκώσεως (e cod. Paris. B.N. gr. 2327, fol. 265)",
        "054": "Ἑρμηνεία περὶ τῶν φώτων (e cod. Paris. B.N. gr. 2327, fol. 265v)",
        "055": "Περὶ αἰθαλῶν (e cod. Venet. Marc. 299, fol. 116v)",
        "056": "Excerptum alchemicum (sine titulo) (e codd. Venet. Marc. 299, fol. 186v, 192v",
        "057": "Περὶ του τριβίκου καὶ τοῦ σωλῆνος (e codd. Venet. Marc. 299, fol. 187r %186v, 194r",
        "058": "Excerptum alchemicum (sine titulo) (e cod. Venet. Marc. 299, fol. 186v % 187r, 195r)",
        "059": "Περὶ τοῦ θείου ὕδατος (e codd. Venet. Marc. 299, fol. 188r",
        "060": "Diagramma (e codd. Venet. Marc. 299, fol. 188v",
        "061": "Ζωσίμου περὶ ὀργάνων καὶ καμίνων (e codd. Venet. Marc. 299, fol. 186r, 195r % Paris. B.N. gr. 2327, fol",
        "062": "Περὶ τῆς ἐξατμίσεως τοῦ θείου ὕδατος τοῦ πήσσοντος τὴν ὑδράργυρον (e codd. Venet. Marc. 299, fol.",
        "063": "Περὶ τοῦ θείου ὕδατος (e codd. Venet. Marc. 299, fol. 113v",
        "064": "Ζωσίμου τοῦ θείου περὶ ἀρετῆς",
        "065": "Ζωσίμου πρᾶξις β",
        "066": "Ποίημα τοῦ Ζωσίμου (πρᾶξις γ",
        "067": "Ζώσιμος λέγει περὶ τῆς ἀσβέστου (e codd. Venet. Marc. 299, fol. 95r % Paris. B.N. gr. 2327, fol. 8r % ",
    },
    "4323": {"001": "Εὐγενίου "},
    "4324": {
        "001": "Συνεσίου φιλοσόφου πρὸς Διόσκορον εἰς τὴν βίβλον Δημοκρίτου, ὡς ἐν σχολίοις (e cod. Venet. Marc. "
    },
    "4325": {
        "001": "Aenigma (sine titulo) (e cod. Venet. Marc. 299, fol. 95)",
        "002": "Αἴνιγμα τοῦ φιλοσοφικοῦ λίθου Ἑρμοῦ καὶ Ἀγαθοδαίμονος (e cod. Paris. B.N. gr. 2327, fol. 234r)",
    },
    "4326": {"001": "Πάππου φιλοσόφου "},
    "4327": {
        "001": "Ἰωάννου ἀρχιερέως τοῦ ἐν Ἐβειγίᾳ περὶ τῆς θείας τέχνης (e cod. Paris. B.N. gr. 2327, fol. 243r)"
    },
    "4328": {
        "001": "Τοῦ Χριστιανοῦ περὶ εὐσταθείας τοῦ χρυσοῦ (e cod. Venet. Marc. 299, fol. 110r)",
        "002": "Τοῦ Χριστιανοῦ περὶ τοῦ θείου ὕδατος (e cod. Venet. Marc. 299, fol. 101r)",
        "003": "Τίς ἡ τῶν ἀρχαίων διαφωνία (e cod. Venet. Marc. 299, fol. 101v)",
        "004": "Τίς ἡ καθόλου τοῦ ὕδατος οἰκονομία (e cod. Venet. Marc. 299, fol. 102r)",
        "005": "Ἡ τοῦ μυθικοῦ ὕδατος ποίησις (e cod. Venet. Marc. 299, fol. 102r)",
        "006": "Ἀντίθεσις λέγουσα ὅτι τὸ θεῖον ὕδωρ ἕν ἐστι τῷ εἴδει καὶ ἡ λύσις αὐτῆς (e cod. Venet. Mar",
        "007": "Ἀπορία. Τὸ ἓν ἀβύσσαιον ὕδωρ ἐν τῷ ἀριθμῷ δεικνύειν ἐθέλουσα ἡ τούτου ἐπίλυσις (e cod. ",
        "008": "Τοῦ Χριστιανοῦ σύνοψις. τίς ἡ αἰτία τῆς προκειμένης συγγραφῆς (e cod. Venet. Marc. 299, fol. 121r)",
        "009": "Ὅτι τετραχῶς διαιρουμένης τῆς ὕλης, διάφοροι ἀπογίνονται τῶν ποιήσεων αἱ τάξεις (e cod. Venet. M",
        "010": "Πόσαι εἰσὶν αἱ κατ",
        "011": "Πῶς δεῖ νοεῖν διαφορὰς τῶν ποιήσεων καὶ σχήμασι γεωμετρικοῖς (e cod. Venet. Marc. 299, fol. 124r)",
        "012": "Τίς ἡ ἐν ἀποκρύφοις τῶν παλαιῶν ἐκδιδομένη τάξις (e cod. Venet. Marc. 299, fol. 124v)",
    },
    "4329": {
        "001": "Ἀνεπιγράφου φιλοσόφου περὶ θείου ὕδατος τῆς λευκώσεως (e cod. Venet. Marc. 299, fol. 78r)",
        "002": "Ἀνεπιγράφου φιλοσόφου κατὰ ἀκολουθίαν χρήσεως ἐμφαῖνον τὸ τῆς χρυσοποιίας συνεπτυγμένον σὺν θεῷ",
        "003": "Ἀνεπιγράφου φιλοσόφου περὶ τῆς θείας καὶ ἱερᾶς τέχνης φιλοσόφων (e codd. Venet. Marc. 299, fol. 181",
    },
    "4330": {
        "001": "Ἑρμηνεία τῆς ἐπιστήμης τῆς χρυσοποιίας ἱερομονάχου τοῦ Κοσμᾶ (e cod. Paris. B.N. gr. 2327, fol. 15"
    },
    "4331": {
        "001": "Ἱεροθέου περὶ τῆς ἱερᾶς τέχνης (e cod. Paris. B.N. gr. 2249, fol. 94r)"
    },
    "4332": {"001": "Ἱεροθέου φιλοσόφου περὶ τῆς θείας καὶ ἱερᾶς τέχνης διὰ στίχων "},
    "4333": {
        "001": "Νικηφόρου τοῦ Βλεμμύδου περὶ τῆς χρυσοποιίας (fort. auctore Nicephoro Blemmyde alio) (e cod. Paris. B.N",
        "002": "Ἅπερ χρῄζει ἡ παροῦσα κατασκευή (fort. auctore Nicephoro Blemmyde alio) (e cod. Paris. B.N. gr. 2509, f",
    },
    "4334": {
        "001": "Ἴσις προφῆτις τῷ υἱῷ Ωρῳ (redactio prima) (e cod. Paris. B.N. gr. 2327, fol. 256r)",
        "002": "Ἴσις προφῆτις τῷ υἱῷ Ωρῳ (redactio secunda) (e cod. Paris. B.N. gr. 2250, fol. 217r)",
    },
    "4335": {"001": "De ponderibus et mensuris"},
    "4337": {
        "001": "Ἡλιοδώρου φιλοσόφου πρὸς Θεοδόσιον τὸν μέγαν βασιλέα περὶ τῆς τῶν φιλοσόφων μυστικῆς τέχνης διὰ"
    },
    "4338": {
        "001": "Θεοφράστου φιλοσόφου περὶ τῆς θείας τέχνης διὰ στίχων ἰάμβων (fort. auctore Heliodoro alchemista et "
    },
    "4339": {
        "001": "Ἀρχελάου φιλοσόφου περὶ τῆς θείας τέχνης διὰ στίχων ἰάμβων (fort. auctore Heliodoro alchemista et p"
    },
    "4340": {"001": "Μέθοδος δι"},
    "4344": {"001": "Fragmenta"},
    "4345": {"001": "Fragmentum"},
    "4346": {"001": "Fragmenta"},
    "4347": {"001": "Fragmenta"},
    "4361": {"001": "De revolutionibus nativitatum"},
    "4374": {"001": "De astrologia dialogus ("},
    "4390": {"001": "Fragmenta"},
    "4391": {"001": "Fragmenta"},
    "4392": {"001": "Fragmentum"},
    "4393": {"001": "Fragmenta"},
    "4394": {"001": "Fragmenta"},
    "4395": {"001": "Fragmentum"},
    "4396": {"001": "Fragmenta"},
    "4397": {"001": "Fragmenta"},
    "5000": {
        "001": "Concilium universale Ephesenum anno 431",
        "002": "Concilium universale Ephesenum anno 431",
        "003": "Concilium universale Chalcedonense anno 451",
        "004": "Synodus Constantinopolitana et Hierosolymitana anno 536",
    },
    "5002": {
        "001": "Papyri magicae",
        "002": "Papyri magicae (fragmenta Christiana)",
        "003": "Papyri magicae (ostraca)",
        "004": "Papyri magicae (tabulae)",
    },
    "5003": {
        "001": "Metiochus et Parthenope (O. Bodl. 2.2175)",
        "002": "Metiochus et Parthenope (P. Berol. inv. 7927 % 9588 % 21179)",
        "003": "Metiochus et Parthenope (",
        "004": "Fragmentum (fort. auctore Antonio Diogene) (P. Mich. inv. 5)",
        "005": "Sesonchosis (P. Oxy 15.1826)",
        "006": "Sesonchosis (P. Oxy. 27.2466)",
        "007": "Sesonchosis (P. Oxy. 47.3319)",
        "008": "Calligone (PSI 8.981)",
        "009": "Antheia (fort. epitome operis Ephesiaca) (PSI 6.726)",
        "010": "Chione (fort. auctore Charitone) (codex Thebanus deperditus)",
        "011": "Fragmenta (fort. pars operis Chione vel Ninus) (P. Berol. 10535 % 21234)",
        "012": "Iolaus (P. Oxy. 42.3010)",
        "013": "Daulis (P. Berol. inv. 11517)",
        "014": "Apollonius (PSI 2.151)",
        "015": "Apollonius (P. Mil. Vogl. 6.260)",
        "016": "Tinouphis (P. Turner 8 [",
        "017": "Fragmentum (P. Oxy. 3.416)",
        "018": "Fragmentum (PSI 3.725)",
        "019": "Fragmentum (P. Mich. inv. 3378)",
        "020": "Staphylus (PSI 11.1220)",
        "021": "Theano (P. Oxy 3.417)",
        "022": "Fragmentum (PSI inv. 516)",
        "023": "Fragmenta (P. Michael. 4)",
        "024": "Fragmentum (P. Ant. 1.18)",
        "025": "Tefnut (P. Lit. Lond. 192 [Brit. Mus. inv. 274])",
    },
    "5004": {"001": "Epimerismi Homerici", "002": "Scholia-epimerismi ("},
    "5008": {"001": "Scholia in Aelium Aristidem (scholia vetera)"},
    "5009": {"001": "Scholia in Aeschinem (scholia vetera)"},
    "5010": {
        "001": "Scholia in Aeschylum (scholia vetera)",
        "002": "Scholia prototricliniana in Aeschylum (scholia recentiora)",
        "003": "Scholia in Aeschylum (scholia recentiora Demetrii Triclinii)",
        "004": "Scholia in Persas (scholia vetera)",
        "005": "Scholia in Prometheum vinctum (scholia vetera)",
        "006": "Scholia in Persas (scholia vetera et recentiora Thomae Magistri et Demetrii Triclinii)",
        "007": "Scholia in Prometheum vinctum (scholia recentiora Thomae Magistri et Demetrii Triclinii) (e cod. Neapol. II.F.31)",
        "008": "Scholia in Aeschylum (scholia recentiora)",
        "009": "Scholia et glossae in Persas (scholia vetera et recentiora Thomae Magistri et Demetrii Triclinii) (e cod. Laur. 3",
        "010": "Scholia in Persas (scholia vetera) (e cod. Mediceo 32.9)",
        "011": "Scholia de metris Aeschyli (scholia recentiora Demetrii Triclinii)",
        "012": "Argumentum in margine et glossae interlineariae ad Persas (glossae recentiores) (e codd. Vindob. 197",
        "013": "Scholia in Persas (scholia recentiora)",
        "014": "Catalogus in fabulas (e cod. Mediceo 32.9)",
        "015": "Scholia in Eumenides (scholia vetera et recentiora Demetrii Triclinii) (e cod. Neapol. II.F.31)",
    },
    "5012": {"001": "Scholia in Apollonii Rhodii Argonautica (scholia vetera)"},
    "5013": {
        "001": "Scholia in Aratum (scholia vetera)",
        "002": "Scholia in Aratum (scholia vetera) (P. Berol. 5865)",
        "003": "Scholia in Aratum (scholia vetera)",
        "004": "Scholia in Aratum (scholia vetera) (e codd. Palat. gr. 40 (P) % Paris gr. 2860)",
        "005": "Scholia in Aratum (scholia vetera) (e cod. Perusino A 35)",
        "006": "Scholia in Aratum (scholia vetera) (e cod. Paris gr. 2728)",
    },
    "5014": {
        "001": "Scholia in Acharnenses (scholia vetera et recentiora Triclinii)",
        "002": "Scholia in equites (scholia vetera et recentiora Triclinii)",
        "003": "Scholia in nubes (scholia vetera)",
        "004": "Scholia in nubes (scholia scholiorumque partes editionis Aldinae propria)",
        "005": "Scholia in nubes (scholia recentiora Eustathii, Thomae Magistri et Triclinii)",
        "006": "Scholia in nubes (scholia anonyma recentiora)",
        "007": "Scholia in vespas (scholia vetera, recentiora Tricliniana et Aldina)",
        "008": "Scholia in pacem (scholia vetera et recentiora Triclinii)",
        "009": "Scholia in aves (scholia vetera)",
        "010": "Scholia in Lysistratam (scholia vetera)",
        "011": "Scholia in Thesmophoriazusas (scholia vetera)",
        "012": "Scholia in ranas (scholia vetera)",
        "013": "Scholia in ecclesiazusas (scholia vetera)",
        "014": "Scholia in plutum (scholia vetera et fort. recentiora sub auctore Moschopulo)",
        "015": "Commentarium in plutum (recensio 1) (scholia recentiora Tzetzae)",
        "016": "Glossae in plutum (scholia recentiora Tzetzae)",
        "017": "Commentarium in nubes (scholia recentiora Tzetzae)",
        "018": "Commentarium in ranas (scholia recentiora Tzetzae)",
        "019": "Argumentum in equites (argumentum Tzetzianum)",
        "020": "Commentarium in aves (scholia vetera et recentiora Tzetzae)",
        "021": "Commentarium in plutum (recensio 2) (scholia recentiora Tzetzae)",
        "022": "Scholia in Acharnenses (scholia vetera) (P. Oxy. 6.856)",
        "023": "Commentarium in ranas (scholia recentiora Tzetzae) (cod. Ambrosianus gr. C 222 inf.)",
    },
    "5015": {
        "001": "Scholia in Aristotelis sophisticos elenchos (scholia recentiora) (e cod. Vat. Urb. gr. 35)",
        "002": "Scholia in Aristotelis sophisticos elenchos (scholia recentiora)",
        "003": "Scholia in Aristotelis ethica Nicomachea (scholia vetera et recentiora) (e cod. Paris. gr. 1854)",
    },
    "5016": {
        "001": "Scholia in Aetia i (scholia Florentina) (PSI 11.1219)",
        "002": "Scholia in Aetia i (scholia Londinensia) (P. Lit. Lond. 181 [",
        "003": "Scholia in Aetia i (commentarius Berolinensis) (P. Berol. 11521)",
        "004": "Scholia in Aetia (P. Berol. 11629 % P. Oxy. 18.2169",
        "005": "Scholia in Iambos (P. Oxy. 7.1011)",
        "006": "Scholia in Iambos (scholia Florentina) (PSI 9.1094)",
        "007": "Scholia in Lyrica (P. Berol. 13417)",
        "008": "Argumentum Hecalae (P. Oxy. 20.2258, olim inedita A, fr. 9)",
        "009": "Scholia in Epica et elegiaca minora (P. Oxy. 20.2258, olim inedita C, fr. 2)",
        "010": "Diegeseis in Aetia (scholia vetera)",
        "011": "Diegeseis in Iambos (scholia vetera)",
        "012": "Diegeseis in Lyrica (scholia vetera)",
        "013": "Diegeseis in Hecalam (scholia vetera)",
        "014": "Diegeseis in Hymnos i et ii (scholia vetera)",
        "015": "Diegeseis fabularum (P. Oxy. 20.2263)",
        "016": "Scholia in Hymnos (scholia vetera) (P. Oxy. 20.2258, olim inedita A, frr. 2, 4, 10)",
        "017": "Scholia in Hymnos ii et iii (scholia vetera) (P. Ant. 20)",
        "018": "Scholia in Hymnum iii (scholia vetera) (P. Cair. 47993b)",
        "019": "Scholia in Hymnum iii (scholia vetera) (P. Amh. 20)",
        "020": "Commentarius ad Aetia i (P. Oxy. 20.2262, olim inedita a, frr. 1-2)",
        "021": "Fragmenta scholiorum incertae sedis (P. Oxy. 20.2258, olim inedita, frr. 10-11)",
        "022": "Scholia in Hymnos (scholia vetera) (scholia ψ ex archetypo)",
    },
    "5017": {"001": "Scholia in Demosthenem (scholia vetera) (fort. auctore Ulpiano)"},
    "5018": {
        "001": "Scholia in Dionysii Byzantii per Bosporum navigationem (scholia recentiora)"
    },
    "5019": {
        "001": "Scholia in Dionysii periegetae orbis descriptionem (scholia vetera) (olim sub auctore Demetrio Lampsaceno)",
        "002": "Scholia in Dionysii periegetae orbis descriptionem (scholia vetera)",
    },
    "5021": {
        "001": "Scholia in Diophanti arithmetica (scholia recentiora e codd. Matr. Bibl. Nat. 4678"
    },
    "5022": {
        "001": "Scholia in Euclidis elementa (scholia vetera et recentiora)",
        "002": "Scholia in Euclidis data (scholia vetera)",
        "003": "Scholia in Euclidis optica (scholia vetera)",
        "004": "Scholia in opticorum recensionem Theonis (scholia vetera)",
        "005": "Scholia in Euclidis catoptrica (scholia vetera)",
        "006": "Scholia in Euclidis phaenomena (scholia vetera)",
        "007": "Scholia in Euclidis data et catoptrica (scholia vetera)",
    },
    "5023": {
        "001": "Scholia in Euripidem (scholia vetera)",
        "002": "Scholia in Euripidem (cod. Hierosolymitanus patriarchalis 36)",
        "003": "Glossae codicis Vaticani 909 in Euripidis Rhesum (scholia vetera)",
        "004": "Glossae codicis C in Euripidis Rhesum (scholia vetera)",
        "005": "Glossae in Euripidis Troiades (scholia vetera)",
    },
    "5024": {
        "001": "Prolegomena in librum περὶ στάσεων",
        "002": "Excerpta e prolegomenis in librum περὶ στάσεων (e cod. Paris. 3032, fol. 143r-149r)",
        "003": "Prolegomena in librum περὶ στάσεων",
        "004": "Introductio in prolegomena Hermogenis artis rhetoricae (fort. auctore Marcellino Gramm. et Rhet.)",
        "005": "Excerpta e prolegomenis in librum περὶ στάσεων (e cod. Paris. 3032, fol. 60r-62r)",
        "006": "Excerpta e prolegomenis diversis (e cod. Matr. 4687)",
        "007": "Prolegomena in librum περὶ στάσεων",
        "008": "Prolegomena in librum περὶ στάσεων",
        "009": "Prolegomena in artem rhetoricam",
        "010": "Prolegomena in artem rhetoricam (excerpta e codd. Marc. 430 % Vat. 900)",
        "011": "Prolegomena in artem rhetoricam (excerpta e codd. Paris. 1983 % 2977)",
        "012": "Prolegomena in librum περὶ ἰδεῶν",
        "013": "Περὶ τῆς τάξεως τῶν ἰδεῶν",
        "014": "Prolegomena in librum περὶ ἰδεῶν (fragmentum e cod. Ambros. 523)",
        "015": "Prolegomena in librum περὶ στάσεων",
        "016": "Prolegomena in librum περὶ εὑρέσεως",
        "017": "Commentarium in librum περὶ στάσεων",
        "018": "Commentarium in librum περὶ εὑρέσεως",
        "019": "Commentarium in librum περὶ ἰδεῶν",
        "020": "De figuris in libris περὶ εὑρέσεων et περὶ ἰδεῶν",
        "021": "Synopses artis rhetoricae (excerpta)",
    },
    "5025": {
        "001": "Scholia in opera et dies (scholia vetera)",
        "002": "Scholia in opera et dies (scholia vetera partim Procli et recentiora partim Moschopuli, Tzetzae et Joannis Galeni",
        "003": "Scholia in theogoniam (scholia vetera)",
        "004": "Glossae in theogoniam",
    },
    "5026": {
        "001": "Scholia in Iliadem (scholia vetera)",
        "002": "Scholia in Iliadem (scholia vetera et recentiora e cod. Genevensi gr. 44)",
        "003": "Scholia in Iliadem (scholia recentiora Theodori Meliteniotis) (e cod. Genevensi gr. 44)",
        "004": "Scholia in Odysseam (scholia vetera)",
        "005": "Scholia in Odysseam 1.1-309 (scholia vetera)",
        "006": "Inscriptiones et hypothesis in Odysseam",
        "007": "Hypotheses in Iliadem (e D scholiis)",
        "008": "Scholia in Iliadem (scholia vetera) (",
    },
    "5027": {
        "001": "Scholia in librum Iamblichi in Nicomachi arithmeticam introductionem (scholia vetera et recentiora)"
    },
    "5028": {"001": "Scholia in Isocratem (scholia vetera)"},
    "5029": {
        "001": "Scholia in Lucianum (scholia vetera et recentiora Arethae)",
        "002": "Scholia in Pseudo-Luciani Halcyonem (scholia vetera)",
    },
    "5030": {
        "001": "Scholia in Lycophronem (scholia vetera et recentiora partim Isaac et Joannis Tzetzae)"
    },
    "5031": {
        "001": "Scholia et glossae in Nicandri theriaca (scholia vetera et recentiora)",
        "002": "Scholia et glossae in Nicandri alexipharmaca (scholia vetera et recentiora)",
    },
    "5032": {
        "001": "Scholia et glossae in cynegetica (scholia vetera et recentiora)",
        "002": "Scholia et glossae in halieutica (scholia vetera et recentiora)",
    },
    "5033": {
        "001": "Scholia in Pausaniae periegesin (scholia vetera sub auctore Agathia)"
    },
    "5034": {
        "001": "Scholia in Pindarum (scholia vetera)",
        "002": "Capitula ad praefationem scholiorum ad Pindari carmina",
        "003": "Scholia in Pythia v-vii (scholia vetera et recentiora Thomae Magistri et Triclinii) (e cod. Flor.)",
        "004": "Scholia et glossae in Olympia et Pythia (scholia recentiora Triclinii, Thomae Magistri, Moschopuli, Germani) (col",
        "005": "Scholia in Pindarum (scholia vetera et recentiora partim Thomae Magistri et Alexandri Phortii) (e cod. Patm.)",
        "006": "Scholia in paeanes (scholia vetera) (P. Oxy. 5.841)",
        "007": "Scholia in Nemea et Isthmia (scholia vetera et recentiora partim Thomae Magistri et Triclinii)",
    },
    "5035": {
        "001": "Scholia in Platonem (scholia vetera)",
        "002": "Scholia in Platonem (scholia recentiora Arethae)",
    },
    "5037": {
        "001": "Scholia in Sophoclis Ajacem (scholia vetera)",
        "002": "Scholia et glossae in Sophoclis Ajacem (glossae et scholia recentiora)",
        "003": "Argumenta et excerpta interpretationum allegoricarum in Sophoclis Ajacem",
        "004": "Scholia in Sophoclem (scholia vetera)",
        "005": "Scholia in Sophoclis Oedipum tyrannum (scholia recentiora)",
        "006": "Scholia in Sophoclis Oedipum Coloneum (scholia vetera)",
    },
    "5038": {"001": "Scholia in Theocritum (scholia vetera)"},
    "5039": {"001": "Scholia in Thucydidem (scholia vetera et recentiora)"},
    "5040": {"001": "Scholia in anabasin Cyri (scholia vetera)"},
    "5045": {
        "001": "Prolegomena in progymnasmata",
        "002": "Incerti auctoris prolegomena in progymnasmata (olim sub auctore Joanne Doxapatre)",
    },
    "5046": {"001": "Scholia in progymnasmata (scholia recentiora)"},
    "5048": {
        "001": "Scholia in protrepticum et paedagogum (scholia recentiora partim sub auctore Aretha)"
    },
    "5052": {"001": "Scholia"},
    "7000": {"001": "Anthologia Graeca"},
    "7051": {
        "001": "Doctrina patrum (fort. auctore Anastasio Sinaïta vel Anastasio Apocrisiario)"
    },
    "7052": {
        "001": "Epigrammata dedicatoria",
        "002": "Epigrammata sepulcralia",
        "003": "Epigrammata demonstrativa",
        "004": "Epigrammata exhortatoria et supplicatoria",
        "005": "Epigrammata irrisoria",
        "006": "Oracula",
        "007": "Problemata et aenigmata",
        "008": "Epigrammatis addenda",
    },
    "9003": {"001": "Fragmenta quattuor apud Eustathium"},
    "9004": {"001": "Anonymi in analyticorum posteriorum librum alterum commentarium"},
    "9006": {
        "001": "Paroemiae",
        "002": "Paroemiae (e cod. Leidense)",
        "003": "Paroemiae (e cod. Mosq.)",
        "004": "Paroemiae (e cod. Vat.)",
    },
    "9007": {"001": "Appendix proverbiorum"},
    "9008": {"001": "Paroemiae"},
    "9009": {"001": "Collectio paroemiarum"},
    "9010": {"001": "Lexicon", "002": "Onomasticon tacticon"},
    "9012": {"001": "Vita Nicephori"},
    "9018": {"001": "Apophthegmata"},
    "9019": {"001": "In Aristotelis librum de interpretatione commentarium"},
    "9020": {"001": "In artem rhetoricam commentaria"},
    "9021": {
        "001": "De magna et sacra arte (sub nomine Stephani Alexandrini philosophi)"
    },
    "9022": {
        "001": "Prolegomena de comoedia Aristophanis",
        "002": "Versus de poematum generibus",
        "003": "De Pleiadibus (excerptum)",
    },
    "9023": {
        "001": "Ecloga nominum et verborum Atticorum",
        "002": "Poemata de Arato [Dub.]",
    },
}
