/*
 * Copyright 2017-2021 Cloudopt
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.cloudopt.next.auth.bean

/**
 * Used to record verification rules.
 * @property name rule's name
 * @property url path of network request access
 * @property method metho of network request access, maybe GET or POST...
 * @property allow Whether to allow network requests to pass
 * @constructor
 */
data class Rule(
    var name: String = "",
    var url: String = "",
    var method: String = "",
    var allow: Boolean = true
)