import type { Metadata } from 'next';
import { headers } from 'next/headers';

export const metadata: Metadata = {
	title: 'Create Next App',
	description: 'Generated by create next app',
};

export default function RootLayout({
	children,
}: Readonly<{
	children: React.ReactNode;
}>) {
	const headerFromMiddleware = headers().get('X-header-from-middleware');

	return (
		<html layout-attr-header-from-middleware={headerFromMiddleware}>
			<body>{children}</body>
		</html>
	);
}
