---
draft: false
date: 2023-09-20
search:
  exclude: true
authors:
  - fkorotkov
categories:
  - announcement
---

# Tart 2.0.0 and community updates

Today we'd like to share some news and updates around the Tart ecosystem since the Tart 1.0.0 release back in February.

<!-- more -->

## Community Growth

In the last 7 months Tart community almost tripled and growth is continuing to accelerate. Tart just crossed 25,000 installations,
dozens of companies that we know of are using Tart in their daily workflows. If your company is not in the list please consider
[joining](https://github.com/cirruslabs/tart/blob/main/Resources/Users/HowToAddYourself.md)!

<div class="grid cards" markdown>

- ![](https://github.com/cirruslabs/tart/raw/main/Resources/Users/Krisp.png){ height="65" }
- ![](https://github.com/cirruslabs/tart/raw/main/Resources/Users/Mullvad.png){ height="65" }
- ![](https://github.com/cirruslabs/tart/raw/main/Resources/Users/ahrefs.png){ height="65" }
- ![](https://github.com/cirruslabs/tart/raw/main/Resources/Users/Suran.png){ height="65" }
- ![](https://github.com/cirruslabs/tart/raw/main/Resources/Users/Symflower.png){ height="65" }
- ![](https://github.com/cirruslabs/tart/raw/main/Resources/Users/Transloadit.png){ height="65" }
- ![](https://github.com/cirruslabs/tart/raw/main/Resources/Users/PITSGlobalDataRecoveryServices.png){ height="65" }
- ![](https://github.com/cirruslabs/tart/raw/main/Resources/Users/Uphold.png){ height="65" }

</div>

We are also very pleased by how the community responded to [the license change](2023-02-11-changing-tart-license.md).
We now have a number of companies running Tart at scale under the new license. Revenue from the licensing allowed us to
allocate time to continue improving Tart which brings us to the section below.

## Recent updates and what's changing in Tart 2.0.0

In the last 7 months we've had 12 feature releases that brought a lot of features requested by the community. Here are just
a few of them to highlight:

-[Custom GitLab Runner Executor](/integrations/gitlab-runner/).
-[Cluster Management via Orchard](2023-04-25-orchard-ga.md).
-Numerous compatibility improvements for all kinds of OCI-registries.
-Sonoma Support (see details [below](#macos-sonoma-updates)).

But one of the most requested features/complaints was around pulling huge Tart images from remote OCI-compatible registries.
With an ideal network conditions `tart pull` worked pretty good but in case of any network issues it was required to
restart the pull from scratch. Additionally, some registries are notably slow streaming a single blob but can stream
multiple blobs in parallel. Finally, the initial format of storing Tart VMs was very naive: disk image is compressed
via a single stream which is chunked up into blobs that are serially uploaded to a registry. A single compression stream
means that Tart can also only decompress blobs serially.

Given these three observations above we came up with an improved format of storing Tart VM disk images. In Tart 2.0.0
disk images are chunked up first and compressed independently into blobs, when pushed, each blob has attached annotations
of expected uncompressed size and a checksum. This way when Tart 2.0.0 is pulling an image pushed by Tart 2.0.0 each blob can
be pulled, uncompressed and written at the right offset independently. Having checksums along expected uncompressed blob size
also allowed to support resumable pulls. Upon a failure Tart 2.0.0 will compare checksums of chunks and will continue pulling
only missing blobs.

Overall in our experiments we saw a 10% improvement in compressed size of the images and **4 times faster pulls**.

In order to try the new image format please upgrade Tart and try to pull any of [the Sonoma images](https://github.com/orgs/cirruslabs/packages?tab=packages&q=macos-sonoma):

```bash
brew upgrade cirruslabs/cli/tart
tart pull ghcr.io/cirruslabs/macos-sonoma-base:latest
```

## macOS Sonoma Updates

Tart VMs now can be run in a "suspendable" mode which will enable VM snapshotting instead of the standard shutdown.
VMs with an existing snapshot will `run` from the same state as they got snapshotted. Please check demo down below:

<div>
    <blockquote class="twitter-tweet" data-theme="dark">
      <p lang="en" dir="ltr">
        Tart 1.8.0 brings macOS Sonoma updates! 🍏 Now you can suspend and resume your virtual machines for even faster startup times. Check out the demo below 👇 <a href="https://t.co/RoRFT8Nwst">pic.twitter.com/RoRFT8Nwst</a>
      </p>&mdash; Cirrus Labs (@cirrus_labs) <a href="https://twitter.com/cirrus_labs/status/1677308360385765382?ref_src=twsrc%5Etfw">July 7, 2023</a>
    </blockquote> 
    <script src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
</div>

There are two caveats to the "suspendable" mode support:

1. Both host and guest should be running macOS Sonoma.
2. Snapshots are locally encrypted and can't be shared between physical hosts. Therefore `tart push` won't push the corresponding snapshotted state of the VM.

Try the "suspendable" mode for yourself by passing `--suspendable` flag to a `tart run` command:

```bash
tart clone ghcr.io/cirruslabs/macos-sonoma-base:latest sonoma-base
tart run --suspendable sonoma-base
```

## Conclusion

We are very excited about this major release of Tart. Please give it a try and let us know how it went!

Stay tuned for new updates and announcements! There are a few coming up very shortly...
