# Contributing to Juggler

Juggler is an open source project.

It is the work of contributors. We appreciate your help!

## Before filing an issue

If you are unsure whether you have found a bug or a new feature request, please consider getting as many evidences (images, screenshots, logs and etc) as possible and directly ask the maintainers.

## Filing issues

If you are sure that you have found a bug or a possible new feature, submit an issue.

### Filing feature requests
The recommended way to file for a feature request is by creating a Github issue answering these three questions:

1. What is the purpose of this feature?
2. What are the expected behaviors of it?
3. What are the test conditions to validate it?


### Filing bugs
The recommended way to file an issue is by creating a Github issue answering these five questions:

1. What version of juggler are you using (`juggler version`)?
2. What operating system and processor architecture are you using?
3. What did you do?
4. What did you expect to see?
5. What did you see instead?


## Contributing code

Please read the website [Effective Go](https://golang.org/doc/effective_go.html) before sending patches.

Unless otherwise noted, the Juggler source files are distributed under
the MIT-style license found in the LICENSE file.

## How to write code

We recommend using https://www.conventionalcommits.org/ for the commit messages.

Remember to reference the issue you are working on your commit messages, like git commit -a -m "[#5] <your_commit_message>."