#### 内核抢占点 

调度本质上体现了对CPU资源的抢占。对于用户进程而言，由于有中断的产生，可以随时打断用户进程的执行，转到操作系统内部，从而给了操作系统以调度控制权，让操作系统可以根据具体情况（比如用户进程时间片已经用完了）选择其他用户进程执行。这体现了用户进程的可抢占性（preemptive）。但如果把ucore操作系统也看成是一个特殊的内核进程或多个内核线程的集合，那ucore是否也是可抢占的呢？其实ucore内核执行是不可抢占的（non-preemptive），即在执行“任意”内核代码时，CPU控制权可被强制剥夺。这里需要注意，不是在所有情况下ucore内核执行都是不可抢占的，有以下几种“固定”情况是例外：

1. 进行同步互斥操作，比如争抢一个信号量、锁（lab7中会详细分析）；     
2. 进行磁盘读写等耗时的异步操作，由于等待完成的耗时太长，ucore会调用shcedule让其他就绪进程执行。

这几种情况其实都是由于当前进程所需的某个资源（也可称为事件）无法得到满足，无法继续执行下去，从而不得不主动放弃对CPU的控制权。如果参照用户进程任何位置都可被内核打断并放弃CPU控制权的情况，这些在内核中放弃CPU控制权的执行地点是“固定”而不是“任意”的，不能体现内核任意位置都可抢占性的特点。我们搜寻一下实验五的代码，可发现在如下几处地方调用了shedule函数：

表一：调用进程调度函数schedule的位置和原因

<table>
<tr><td>编号</td><td>位置</td><td>原因</td></tr>
<tr><td>1</td><td>proc.c::do_exit</td><td>用户线程执行结束，主动放弃CPU控制权。</td></tr>
<tr><td>2</td><td>proc.c::do_wait</td><td>用户线程等待子进程结束，主动放弃CPU控制权。</td></tr>
<tr><td>3</td><td>proc.c::init_main</td><td>1.  initproc内核线程等待所有用户进程结束，如果没有结束，就主动放弃CPU控制权;
2.  initproc内核线程在所有用户进程结束后，让kswapd内核线程执行10次，用于回收空闲内存资源</td></tr>
<tr><td>4</td><td>proc.c::cpu_idle</td><td>idleproc内核线程的工作就是等待有处于就绪态的进程或线程，如果有就调用schedule函数</td></tr>
<tr><td>5</td><td>sync.h::lock</td><td>在获取锁的过程中，如果无法得到锁，则主动放弃CPU控制权</td></tr>
<tr><td>6</td><td>trap.c::trap</td><td>如果在当前进程在用户态被打断去，且当前进程控制块的成员变量need_resched设置为1，则当前线程会放弃CPU控制权</td></tr>
</table>

仔细分析上述位置，第1、2、5处的执行位置体现了由于获取某种资源一时等不到满足、进程要退出、进程要睡眠等原因而不得不主动放弃CPU。第3、4处的执行位置比较特殊，initproc内核线程等待用户进程结束而执行schedule函数；idle内核线程在没有进程处于就绪态时才执行，一旦有了就绪态的进程，它将执行schedule函数完成进程调度。这里只有第6处的位置比较特殊：

```
if (!in_kernel) {
	……

	if (current->need_resched) {
		schedule();
	}
}
```

这里表明了只有当进程在用户态执行到“任意”某处用户代码位置时发生了中断，且当前进程控制块成员变量need\_resched为1（表示需要调度了）时，才会执行shedule函数。这实际上体现了对用户进程的可抢占性。如果没有第一行的if语句，那么就可以体现对内核代码的可抢占性。但如果要把这一行if语句去掉，我们就不得不实现对ucore中的所有全局变量的互斥访问操作，以防止所谓的racecondition现象，这样ucore的实现复杂度会增加不少。
