#### 硬盘访问概述

bootloader让CPU进入保护模式后，下一步的工作就是从硬盘上加载并运行OS。考虑到实现的简单性，bootloader的访问硬盘都是LBA模式的PIO（Program IO）方式，即所有的IO操作是通过CPU访问硬盘的IO地址寄存器完成。

一般主板有2个IDE通道，每个通道可以接2个IDE硬盘。访问第一个硬盘的扇区可设置IO地址寄存器0x1f0-0x1f7实现的，具体参数见下表。一般第一个IDE通道通过访问IO地址0x1f0-0x1f7来实现，第二个IDE通道通过访问0x170-0x17f实现。每个通道的主从盘的选择通过第6个IO偏移地址寄存器来设置。

表一 磁盘IO地址和对应功能
<table>
<tr><td>IO地址</td><td>功能</td></tr>
<tr><td>0x1f0</td><td>读数据，当0x1f7不为忙状态时，可以读。</td></tr>
<tr><td>0x1f2</td><td>要读写的扇区数，每次读写前，你需要表明你要读写几个扇区。最小是1个扇区</td></tr>
<tr><td>0x1f3</td><td>如果是LBA模式，就是LBA参数的0-7位</td></tr>
<tr><td>0x1f4</td><td>如果是LBA模式，就是LBA参数的8-15位</td></tr>
<tr><td>0x1f5</td><td>如果是LBA模式，就是LBA参数的16-23位</td></tr>
<tr><td>0x1f6</td><td>第0~3位：如果是LBA模式就是24-27位     第4位：为0主盘；为1从盘</td></tr>
第6位：为1=LBA模式；0 = CHS模式        第7位和第5位必须为1</td></tr>
<tr><td>0x1f7</td><td>状态和命令寄存器。操作时先给命令，再读取，如果不是忙状态就从0x1f0端口读数据</td></tr>
</table>

当前 硬盘数据是储存到硬盘扇区中，一个扇区大小为512字节。读一个扇区的流程（可参看boot/bootmain.c中的readsect函数实现）大致如下：

1. 等待磁盘准备好
2. 发出读取扇区的命令
3. 等待磁盘准备好
4. 把磁盘扇区数据读到指定内存
