
###### 编译简单的 C 程序

C 语言经典的入门例子是 Hello World，下面是一示例代码： 

	#include <stdio.h>
	int
	main(void)
	{
		printf("Hello, world!\n");
		return 0;
	}
 
我们假定该代码存为文件‘hello.c’。要用 gcc 编译该文件，使用下面的命令： 

	$ gcc -Wall hello.c -o hello

该命令将文件‘hello.c’中的代码编译为机器码并存储在可执行文件 ‘hello’中。机器码的文件名是通过 -o 选项指定的。该选项通常作为命令行中的最后一个参数。如果被省略，输出文件默认为 ‘a.out’。 

注意到如果当前目录中与可执行文件重名的文件已经存在，它将被复盖。 
选项 -Wall 开启编译器几乎所有常用的警告──**强烈建议你始终使用该选项**。编译器有很多其他的警告选项，但 -Wall 是最常用的。默认情况下GCC 不会产生任何警告信息。当编写 C 或 C++ 程序时编译器警告非常有助于检测程序存在的问题。 

本例中，编译器使用了 -Wall 选项而没产生任何警告，因为示例程序是完全合法的。 

要运行该程序，输入可执行文件的路径如下： 

	$ ./hello
	Hello, world!

这将可执行文件载入内存，并使 CPU 开始执行其包含的指令。 路径 ./ 指代当前目录，因此 ./hello 载入并执行当前目录下的可执行文件 ‘hello’。 
