<?php

use Cartalyst\Sentry\Users\Eloquent\User as SentryUserModel;
use Cartalyst\Sentry\Users\ProviderInterface as SentryInterfaceProvider;
class User extends SentryUserModel  {

	/**
	 * Indicates if the model should soft delete.
	 *
	 * @var bool
	 */

	public function __construct()
	{
		parent::__construct();
		
	}
	//protected $softDelete = true;

	/**
	 * Returns the user full name, it simply concatenates
	 * the user first and last name.
	 *
	 * @return string
	 */
	public function fullName()
	{
		return "{$this->first_name} {$this->last_name}";
	}

	/**
	 * Returns the user Gravatar image url.
	 *
	 * @return string
	 */
	public function gravatar()
	{
		// Generate the Gravatar hash
		$gravatar = md5(strtolower(trim($this->gravatar)));

		// Return the Gravatar url
		return "//gravatar.org/avatar/{$gravatar}";
	}

	public function tasks()
	{
		return $this->belongsToMany('Task','task_user')->withPivot('task_id');
	}
	
	public function events()
	{
		return $this->belongsToMany('Events','event_user')->withPivot('events_id');
	}

}
