# Contributing

We love contributors! Your help is welcome to make this project better!

Some simple guidelines we'd like you to follow.

## Got Questions or Problems?

If you have questions about http-proxy-middle usage; Please check if your question hasn't been already answered on [Stack Overflow](http://stackoverflow.com/search?q=%22http-proxy-middleware%22) or in our [issue archive](https://github.com/chimurai/http-proxy-middleware/issues?utf8=%E2%9C%93&q=is%3Aissue+), [examples](https://github.com/chimurai/http-proxy-middleware/tree/master/examples) and [recipes](https://github.com/chimurai/http-proxy-middleware/tree/master/recipes).

Since Nodejitsu's `http-proxy` is providing the actual proxy functionality; You might find your answer in their [documentation](https://github.com/nodejitsu/node-http-proxy), [issue archive](https://github.com/nodejitsu/node-http-proxy/issues?utf8=%E2%9C%93&q=is%3Aissue) or [examples](https://github.com/nodejitsu/node-http-proxy/tree/master/examples).

## Report Issues

If you think you've found an issue, please submit it to the [Github issue tracker](https://github.com/chimurai/http-proxy-middleware/issues).

"_[It doesn't work](https://goo.gl/GzkkTg)_" is not very useful for anyone.
A good issue report should have a well described **problem description** and proxy **configuration**. A great issue report includes a **minimal example**.

Properly format your code example for easier reading: [Code and Syntax Highlighting](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet#code-and-syntax-highlighting).

The quality of your issue report will determine how quickly and deeply we'll delve into it. Some simple pointers for reporting an issue:

#### Problem Description

- describe the problem
- steps taken (request urls)
- found
- expected

#### Configuration / Setup

- http-proxy-middleware version
- http-proxy-middleware configuration

It might be useful to provide server information in which http-proxy-middleware is used and the target server information to which requests are being proxied.

- server + version (express, connect, browser-sync, etc...)
  - server port number
- target server
  - target server port number

### Minimal example

Provide a minimal example to exclude external factors. This will greatly help identifying the issue.

Tips on how to create a minimal example: http://stackoverflow.com/help/mcve

## New Feature?

Request a new feature by submitting an issue into our [Github issue tracker](https://github.com/chimurai/http-proxy-middleware/issues).

PRs are welcome. Please discuss it in our [Github issue tracker](https://github.com/chimurai/http-proxy-middleware/issues) before you start working on it, to avoid wasting your time and effort in case we are already (planning to) working on it.

## Documentation

Feel free to send PRs to improve the documentation, [examples](https://github.com/chimurai/http-proxy-middleware/tree/master/examples) and [recipes](https://github.com/chimurai/http-proxy-middleware/tree/master/recipes).
