/**
 * (Geometry: n-sided regular polygon) In an n-sided regular polygon, all sides
 * have the same length and all angles have the same degree (i.e., the polygon is
 * both equilateral and equiangular). Design a class named RegularPolygon that
 * contains:
 * 
 * ■ A private int data field named n that defines the number of sides in the polygon
 * with default value 3.
 * ■ A private double data field named side that stores the length of the side with
 * default value 1.
 * ■ A private double data field named x that defines the x-coordinate of the polygon’s
 * center with default value 0.
 * ■ A private double data field named y that defines the y-coordinate of the polygon’s
 * center with default value 0.
 * ■ A no-arg constructor that creates a regular polygon with default values.
 * ■ A constructor that creates a regular polygon with the specified number of sides
 * and length of side, centered at (0, 0).
 * ■ A constructor that creates a regular polygon with the specified number of sides,
 * length of side, and x- and y-coordinates.
 * ■ The accessor and mutator methods for all data fields.
 * ■ The method getPerimeter() that returns the perimeter of the polygon.
 * ■ The method getArea() that returns the area of the polygon. The formula for
 * 
 * computing the area of a regular polygon is Area = (n x s^2) / (4 x tan(PI / n))
 *
 * Draw the UML diagram for the class and then implement the class. Write a test
 * program that creates three RegularPolygon objects, created using the no-arg
 * constructor, using RegularPolygon(6, 4), and using RegularPolygon(10,
 * 4, 5.6, 7.8). For each object, display its perimeter and area.
 * 
 * Author: chill4Eng2Dev 
 * Date: 1/28/2021
 * Book: Introduction to Java Programming, 10th Edition, Y. Daniel Liang
 * Exercise: 9.9
 */

public class EX09_TestRegularPolygon {
    
    public static void main(String[] args) {
        
        // default regular polygon object
        RegularPolygon regPoly1 = new RegularPolygon();
        System.out.println("\nRegularPolygon 1 with No-Arg Constructor:");
        System.out.printf("Perimeter: \t%-3.2f\nArea:    \t%-3.2f\n", regPoly1.getPerimeter(), regPoly1.getArea());
        
        // user defined sides and lengths regular polygon object
        RegularPolygon regPoly2 = new RegularPolygon(6, 4);        
        System.out.println("\nRegularPolygon 2 with N and Side Constructor:");
        System.out.printf("Perimeter: \t%-3.2f\nArea:    \t%-3.2f\n", regPoly2.getPerimeter(), regPoly2.getArea());
        
        // user defined sides, lengths, x-, y-coordinates regular polygon object
        RegularPolygon regPoly3 = new RegularPolygon(10, 4, 5.6, 7.8);
        System.out.println("\nRegularPolygon 3 with N, Side, X, and Y Constructor:");
        System.out.printf("Perimeter: \t%-3.2f\nArea:    \t%-3.2f\n", regPoly3.getPerimeter(), regPoly3.getArea());

    }

}
