
const getBody = (xhr) => {
  const text = xhr.responseText || xhr.response;

  if (!text) return text;

  try {
    return JSON.parse(text)
  } catch (e) {
    return text
  }
};

const getError = (action, option, xhr) => {
  const msg = `fail to post ${action} ${xhr.status}`;
  const err = new Error(msg);
  err.status = xhr.status;
  err.method = 'post';
  err.url = action;
  return err;
};

const uploadAjax = (option) => {
  if (typeof XMLHttpRequest === 'undefined') {
    return
  }

  const xhr = new XMLHttpRequest();
  const action = option.action;

  if (xhr.upload) {
    xhr.upload.onprogress = function progress(e) {
      if (e.total > 0) {
        e.percent = e.loaded / e.total * 100
      }
      option.onProgress(e);
    }
  }

  const formData = new FormData();

  if (option.data) {
    Object.keys(option.data).map(key => {
      formData.append(key, option.data[key])
    })
  }

  formData.append(option.filename, option.file);

  xhr.onerror = function error(e) {
    option.onError(e)
  };

  xhr.onload = function onload() {
    if (xhr.status < 200 || xhr.status >= 300) {
      return option.onError(getError(action, option, xhr), getBody(xhr));
    }
    option.onSuccess(getBody(xhr));
  };

  xhr.open('post', action, true);

  const headers = option.headers || {};

  // eslint-disable-next-line no-unused-vars
  for (const item in headers) {
    if (headers.hasOwnProperty(item) && headers[item] !== null) {
      xhr.setRequestHeader(item, headers[item])
    }
  }

  xhr.send(formData);
};

export default uploadAjax
