# 国际化

`monkey-view`内部默认使用中文语言。如果需要使用其他语言，可以进行语言配置。下面以使用英文为例：

## webpack中使用

完整引入

```javascript
import Vue from 'vue'
import MonkeyView from 'monkey-view'
import locale from 'monkey-view/dist/locale/en-US'

Vue.use(MonkeyView, { locale })
```

按需引入

```javascript
import Vue from 'vue';
import { locale, Page } from 'monkey-view';
import lang from 'monkey-view/dist/locale/en-US'

// configure language
locale(lang);

// import components
Vue.component('Page', Page);
```

兼容 vue-i18n@6.x+

```javascript
import Vue from 'vue';
import MonkeyView from 'monkey-view';
import VueI18n from 'vue-i18n';
import en from 'monkey-view/dist/locale/en-US';
import zh from 'monkey-view/dist/locale/zh-CN';

Vue.use(VueI18n);
Vue.use(MonkeyView);
Vue.locale = () => {};

const messages = {
    en: Object.assign({ message: 'hello' }, en),
    zh: Object.assign({ message: '你好' }, zh)
};

const i18n = new VueI18n({
    locale: 'en',
    messages
});

new Vue({ i18n }).$mount('#app');
```

兼容 vue-i18n@5.x

```javascript
import Vue from 'vue';
import MonkeyView from 'monkey-view';
import VueI18n from 'vue-i18n';
import en from 'monkey-view/dist/locale/en-US';
import zh from 'monkey-view/dist/locale/zh-CN';

Vue.use(VueI18n);
Vue.use(MonkeyView);

Vue.config.lang = 'en-US';
Vue.locale('en-US', en);
Vue.locale('zh-CN', zh);
```

## CDN 的方式使用


```html
<script src="//unpkg.com/vue"></script>
<script src="//unpkg.com/monkey-view/dist/monkey-view.min.js"></script>
<script src="//unpkg.com/monkey-view/dist/locale/en-US.js"></script>

<script>
    MONKEY.locale(MONKEY.langs['en-US'])
</script>
```

## 支持的语言

目前`monkey-view`支持一下语言：

- 简体中文(zh-CN)
- 英文(en-US)
- 繁体中文(zh-TW)

欢迎贡献代码，以支持更多语言。只需在 <a href="https://github.com/chengllNice/monkey-view/tree/master/src/locale/lang" target="_blank">这里</a> 添加一个语言配置文件即可。
