<?php
/**
 * The router file of chanzhiEPS.
 *
 * @copyright   Copyright 2009-2015 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZPLV12 (http://zpl.pub/page/zplv12.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     chanzhiEPS
 * @version     $Id$
 * @link        http://www.zsite.com
 */
/* Turn off error reporting first. */
error_reporting(0);

/* Start output buffer. */
ob_start();

/* Define the run mode as front. */
define('RUN_MODE', 'front');
define('IS_WMP', TRUE);

/* Load the framework. */
include 'loader.php';

/* Instance the app and run it. */
$app = router::createApp('chanzhi', $systemRoot);
$config = $app->config;

/* Connect to db, load module. */
$common = $app->loadCommon();
$common->checkDomain();

/* Check the reqeust is getconfig or not. Check installed or not. */
if(isset($_GET['mode']) and $_GET['mode'] == 'getconfig') die($app->exportConfig());
if(!isset($config->installed) or !$config->installed) die(header('location: install.php'));

/* Check site status. */
if($app->config->site->status == 'pause')
{
    die("<div style='text-align:center'>" . htmlspecialchars_decode($app->config->site->pauseTip, ENT_QUOTES) . '</div>');
}

$app->setClientDevice('mobile');
$common->checkWMP();
$common->InitWMP();

unset($_POST['wmpOpenID']);
unset($_POST['wmpToken']);

$config->requestType = 'GET';
$_GET['t'] = 'json';
//$_POST['t'] = 'json';
$app->parseRequest();

ob_start();
$common->checkPriv();
$app->loadModule();
$content = ob_get_flush();
ob_clean();

$response = json_decode($content);

$moduleName = $app->getModuleName();
$methodName = $app->getMethodName();

if(!is_object($response->data)) $response->data = json_decode($response->data);

if(!empty($response->data->videos))
{
    $count = 0;
    $videos = new stdclass();
    foreach($response->data->videos as $video)
    {
        $count ++;
        $videos->$count = $video;
    }
    $response->data->videos = $videos;
}

$response->status  = is_object($response->data) ? 'success' : 'fail';
$response->company = $config->company;
$response->site    = $config->site;
$response->layouts = $common->loadModel('block')->getWmpLayouts($moduleName, $methodName);

die(json_encode($response));
