{*php
/**
 * The view view file of form module of chanzhiEPS.
 *
 * @copyright   Copyright 2009-2017 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZPL (http://zpl.pub/form/zplv12.html)
 * @author      Gang Liu <liugang@cnezsoft.com>
 * @package     form 
 * @version     $Id$
 * @link        http://www.chanzhi.org
 */
/php*}
{if(!empty($form->fullScreen))}
  {include $control->loadModel('ui')->getEffectViewFile('mobile', 'common', 'header')}
{else}
  {include $control->loadModel('ui')->getEffectViewFile('mobile', 'common', 'header')}
{/if}
{!js::set('formLayout', $control->block->getLayoutScope('form_view', $formID))}
{include TPL_ROOT . 'common/chosen.html.php'}
{include TPL_ROOT . 'common/datepicker.html.php'}
{!js::import($control->config->webRoot . 'js/fingerprint/fingerprint.js')}
{!css::import($jsRoot . 'uploader/min.css')}
{!js::set('confirm', $lang->form->confirmSubmit)}
{!js::set('fullScreen', $form->fullScreen)}
{!js::set('type', $form->type)}
{!js::set('formID', $form->id)}
<div class="panel detail">
      {if($form->denied)}
        <h2 class='text-center'>
          {$form->reason}
          {if($form->needLogin && $control->app->user->account == 'guest')}
            {!html::a($control->createLink('user', 'login', 'referer=' . helper::safe64Encode($control->server->request_uri)), $lang->login, "class='btn btn-primary'")}
          {/if}
        </h2>
      {else}
        <header>
          <h2>{$form->title}</h2>
          {if($form->type == 'exam')}
            <h4 class='text-center'>
              <span class='text-danger'>{!printf($lang->form->examTips, $form->timeLimitLabel)}</span>
              <span class='timeLeft pull-right'><i class='icon icon-time'> </i>{$form->timeLeft}</span>
            </h4>
          {/if}
        </header>
        <form id='form{!md5($form->id)}' method='post' autocomplete='off' data-checkfingerprint='1'>
          {$pageTotal = count($items)}
          {foreach($items as $page => $pageItems)}
              <div class='items'>
                {foreach($pageItems as $item)}
                  <div class='item'>
                    <div class='item-heading'>
                      {if($item->control == 'section')}
                        <h3>{$item->title}</h3>
                        <p>{$item->desc}</p>
                      {else}
                        {@$itemTotal++}
                        <h4>
                          <span class='order'>{if($pageTotal > 1 or count($pageItems) > 1)} {$itemTotal} {/if}</span>
                          {$item->title}
                          {if($form->type == 'exam' && $item->type == 'common')} ({$item->score}{$lang->formitem->scoreUnit}) {/if}
                          {if(strpos(",$item->rule,", ',notempty,') !== false)}
                            <span class='required'></span>
                          {/if}
                        </h4>
                      {/if}
                    </div>
                    {if($item->control != 'section')}
                      {$name = 'item' . $item->id}
                      {if($item->control == 'radio' or $item->control == 'checkbox')}
                      <div class='item-content'>
                        {$func = $item->control}
                        {if($item->optionType == 'text')} {!html::$func($name, $item->options, '', '', $item->display)} {/if}
                        {if($item->optionType == 'image')} {$control->formitem->printOptionImages($item, $name)} {/if}
                      </div>
                      {elseif($item->control == 'select')}
                      <div class='item-heading'>
                        <h4>{!html::select($name, array('' => '') + $item->options, '', "class='form-control chosen'")}</h4>
                      </div>
                      {elseif($item->control == 'input')}
                      <div class='item-content'>
                        {$value = ''}
                        {foreach(array('realname', 'mobile', 'phone', 'email', 'address', 'qq') as $type)}
                        {if($item->type == $type)} {$value = $control->app->user->$type} {/if}
                        {if($item->type == 'realname' and $value == 'guest')} {$value = ''} {/if}
                        {/foreach}
                        {!html::input($name, $value, "class='form-control' placeholder='{{$item->desc}}'")}
                      </div>
                      {elseif($item->control == 'date')}
                      <div class='item-content'>{!html::input($name, '', "class='form-control form-{{$item->format}}'")}</div>
                      {elseif($item->control == 'textarea')}
                        <div class='item-content'>
                        {!html::textarea($name, '', "rows='3' placeholder='{{$item->desc}}' class='form-control'")}
                        </div>
                      {/if}
                    {/if}
                  </div>
                {/foreach}
              </div>
          {/foreach}
          <footer>{!html::submitButton($lang->save, "btn info")}</footer>
        </form>
      {/if}
    </div>
{!js::set('itemTotal', $itemTotal)}
{!js::set('pageTotal', $pageTotal)}
{!js::set('page', 1)}
{if(!empty($form->fullScreen))}
  {include $control->loadModel('ui')->getEffectViewFile('mobile', 'common', 'footer')}
{else}
      <div class='row blocks' data-region='form_view-bottom'>{$control->block->printRegion($layouts, 'form_view', 'bottom', true)}</div>
    </div>
    {if(!empty($layouts['form_view']['side']) and !(empty($sideFloat) || $sideFloat === 'hidden'))}
      <div class='col-md-{$sideGrid} col-side'><side class='form-side blocks blocks' data-region='form_view-side'>{$control->block->printRegion($layouts, 'form_view', 'side')}</side></div>
    {/if}
  </div>
  <div class='row blocks' data-region='form_view-bottomBanner'>{$control->block->printRegion($layouts, 'form_view', 'bottomBanner', true)}</div>
  {include $control->loadModel('ui')->getEffectViewFile('mobile', 'common', 'footer')}
{/if}
