$(document).ready(function()
{
    $('.nav-system-book').addClass('active');
    $('#navbar li.active').parents('li').addClass('active');
    $('#article' + v.objectID).addClass('active');
    $('#article' + v.objectID).parents('dd').each(function()
    {
        $(this).attr('class', $(this).attr('class').replace('closed', 'opened'));
        $(this).addClass('active');
    })
    if(v.fullScreen)
    {
        $('html, body').css('height', '100%');

        curPos = sessionStorage.getItem('curPos');
        if(curPos) $('.fullScreen-catalog').animate({scrollTop: curPos}, 0);

        $('.article').click(function(){sessionStorage.setItem('curPos', $('.fullScreen-catalog').scrollTop());});
    }

    $('dd > span').click(function()
    {
        if($(this).parent().attr('class').indexOf('closed') != '-1')
        {
            $(this).parent().attr('class', $(this).parent().attr('class').replace('closed', 'opened'));
            $(this).parent().find('dd').each(function()
            {
                $(this).attr('class', $(this).attr('class').replace('closed', 'opened'));
            })
        }
        else
        {
            $(this).parent().attr('class', $(this).parent().attr('class').replace('opened', 'closed'));
            $(this).parent().find('dd').each(function()
            {
                $(this).attr('class', $(this).attr('class').replace('opened', 'closed'));
            })
        }
    });

    $('dd a').click(function()
    {
        if($('.article.book-content').length !== 0)
        {
            getContent(this);
            return false;
        }
    });

    $('body').on("click",".icon-next a, .icon-previous a, .previous a, .next a",function()
    {
        if($('.article.book-content').length !== 0)
        {
            getContent(this);
            return false;
        }
    });

    $('body').on("blur",'.popover input',function()
    {
        $('[data-toggle="popover"]').popover('hide');
        return false;
    });


    function getContent(obj)
    {
        if($(obj).parent().attr('class').indexOf('disabled') != '-1') return false;
        var url = $(obj).attr('href');
        if($('.article.book-content').length !== 0)
        {
            $('.col-md-9').load(url + ' .col-md-9 > div', function(response)
            {
                if($(response).find('.col-md-9').length === 0)
                {
                    $('.col-md-9').html("<div class='article book-content'>" + $(response).find('.modal-dialog').html() + "</div>")
                }
                $('.breadcrumb').html($(response).find('.breadcrumb').html());
                init();
            });
        }
        else
        {
            $.get(url, function(data)
            {   
                $('.fullScreen-content').html($(data).find('.fullScreen-content').html());
                $('.fullScreen-nav').html($(data).find('.fullScreen-nav').html());
                init();
            })
        }
    }

    function init()
    {
        var objectID = $('#id').val();
        $('.article').removeClass('active');
        $('#article' + objectID).addClass('active');
        $('#article' + objectID).parents('dd').each(function()
        {
            $(this).attr('class', $(this).attr('class').replace('closed', 'opened'));
            $(this).addClass('active');
        })
        if($(".books dd.article.active > a").attr('href'))
        {
            if($(".qrcode-mobile").length)
            {
                articleID = $(".books dd.article.active").attr('id').substr('7');
                if($(".qrcode-mobile").attr('data-src'))
                {
                    length = $(".qrcode-mobile").attr('data-src').indexOf('qrcode');
                    $(".qrcode-mobile").attr('data-src', createLink('misc', 'qrcode', 'articleID=' + articleID));
                }
                else
                {
                    length = $(".qrcode-mobile").attr('src').indexOf('qrcode');
                    $(".qrcode-mobile").attr('src', createLink('misc', 'qrcode', 'articleID=' + articleID));
                }
            }
        }
        $('[data-toggle="popover"]').popover(
        { 
            content : v.scheme + "://" + v.httpHost + $(".books dd.article.active a").attr('href'),
            template : '<div class="popover"><div class="arrow"></div><h3 class="popover-title"></h3><input class="form-control" type="text" value=' + v.scheme + "://" + v.httpHost + $(".books dd.article.active a").attr('href') + '></div></div>',
            trigger : 'click',
        });
        $('[data-toggle="popover"]').tooltip({placement : 'right', title : v.copySuccess, trigger : 'manual'});
    }

    $(window).keydown(function(e)
    {
        if(e.keyCode == 37) getContent($('.previous a'));
        if(e.keyCode == 39) getContent($('.next a'));
    });

    init();
});
