{*php
/**
 * The latest video front view file of block module of chanzhiEPS.
 *
 * @copyright   Copyright 2009-2016 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     商业软件，非开源软件 
 * @author      Gang Liu <liugang@cnezsoft.com> 
 * @package     video 
 * @version     $Id$
 * @link        http://www.zsite.com
*/
/php*}
{* /* Set $themRoot. */ *}
{$themeRoot = $config->webRoot . 'theme/'}

{* /* Decode the content and get videos. */ *}
{$content  = json_decode($block->content)}
{$method   = 'get' . ucfirst(str_replace('video', '', strtolower($block->type)))}
{$videos = $model->loadModel('article')->$method(empty($content->category) ? 0 : $content->category, $content->limit, 'video')}
{if(isset($content->image))} {$videos = $model->loadModel('file')->processImages($videos, 'video')} {/if}
<div id="block{$block->id}" class='panel panel-block {$blockClass}'>
  <div class='panel-heading'>
    <strong>{!echo $icon . $block->title}</strong>
    {if(isset($content->moreText) and isset($content->moreUrl))}
      <div class='pull-right'>{!html::a($content->moreUrl, $content->moreText, isset($content->moreOpen) ? " target='_blank'" : '')}</div>
    {/if}
  </div>
  {if(isset($content->image))}
    <div class='panel-body'>
      <div class='cards cards-borderless cards-custom'>
        {foreach($videos as $video)}
          {$url = helper::createLink('video', 'view', "id=$video->id", "category={{$video->category->alias}}&name=$video->alias")}
          {$recPerRow = (isset($content->recPerRow) and !empty($content->recPerRow)) ? $content->recPerRow : '3'}
            <div class='col-md-12' data-recperrow="{$recPerRow}">
              <a class='card' href="{$url}" {!isset($content->linkOpen) ? " target='_blank'" : '';}>
                {if(!empty($video->image))}
                {$video->image->primary->objectType = 'video'}
                <div class='media' style='background-image: url({$model->loadModel('file')->printFileURL($video->image->primary, 'middleURL')});'>
                  {$title = $video->image->primary->title ? $video->image->primary->title : $video->title}
                  {!html::image($model->loadModel('file')->printFileURL($video->image->primary, 'middleURL'), "title='{{$title}}' alt='{{$video->title}}'")}
                </div>
                {else}
                <div class='media media-wrapper' style=''>
                  <div class="media-placeholder" data-id="' . $video->id . '">
                    {!echo $video->title}
                  </div>
                </div>
                {/if}
    
                <div class="card-heading {if(isset($content->alignTitle) && $content->alignTitle == 'middle')} {!'text-center'} {/if}">
                  <strong title="{$video->title}">
                    {if(zget($content, 'showCategory') == 1)} {!echo '[' . ($content->categoryName == 'abbr' and $video->category->abbr) ? $video->category->abbr : $video->category->name . ']'} {/if}
                    {$video->title}
                  </strong>
                </div>
    
                {if(isset($content->showInfo) and isset($content->infoAmount))}
                  {$videoInfo = empty($video->desc) ? $video->content : $video->desc}
                  {$videoInfo = strip_tags($videoInfo)}
                  {$videoInfo = helper::substr($videoInfo, $content->infoAmount)}
                  <div class='card-content text-muted with-padding'>{!echo $videoInfo}</div>
                {/if}
              </a>
            </div>
        {/foreach}
      </div>
    </div>
  {else}
    <div class='panel-body'>
        <ul class='ul-list'>
          {foreach($videos as $video)}
            {$url = helper::createLink('video', 'view', "id=$video->id", "category={{$video->category->alias}}&name=$video->alias")}
            <li>
              <span class='text-latin pull-right'>
              {if(isset($content->showPrice) and $content->showPrice)}
                <span>
                {if(!$video->unsaleable)}
                  {if($video->negotiate)}
                    &nbsp;&nbsp;
                    <strong class='text-danger'>{$lang->video->negotiate}</strong>
                  {else}
                    {if($video->promotion != 0)}
                      {if($video->price != 0)}
                        <small class='text-muted'>{$config->video->currencySymbol}</small>
                        <del><small class='text-muted'>{$video->price}</small></del>
                      {/if}
                      &nbsp; <small class='text-muted'>{$config->video->currencySymbol}</small>
                      <strong class='text-danger'>{$video->promotion}</strong>
                    {elseif($video->price != 0)}
                       &nbsp; <small class='text-muted'>{$config->video->currencySymbol}</small>
                       <strong class='text-important'>{$video->price}</strong>
                    {/if}
                  {/if}
                {/if}
              {/if}
              </span>
              {if(isset($content->showViews) and $content->showViews)}
                <span> <i class="icon icon-eye-open"></i> {!echo $video->views} </span>
              {/if}
              </span>
              {if(isset($content->showCategory) and $content->showCategory == 1)}
                {if($content->categoryName == 'abbr')}
                {$categoryName = '[' . ($video->category->abbr ? $video->category->abbr : $video->category->name) . '] '}
                {!html::a(helper::createLink('video', 'browse', "categoryID={{$video->category->id}}", "category={{$video->category->alias}}"), $categoryName)}
                {else}
                {!html::a(helper::createLink('video', 'browse', "categoryID={{$video->category->id}}", "category={{$video->category->alias}}"), '[' . $video->category->name . '] ')}
                {/if}
              {/if}
              {!html::a($url, $video->title, isset($content->linkOpen) ? " target='_blank'" : '')}
            </li>
            {if(isset($content->showInfo) and isset($content->infoAmount))}
              {$videoInfo = empty($video->desc) ? $video->content : $video->desc}
              {$videoInfo = strip_tags($videoInfo)}
              {$videoInfo = (mb_strlen($videoInfo) > $content->infoAmount) ? mb_substr($videoInfo, 0 , $content->infoAmount, 'utf8') : $videoInfo}
            <div style='padding-left:30px;'>{!echo $videoInfo}</div>
            {/if}
          {/foreach}
        </ul>
      </div>
      {/if}
    </div>
{noparse}
<style>
.block-article-latestVideo .media-wrapper:hover {text-decoration: none}
.block-article-latestVideo .media-placeholder {display: block; width: 100%; height: 100%; color: #fff; font-weight: bold; text-shadow: 2px 2px 0 #ccc, 1px 1px 0 #eee; padding: 25px; font-size: 24px; word-spacing:normal; word-break:break-all; text-align: center;}
.block-article-latestVideo .media-placeholder-list {padding: 5px; font-size: 15px;}
.block-article-latestVideo .media-placeholder { height: 200px; line-height: 150px}
.panel-body .cards-custom .card > .card-heading {min-height: 40px; height: 40px; padding: 10px; font-size: 13px; position: relative;}
.panel-body .cards-custom .card > .card-heading > strong {display: inline-block; vertical-align: middle; max-width: 150px; white-space: nowrap; overflow: hidden;}
.panel-body .cards-custom .card > .card-heading > .views {position: absolute; right: 0; top: 10px;}
.panel-body .cards-custom .card > .card-content {padding: 0 10px 10px 10px; margin-bottom: 10px;}
{/noparse}

{if(empty($content->showPrice) and empty($conetnt->showViews))}
.panel-body .cards-custom .card > .card-heading{display: block; overflow: hidden; white-space: nowrap;}
.panel-body .cards-custom .card > .card-heading > strong{max-width:100%;}
{/if}

{noparse}
</style>
<script>
$('.block-article-latestVideo .media-placeholder').each(function()
{
    var $this = $(this);
    $this.attr('style', 'background-color: hsl(' + $this.data('id') * 57 % 360 + ', 80%, 90%)');
});
</script>
{/noparse}
