<?php
public function updateRank($account, $count)
{
    return $this->loadExtension('mall')->updateRank($account, $count);
}

public function computeUserLevel($rank, $option = 'name')
{
    return $this->loadExtension('mall')->computeUserLevel($rank, $option);
}

public function getUserLevel($account, $option = 'name')
{
    return $this->loadExtension('mall')->getUserLevel($account, $option);
}

public function isAbove($account, $level)
{
    return $this->loadExtension('mall')->isAbove($account, $level);
}
/**
 * Get User Template.
 * 
 * @param  string    $type 
 * @access public
 * @return array
 */
public function getUserTemplates($type)
{
    return $this->dao->select('id,account,title,content,public')
        ->from(TABLE_USERTPL)
        ->where('type')->eq($type)
        ->andwhere('account', true)->eq($this->app->user->account)
        ->orWhere('public')->eq('1')
        ->markRight(1)
        ->orderBy('id')
        ->fetchAll();
}

/**  
 * Save user template.
 *
 * @param  string    $type 
 * @access public
 * @return void
 */
public function saveUserTemplate($type)
{    
    $template = fixer::input('post')
        ->setDefault('account', $this->app->user->account)
        ->setDefault('type', $type)
        ->stripTags('content', $this->config->allowedTags)
        ->get();

    $condition = "`type`='$type' and account='{$this->app->user->account}'";
    $this->dao->insert(TABLE_USERTPL)->data($template)->batchCheck('title, content', 'notempty')->check('title', 'unique', $condition)->exec();
} 
