$(document).ready(function()
{
    var parseColor = function(c)
    {
        try {return new $.zui.Color(c);}
        catch(e) {return null;}
    };
    var $css = $('#css');
    $('.color').each(function()
    {
        var $this = $(this);
        var c = $this.attr('data').replace(';', '');
        if(!c) return;
        var cc = parseColor(c);
        if(!cc) return;
        cc = cc.contrast().toCssStr();

        var $inputColor = ($this.hasClass('input-group') ? $this.find('.input-group-btn .dropdown-toggle') : $this).css({'background': c === 'transparent' ? '' : c, 'color': cc}).find('.caret').css('border-top-color', cc).closest('.input-group').find('.input-color');
        if(!$inputColor.attr('placeholder'))
        {
            $inputColor.attr('placeholder', c);
        }
    }).click(function()
    {
        var $this = $(this);
        if($this.hasClass('input-group')) return;
        var $plate = $this.closest('.colorplate');
        $plate.find('.color.active').removeClass('active');
        if($this.hasClass('color-tile')) $plate.find('.input-color').val($this.attr('data')).change();
        $this.addClass('active');
    });

    $('.input-color').on('keyup change.color', function()
    {
        var $this = $(this);
        var val = $this.val();

        $this.closest('.colorplate').find('.color.active').removeClass('active');

        if($.zui.Color.isColor(val))
        {
            var ic = (new $.zui.Color(val)).contrast().toCssStr();
            $this.attr('placeholder', val).closest('.color').removeClass('error').find('.input-group-btn .dropdown-toggle').css({'background': val, 'color': ic}).find('.caret').css('border-top-color', ic);;
        }
        else
        {
            $this.closest('.color').addClass('error');
        }
    });

    $('#submit').on('click', function()
    {
        $('#saveType').val('publish');
    })

    $('.btn-save').on('click', function()
    {
        $('#saveType').val('saveAndReview');
        $(this).attr('disabled','disabled');
        $('#editForm').submit();
    })

    $.setAjaxForm('#editForm', function(response)
    {
        if(response.target == 'newOpen' && response.result == 'success')
        {   
            $('.btn-save').popover({container : 'body', trigger : 'manual', content : response.info, placement : 'right', tipClass : 'popover-success popover-ajaxform'}).popover('show');
            setTimeout(function(){$('.btn-save').popover('destroy');}, 2000);
            setTimeout(function(){window.open(response.targetLink);}, 1200);
        }
        else if(response.result == 'success')
        {
            setTimeout(function(){location.href = response.locate;}, 1200);
        }
        $('.btn-save').removeAttr('disabled');
    });
});
