<?php if(!defined("RUN_MODE")) die();?>
<?php include '../../common/view/header.admin.html.php';?>
<?php include '../../common/view/datepicker.html.php';?>
<?php js::import($jsRoot . 'clipboard/clipboard.min.js');?>
<?php js::set('copySuccess', $lang->file->copySuccess);?>
<?php js::set('noCategoryFile', $lang->file->noCategoryFile);?>
<?php js::set('categoryID', $categoryID);?>
<?php $date       = $this->get->date ? $this->get->date : '';?>
<?php $theme      = $this->config->template->{$this->app->clientDevice}->theme;?>
<?php $template   = $this->config->template->{$this->app->clientDevice}->name;?>
<?php $searchWord = $this->get->searchWord ? $this->get->searchWord : '';?>
<section class='main-table'>
  <header class='clearfix'>
    <ul class='nav nav-tabs-main pull-left'>
      <li class='active'>
        <?php echo html::a(inlink('browsesource', "type=&categoryID={$categoryID}"), $lang->file->all);?>
      </li>
    </ul>
    <div class='pull-left btn-toolbar'>
      <div class='space'></div>
      <div class='input-control has-icon-right'>
        <button type='btn' class='btn'>
          <?php echo !empty($date) ? $date : $lang->selectDate;?>
          <i class='icon-angle-sm-down'></i>
          <?php if(!empty($date)):?> <i class='icon-close'></i> <?php endif;?>
        </button>
        <input type='btn' value='<?php echo $date;?>' class='btn form-datecustom w-80px' data-picker-position='bottom-right' href='<?php echo inlink('browsesource', "type=&categoryID={$categoryID}&orderBy={$orderBy}&pageID=");?>'/>
      </div>
      <div class='space'></div>
      <form method='get' class='input-control search-box has-icon-right' data-ride='searchbox'>
        <?php echo html::hidden('m', 'file');?>
        <?php echo html::hidden('f', 'browsesource');?>
        <?php echo html::hidden('type', '');?>
        <?php echo html::hidden('categoryID', $categoryID);?>
        <?php echo html::hidden('orderBy', '');?>
        <?php echo html::hidden('pageID', 1);?>
        <?php echo html::hidden('date', $date);?>
        <?php echo html::input('searchWord', $searchWord, "class='form-control search-query' placeholder='{$lang->searchPlaceholder}'");?>
        <button type="submit" class="btn btn-link input-control-icon-right search-submit-btn"><i class="icon icon-search icon-lg"></i></button>
      </form>
    </div>
    <div class='pull-right btn-toolbar'>
      <?php $listClass = $viewType == 'card' ? 'active' : '';?>
      <?php echo html::a('javascript:;', "<i class='icon icon-apps'></i>", "class='btn btn-icon btn-card {$listClass}'")?>
      <?php $cardClass = $viewType == 'list' ? 'active' : '';?>
      <?php echo html::a('javascript:;', "<i class='icon icon-list-bold'></i>", "class='btn btn-icon btn-list {$cardClass}'")?>
      <?php commonModel::printLink('file', 'browse', "objectType=source&objectID={$template}_{$theme}&isImage=&categoryID={$categoryID}", '<i class="icon icon-upload-cloud"></i>' . $lang->file->uploadSource, "data-toggle='modal' class='btn btn-primary'");?>
    </div>
  </header>
  <?php if($viewType == 'card'):?>
  <form id='ajaxForm' action='<?php echo $this->createLink('file', 'batchDelete');?>' method='post' class='deleteForm'>
    <ul class='files-card clearfix'>
    <?php foreach($files as $file):?>
        <?php
        $imageHtml = '';
        $fileHtml  = '';
        $fullURL   = html::input('', $file->fullURL, "size='" . strlen($file->fullURL) . "' style='border:none; background:none;' onmouseover='this.select()'");
        $imagePath = $this->file->printFileURL($file);
        if($file->isImage)
        {
            $imageHtml .= "<li class='col-lg-2 col-md-3 col-sm-6 file-image file-{$file->extension}'>";
            $imageHtml .= "<div class='image-wrapper'>";
            $imageHtml .= html::a(helper::createLink('file', 'download', "fileID=$file->id&mose=left"), html::image($imagePath), "target='_blank' data-toggle='lightbox'");
            $imageHtml .= "<div class='file-source'><div class='input-group'>";
            $imageHtml .= "<span class='input-group-select checkboxBox'>" . html::checkbox('fileList', array($file->id => '')) . "</span>";
            $imageHtml .= "<input readonly id='fullURL{$file->id}' type='text' value='{$imagePath}' class='form-control file-url'/><span class='input-copy-btn'><button type='button' class='btn btn-sm copyBtn' data-clipboard-target='#fullURL{$file->id}'>{$lang->copy}</button></span></div></div>";
            $imageHtml .= "<div class='file-actions'>";
            $imageHtml .= html::a(helper::createLink('file', 'editsource', "id=$file->id&categoryID=$categoryID"), "<i class='icon icon-pencil'></i>", "data-toggle='modal' data-title='{$lang->file->editSource}'");
            $imageHtml .= html::a(helper::createLink('file', 'deletesource', "id=$file->id"), "<i class='icon icon-delete'></i>", "class='deleter'");
            $imageHtml .= '</div>';
            $imageHtml .= '</div>';
            $imageHtml .= '</li>';
        }
        else
        {
            $file->title = $file->title . ".$file->extension";
            $fileHtml .= "<li class='col-lg-2 col-md-3 col-sm-6 file file-{$file->extension}'>";
            $fileHtml .= "<div class='file-wrapper'>";
            $fileHtml .= html::a(helper::createLink('file', 'download', "fileID=$file->id&mouse=left"), $file->title, "target='_blank'");
            $fileHtml .= "<div class='file-source'><div class='input-group'>";
            $fileHtml .= "<span class='input-group-select checkboxBox'>" . html::checkbox('fileList', array($file->id => '')) . "</span>";
            $fileHtml .= "<input readonly id='fullURL{$file->id}' type='text' value='{$imagePath}' class='form-control file-url'/><span class='input-copy-btn'><button type='button' class='btn btn-sm copyBtn' data-clipboard-target='#fullURL{$file->id}'>{$lang->copy}</button></span></div></div>";
            $fileHtml .= "<span class='file-actions'>";
            $fileHtml .= html::a(helper::createLink('file', 'editsource', "id=$file->id"), "<i class='icon icon-pencil'></i>", "data-toggle='modal' data-title='{$lang->file->editSource}'");
            $fileHtml .= html::a(helper::createLink('file', 'deletesource', "id=$file->id"), "<i class='icon icon-delete'></i>", "class='deleter'");
            $fileHtml .= '</span>';
            $fileHtml .= '</div>';
            $fileHtml .= '</li>';
        }
        if($imageHtml or $fileHtml) echo $imageHtml . $fileHtml;
        ?>
    <?php endforeach;?>
    </ul>
    <div class='table-footer'>
      <?php if($files):?>
      <div class='batch pull-left'>
        <div class='btn-group'><?php echo html::selectbutton();?></div>
        <?php echo html::submitbutton($lang->delete, 'btn delete btn-batch');?>
      </div>
      <?php endif;?>
      <?php $pager->show();?>
    </div>
  </form>
  <?php else:?>
  <form id='ajaxForm'  action='<?php echo $this->createLink('file', 'batchDelete');?>' method='post' class='deleteForm'>
    <table class='table table-hover tablesorter table-fixed files-list'>
      <thead>
        <tr class='text-center'>
          <th class='w-10px first'></th>
          <th class='w-30px'></th>
          <th class='w-150px'><?php echo $lang->file->source;?></th>
          <th><?php echo $lang->file->sourceURI;?></th>
          <th class='w-100px addedBy'><?php echo $lang->file->addedBy;?></th>
          <th class='w-160px addedDate'><?php echo $lang->file->addedDate;?></th>
          <th class='w-30px actions'><?php echo $lang->edit;?></th>
          <th class='w-30px actions'><?php echo $lang->delete;?></th>
          <th class="text-center actions w-10px"></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($files as $file):?>
        <tr class='text-center text-middle'>
          <td></td>
          <td>
            <?php echo html::checkbox('fileList', array($file->id => '')); ?>
          </td>
          <td class='text-left'>
            <div class='file-name-wrapper'>
            <?php echo html::a(inlink('download', "id=$file->id"), $file->title, "target='_blank' title='{$file->title}'");?>
            </div>
          </td>
          <?php $filePath = $this->file->printFileURL($file);?>
          <td class='text-left inherit'>
            <div class='file-source'>
              <div class='input-group'>
                <input readonly id='fullURL<?php echo $file->id;?>' type='text' value='<?php echo $filePath;?>' class='form-control file-url'/>
                <span class='input-copy-btn'>
                  <button type='button' class='btn btn-sm copyBtn' data-clipboard-target='#fullURL<?php echo $file->id;?>'><?php echo $lang->copy;?></button>
                </span>
              </div>
            </div>
          </td>
          <?php $addedBy = isset($users[$file->addedBy]) ? $users[$file->addedBy] : '';?>
          <td title='<?php echo $addedBy;?>'><?php echo $addedBy;?></td>
          <td><?php echo $file->addedDate;?></td>
          <td class='c-actions'>
            <?php commonModel::printLink('file', 'editsource',   "id=$file->id", '<i class="icon icon-edit"></i>', "class='btn btn-icon' data-toggle='modal'"); ?>
          </td>
          <td class='c-actions'>
            <?php commonModel::printLink('file', 'deletesource', "id=$file->id", '<i class="icon icon-delete"></i>', "class='btn btn-icon deleter'"); ?>
          </td>
          <td></td>
        </tr>
        <?php endforeach;?>
      </tbody>
    </table>
    <div class='table-footer'>
      <?php if($files):?>
      <div class='batch pull-left'>
        <div class='btn-group'><?php echo html::selectbutton();?></div>
        <?php echo html::submitbutton($lang->delete, 'btn delete btn-batch');?>
      </div>
      <?php endif;?>
      <?php $pager->show();?>
    </div>
  </form>
  <?php endif;?>
</div>
<?php include '../../common/view/footer.admin.html.php';?>
