<?php
/**
 * Chanzhi article converted to wechat news according to template.
 * 
 * @param  string  $content 
 * @access public
 * @return void
 */
public function renderWP($content, $theme = 'news')
{
    $theme = $this->post->theme ? $this->post->theme : $theme;

    $customedTheme = !empty($this->config->wechattheme->$theme) ? $this->config->wechattheme->$theme : '';
    if(!$_POST && $customedTheme) $_POST = json_decode($customedTheme, true);

    if(!$_POST || $this->post->renderText === '1')
    {
        $fontSize     = zget($_POST, 'fontSize',     $this->config->wpeditor->{$theme}->body['text']['fontSize']);
        $fontColor    = zget($_POST, 'fontColor',    $this->config->wpeditor->{$theme}->body['text']['fontColor']);
        $fontSpacing  = zget($_POST, 'fontSpacing',  $this->config->wpeditor->{$theme}->body['text']['fontSpacing']);
        $lineHeight   = zget($_POST, 'lineHeight',   $this->config->wpeditor->{$theme}->body['text']['lineHeight']);
        $marginTop    = zget($_POST, 'marginTop',    $this->config->wpeditor->{$theme}->body['text']['marginTop']);
        $marginRight  = zget($_POST, 'marginRight',  $this->config->wpeditor->{$theme}->body['text']['marginRight']);
        $marginBottom = zget($_POST, 'marginBottom', $this->config->wpeditor->{$theme}->body['text']['marginBottom']);
        $marginLeft   = zget($_POST, 'marginLeft',   $this->config->wpeditor->{$theme}->body['text']['marginLeft']);

        $fontStyle   = "font-size:{$fontSize}px;color:{$fontColor};letter-spacing: {$fontSpacing}px;line-height:{$lineHeight}em;";
        $marginStyle = "margin-top:{$marginTop}px;margin-right:{$marginRight}px;margin-bottom:{$marginBottom}px;margin-left:{$marginLeft}px;";
        $style = "style='{$fontStyle}{$marginStyle}'";

        $content = str_replace('<p', "<p {$style}", $content);
        $content = str_replace('<span', "<span {$style}", $content);
    }

    foreach($this->config->wpeditor->{$theme}->title as $titleLabel => $htmlCode)
    {
        if($titleLabel == 'headline' && ($_POST && $this->post->renderHeadline !== '1')) continue;
        if($titleLabel == 'subhead' &&  ($_POST && $this->post->renderSubhead !== '1')) continue;

        $label = $this->post->{$titleLabel} ? $this->post->{$titleLabel} : $this->config->wpeditor->{$theme}->body[$titleLabel];
        preg_match_all("/<{$label}.*>([\s\S]*)<\/{$label}>/U", $content, $matches);
        foreach($matches[0] as $key => $replaceLabel)
        {
            $content = str_replace($replaceLabel, sprintf($htmlCode, $matches[1][$key]), $content);
        }
    }

    $content = "<section style='{$fontStyle}'>$content</section>";

    if(file_exists("../view/wechatheader.{$theme}.html.php")) 
    {
        $content = file_get_contents("../view/wechatheader.{$theme}.html.php") . $content;

        $count = 1;
        foreach($this->config->wpeditor->{$theme}->top as $key => $topLabel)
        {
            $topContent = $this->post->articleTop ? $this->post->articleTop[$key] : $topLabel['value'];
            if($topLabel['type'] == 'input') $content = str_replace('{$TOPTEXT' . $count . '}', $topContent, $content);
            $count ++;
        }
        if($_POST && $this->post->renderTop !== '1') $content = str_replace("name='renderTop'", "name='renderTop' class='hide'", $content);
    }

    if($theme == 'news' && !empty($this->post->oldTitle))
    {
        $linkHtml = '';
        foreach($this->post->oldTitle as $key => $title)
        {
            $link = $this->post->oldLink[$key] ? $this->post->oldLink[$key] : 'javascript:;';
            $linkHtml .= "<section style='margin-top: 10px;margin-right: 8px;margin-left: 8px;line-height: 1.75em;'><a target='_blank' href='{$link}' tab='innerlink'>{$title}</a></section>";
        }
        if(file_exists("../view/wechatrecommend.{$theme}.html.php")) $content = $content . file_get_contents("../view/wechatrecommend.{$theme}.html.php");

        $oldLinkHead = $this->post->oldLinkHead ? $this->post->oldLinkHead : $this->config->wpeditor->{$theme}->oldlink['head'];
        $content = str_replace('{$OLDLINKHEAD}', $oldLinkHead, $content);
        $content = str_replace('{$WECHATLINK}', $linkHtml, $content);
        if($_POST && $this->post->renderOldLink !== '1') $content = str_replace("name='renderOldLink'", "name='renderOldLink' class='hide'", $content);
    }

    if(file_exists("../view/wechatqrcode.{$theme}.html.php")) 
    {
        $content = $content . file_get_contents("../view/wechatqrcode.{$theme}.html.php");

        $this->app->loadClass('qrcode', true);
        $qrcodeFile = $this->app->getDataRoot() . 'wechat' . DS . $this->app->user->account . '.png';
        if(!is_dir(dirname($qrcodeFile))) @mkdir(dirname($qrcodeFile));

        qrcode::png($this->post->pushQRCode ? $this->post->pushQRCode : ' ', $qrcodeFile, QR_ECLEVEL_L, 4, 2);
        $content = str_replace('{$QRCODESRC}', $this->app->getWebRoot() . 'data/wechat/' . $this->app->user->account . '.png?v=' . time(), $content);

        $count = 1;
        foreach($this->config->wpeditor->{$theme}->qrcode as $key => $qrcodeLabel)
        {
            $qrcodeContent = $this->post->articleQRCode ? $this->post->articleQRCode[$key] : $qrcodeLabel['value'];
            if($qrcodeLabel['type'] == 'input') $content = str_replace('{$QRCODETEXT' . $count . '}', $qrcodeContent, $content);
            $count ++;
        }
        if($_POST && $this->post->renderQRCode !== '1') $content = str_replace("name='renderQRCode'", "name='renderQRCode' class='hide'", $content);
    }

    if(file_exists("../view/wechatfooter.{$theme}.html.php")) 
    {
        $content = $content . file_get_contents("../view/wechatfooter.{$theme}.html.php");

        $count = 1;
        foreach($this->config->wpeditor->{$theme}->bottom as $key => $bottomLabel)
        {
            $bottomContent = $this->post->articleBottom ? $this->post->articleBottom[$key] : $bottomLabel['value'];
            if($bottomLabel['type'] == 'input') $content = str_replace('{$BOTTOMTEXT' . $count . '}', $bottomContent, $content);
            $count ++;
        }
        if($_POST && $this->post->renderBottom !== '1') $content = str_replace("name='renderBottom'", "name='renderBottom' class='hide'", $content);
    }

    $content = "<section style='{$fontStyle}'>$content</section>";
    return $content;
}

/**
 * Send articles to WeChat. 
 * 
 * @param  string  $content 
 * @access public
 * @return void
 */
public function sync2wechat($content)
{
    $content = $this->renderWP($content);

    $api     = $this->loadModel('wechat')->loadApi($this->post->wechatAccount); 

    $content = $this->processPicForWP($api, $content);

    $thumbID = $this->uploadWPThumb($api);

    $data = new stdclass();
    $data->articles = array();
    $data->articles[0]->title              = $this->post->pushTitle ? $this->post->pushTitle : ' ';
    $data->articles[0]->author             = $this->post->pushAuthor ? $this->post->pushAuthor : ' ';
    $data->articles[0]->show_cover_pic     = $this->post->renderCoverPic;
    $data->articles[0]->content            = $content;
    $data->articles[0]->content_source_url = $this->post->sourceURL ? $this->post->sourceURL : ' ';
    $data->articles[0]->digest             = $this->post->pushDesc ? $this->post->pushDesc : ' ';
    $data->articles[0]->thumb_media_id     = $thumbID;

    $jsonData = json_encode($data, JSON_UNESCAPED_UNICODE);
    $result   = $api->uploadNews($jsonData);

    return $result;

}

/**
 * Upload Thumb pic.
 * 
 * @param  object  $api 
 * @access public
 * @return void
 */
public function uploadWPThumb($api)
{
    $file    = $this->loadModel('file')->getByID($this->post->coverID);
    $tmpFile = $file->realPath . '.' . $file->extension;

    copy($file->realPath, $tmpFile);
    $result = $api->uploadMaterial($tmpFile, 'thumb');
    unlink($tmpFile);

    return $result->media_id;
}

/**
 * Article pic to wechat pic. 
 * 
 * @param  object  $api 
 * @param  string  $content 
 * @access public
 * @return string
 */
public function processPicForWP($api, $content)
{
    preg_match_all("/src=[\"\']([\s\S]*)[\"\']/U", $content, $images);
    preg_match_all("/url\(&quot;([\s\S]*)&quot;\)/U", $content, $backgroundImages);

    $images = array_merge($images[1], $backgroundImages[1]);

    foreach($images as $key => $imageURL)
    {
        if(strpos($content, $imageURL) === false) continue;

        $wechatPicURL = '';
        if(strpos($imageURL, 'mmbiz.qpic.cn') === false)
        {
            $fullURL = $imageURL;
            if(strpos(substr($imageURL, 0, 10), 'file.php') !== false || substr($imageURL, 0, 6) == '/data/') 
            {
                $scheme = 'http';
                if(isset($this->config->site->scheme))
                {   
                    $scheme = $this->config->site->scheme;
                }   
                else if(isset($_SERVER['REQUEST_SCHEME'])) 
                {   
                    $scheme = $_SERVER['REQUEST_SCHEME'];
                }
                $fullURL = $scheme . '://' . $this->server->http_host . $fullURL;
            }

            $file     = file_get_contents($fullURL);
            $filePath = $this->app->tmpRoot . time();

            file_put_contents($filePath, $file);

            $fileType = mime_content_type($filePath);
            if($fileType == "image/jpeg")
            {
                rename($filePath, $filePath.'.jpg');
                $filePath .= '.jpg';
            }
            if($fileType == "image/png")
            { 
                rename($filePath, $filePath.'.png');
                $filePath .= '.png';
            }

            if(file_exists($filePath)) $wechatPicURL = $api->uploadImage($filePath)->url;
            @unlink($filePath);
        }

        if($wechatPicURL) $content = str_replace($imageURL, $wechatPicURL, $content);
    }

    return $content;
}
