$(document).ready(function()
{   
    $('[data-toggle="tooltip"]').tooltip({container: 'body'});
    $.setAjaxForm('#wechatForm', function(data)
    {
        if(data.result == 'success')
        {
            if(data.action == 'push')   setTimeout(function(){ location.href = data.locate;}, 1200);
            if(data.action == 'render') $('#content').html(data.content);
            if(data.action == 'save')   bootbox.alert(data.info);
            if(data.action == 'reset')
            {
                bootbox.alert(data.info);
                setTimeout(function(){ location.reload()}, 1200);
            }
        }
    }); 

    $(document).on('change', '#theme', function()
    {
        var theme = $(this).val();
        window.location.href = v.viewUrl + '&theme=' + theme;
    });

    $(document).on('keyup', 'input[type=text]', function()
    {
        var id = $(this).attr('id');
        $(".content-view *[name='" + id + "']").html($(this).val());
    });

    $(document).on('blur', 'input[type=text]', function()
    {
        var id = $(this).attr('id');
        $(".content-view *[name='" + id + "']").html($(this).val());
    });

    $(document).on('change', 'input[type=checkbox]', function()
    {
        var id = $(this).attr('id');
        if($(this).prop('checked')) $(".content-view *[name='" + id + "']").show();
        if(!$(this).prop('checked')) $(".content-view *[name='" + id + "']").hide();
    });

    $(document).on('change', '.render-change', function()
    {
        $('#wechatForm').attr('action', v.viewUrl);
        $('#wechatForm').submit();
        return false;
    });

    $(document).on('change', '#renderOldLink', function()
    {   
        if($(this).prop('checked'))  $(".oldlink").show();
        if(!$(this).prop('checked')) $(".oldlink").hide();
    });

    $(document).on('blur', '.render-blur', function()
    {
        $('#wechatForm').attr('action', v.viewUrl);
        $('#wechatForm').submit();
        return false;
    });

    $(document).on('click', 'a.addlink', function()
    {   
        $(this).parent().parent().after("<div class='input-group'>" + $('div.first').html() + "</div>");
        $('#wechatForm').attr('action', v.viewUrl);
        $('#wechatForm').submit();
        return false;
    }); 

    $(document).on('click', 'a.rmlink', function()
    {   
        if($(this).parent().parent().attr('class').indexOf('first') >= 0) return false;
        $(this).parent().parent().remove();
        $('#wechatForm').attr('action', v.viewUrl);
        $('#wechatForm').submit();
        return false;
    });

    $(document).on('click', '.btn-push', function()
    {  
        $('#wechatForm').attr('action', v.pushUrl);
        $('#wechatForm').submit();
        return false;
    });

    $(document).on('click', '.btn-save', function()
    {  
        $('#wechatForm').attr('action', v.saveUrl);
        $('#wechatForm').submit();
        return false;
    });

    $(document).on('click', '.btn-reset', function()
    {  
        $('#wechatForm').attr('action', v.resetUrl);
        $('#wechatForm').submit();
        return false;
    });

    $(document).on('click', '.btn-back', function()
    {
        location.href = v.backUrl;
    }); 

    $(document).on('click', '.cp-tile', function()
    {   
        var color = $(this).attr('data-color');
        $('#fontColor').val(color);
        $('#fontColor').css('color','#333');
        $('#wechatForm').attr('action', v.viewUrl);
        $('#wechatForm').submit();
        return false;
    });

    $('.cover').click(function()
    {   
        $('input[type=file]').click();
    })

    $('input[type=file]').change(function()
    {
        $(this).parents('form').submit();
        return false;
    });

    $.setAjaxForm('#coverForm', function(response)
    {
        if(response.result == 'success')
        {
            $('#coverID').val(response.fileID);
            $('.cover').html(response.image);
        }
        else
        {
            bootbox.alert(response.message)
        }
    });
});
