<?php if(!defined("RUN_MODE")) die();?>
<?php
/**
 * The control file of action module of chanzhiEPS.
 *
 * @copyright   Copyright 2009-2015 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZPLV1.2 (http://zpl.pub/page/zplv12.html)
 * @author      Tingting Dai <daitingting@xirangit.com>
 * @package     action 
 * @version     $Id$
 * @link        http://www.zsite.com
 */
class action extends control
{
    /**
     * browse history actions and records. 
     * 
     * @param  string    $objectType
     * @param  int       $objectID 
     * @param  string    $action
     * @param  string    $from
     * @access public
     * @return void
     */
    public function history($objectType, $objectID, $action = '', $from = 'view')
    {
        $this->view->actions    = $this->action->getList($objectType, $objectID, $action);
        $this->view->objectType = $objectType;
        $this->view->objectID   = $objectID;
        $this->view->users      = $this->loadModel('user')->getPairs();
        $this->view->from       = $from;
        $this->view->behavior   = $action;
        $this->display();
    }

    /**
     * Edit comment of an action.
     * 
     * @param  int    $actionID 
     * @access public
     * @return void
     */
    public function editComment($actionID)
    {
        if(!strip_tags($this->post->lastComment)) $this->send(array('result' => 'success', 'locate' => $this->server->http_referer));
        $this->action->updateComment($actionID);
        $this->send(array('result' => 'success', 'message' => $this->lang->saveSuccess, 'locate' => $this->server->http_referer));
    }

    /**
     * Action logs page. 
     * 
     * @param  int    $recTotal 
     * @param  int    $recPerPage 
     * @param  int    $pageID 
     * @access public
     * @return void
     */
    public function admin($recTotal = 0, $recPerPage = 10, $pageID = 1)
    {
        $this->lang->menuGroups->action = 'security';

        $this->loadModel('user');
        $this->app->loadClass('pager', $static = true);
        $pager = new pager($recTotal, $recPerPage, $pageID);
        $actions = $this->action->getList('', '', '', $pager, '', 'admin', 'id_desc');

        $this->lang->action->desc = $this->lang->action->indexDesc;

        $this->view->title        = $this->lang->action->admin;
        $this->view->users        = $this->user->getPairs();
        $this->view->actions      = $actions;
        $this->view->pager        = $pager;
        $this->display(); 
    }

    /**
     * Action browse
     * 
     * @param  string $source admin or front 
     * @param  int    $pageID 
     * @access public
     * @return void
     */
    public function browse($source = 'admin', $pageID = 1)
    {
        $this->loadModel('user');
        $this->app->loadLang('widget');
        $this->app->loadClass('pager', $static = true);
        $pager = new pager($recTotal = 0, 30, $pageID);
        $operationLog = $this->action->getAllList($source, $pager);
        $switchLocal = $source == 'admin' ? 'front' : 'admin';

        $this->lang->action->desc = $this->lang->action->indexDesc;

        $this->view->title        = $this->lang->action->browse;
        $this->view->source       = $source;
        $this->view->switchLocal  = $switchLocal;
        $this->view->operationLog = $operationLog;
        $this->view->users        = $this->user->getPairs();
        $this->view->pageID       = $pageID;
        $this->view->pager        = $pager;
        $this->display(); 
    }
}
