import LayoutPage,{chanzhi} from '../../core/layout-page.js';

LayoutPage({
    onDataLoad: data => {
        data.attractive        = [];
        data.number            = 1;
        data.messageObjectType = "product";
        data.messageObjectID   = data.data.product.id;
        data.messageParam      = {type : 'comment'};
        data.messageClass      = "hide";
        data.attractivestr     = "";
        return data;
    },
    onMessageLoad: data => {},
    clickAttr: function(e){
        var value = e.currentTarget.dataset.value;
        var price = e.currentTarget.dataset.price;
        var attribute = e.currentTarget.dataset.attribute;
        var attractive = this.data.attractive;
        var attractivestr = "";
        var flag = false;
        for (var i = 0; i < attractive.length; i++) 
        { 
            if(attractive[i].attribute == attribute) 
            {
                attractive[i].value = value;
                attractive[i].price = price;
                flag = true;
            }
        }

        if(flag === false) 
        {
            attractive = attractive.concat([{attribute:attribute,value:value,price:price}])
        }

        this.setData({attractive : attractive});

        if(this.data.data.product.promotion)
        {
            price = this.data.data.product.promotion;
        }
        else
        {
            price = this.data.data.product.price;
        }

        for (var i = 0; i < attractive.length; i++) 
        {
            if(attractive[i].price) price = parseFloat(price) + parseFloat(attractive[i].price);
            attractivestr += attractive[i].attribute + '|=|' + attractive[i].value + "||";
        }
        this.setData({attractivestr : attractivestr});
        this.setData({attrprice : price.toFixed(2)});
    },
    addNum: function(e){
        var number = this.data.number;
        number = parseInt(number) + 1;
        this.setData({number : number});
    },
    reduceNum: function(e){
        var number = this.data.number;
        number = parseInt(number) - 1;
        if(number > 0) this.setData({number : number});
    },
    buySubmit: function(e){
        if(e.detail.target.dataset.type == 'addcart')
        {
            if(wx.getStorageSync('token').userInfo)
            {
                e.detail.value.wmpOpenID = wx.getStorageSync('token').wmpOpenID;
                e.detail.value.wmpToken = wx.getStorageSync('token').wmpToken;
            }
            for (var key in e.detail.value) 
            {
                if(key.indexOf('extra') != '-1')
                {
                    var value = e.detail.value[key];
                    delete e.detail.value[key];
                    key = key.replace('[' + this.data.data.product.id + ']', '');
                    e.detail.value[key] = value;
                }
            }
            chanzhi.ajaxPost({
                url: chanzhi.getServerUrl("cart", "add",{'product':this.data.data.product.id,'count':this.data.number}),
                data:  e.detail.value,
                header: {"content-type":"application/x-www-form-urlencoded"}
            }).then(data => {
                const _this = this;
                if(data.result == 'success')
                {
                    _this.setData({msgClass: 'msger-success'});
                    _this.setData({msgInfo: "成功加入购物车"});
                }
                setTimeout(function() {
                    _this.setData({msgClass: "hide"});
                    _this.setData({msgInfo: ""});
                }, 2000);
            })
        }
        else
        {
            wx.setStorageSync('postData', e.detail.value);
            if(wx.getStorageSync('token').userInfo)
            {
                wx.navigateTo({
                    url: '../order/confirm',
                });
            }
            else
            {
                wx.navigateTo({
                    url: '../user/control',
                });
            }
        }
    },
    showMessage: function(e){
        if(this.data.messageClass == 'hide')
        {
            this.setData({messageClass : ""});
        }
        else
        {
            this.setData({messageClass : "hide"});
        }
    },
});
