import LayoutPage,{chanzhi} from '../../core/layout-page.js';

LayoutPage({
    pay: function(e){
        var postData = {'payment': 'wechatpay'};
        if(wx.getStorageSync('token').userInfo)
        {
            postData.wmpOpenID  = wx.getStorageSync('token').wmpOpenID;
            postData.wmpToken   = wx.getStorageSync('token').wmpToken;
        }
        chanzhi.ajaxPost({
            url: chanzhi.getServerUrl("order", "pay",{'orderID':e.currentTarget.dataset.id}),
            data: postData,
            header: {"content-type":"application/x-www-form-urlencoded"}
        }).then(data => {
            chanzhi.ajaxPost({
                url: chanzhi.getServerUrl("order", "wechatpay",{'orderID':e.currentTarget.dataset.id}),
                data: postData,
                header: {"content-type":"application/x-www-form-urlencoded"}
            }).then(data => {
                var out_trade_no = data.data.out_trade_no;
                wx.requestPayment({
                    'timeStamp': data.data.timeStamp,
                    'nonceStr': data.data.timeStamp,
                    'package': data.data.package,
                    'signType': 'MD5',
                    'paySign': data.data.paySign,
                    'success':function(res){
                        wx.setStorageSync('postData', {"return_code":"SUCCESS","out_trade_no":out_trade_no});
                        wx.navigateTo({
                            url: '../order/processorder?type=wechat&mode=notify',
                        });
                    },
                    'fail':function(res){console.log(res)},
                    'complete':function(res){console.log(res)}
                })
            })
        })
    }
})
