import LayoutPage,{chanzhi} from '../../core/layout-page.js';

LayoutPage({
    onDataLoad: data => {
        var count = 0;
        var total_fee = 0;
        var orders = data.data.orders;
        var statusList = {'not_paid':'待付款','paid':'已付款','not_send':'待发货','send':'待收货','confirmed':'已收货','normal':'进行中','finished':'已完成','canceled':'已取消','refunding':'待退款','refunded':'已退款','expired':'已过期'};
        for (var id in orders) 
        {
            count = 0;
            total_fee = 0;
            for (var productID in orders[id].products) 
            {
                count ++;
                total_fee += orders[id].products[productID].count * orders[id].products[productID].price;
            }
            data.data.orders[id].productCount = count;
            data.data.orders[id].total_fee    = total_fee;
            if(orders[id].status == 'finished' || orders[id].status == 'canceled' || orders[id].status == 'expired')
            {
                data.data.orders[id].showStatus = statusList[orders[id].status];
            }
            else if(orders[id].payment == 'COD')
            {
                data.data.orders[id].showStatus = statusList[orders[id].deliveryStatus];
            }
            else if(orders[id].payment != 'COD')
            {
                if(orders[id].status == 'paid')
                {
                    data.data.orders[id].showStatus = statusList[orders[id].deliveryStatus];
                }
                else
                {
                    data.data.orders[id].showStatus = statusList[orders[id].payStatus];
                }
            }
        }
        return data;
    },
})

