import LayoutPage,{chanzhi} from '../../core/layout-page.js';

LayoutPage({
    onDataLoad: data => {
        var count = 0;
        var products = data.data.products;
        for (var id in products) {
            count ++;
        }
        data.countProducts = count;
        data.count         = 0;
        data.total_fee     = 0;
        data.manage        = '管理';
        data.deleterClass  = 'hide';
        data.confirmClass  = '';
        return data;
    },
    cartSubmit: function(e){
        if(e.detail.target.dataset.type == 'deleter')
        {
            var changeProduct = {};
            var carts = '';
            if(this.data.changeProduct) changeProduct = this.data.changeProduct;
            for(var pid in changeProduct) {
                carts = carts + pid + ',';
            }
            if(carts != '')
            {
                var userinfo = {};
                if(wx.getStorageSync('token').userInfo)
                {
                    userinfo.wmpOpenID  = wx.getStorageSync('token').wmpOpenID;
                    userinfo.wmpToken   = wx.getStorageSync('token').wmpToken;
                }
                chanzhi.ajaxPost({
                    url: chanzhi.getServerUrl("cart", "batchdelete", {carts: carts}),
                    data:userinfo,
                    header: {"content-type":"application/x-www-form-urlencoded"}
                });
                wx.redirectTo({
                    url: '../cart/browse',
                });
            }
        }
        else
        {
            wx.setStorageSync('postData', e.detail.value);
            if(wx.getStorageSync('token').userInfo)
            {
                wx.navigateTo({
                    url: '../order/confirm',
                });
            }
            else
            {
                wx.navigateTo({
                    url: '../user/control',
                });
            }
        }
    },
    checkboxChange: function(e){
        var data = this.data.data;
        var changeProduct = {};
        var total_fee = 0;
        var id = e.currentTarget.dataset.id;
        var products = data.products;
        var count = 0;
        if(this.data.changeProduct) changeProduct = this.data.changeProduct;
        if(e.detail.value[0]) 
        {
            products[id].checked = true;
            changeProduct[id] = e.detail.value[0];

            var flag = true;
            for (var id in products) {
                if(products[id].checked !== true) flag = false;
            }
            if(flag === true) this.setData({allCheck : true});
        }
        else 
        {
            products[id].checked = false;
            this.setData({allCheck : false});
            delete changeProduct[id];
        }
        for (var id in products) {
            for(var pid in changeProduct) {
                if(pid == id) 
                {
                    count ++;
                    if(products[id].promotion !== 0) total_fee = (parseFloat(total_fee) + products[id].promotion * products[id].count).toFixed(2);
                    if(products[id].promotion === 0) total_fee = (parseFloat(total_fee) + products[id].price * products[id].count).toFixed(2);
                }
            }
        }
        this.setData({count : count});
        this.setData({total_fee : total_fee});
        this.setData({changeProduct : changeProduct});
        this.setData({data : data});
    },
    allCheck: function(e){
        var data = this.data.data;
        var changeProduct = {};
        var total_fee = 0;
        var products = data.products;
        var count = 0;
        if(this.data.changeProduct) changeProduct = this.data.changeProduct;
        if(e.detail.value[0]) 
        {
            for (var id in products) {
                changeProduct[id] = products[id].product;
                products[id].checked = true;
            }
        }
        else
        {
            for (var id in products) {
                products[id].checked = false;
            }
            changeProduct = {};
        }
        for (var id in products) {
            for(var pid in changeProduct) {
                if(pid == id) 
                {
                    count ++;
                    if(products[id].promotion !== 0) total_fee = (parseFloat(total_fee) + products[id].promotion * products[id].count).toFixed(2);
                    if(products[id].promotion === 0) total_fee = (parseFloat(total_fee) + products[id].price * products[id].count).toFixed(2);
                }
            }
        }
        this.setData({count : count});
        this.setData({total_fee : total_fee});
        this.setData({changeProduct : changeProduct});
        this.setData({data : data});
    },
    addNum: function(e){
        var price     = 0;
        var total_fee = 0;
        var id        = e.currentTarget.dataset.id;
        var data      = this.data.data;
        var products  = data.products;
        var count     = products[id].count;
        var changeProduct = {};
        if(this.data.changeProduct) changeProduct = this.data.changeProduct;

        if(products[id].promotion !== 0)
        {
            price = products[id].promotion;
        }
        else
        {
            price = products[id].price;
        }
        count = parseInt(count) + 1;
        products[id].count = count;
        products[id].total = (count * price).toFixed(2);
        this.setData({data : data});

        for (var id in products) {
            for(var pid in changeProduct) {
                if(pid == id)
                {
                    if(products[id].promotion !== 0) total_fee = (parseFloat(total_fee) + products[id].promotion * products[id].count).toFixed(2);
                    if(products[id].promotion === 0) total_fee = (parseFloat(total_fee) + products[id].price * products[id].count).toFixed(2);
                }
            }
        }
        this.setData({total_fee : total_fee});
    },
    reduceNum: function(e){
        var price     = 0;
        var total_fee = 0;
        var id        = e.currentTarget.dataset.id;
        var data      = this.data.data;
        var products  = data.products;
        var count     = products[id].count;
        var changeProduct = {};
        if(this.data.changeProduct) changeProduct = this.data.changeProduct;

        if(products[id].promotion !== 0)
        {
            price = products[id].promotion;
        }
        else
        {
            price = products[id].price;
        }
        count = parseInt(count) - 1;
        if(count > 0)
        {
            products[id].count = count;
            products[id].total = (count * price).toFixed(2);
            this.setData({data : data});
        }

        for (var id in products) {
            for(var pid in changeProduct) {
                if(pid == id)
                {
                    if(products[id].promotion !== 0) total_fee = (parseFloat(total_fee) + products[id].promotion * products[id].count).toFixed(2);
                    if(products[id].promotion === 0) total_fee = (parseFloat(total_fee) + products[id].price * products[id].count).toFixed(2);
                }
            }
        }
        this.setData({total_fee : total_fee});
    },
    inputNum: function(e){
        var price     = 0;
        var total_fee = 0;
        var id        = e.currentTarget.dataset.id;
        var data      = this.data.data;
        var products  = data.products;
        var count     = e.detail.value;

        if(products[id].promotion !== 0)
        {
            price = products[id].promotion;
        }
        else
        {
            price = products[id].price;
        }
        if(count > 0)
        {
            products[id].count = count;
            products[id].total = (count * price).toFixed(2);
            this.setData({data : data});
        }

        for (var id in products) {
            if(products[id].promotion !== 0) total_fee = (parseFloat(total_fee) + products[id].promotion * products[id].count).toFixed(2);
            if(products[id].promotion === 0) total_fee = (parseFloat(total_fee) + products[id].price * products[id].count).toFixed(2);
        }
        this.setData({total_fee : total_fee});
    },
    manage: function(e)
    {
        if(this.data.manage == '管理')
        {
            this.setData({confirmClass : 'hide'});
            this.setData({deleterClass : ''});
            this.setData({manage : '完成'});
        }
        else
        {
            this.setData({confirmClass : ''});
            this.setData({deleterClass : 'hide'});
            this.setData({manage : '管理'});
        }
    }
})
