import LayoutPage,{chanzhi} from '../../core/layout-page.js';

LayoutPage({
    delete: function(e){
        var userinfo = {};
        if(wx.getStorageSync('userInfo'))
        {
            userinfo.wmpUserInfo = JSON.stringify(wx.getStorageSync('userInfo'));
            userinfo.wmpAccount  = wx.getStorageSync('token').userInfo.account;
        }

        chanzhi.ajaxPost({
            url: chanzhi.getServerUrl("address", "delete", {ids: e.currentTarget.dataset.id}),
            data:userinfo,
            header: {"content-type":"application/x-www-form-urlencoded"}
        }).then(data => {
            const _this = this;
            if(data.result == 'success')
            {
                _this.setData({msgClass: 'msger-success'});
                _this.setData({msgInfo: data.message});
            }

            if(data.result == 'fail')
            {
                if(typeof(data.message) == 'string')
                {
                    _this.setData({msgClass: 'msger-warning'});
                    _this.setData({msgInfo: data.message});
                }
                else if(data.message.content)
                {
                    _this.setData({msgClass: 'msger-warning'});
                    _this.setData({msgInfo: data.message.content});
                }
                else
                {
                    _this.setData({formMsg: data.message});
                }
            }
            setTimeout(function() {
                _this.setData({msgClass: "hide"});
                _this.setData({msgInfo: ""});
            }, 2000);

            if(data.locate) 
            {
                setTimeout(function() {
                    wx.redirectTo({
                        url: chanzhi.convertUrl(data.locate),
                    });
                }, 1000);
            }
        })
    },
})
