package sri.mobile.examples

import scala.scalajs.js.annotation.ScalaJSDefined

import sri.core.ElementFactory._
import sri.core.ReactComponent
import sri.mobile.ReactNative
import sri.universal.components._
import sri.universal.styles.UniversalStyleSheet


object HelloSriMobile {

  @ScalaJSDefined
  class Component extends ReactComponent[Unit, Unit] {

    def render() = {
      View(style = styles.container)(
        Text(style = styles.text)(s"Welcome to Sri Mobile(${ReactNative.Platform.OS})"),
        Image(style = styles.image, source = ImageSource(uri = "http://www.scala-js.org/images/scala-js-logo-256.png"))(),
        Text(style = styles.text)("Scala.js - Future of app development!")
      )
    }
  }

  object styles extends UniversalStyleSheet {

    val container = style(flexOne,
      backgroundColor := "rgb(175, 9, 119)",
      justifyContent.center,
      alignItems.center)

    val image = style(width := 256, height := 256, margin := 20)

    val text = style(fontWeight._500,
      fontSize := 18,
      color := "white")

  }

  def apply() = makeElement[Component]
}
