//! moment.js locale configuration
//! locale : chinese (zh-cn)
//! author : suupic : https://github.com/suupic
//! author : Zeno Zeng : https://github.com/zenozeng

(function (global, factory) {
   typeof exports === 'object' && typeof module !== 'undefined' ? factory(require('../moment')) :
   typeof define === 'function' && define.amd ? define(['moment'], factory) :
   factory(global.moment)
}(this, function (moment) { 'use strict';


    var zh_cn = moment.defineLocale('zh-cn', {
        months : 'һ_________ʮ_ʮһ_ʮ'.split('_'),
        monthsShort : '1_2_3_4_5_6_7_8_9_10_11_12'.split('_'),
        weekdays : '_һ_ڶ____'.split('_'),
        weekdaysShort : '_һ_ܶ____'.split('_'),
        weekdaysMin : '_һ_____'.split('_'),
        longDateFormat : {
            LT : 'Ahmm',
            LTS : 'Ahms',
            L : 'YYYY-MM-DD',
            LL : 'YYYYMMMD',
            LLL : 'YYYYMMMDAhmm',
            LLLL : 'YYYYMMMDddddAhmm',
            l : 'YYYY-MM-DD',
            ll : 'YYYYMMMD',
            lll : 'YYYYMMMDAhmm',
            llll : 'YYYYMMMDddddAhmm'
        },
        meridiemParse: /賿|||||/,
        meridiemHour: function (hour, meridiem) {
            if (hour === 12) {
                hour = 0;
            }
            if (meridiem === '賿' || meridiem === '' ||
                    meridiem === '') {
                return hour;
            } else if (meridiem === '' || meridiem === '') {
                return hour + 12;
            } else {
                // ''
                return hour >= 11 ? hour : hour + 12;
            }
        },
        meridiem : function (hour, minute, isLower) {
            var hm = hour * 100 + minute;
            if (hm < 600) {
                return '賿';
            } else if (hm < 900) {
                return '';
            } else if (hm < 1130) {
                return '';
            } else if (hm < 1230) {
                return '';
            } else if (hm < 1800) {
                return '';
            } else {
                return '';
            }
        },
        calendar : {
            sameDay : function () {
                return this.minutes() === 0 ? '[]Ah[]' : '[]LT';
            },
            nextDay : function () {
                return this.minutes() === 0 ? '[]Ah[]' : '[]LT';
            },
            lastDay : function () {
                return this.minutes() === 0 ? '[]Ah[]' : '[]LT';
            },
            nextWeek : function () {
                var startOfWeek, prefix;
                startOfWeek = moment().startOf('week');
                prefix = this.unix() - startOfWeek.unix() >= 7 * 24 * 3600 ? '[]' : '[]';
                return this.minutes() === 0 ? prefix + 'dddAh' : prefix + 'dddAhmm';
            },
            lastWeek : function () {
                var startOfWeek, prefix;
                startOfWeek = moment().startOf('week');
                prefix = this.unix() < startOfWeek.unix()  ? '[]' : '[]';
                return this.minutes() === 0 ? prefix + 'dddAh' : prefix + 'dddAhmm';
            },
            sameElse : 'LL'
        },
        ordinalParse: /\d{1,2}(||)/,
        ordinal : function (number, period) {
            switch (period) {
            case 'd':
            case 'D':
            case 'DDD':
                return number + '';
            case 'M':
                return number + '';
            case 'w':
            case 'W':
                return number + '';
            default:
                return number;
            }
        },
        relativeTime : {
            future : '%s',
            past : '%sǰ',
            s : '',
            m : '1 ',
            mm : '%d ',
            h : '1 Сʱ',
            hh : '%d Сʱ',
            d : '1 ',
            dd : '%d ',
            M : '1 ',
            MM : '%d ',
            y : '1 ',
            yy : '%d '
        },
        week : {
            // GB/T 7408-1994ԪͽʽϢںʱʾISO 8601:1988Ч
            dow : 1, // Monday is the first day of the week.
            doy : 4  // The week that contains Jan 4th is the first week of the year.
        }
    });

    return zh_cn;

}));