# awesome-terminals
Terminal Emulators

### Android
- [Termux](https://termux.com/) - Termux is an Android terminal emulator and Linux environment app that works directly with no rooting or setup required.

### iOS
- [a-Shell](https://holzschu.github.io/a-Shell_iOS/) - A terminal for iOS, with multiple windows
- [Blink Shell](https://github.com/blinksh/blink) - Blink Mobile Shell for iOS (Mosh based) [https://blink.sh](https://blink.sh)
- [ish](https://github.com/tbodt/ish) - Linux shell for iOS. [https://ish.app](https://ish.app)
- [La Terminal](https://apps.apple.com/us/app/la-terminal/id1629902861) - More than just a simple command-line shell, La Terminal provides a fully-native, first-class touch experience for command-line hackers on iPhone and iPad. [https://blog.xibbon.com/welcome-to-la-terminal/](https://blog.xibbon.com/welcome-to-la-terminal/)

### Linux
- [Alacritty](https://github.com/jwilm/alacritty) - A cross-platform, GPU-accelerated terminal emulator.
- [Contour](https://contour-terminal.org/) - is a modern, actually fast, modal terminal emulator. It aims to be the daily driver of power users looking for modern terminal features.
- [eDEX-UI](https://github.com/GitSquared/edex-ui) - **[DEPRECATED]** A cross-platform, customizable science fiction terminal emulator with advanced monitoring & touchscreen support.
- [Darktile](https://github.com/liamg/darktile) - a GPU rendered terminal emulator designed for tiling window managers.
- [Extraterm](https://github.com/sedwards2009/extraterm) - The swiss army chainsaw of terminal emulators. [https://extraterm.org](https://extraterm.org)
- [foot](https://codeberg.org/dnkl/foot) - A fast, lightweight and minimalistic Wayland terminal emulator.
- [Fyne Terminal](https://github.com/fyne-io/terminal) - A graphical terminal emulator for Linux using Fyne
- [Gnome Terminal](https://github.com/GNOME/gnome-terminal) - A terminal emulator for GNOME.
- [Guake](http://guake-project.org/) - Guake is a top-down terminal for Gnome, and is highly inspirated by the famous terminal used in Quake.
- [Hyper](https://github.com/zeit/hyper) - A terminal built on web technologies.
- [kermit](https://github.com/orhun/kermit) - A VTE-based, simple and froggy terminal emulator.
- [Kitty](https://github.com/kovidgoyal/kitty) - A cross-platform, fast, feature full, GPU based terminal emulator
- [Konsole](https://konsole.kde.org/) - Konsole is a terminal emulator for the K Desktop Environment.
- [Mosh](https://github.com/mobile-shell/mosh) - Mobile Shell.
- [Notty](https://github.com/withoutboats/notty) - **[DEPRECATED]** A new kind of terminal.
- [QTerminal](https://github.com/lxqt/qterminal) - A lightweight Qt-based terminal emulator.
- [Ptyxis](https://gitlab.gnome.org/chergert/ptyxis) - New Container-Focused Terminal Emulator for GNOME.
- [Rio](https://github.com/raphamorim/rio) - A hardware-accelerated GPU terminal emulator powered by WebGPU, focusing to run in desktops and browsers. 
- [ROXTerm](http://roxterm.sourceforge.net/) - ROXTerm is a terminal emulator intended to provide similar features to gnome-terminal, based on the same VTE library.
- [rxvt-unicode](http://software.schmorp.de/pkg/rxvt-unicode.html) - rxvt-unicode is a fork of the well known terminal emulator rxvt.
- [Sakura](https://launchpad.net/sakura) - Sakura is a terminal emulator based just on GTK and VTE.
- [st](https://st.suckless.org/) - st is a simple terminal implementation for X.
- [Tabby](https://github.com/Eugeny/tabby) - A terminal for a more modern age (formerly Terminus) [https://tabby.sh/](https://tabby.sh/)
- [Terminal](https://github.com/elementary/terminal) - Terminal emulator designed for elementary OS.
- [Terminator](https://gnometerminator.blogspot.com/p/introduction.html) - The robot future of terminals.
- [Termit](https://github.com/nonstop/termit) - Terminal emulator based on VTE library with Lua scripting.
- [Termite](https://github.com/thestinger/termite/) - **[OBSOLETED BY ALACRITTY]** A keyboard-centric VTE-based terminal, aimed at use within a window manager with tiling and/or tabbing support.
- [Tilda](https://github.com/lanoxx/tilda) - A Gtk based drop down terminal for Linux and Unix.
- [Tilix](https://github.com/gnunn1/tilix) - Tilix is an advanced GTK3 tiling terminal emulator that follows the Gnome Human Interface Guidelines. [https://gnunn1.github.io/tilix-web/](https://gnunn1.github.io/tilix-web/)
- [Upterm](https://github.com/railsware/upterm) - **[DEPRECATED]** A terminal emulator for the 21st century.
- [Wave Terminal](https://www.waveterm.dev/) - Wave is an open-source, AI-native terminal built for seamless developer workflows with inline rendering, a modern UI, and persistent sessions.
- [Wayst](https://github.com/91861/wayst) - A simple terminal emulator.
- [Wezterm](https://github.com/wez/wezterm) - A GPU-accelerated cross-platform terminal emulator and multiplexer written by @wez and implemented in Rust. [https://wezfurlong.org/wezterm/](https://wezfurlong.org/wezterm/)
- [Xfce Terminal](https://docs.xfce.org/apps/terminal/start) - Modern terminal emulator primarily for the Xfce desktop environment.
- [xTerm](http://invisible-island.net/xterm/) - The xterm program is a terminal emulator for the X Window System.
- [yaft](https://github.com/uobikiemukot/yaft) - yet another framebuffer terminal.
- [Yakuake](https://www.kde.org/applications/system/yakuake/) - Yakuake is a drop-down terminal emulator based on KDE Konsole technology.
- [Zutty](https://github.com/tomscii/zutty) - Unicode terminal with correct VT emulation that uses OpenGL ES Compute Shaders.

### macOS
- [Alacritty](https://github.com/jwilm/alacritty) - A cross-platform, GPU-accelerated terminal emulator.
- Cathode - **[DEPRECATED]** VINTAGE TERMINAL.
- [Contour](https://contour-terminal.org/) - is a modern, actually fast, modal terminal emulator. It aims to be the daily driver of power users looking for modern terminal features.
- [cool-retro-term](https://github.com/Swordfish90/cool-retro-term) - A good looking terminal emulator which mimics the old cathode display.
- [eDEX-UI](https://github.com/GitSquared/edex-ui) - **[DEPRECATED]** A cross-platform, customizable science fiction terminal emulator with advanced monitoring & touchscreen support.
- [Extraterm](https://github.com/sedwards2009/extraterm) - The swiss army chainsaw of terminal emulators. [https://extraterm.org](https://extraterm.org)
- [Fig](https://fig.io/) - **[DEPRECATED]** The next-generation command line. The source of truth for your team’s secrets, scripts, and SSH credentials.
- [Go2Shell](https://zipzapmac.com/Go2Shell) - Opens a terminal window to the current directory in Finder.
- [Hyper](https://github.com/zeit/hyper) - A terminal built on web technologies.
- [iTerm2](https://github.com/gnachman/iTerm2) iTerm2 is a terminal emulator for Mac OS X that does amazing things.
- [Kitty](https://github.com/kovidgoyal/kitty) - A cross-platform, fast, feature full, GPU based terminal emulator
- [MacTerm](https://www.macterm.net/) - Powerful replacement for macOS Terminal, supporting 24-bit color, standard graphics protocols and iTerm2 image sequences and color schemes.
- [Mosh](https://github.com/mobile-shell/mosh) - Mobile Shell.
- [Rio](https://github.com/raphamorim/rio) - A hardware-accelerated GPU terminal emulator powered by WebGPU, focusing to run in desktops and browsers.
- [Tabby](https://github.com/Eugeny/tabby) - A terminal for a more modern age (formerly Terminus) [https://tabby.sh/](https://tabby.sh/)
- [Termbar](https://github.com/vetelko/termbar) - TermBar puts the command line in your Menubar, allowing you to free up screen space, and use it with convinience.
- [Terminology](https://github.com/billiob/terminology) - The best terminal emulator based on the Enlightenment Foundation Libraries. [https://www.enlightenment.org/about-terminology](https://www.enlightenment.org/about-terminology)
- [TotalTerminal](https://totalterminal.binaryage.com/) - A system-wide terminal available on a hot-key. TotalTerminal is a plugin for Terminal.app.
- [Upterm](https://github.com/railsware/upterm) - **[DEPRECATED]** A terminal emulator for the 21st century.
- [Warp](https://www.warp.dev/) - Warp is a blazingly fast, rust-based terminal reimagined from the ground up to work like a modern app.
- [Wave Terminal](https://www.waveterm.dev/) - Wave is an open-source, AI-native terminal built for seamless developer workflows with inline rendering, a modern UI, and persistent sessions.
- [Wezterm](https://github.com/wez/wezterm) - A GPU-accelerated cross-platform terminal emulator and multiplexer written by @wez and implemented in Rust. [https://wezfurlong.org/wezterm/](https://wezfurlong.org/wezterm/)
- [ZOC](https://www.emtec.com/zoc/index.html) - SSH Client and Terminal Emulator for macOS and Windows

### Web
 - [AnderShell 3000](https://github.com/andersevenrud/retro-css-shell-demo) - Retro looking terminal in CSS [https://crt.no/](https://crt.no/)
 - [jQuery Terminal Emulator](https://github.com/jcubic/jquery.terminal) - library for creating web based terminals
 - [Xterm.js](https://github.com/xtermjs/xterm.js) - A terminal for the web. [https://xtermjs.org/](https://xtermjs.org/)

### Windows
- [Alacritty](https://github.com/jwilm/alacritty) - A cross-platform, GPU-accelerated terminal emulator.
- [Cmder](https://github.com/cmderdev/cmder) - Lovely console emulator package for Windows.
- [ConEmu](https://github.com/Maximus5/ConEmu) - Customizable Windows terminal with tabs, splits, quake-style, hotkeys and more.
- [Console](https://sourceforge.net/projects/console/) - Console is a Windows console window enhancement.
- [ConsoleZ](https://github.com/cbucher/console) - Windows console window enhancement. It is a fork of Console project.
- [Contour](https://contour-terminal.org/) - is a modern, actually fast, modal terminal emulator. It aims to be the daily driver of power users looking for modern terminal features.
- [eDEX-UI](https://github.com/GitSquared/edex-ui) - **[DEPRECATED]** A cross-platform, customizable science fiction terminal emulator with advanced monitoring & touchscreen support.
- [Extraterm](https://github.com/sedwards2009/extraterm) - The swiss army chainsaw of terminal emulators. [https://extraterm.org](https://extraterm.org)
- [Fluent Terminal](https://github.com/felixse/FluentTerminal) - A Terminal Emulator based on UWP and web technologies.
- [Hyper](https://github.com/zeit/hyper) - A terminal built on web technologies.
- [KiTTY](http://kitty.9bis.net/) - Fork from version 0.67 of PuTTY, the best telnet / SSH client in the world.
- [MobaXterm](https://mobaxterm.mobatek.net/) - Enhanced terminal for Windows with X11 server, tabbed SSH client, network tools and much more.
- [Mosh](https://github.com/mobile-shell/mosh) - Mobile Shell.
- [Rio](https://github.com/raphamorim/rio) - A hardware-accelerated GPU terminal emulator powered by WebGPU, focusing to run in desktops and browsers.
- [PuTTY](https://www.putty.org/) - SSH and telnet client, developed originally by Simon Tatham for the Windows platform.
- [Tabby](https://github.com/Eugeny/tabby) - A terminal for a more modern age (formerly Terminus) [https://tabby.sh/](https://tabby.sh/)
- [Terminology](https://github.com/billiob/terminology) - The best terminal emulator based on the Enlightenment Foundation Libraries [http://terminolo.gy/)](http://terminolo.gy/)
- [Wezterm](https://github.com/wez/wezterm) - A GPU-accelerated cross-platform terminal emulator and multiplexer written by @wez and implemented in Rust. [https://wezfurlong.org/wezterm/](https://wezfurlong.org/wezterm/)
- [Windows Terminal](https://github.com/microsoft/terminal) -  The new Windows Terminal, and the original Windows console host - all in the same place!
- [wsltty](https://github.com/mintty/wsltty) - Mintty as a terminal for Bash on Ubuntu on Windows / WSL. It has the look and feel of PuTTY.
- [ZOC](https://www.emtec.com/zoc/index.html) - SSH Client and Terminal Emulator for macOS and Windows

## Shells
- [fish](https://github.com/fish-shell/fish-shell) - The user-friendly command line shell.
- [GNU Bash](https://git.savannah.gnu.org/cgit/bash.git/) - Bash is the GNU Project's Bourne Again SHell, a complete implementation of the POSIX shell spec.
- [Murex](https://github.com/lmorg/murex) - A smarter shell and scripting environment with advanced features designed for usability, safety and productivity [https://murex.rocks](https://murex.rocks)
- [Nu Shell](https://github.com/nushell/nushell) - A new type of shell.
- [Oils](https://github.com/oilshell/oil) - Oils is a new Unix shell. It's our upgrade path from bash to a better language and runtime. It's also for Python and JavaScript users who avoid shell!
- [PowerShell](https://github.com/PowerShell/PowerShell) - PowerShell for every system!
- [xonsh](https://github.com/xonsh/xonsh) - 🐚 Python-powered, cross-platform, Unix-gazing shell
- [Z Shell](https://sourceforge.net/p/zsh/code/ci/master/tree/) - Zsh is a shell designed for interactive use, although it is also a powerful scripting language. [https://www.zsh.org/](https://www.zsh.org/)

## Tools
### Bash
 - [basher](https://github.com/basherpm/basher) - A package manager for shell scripts. [https://www.basher.it/](https://www.basher.it/)
 - [bashtop](https://github.com/aristocratos/bashtop) - Linux resource monitor.
 - [ble.sh](https://github.com/akinomyoga/ble.sh) - Bash Line Editor -- a full-featured line editor written in pure Bash! Syntax highlighting, auto suggestions, vim modes, etc. are available in Bash interactive sessions!
 - [desk](https://github.com/jamesob/desk) - A lightweight workspace manager for the shell.
 - [dn](https://github.com/tomlockwood/dn) - Daily notes command line tool
 - [emojify](https://github.com/mrowa44/emojify) - Emoji on the command line 😱.
 - [fff](https://github.com/dylanaraps/fff) - 📁 A simple file manager written in bash.
 - [fuck](https://github.com/EricFreeman/fuck) - Fix command line spelling errors like it's 1999.
 - [gg](https://github.com/qw3rtman/gg) - Git Goodies: At-A-Glance, Efficient, and Aesthetically Pleasing Git Shortcuts [https://git.io/gitgoodies](https://git.io/gitgoodies)
 - [has](https://github.com/kdabir/has) - ✅ checks presence of various command line tools and their versions on the path.
 - [lsix](https://github.com/hackerb9/lsix) - Like "ls", but for images. Shows thumbnails in terminal using sixel graphics.
 - [neofetch](https://github.com/dylanaraps/neofetch) - A command-line system information tool written in bash 3.2+.
 - [prettyping](https://github.com/denilsonsa/prettyping) - `prettyping` is a wrapper around the standard `ping` tool, making the output prettier, more colorful, more compact, and easier to read. [http://denilsonsa.github.io/prettyping](http://denilsonsa.github.io/prettyping)
 - [pwd.sh](https://github.com/drduh/pwd.sh) - GPG symmetric password manager.
 - [p2pvc](https://github.com/mofarrell/p2pvc) - A point to point color terminal video chat.
 - [ramfetch](https://codeberg.org/jahway603/ramfetch) - Fetchs memory info using /proc/meminfo.
 - [screenfetch](https://github.com/KittyKatt/screenFetch) - Fetches system/theme information in terminal for Linux desktop screenshots.
 - [Sensible Bash](https://github.com/mrzool/bash-sensible) - An attempt at saner Bash defaults. [https://github.com/mrzool/bash-sensible/blob/master/sensible.bash](https://github.com/mrzool/bash-sensible/blob/master/sensible.bash)
 - [slacktee](https://github.com/coursehero/slacktee) - slacktee is a bash script that works like tee command. Instead of writing the standard input to files, slacktee posts it to Slack.
### C
 - [afetch](https://github.com/13-CF/afetch) - Simple system info written in C
 - [ag](https://github.com/ggreer/the_silver_searcher) - A code-searching tool similar to ack, but faster. [https://geoff.greer.fm/ag/](https://geoff.greer.fm/ag/)
 - [atop](https://github.com/Atoptool/atop) - System and process monitor for Linux.
 - [catimage](https://github.com/posva/catimg) - 🦦 Insanely fast image printing in your terminal.
 - [chafa](https://github.com/hpjansson/chafa) - 📺🗿 Terminal graphics for the 21st century.
 - [fastfetch](https://github.com/LinusDierheimer/fastfetch) - Like neofetch, but much faster because written in c. Only Linux.
 - [hashcat](https://github.com/hashcat/hashcat-legacy) - Advanced CPU-based password recovery utility.
 - [htop](https://github.com/hishamhm/htop) - htop is an interactive text-mode process viewer for Unix systems. It aims to be a better 'top'.
 - [hstr](https://github.com/dvorka/hstr) - bash and zsh shell history suggest box - easily view, navigate, search and manage your command history.
 - [imgcat](https://github.com/eddieantonio/imgcat) - It's like cat, but for images.
 - [jo](https://github.com/jpmens/jo) - JSON output from a shell. [https://jpmens.net/2016/03/05/a-shell-command-to-create-json-jo/](https://jpmens.net/2016/03/05/a-shell-command-to-create-json-jo/)
 - [jq](https://github.com/stedolan/jq) - Command-line JSON processor. [https://stedolan.github.io/jq/](https://stedolan.github.io/jq/)
 - [mptun](https://github.com/cloudwu/mptun) - Multi-path Tunnel.
 - [nnn](https://github.com/jarun/nnn) - n³ The unorthodox terminal file manager.
 - [progress](https://github.com/Xfennec/progress) - Linux tool to show progress for cp, mv, dd, ... (formerly known as cv).
 - [pv](https://ivarch.com/programs/pv.shtml) - Pipe Viewer - is a terminal-based tool for monitoring the progress of data through a pipeline.
 - [smenu](https://github.com/p-gen/smenu) -  Terminal utility that reads words from standard input or from a file and creates an interactive selection window just below the cursor. The selected word(s) are sent to standard output for further processing.
 - [tmux](https://github.com/tmux/tmux) - tmux is a terminal multiplexer.
 - [xhyve](https://github.com/machyve/xhyve) - xhyve, a lightweight OS X virtualization solution.
 - [ttyd](https://github.com/tsl0922/ttyd) - Share your terminal over the web.
 - [vifm](https://github.com/vifm/vifm) - Vifm is a file manager with curses interface, which provides Vi[m]-like environment for managing objects within file systems, extended with some useful ideas from mutt. [https://github.com/vifm/vifm](https://github.com/vifm/vifm)
 - [yank](https://github.com/mptre/yank) - Yank terminal output to clipboard.
 - [zstd](https://github.com/facebook/zstd) - Zstandard - Fast real-time compression algorithm [http://www.zstd.net](http://www.zstd.net)
### C++
 - [flameshot](https://github.com/flameshot-org/flameshot) - Powerful yet simple to use screenshot software 🖥️ 📸.
 - [guetzli](https://github.com/google/guetzli) - Perceptual JPEG encoder.
 - [mazegen](https://github.com/razimantv/mazegenerator) - Generate mazes of different shapes and arbitrary sizes.
 - [openalpr](https://github.com/openalpr/openalpr) - Automatic License Plate Recognition library [http://www.openalpr.com](http://www.openalpr.com)
 - [timew](https://github.com/GothenburgBitFactory/timewarrior) - Commandline Time Reporting
 - [timg](https://github.com/hzeller/timg) - A terminal image viewer.
 - [vtm](https://github.com/netxs-group/VTM) - Terminal multiplexer with TUI window manager and multi-party session sharing [https://vtm.netxs.online/](https://vtm.netxs.online/)
 - [watchman](https://github.com/facebook/watchman) - Watches files and records, or triggers actions, when they change. [https://facebook.github.io/watchman/](https://facebook.github.io/watchman/)
 - [winget](https://github.com/microsoft/winget-cli) - Windows Package Manager CLI (aka winget).
 - [zindex](https://github.com/mattgodbolt/zindex) - Create an index on a compressed text file.
### CMD
 - [gg](https://github.com/qw3rtman/gg) - Git Goodies: At-A-Glance, Efficient, and Aesthetically Pleasing Git Shortcuts [https://git.io/gitgoodies](https://git.io/gitgoodies)
### Go
 - [3mux](https://github.com/aaronjanse/3mux) - Terminal multiplexer inspired by i3.
 - [bit](https://github.com/chriswalz/bit) - Bit is a modern Git CLI.
 - [browsh](https://github.com/browsh-org/browsh) - A fully-modern text-based browser, rendering to TTY and browsers. [https://www.brow.sh/](https://www.brow.sh/)
 - [ccat](https://github.com/jingweno/ccat) - Colorizing `cat`.
 - [cheat](https://github.com/cheat/cheat) - cheat allows you to create and view interactive cheatsheets on the command-line. It was designed to help remind *nix system administrators of options for commands that they use frequently, but not frequently enough to remember.
 - [cointop](https://github.com/miguelmota/cointop) - The fastest and most interactive terminal based UI application for tracking cryptocurrencies. [https://cointop.sh](https://cointop.sh)
 - [comcast](https://github.com/tylertreat/comcast) - Simulating shitty network connections so you can build better systems.
 - [croc](https://github.com/schollz/croc) - Easily and securely send things from one computer to another 🐊 📦.
 - [curlie](https://github.com/rs/curlie) - The power of curl, the ease of use of httpie. [https://curlie.io/](https://curlie.io/)
 - [devd](https://github.com/cortesi/devd) - A local webserver for developers.
 - [direnv](https://github.com/direnv/direnv) - unclutter your .profile. [http://direnv.net](http://direnv.net)
 - [dive](https://github.com/wagoodman/dive) - A tool for exploring each layer in a docker image.
 - [duf](https://github.com/muesli/duf) - Disk Usage/Free Utility.
 - [frangipanni](https://github.com/birchb1024/frangipanni) - Program to convert lines of text into a tree structure.
 - [fsql](https://github.com/kashav/fsql) - Search through your filesystem with SQL-esque queries.
 - [fzf](https://github.com/junegunn/fzf) - A command-line fuzzy finder.
 - [furious](https://github.com/liamg/furious) - Golang IP/port scanner with SYN (stealth) scanning and device manufacturer identification.
 - [gh](https://github.com/cli/cli) - GitHub’s official command line tool
 - [ghq](https://github.com/motemen/ghq) - Remote repository management made easy.
 - [glow](https://github.com/charmbracelet/glow) - Render markdown on the CLI, with pizzazz! 💅🏻
 - [goaccess](https://github.com/allinurl/goaccess) - GoAccess is a real-time web log analyzer and interactive viewer that runs in a terminal in \*nix systems or through your browser. [https://goaccess.io](https://goaccess.io)
 - [goterpix](https://github.com/FinecoFinit/goterpix) - Draw pixel art images with Ansi Escape code.
 - [gotop](https://github.com/cjbassi/gotop) - **[DEPRECATED]** A terminal based graphical activity monitor inspired by gtop and vtop.
 - [gotty](https://github.com/yudai/gotty) - Share your terminal as a web application.
 - [grit](https://github.com/climech/grit) - Multitree-based personal task manager.
 - [gum](https://github.com/charmbracelet/gum) - A tool for glamorous shell scripts 🎀
 - [hostyoself](https://github.com/schollz/hostyoself) - Host yo' self from your browser, your phone, your toaster. [https://hostyoself.com](https://hostyoself.com)
 - [hub](https://github.com/github/hub) - A command-line tool that makes git easier to use with GitHub. [https://hub.github.com/](https://hub.github.com/)
 - [hyperfox](https://github.com/malfunkt/hyperfox) - HTTP/HTTPs MITM proxy and traffic recorder with on-the-fly TLS cert generation.
 - [inlets](https://github.com/alexellis/inlets) -  Expose your local endpoints to the Internet. [https://blog.alexellis.io/https-inlets-local-endpoints/](https://blog.alexellis.io/https-inlets-local-endpoints/)
 - [lazygit](https://github.com/jesseduffield/lazygit) - Simple terminal UI for git commands.
 - [mkcert](https://github.com/FiloSottile/mkcert) - A simple zero-config tool to make locally trusted development certificates with any names you'd like. [https://mkcert.dev](https://mkcert.dev)
 - [micro](https://github.com/zyedidia/micro) - A modern and intuitive terminal-based text editor. [https://micro-editor.github.io/](https://micro-editor.github.io/)
 - [mole](https://github.com/davrodpin/mole) - cli app to create ssh tunnels [https://davrodpin.github.io/mole/](https://davrodpin.github.io/mole/)
 - [noti](https://github.com/variadico/noti) - Monitor a process and trigger a notification.
 - [piknik](https://github.com/jedisct1/piknik) - Copy/paste anything over the network.
 - [plow](https://github.com/six-ddc/plow) - A high-performance HTTP benchmarking tool with real-time web UI and terminal displaying
 - [pup](https://github.com/ericchiang/pup) - Parsing HTML at the command line.
 - [qrcp](https://github.com/claudiodangelis/qrcp) - Transfer files over wifi from your computer to your mobile device by scanning a QR code without leaving the terminal. [https://claudiodangelis.com/qrcp](https://claudiodangelis.com/qrcp)
 - [ran](https://github.com/m3ng9i/ran) - a simple static web server written in Go.
 - [reflex](https://github.com/cespare/reflex) - Run a command when files change.
 - [rtop](https://github.com/rapidloop/rtop) - rtop is an interactive, remote system monitoring tool based on SSH. [http://www.rtop-monitor.org/](http://www.rtop-monitor.org/)
 - [s](https://github.com/zquestz/s) - Open a web search in your terminal.
 - [sampler](https://github.com/sqshq/sampler) - A tool for shell commands execution, visualization and alerting. Configured with a simple YAML file. [https://sampler.dev](https://sampler.dev)
 - [scc](https://github.com/boyter/scc) -  Sloc, Cloc and Code: scc is a very fast accurate code counter with complexity calculations and COCOMO estimates written in pure Go.
 - [screego](https://github.com/screego/server) - Screen sharing for developers. [https://screego.net/](https://screego.net/)
 - [slides](https://github.com/maaslalani/slides) - Terminal based presentation tool [https://maaslalani.com/slides/](https://maaslalani.com/slides/)
 - [switcher](https://github.com/jamescun/switcher) - Run SSH and HTTP(S) on the same port.
 - [termshark](https://github.com/gcla/termshark) - A terminal UI for tshark, inspired by Wireshark.
 - [ticker](https://github.com/achannarasappa/ticker) - Terminal stock ticker with live updates and position tracking.
 - [up](https://github.com/akavel/up) - Ultimate Plumber is a tool for writing Linux pipes with instant live preview.
 - [webtty](https://github.com/maxmcd/webtty) - Share a terminal session over WebRTC [https://maxmcd.github.io/webtty/](https://maxmcd.github.io/webtty/)
 - [wego](https://github.com/schachmat/wego) -  weather app for the terminal.
 - [wtf](https://github.com/wtfutil/wtf) - The personal information dashboard for your terminal. [http://wtfutil.com](http://wtfutil.com)
### Haskell
 - [bench](https://github.com/Gabriel439/bench) - Command-line benchmark tool.
 - [pandoc](https://github.com/jgm/pandoc) - Universal markup converter [https://pandoc.org](https://pandoc.org)
 - [shellcheck](https://github.com/koalaman/shellcheck) - ShellCheck, a static analysis tool for shell scripts. [https://www.shellcheck.net/](https://www.shellcheck.net/)
### Node
 - [catj](https://github.com/soheilpro/catj) - Displays JSON files in a flat format.
 - [cash](https://github.com/dthree/cash) - Cross-platform Linux commands in ES6.
 - [fkill](https://github.com/sindresorhus/fkill-cli) - Fabulously kill processes. Cross-platform.
 - [football](https://github.com/manrajgrover/football-cli) - ⚽ Command line interface for Hackers who love football.
 - [git-stats](https://github.com/IonicaBizau/git-stats) - 🍀 Local git statistics including GitHub-like contributions calendars.
 - [gtop](https://github.com/aksakalli/gtop) - System monitoring dashboard for terminal.
 - [hn](https://github.com/rafaelrinaldi/hn-cli) - 📰 CLI to browse Hacker News.
 - [moro](https://github.com/albacoretuna/moro) - Simple CLI tool for tracking work hours [https://moro.js.org/](https://moro.js.org/)
 - [nativefier](https://github.com/jiahaog/nativefier) -  Make any web page a desktop application.
 - [pdf-bot](https://github.com/esbenp/pdf-bot) - 🤖 A Node queue API for generating PDFs using headless Chrome. Comes with a CLI, S3 storage and webhooks for notifying subscribers about generated PDFs.
 - [percollate](https://github.com/danburzo/percollate) - 🌐 → 📖 A command-line tool to turn web pages into beautifully formatted PDFs.
 - [readme](https://github.com/kefranabg/readme-md-generator) - CLI that generates beautiful README.md files. [https://www.npmjs.com/package/readme-md-generator](https://www.npmjs.com/package/readme-md-generator)
 - [resume](https://github.com/jsonresume/resume-cli) - CLI tool to easily setup a new resume.
 - [rtail](https://github.com/kilianc/rtail) - Terminal output to the browser in seconds, using UNIX pipes. [http://rtail.org](http://rtail.org)
 - [screenshoteer](https://github.com/vladocar/screenshoteer) - Make website screenshots and mobile emulations from the command line.
 - [slim](https://github.com/ottomatica/slim) - Build and run tiny vms from Dockerfiles. Small and sleek.
 - [stacks-cli](https://github.com/WeiChiaChang/stacks-cli) - 📊 Analyze website stack from the terminal 💻.
 - [splash](https://github.com/splash-cli/splash-cli) - 📸 Beautiful wallpapers from Unsplash 🖼️🛠️
 - [terminalizer](https://github.com/faressoft/terminalizer) - 🦄 Record your terminal and generate animated gif images or share a web player.
 - [tldr](https://github.com/tldr-pages/tldr) - Collaborative cheatsheets for console commands [https://tldr.sh/](https://tldr.sh/)
 - [trash](https://github.com/sindresorhus/trash) - Move files and directories to the trash.
 - [unfluff](https://github.com/ageitgey/node-unfluff) - Automatically extract body content (and other cool stuff) from an html document.
 - [vtop](https://github.com/MrRio/vtop) - Wow such top. So stats. More better than regular top. [http://parall.ax/vtop](http://parall.ax/vtop)
 - [youtube-dl-interactive](https://github.com/synox/youtube-dl-interactive) - Interactively select the quality and format for youtube-dl.
 - [zx](https://github.com/google/zx) - A tool for writing better scripts
### PowerShell
 - [commando-vm](https://github.com/fireeye/commando-vm) - Complete Mandiant Offensive VM (Commando VM), a fully customizable Windows-based pentesting virtual machine distribution. commandovm@fireeye.com. [https://www.fireeye.com/blog/threat-research/2019/08/commando-vm-customization-containers-kali.html](https://www.fireeye.com/blog/threat-research/2019/08/commando-vm-customization-containers-kali.html)
### Python
 - [asciinema](https://github.com/asciinema/asciinema) - Terminal session recorder 📹 [https://asciinema.org](https://asciinema.org)
 - [bashhub](https://github.com/rcaloras/bashhub-client) - Bash history in the cloud. Indexed and searchable. [https://bashhub.com](https://bashhub.com)
 - [bpytop](https://github.com/aristocratos/bpytop) - Linux/OSX/FreeBSD resource monitor.
 - [buku](https://github.com/jarun/buku) - Browser-independent bookmark manager
 - [datasette](https://github.com/simonw/datasette) - A tool for exploring and publishing data. [http://datasette.readthedocs.io/](http://datasette.readthedocs.io/)
 - [face_recognition](https://github.com/ageitgey/face_recognition) - The world's simplest facial recognition api for Python and the command line.
 - [fpp](https://github.com/facebook/PathPicker) - PathPicker accepts a wide range of input -- output from git commands, grep results, searches -- pretty much anything.After parsing the input, PathPicker presents you with a nice UI to select which files you're interested in. After that you can open them in your favorite editor or execute arbitrary commands. [http://facebook.github.io/PathPicker/](http://facebook.github.io/PathPicker/)
 - [fuck](https://github.com/nvbn/thefuck) - Magnificent app which corrects your previous console command.
 - [hn](https://github.com/donnemartin/haxor-news) -  Browse Hacker News like a haxor: A Hacker News command line interface (CLI).
 - [howmanypeoplearearound](https://github.com/schollz/howmanypeoplearearound) - Count the number of people around you 👨‍👨‍👦 by monitoring wifi signals 📡.
 - [glances](https://github.com/nicolargo/glances) - Glances an Eye on your system. A top/htop alternative for GNU/Linux, BSD, Mac OS and Windows operating systems. [http://nicolargo.github.io/glances/](http://nicolargo.github.io/glances/)
 - [httpie](https://github.com/jakubroztocil/httpie) - As easy as HTTPie /aitch-tee-tee-pie/ 🥧 Modern command line HTTP client – user-friendly curl alternative with intuitive UI, JSON support, syntax highlighting, wget-like downloads, extensions, etc. [https://httpie.org](https://httpie.org)
 - [http-prompt](https://github.com/eliangcs/http-prompt) - HTTPie + prompt_toolkit = an interactive command-line HTTP client featuring autocomplete and syntax highlighting. [http://http-prompt.com](http://http-prompt.com)
 - [itermocil](https://github.com/TomAnthony/itermocil) - Create pre-defined window/pane layouts and run commands in iTerm.
 - [jungle](https://github.com/achiku/jungle) - AWS operations by cli should be simpler.
 - [kb](https://github.com/gnebbia/kb) - A minimalist command line knowledge base manager.
 - [legofy](https://github.com/JuanPotato/Legofy) - Make images look as if they are made out of 1x1 LEGO blocks.
 - [linkchecker](https://github.com/wummel/linkchecker) - check links in web documents or full websites. [http://wummel.github.io/linkchecker/](http://wummel.github.io/linkchecker/)
 - [mycli](https://github.com/dbcli/mycli) - A Terminal Client for MySQL with AutoCompletion and Syntax Highlighting. [http://mycli.net](http://mycli.net)
 - [outrun](https://github.com/Overv/outrun) - Execute a local command using the processing power of another Linux machine.
 - [present](https://github.com/vinayak-mehta/present) - A terminal-based presentation tool with colors and effects. [https://present.readthedocs.io/en/latest/](https://present.readthedocs.io/en/latest/)
 - [py](https://github.com/Russell91/pythonpy) - the swiss army knife of the command line.
 - [ranger](https://github.com/ranger/ranger) - A VIM-inspired filemanager for the console [https://ranger.github.io/](https://ranger.github.io/)
 - [rockstar](https://github.com/avinassh/rockstar) - Makes you a Rockstar C++ Programmer in 2 minutes.
 - [soccer](https://github.com/architv/soccer-cli) - ⚽️ Football scores for hackers. 💻 A command line interface for all the football scores.
 - [statuspage](https://github.com/jayfk/statuspage) - A statuspage generator that lets you host your statuspage for free on Github.
 - [stellar](https://github.com/fastmonkeys/stellar) - Fast database snapshot and restore tool for development.
 - [repk](https://github.com/rahulunair/repo-peek) - open a remote repo locally quickly
 - [td](https://github.com/darrikonn/td-cli) - A todo command line todo manager ✔️ [https://pypi.org/project/td-cli/](https://pypi.org/project/td-cli/)
 - [termius](https://github.com/termius/termius-cli) - CLI for the ssh client Termius [https://termius.com](https://termius.com).
 - [tldr](https://github.com/tldr-pages/tldr) - 📚 Simplified and community-driven man pages [https://tldr.sh](https://tldr.sh)
 - [twtxt](https://github.com/buckket/twtxt) - Decentralised, minimalist microblogging service for hackers. [https://twtxt.readthedocs.io/en/stable/](https://twtxt.readthedocs.io/en/stable/)
 - [wifiphisher](https://github.com/wifiphisher/wifiphisher) - The Rogue Access Point Framework [https://wifiphisher.org](https://wifiphisher.org)
 - [xxh](https://github.com/xxh/xxh) - 🚀 Bring your favorite shell wherever you go through the ssh.
 - [you-get](https://github.com/soimort/you-get) - ⏬ Dumb downloader that scrapes the web [https://you-get.org/](https://you-get.org/)
 - [youtube-dl](https://github.com/ytdl-org/youtube-dl) - Command-line program to download videos from YouTube.com and other video sites [http://ytdl-org.github.io/youtube-dl/](http://ytdl-org.github.io/youtube-dl/)
 - [yt-dlp](https://github.com/yt-dlp/yt-dlp) - A youtube-dl fork with additional features and fixes
 - [yts](https://github.com/darkHarry/yts-cli) - A Python script to download yts movies with the help of transmission-gtk torrent client.
### Ruby
 - [doing](https://github.com/ttscoff/doing) - A command line tool for remembering what you were doing and tracking what you've done.
 - [facebook-cli](https://github.com/specious/facebook-cli) - 💻 Facebook command line tool [https://asciinema.org/a/87129](https://asciinema.org/a/87129)
 - [hibp](https://github.com/michenriksen/hibp) - A simple tool to check a bunch of email addresses against the Have I Been Pwned API. [https://rubygems.org/gems/hibp](https://rubygems.org/gems/hibp)
 - [htty](https://github.com/htty/htty) - htty is the HTTP TTY, a console application for interacting with web servers. [http://htty.github.io](http://htty.github.io)
 - [teamocil](https://github.com/remi/teamocil) - Teamocil is a simple tool used to automatically create windows and panes in tmux with YAML files.
 - [tmuxinator](https://github.com/tmuxinator/tmuxinator) -  Manage complex tmux sessions easily.
### Rust
 - [amp](https://github.com/jmacdonald/amp) - A complete text editor for your terminal.
 - [atm](https://github.com/allthemusicllc/atm-cli) - Command line tool for generating and working with MIDI files.[http://allthemusic.info](http://allthemusic.info)
 - [atuin](https://github.com/atuinsh/atuin) - ✨ Magical shell history [https://atuin.sh/](https://atuin.sh/)
 - [bandwhich](https://github.com/imsnif/bandwhich) - Terminal bandwidth utilization tool.
 - [bat](https://github.com/sharkdp/bat) - A cat(1) clone with wings.
 - [br](https://github.com/Canop/broot) - A new way to see and navigate directory trees [https://dystroy.org/broot](https://dystroy.org/broot)
 - [btm](https://github.com/ClementTsang/bottom) - Yet another cross-platform graphical process/system monitor. [https://clementtsang.github.io/bottom/nightly/](https://clementtsang.github.io/bottom/nightly/)
 - [choose](https://github.com/theryangeary/choose) - A human-friendly and fast alternative to cut and (sometimes) awk
 - [coreutils](https://github.com/uutils/coreutils) -  Cross-platform Rust rewrite of the GNU coreutils.
 - [delta](https://github.com/dandavison/delta) - A viewer for git and diff output
 - [difft](https://github.com/Wilfred/difftastic) - a structural diff that understands syntax 🟥🟩
 - [dog](https://github.com/ogham/dog) - A command-line DNS client. [https://dns.lookup.dog/](https://dns.lookup.dog/)
 - [dua](https://github.com/Byron/dua-cli) - View disk space usage and delete unwanted data, fast. [https://lib.rs/crates/dua-cli](https://lib.rs/crates/dua-cli)
 - [dust](https://github.com/bootandy/dust) - A more intuitive version of du in rust.
 - [eureka](https://github.com/simeg/eureka) - 💡 CLI tool to input and store your ideas without leaving the terminal.
 - [exa](https://github.com/ogham/exa) - **[DEPRECATED]** A modern version of ‘ls’. [https://the.exa.website/](https://the.exa.website/)
 - [eza](https://github.com/eza-community/eza) - A modern version of ‘ls’. [https://eza.rocks/](https://eza.rocks/)
 - [fd](https://github.com/sharkdp/fd) - A simple, fast and user-friendly alternative to 'find'
 - [findomain](https://github.com/Edu4rdSHL/findomain) - The fastest and cross-platform subdomain enumerator, don't waste your time.
 - [gping](https://github.com/orf/gping) - Ping, but with a graph.
 - [grex](https://github.com/pemistahl/grex) - A command-line tool and library for generating regular expressions from user-provided test cases.
 - [hx](https://github.com/helix-editor/helix) - A post-modern modal text editor.
 - [hexyl](https://github.com/sharkdp/hexyl) - A command-line hex viewer.
 - [hyperfine](https://github.com/sharkdp/hyperfine) - A command-line benchmarking tool.
 - [joshuto](https://github.com/kamiyaa/joshuto) - ranger-like terminal file manager written in Rust
 - [loc](https://github.com/cgag/loc) - Count lines of code quickly.
 - [lsd](https://github.com/Peltoche/lsd) - The next gen ls command.
 - [mcfly](https://github.com/cantino/mcfly) - Fly through your shell history. Great Scott!
 - [navi](https://github.com/denisidoro/navi) - An interactive cheatsheet tool for the command-line.
 - [pastel](https://github.com/sharkdp/pastel) - A command-line tool to generate, analyze, convert and manipulate colors.
 - [procs](https://github.com/dalance/procs) - A modern replacement for ps written in Rust.
 - [rg](https://github.com/BurntSushi/ripgrep) - ripgrep recursively searches directories for a regex pattern.
 - [rq](https://github.com/dflemstr/rq) - Record Query - A tool for doing record analysis and transformation.
 - [sd](https://github.com/chmln/sd) - Intuitive find & replace CLI (sed alternative).
 - [spt](https://github.com/Rigellute/spotify-tui) - Spotify for the terminal written in Rust 🚀
 - [starship](https://github.com/starship/starship) - ☄🌌️ The cross-shell prompt for astronauts. [https://starship.rs](https://starship.rs)
 - [tldr](https://github.com/dbrgn/tealdeer) - A very fast implementation of tldr in Rust.
 - [tokei](https://github.com/XAMPPRocky/tokei) - Count your code, quickly.
 - [tre](https://github.com/dduan/tre) - Tree command, improved.
 - [viu](https://github.com/atanunq/viu) - Simple terminal image viewer written in Rust.
 - [xh](https://github.com/ducaale/xh) - Friendly and fast tool for sending HTTP requests
 - [weztermocil](https://github.com/alexcaza/weztermocil) - Automatically create windows and panes in Wezterm via YAML configs (like Teamocil and iTermocil).
 - [xsv](https://github.com/BurntSushi/xsv) - A fast CSV command line toolkit written in Rust.
 - [z](https://github.com/ajeetdsouza/zoxide) - A faster way to navigate your filesystem.
 - [zellij](https://github.com/zellij-org/zellij) - A terminal workspace with batteries included. [https://zellij.dev/](https://zellij.dev/)
 - [zenith](https://github.com/bvaisvil/zenith) - sort of like top or htop but with zoom-able charts, CPU, GPU, network, and disk usage.
 - [zoxide](https://github.com/ajeetdsouza/zoxide) - A smarter cd command. Supports all major shells.
### sh
 - [ansiweather](https://github.com/fcambus/ansiweather) - Weather in terminal, with ANSI colors and Unicode symbols
 - [nb](https://github.com/xwmx/nb) - CLI plain-text note-taking, bookmarking, and archiving with encryption, filtering and search, Git-backed versioning and syncing, Pandoc-backed conversion, and more in a single portable script. [https://xwmx.github.io/nb/](https://xwmx.github.io/nb/)
 - [nvm](https://github.com/nvm-sh/nvm) - Node Version Manager - POSIX-compliant bash script to manage multiple active node.js versions.
 - [shellfire](https://github.com/shellfire-dev/shellfire) - A repository of namespaced, composable shell (bash, sh and dash) function libraries. Takes aware the pain of shell scripting, making it robust and reusable. Includes secure curl usage, JSON, XML and Debian control file parsers, dependency documentation via attributes, and more. Batteries ARE included.
 - [takeover.sh](https://github.com/marcan/takeover.sh) - Wipe and reinstall a running Linux system via SSH, without rebooting. You know you want to.
 - [tmux-fzf-url](https://github.com/wfxr/tmux-fzf-url) - 🚀 Quickly open urls on terminal screen!
 - [tuxi](https://github.com/Bugswriter/tuxi) - Tuxi is a cli assistant. Get answers of your questions instantly.
### sh (macOS)
 - [lsusb](https://github.com/jlhonora/lsusb) - lsusb command for Mac OS X.
 - [mac](https://github.com/guarinogabriel/Mac-CLI) -  OS X command line tools for developers – The ultimate tool to manage your Mac. It provides a huge set of command line commands that automatize the usage of your OS X system.
 - [mas](https://github.com/mas-cli/mas) - 📦 Mac App Store command line interface.
 - [m-cli](https://github.com/rgcr/m-cli) -  Swiss Army Knife for macOS.
 - [pfetch](https://github.com/dylanaraps/pfetch) - 🐧 A pretty system information tool written in POSIX sh.
 - [termtile](https://github.com/apaszke/termtile) - Terminal window manager for OS X.
 - [x-cmd](https://github.com/x-cmd/x-cmd) A vast and interesting collection of tools that can then bootstrap lots of other programs / functions in a consistent and structured way.
### Swift
 - [trash](https://github.com/sindresorhus/macos-trash) - Move files and folders to the trash.

## Dotfiles
 - [~/.dotfiles](https://github.com/maximbaz/dotfiles) - Configuration for Arch Linux, sway, kitty, kakoune, zsh and more + scripted installation guide.
 - [dot](https://github.com/makccr/dot) - These are my dot files. I've primarily been a MacOS user for most of the time I've been collecting dotfiles, but I've recently switched to Linux
 - [dots](https://github.com/safinsingh/dots) - My dotfiles for Arch Linux and awesomeWM.
 - [dots](https://github.com/Who23/dots) - My macOS dots :)
 - [dotfiles](https://github.com/koekeishiya/dotfiles) - Configuration files.
 - [dotfiles](https://github.com/NerdyPepper/dotfiles) - Files that define my GNU/Linux box.
 - [dotfiles](https://github.com/nickjj/dotfiles) - Settings for various tools I use.
 - [dotfiles](https://github.com/dikiaap/dotfiles)
 - [dotfiles](https://github.com/mathiasbynens/dotfiles) - 🔧 .files, including ~/.macos — sensible hacker defaults for macOS
 - [dotfiles](https://github.com/yutkat/dotfiles) - The best and strongest dotfiles. Editor: Neovim(coc.nvim); Shell: zsh(zinit, powerlevel10k); Terminal: tmux, alacritty; Desktop: i3-gaps/sway, rofi, dunst; OS: ArchLinux, (Ubuntu/Fedora/CentOS)
 - [dotfiles-public](https://github.com/craftzdog/dotfiles-public) - My personal dotfiles
 - [dotfiles.fish](https://github.com/caarlos0/dotfiles.fish) - my own dotfiles ported to fish
 - [dotfiles](https://github.com/ferdinandyb/dotfiles) - Various dotfiles, most notably for terminal email (aerc, isync, mailctl, mstmp(q), ranked addressbook etc), various terminals (kitty, contour, wezterm), zsh, ipython, vim, regolith and some git goodies.

## Guides
### Bash
 - [Bash-Snippets](https://github.com/alexanderepstein/Bash-Snippets) - A collection of small bash scripts for heavy terminal users
 - [pure bash bible](https://github.com/dylanaraps/pure-bash-bible) - A collection of pure bash alternatives to external processes.
### sh
 - [acme.sh](https://github.com/Neilpang/acme.sh) - A pure Unix shell script implementing ACME client protocol. [https://acme.sh](https://acme.sh)
 - [Command Line Text Processing](https://github.com/learnbyexample/Command-line-text-processing) - From finding text to search and replace, from sorting to beautifying text and more.
 - [The Art of Command Line](https://github.com/jlevy/the-art-of-command-line) - Master the command line, in one page.
