{*****************************************************************************}
{   TxQuery DataSet                                                           }
{                                                                             }
{   The contents of this file are subject to the Mozilla Public License       }
{   Version 1.1 (the "License"); you may not use this file except in          }
{   compliance with the License. You may obtain a copy of the License at      }
{   http://www.mozilla.org/MPL/                                               }
{                                                                             }
{   Software distributed under the License is distributed on an "AS IS"       }
{   basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the   }
{   License for the specific language governing rights and limitations        }
{   under the License.                                                        }
{                                                                             }
{   The Original Code is: XQConsts.pas                                        }
{                                                                             }
{                                                                             }
{   The Initial Developer of the Original Code is Alfonso Moreno.             }
{   Portions created by Alfonso Moreno are Copyright (C) <1999-2003> of       }
{   Alfonso Moreno. All Rights Reserved.                                      }
{   Open Source patch reviews (2009-2012) with permission from Alfonso Moreno }
{                                                                             }
{   Alfonso Moreno (Hermosillo, Sonora, Mexico)                               }
{   email: luisarvayo@yahoo.com                                               }
{     url: http://www.ezsoft.com                                              }
{          http://www.sigmap.com/txquery.htm                                  }
{                                                                             }
{   Contributor(s): Chee-Yang, CHAU (Malaysia) <cychau@gmail.com>             }
{                   Sherlyn CHEW (Malaysia)                                   }
{                   Francisco Dueas Rodriguez (Mexico) <fduenas@gmail.com>   }
{                                                                             }
{              url: http://code.google.com/p/txquery/                         }
{                   http://groups.google.com/group/txquery                    }
{                                                                             }
{*****************************************************************************}

Unit XQConsts;

{$I XQ_FLAG.INC}
{$DEFINE LANG_ENG}
{.$DEFINE LANG_SPA}
Interface

Resourcestring

  SXQUERY_ABOUT = 'TxQuery Version 3.01';

  SAggrSUM = 'SumOF_';
  SAggrAVG = 'AvgOF_';
  SAggrSTDEV = 'StDevOF_';
  SAggrMIN = 'MinOF_';
  SAggrMAX = 'MaxOF_';
  SAggrCOUNT = 'COUNT(*)';

{$IFDEF LANG_ENG}
  SExprParserError = ' %s at line : %d, Column: %d, token: %s';
  SInsertWrongFieldName = 'INSERT: Field: %s does not exist in the dataset';
  SGroupByIncongruent = 'Fields in GROUP BY must also exists in SELECT columns';
  SIsNotValidInExecSQL = 'You must use SELECT only with Open method or Active property!';
  SIsNotValidInSelect = 'You must use UPDATE, DELETE, INSERT or CREATE TABLE only with ExecSQL method !';
  SGetRecordInvalid = 'GetRecord: Invalid record';
  SWrongParamsInExtract = 'Parameters for extract must be float or integer !';
  SWrongParamsInDateTime = 'Parameters for day/time function must be float or integer !';
  SSQLIsEmpty = 'SQL statement cannot be empty';
  SWrongLengthInTrim = 'Length of trimmed char in TRIM function must be 1';
  SHavingExprWrong = 'Wrong expression in HAVING predicate';
  SHavingWrong = 'Aggregate function not found in SELECT';
  SCircularReference = 'Circular reference not allowed';
  SJoinPredicateWrong = 'Number of tables in JOIN predicate must meet number of tables in FROM !';
  SDataSetNotOpened = 'DataSet %s is not opened !';
  SWrongDataSetnameInExpr = 'Wrong dataset name ''%s'' in expression';
  SWrongResultsetFieldname = 'Wrong field name ''%s'' in expression';
  SJoinExpectedDataSet = 'The joining is not correctly defined !';
  SWrongParameters = 'Parameter(s) invalid for function %s';
  SWrongFirstArg = 'Argument %s must be alfanumeric !';
  SXQueryNotDefined = 'XQuery component not defined !';
  SDuplicateDataSets = 'DataSet name %s is duplicated in the table list';
  SColumnRepeated = 'There are more than one column with name %s';
  SRecnoInvalid = 'Recno out of range';
  SGroupBySelectWrong = 'Every single field in GROUP BY clause must be in SELECT clause';
  SGroupByWrongNum = 'No. of fields in GROUP unmatched with SELECT';
  SWrongTableName = 'Wrong table name in format %s.*';
  SWrongIndexField = 'Field index incorrect';
  SFieldNotFound = 'Field %s was not found';
  SDataSetFieldNotFound = 'DataSet Field %s was not found';
  SJoinOnMustHaveDiffTables = 'Left and right tables must be different in JOIN';
  SJoinOnWrongRightTable = 'Right table in JOIN must meet second table in FROM';
  SJoinOnWrongLeftTable = 'Left table in JOIN must meet first table in FROM';
  SJoinOnWrongTableNum = 'Number of tables in FROM is wrong for JOIN ON clause';
  SSubqueryWrongCols = 'Subquery with more than one column';
  SSubqueryWrongTables = 'More than one table in FROM clause in subquery';
  SWrongTableNumber = 'No tables defined in FROM clause!';
  SWrongFieldName = 'Field Name %s not found';
  SWrongDataSetName = 'DataSet %s doesn''t exists';
  SErrorInDBField = 'Error specifying a database field !';
  SCannotContainParams = 'Field %s of database cannot have parameters !';
  SExpresionNull = 'Expression is empty';
  SExprNotBoolean = 'Expresion is not of boolean type !';
  SRecordNotFound = 'Cannot found a record that correspond to the expression !';
  SBookmarkNotFound = 'Bookmark %d not found';
  SIndexOutOfRange = 'Index out of range';
  SErrorInWhere = 'Error in where expression';
  SParameterNotFound = 'Parameter %s not found in the list of params';
  SFileNotExists = 'LoadFromBinaryFile: File does not exists !';
  SCircularDataLink = 'Circular data link';
  SDuplicateFieldName = 'Duplicate field name';
  SFieldNameNotFound = 'PRIMARY KEY: field not found';
  SBlobFieldWrongType = 'BLOB FIELD: wrong type (1-5)';
  SDataSetUnexpected = 'DataSet is not of the expected class: %s';
  SReadBooleanField = 'Cannot read field as boolean';
  SReadFloatField = 'Cannot read field as float';
  SReadIntegerField = 'Cannot read field as integer';
  SReadLargeIntegerField = 'Cannot read field as large integer'; {added by fduenas: fix for ftLargeInt issues}
  SReadStringField = 'Cannot read field as string';
  SReadWideStringField = 'Cannot read field as WideString'; {added by fduenas: added WideString support}
  SReadVariantField = 'Cannot read field as variant';
  SWriteBooleanField = 'Cannot assign field as boolean';
  SWriteFloatField = 'Cannot assign field as float';
  SWriteIntegerField = 'Cannot assign field as integer';
  SWriteLargeIntegerField = 'Cannot assign field as large integer'; {added by fduenas: fix for ftLargeInt issues}
  SWriteStringField = 'Cannot assign field as string';
  SWriteWideStringField = 'Cannot assign field as WideString'; {added by fduenas: added WideString support}
  SWriteVariantField = 'Cannot assign field as variant';
  SIsInvalidFloatValue = 'Invalid floating point value %s';
  SIsInvalidIntegerValue = 'Invalid integer value %s';
  SIsInvalidLargeIntValue = 'Invalid large integer value %s';
  SIsInvalidBoolValue = 'Invalid boolean value %s';
  SNotAnAggregate = 'This is not an aggregate field !';
  SInvalidFieldNo = 'Invalid field number %d';
  STransfColumnsMismatch = 'Number of columns in SELECT mismatch in GROUP BY';
  STransfOrderByMismatch = 'Number of columns in SELECT mismatch in ORDER BY';
  STransfWrongColumnGroup = 'Column order in GROUP BY must match in SELECT';
  STransfWrongColumnoRDER = 'Column order in order BY must match in SELECT';
  SFailOpenFile = 'Failed to open or create file';
  SFailCreateMapping = 'Failed to create file mapping';
  SFailMapView = 'Failed to map view of file';
  SBeyondEOF = 'Position beyond EOF';
  SListError = 'List index error';
  SSyntaxErrorMsg = ' %s at line : %d, Column: %d, token: %s';
  SParamsError = 'Params were not replaced !';
  SDuplicateAlias = 'Alias already exists';
  SSubqueryInSelectsError = 'Not allowed nested subqueries in subqueries in SELECT';
  SWrongParameterQuotes = 'It is not possible to coexist both quotes (") and (''))';
  SWrongJoin = 'More than one table but no JOINing defined';
  SSubqueryKindWrong = 'In this version all subqueries must be ANY or ALL, but not both';
  SWrongIntoTable = 'The INTO table defined does not exists';
  SxqFieldNotFound = 'Field not found ';
  SCaseListMissingAlias = 'CASE statement need an alias.';
  SCaseExprNotBoolean = 'Expresion is not of boolean type in CASE clause !';
  SJoinNotMismatch = 'Tables referenced in JOIN does not correspond';
  SDupParamsAsFields = 'ParamsAsFields: duplicate name';
  SJoinFieldIncongruency= 'Field in join for corresponding table not found';
  SJoinInvalidFieldName= 'Invalid field or table name in join clause';
  SEXPR_WRONGWHENEXPR = 'Expression in Case must be boolean';
  SEXPR_WRONGTHENEXPR = 'Expressions in THEN section must be all of same type';
  SEXPR_UNKNOWNID = 'Unknown Identifier "%s"';
  SEXPR_OPERATORINCOMPAT = 'Operator %s incompatible';
  SEXPR_CANNOTCASTTOWIDESTRING = 'Cannot read %s as WideString';
  SEXPR_CANNOTCASTTOSTRING = 'Cannot read %s as String';
  SEXPR_CANNOTCASTTOFLOAT = 'Cannot read %s as Float';
  SEXPR_CANNOTCASTTOINTEGER = 'Cannot read %s as Integer';
  SEXPR_CANNOTCASTTOLARGEINTEGER = 'Cannot read %s as Large Integer';
  SEXPR_CANNOTCASTTOBOOLEAN = 'Cannot read %s as boolean';
  SEXPR_WRONGUNARYOP = '%s is not simple unary operator';
  SEXPR_WRONGBINARYOP = '%s is not a simple binary operator';
  SEXPR_WRONGBOOLEANOP = 'cannot apply %s to boolean operands';
  SEXPR_WRONGRELATIONALOP = '%s is not relational operator';
  SEXPR_WRONGPARAMETER = 'Invalid parameter to %s';
  SEXPR_INVALIDPARAMETERTO = 'Invalid parameter to %s';
  SEXPR_INVALIDPARAMETERTYPE = 'Invalid parameter type %s';
  SEXPR_INVALIDPARAMETERTYPEMUSTBE = 'Invalid parameter type %s, it must be of type %s';
  SEXPR_WRONGPARAMETERCOUNT = '%s: Incorrect number of arguments';
  SEXPR_PARAMETERSTYPEDIFFERENT = '%s: All parameters must be of the same type';
  SEXPR_MATCHINVALIDMASK = '%s: Invalid Mask "%s", "%s"';
{$ENDIF}

{$IFDEF LANG_SPA}

  { Resource strings en Espaol - Mexicano       }
  { Traducido por Francisco Dueas               }
  { Email: fduenas@gmail.com                     }

  SExprParserError = ' %s Lnea : %d, Columna: %d, Identificador: %s'; //' %s at line : %d, Column: %d, token: %s';
  SInsertWrongFieldName = 'INSERT: El Campo: %s no existe en el dataset'; //'INSERT: Field: %s does not exist in the dataset';
  SGroupByIncongruent = 'Los campos del GROUP BY deben tambin existir en las columnas del SELECT'; //'Fields in GROUP BY must also exists in SELECT columns';
  SIsNotValidInExecSQL = ' Solo se debe usar SELECT con el mtodo Open o la propiedad Active !'; //'You must use SELECT only with Open method or Active property!';
  SIsNotValidInSelect = ' Solo se deben usar UPDATE, DELETE, INSERT or CREATE TABLE con el mtodo ExecSQL !'; //'You must use UPDATE, DELETE, INSERT or CREATE TABLE only with ExecSQL method !';
  SGetRecordInvalid = 'GetRecord: Registro invlido'; //'GetRecord: Invalid record';
  SWrongParamsInExtract = ' Los Parmetros para funcin Extract deben ser de tipo float  integer !'; //'Parameters for extract must be float or integer !';
  SWrongParamsInDateTime = ' Los Parmetros para funcin day/time deben ser de tipo float  integer !'; //'Parameters for day/time function must be float or integer !';
  SSQLIsEmpty = 'La sentencia SQL no puede estar vaca'; //'SQL statement cannot be empty';
  SWrongLengthInTrim = 'La longitud de la cadena a truncar en la funcin TRIM debe ser por lo menos 1'; //'Length of trimmed char in TRIM function must be 1';
  SHavingExprWrong = 'Expresin incorrecta en el predicado HAVING'; //'Wrong expression in HAVING predicate';
  SHavingWrong = 'La Funcin Agregada no se encuentra en la clusula SELECT'; //'Aggregate function not found in SELECT';
  SCircularReference = 'La referencia circular no es permitida';//'Circular reference not allowed';
  SJoinPredicateWrong = 'El nmero de tablas en el predicado JOIN debe ser el mismo que el de la clsusula FROM !'; //'Number of tables in JOIN predicate must meet number of tables in FROM !';
  SDataSetNotOpened = ' El DataSet %s no est abierto !'; //'DataSet %s is not opened !';
  SWrongDataSetnameInExpr = 'Nombre del Dataset ''%s'' incorrecto en la expresin'; //'Wrong dataset name ''%s'' in expression';
  SWrongResultsetFieldname = 'Nombre de Campo ''%s'' incorrecto en la expresin'; //'Wrong field name ''%s'' in expression';
  SJoinExpectedDataSet = ' El JOINing no est definido correctamente !'; //'The joining is not correctly defined !';
  SWrongParameters = 'Parmetro(s) invlido(s) para la funcin %s'; //'Parameter(s) invalid for function %s';
  SWrongFirstArg = ' El Argumento %s debe ser alfanumrico !'; //'Argument %s must be alfanumeric !';
  SXQueryNotDefined = ' Componente XQuery no definido !'; //'XQuery component not defined !';
  SDuplicateDataSets = 'El Nombre del DataSet %s est duplicado en la lista de tablas'; //'DataSet name %s is duplicated in the table list';
  SColumnRepeated = 'Existe ms de una columna con el nombre %s'; //'There are more than one column with name %s';
  SRecnoInvalid = 'RecNo fuera de rango'; //'Recno out of range';
  SGroupBySelectWrong = 'Cada Campo en la clasula GROUP BY debe estar en la clasula SELECT'; //'Every single field in GROUP BY clause must be in SELECT clause';
  SGroupByWrongNum = 'El No. de Campos en la clasula GROUP no concuerda con los de la clasula SELECT'; //'No. of fields in GROUP unmatched with SELECT';
  SWrongTableName = 'Nombre de Tabla incorrecto con formato %s.*'; //'Wrong table name in format %s.*';
  SWrongIndexField = 'Indice del Campo incorrecto'; //'Field index incorrect';
  SFieldNotFound = 'No se encontr el campo %s'; //'Field %s was not found';
  SDataSetFieldNotFound = 'No se encontr el campo %s del DataSet' //'DataSet Field %s was not found';
  SJoinOnMustHaveDiffTables = 'Tablas Izquierda y Derecha deben ser diferentes en el JOIN'; //'Left and right tables must be different in JOIN';
  SJoinOnWrongRightTable = 'La Tabla Derecha en el JOIN debe ser la segunda tabla en el FROM'; //'Right table in JOIN must meet second table in FROM';
  SJoinOnWrongLeftTable = 'Left table in JOIN must meet first table in FROM';
  SJoinOnWrongTableNum = 'El nmero de tablas en el FROM es incorrecto para la clasula JOIN ON'; //'Number of tables in FROM is wrong for JOIN ON clause';
  SSubqueryWrongCols = 'Sunconsulta con ms de una columna'; //'Subquery with more than one column';
  SSubqueryWrongTables = 'Ms de una tabla en la clasula FROM en la subconsulta'; //'More than one table in FROM clause in subquery';
  SWrongTableNumber = 'No hay tablas definidas en la clasula FROM!'; //'No tables defined in FROM clause!';
  SWrongFieldName = 'Nombre del Campo %s no encontrado'; //'Field Name %s not found';
  SWrongDataSetName = 'El Dataset %s no existe'; //'DataSet %s doesn''t exists';
  SErrorInDBField = ' Error especificando un campo de base de datos !'; //'Error specifying a database Field !';
  SCannotContainParams = ' El Campo %s de la Base de datos no puede tener parmetros !'; //'Field %s of database cannot have parameters !';
  SExpresionNull = 'La expresin est vaca'; //'Expression is empty';
  SExprNotBoolean = 'La expresin no es de tipo lgico'; //'Expresion is not of boolean type !';
  SRecordNotFound = ' No se pudo encontrar el registro correspondiente a la expresin !'; //'Cannot found a record that correspond to the expression !';
  SBookmarkNotFound = 'Bookmark %d no encontrado'; //'Bookmark %d not found';
  SIndexOutOfRange = 'Indice fuera de rango'; //'Index out of range';
  SErrorInWhere = 'Error en la expresin WHERE'; //'Error in where expression';
  SParameterNotFound = 'El Parmetro %s no se encontr en la lista de parmetros'; //'Parameter %s not found in the list of params';
  SFileNotExists = 'LoadFromBinaryFile:  El archivo no existe !'; //'LoadFromBinaryFile: File does not exists !';
  SCircularDataLink = 'La liga de datos es circular'; //'Circular data link';
  SDuplicateFieldName = 'Nombre del campo duplicado'; //'Duplicate field name';
  SFieldNameNotFound = 'LLAVE PRIMARIA: Campo no econtrado'; //'PRIMARY KEY: field not found';
  SBlobFieldWrongType = 'CAMPO BLOB: tipo incorrecto (1-5)'; //'BLOB FIELD: wrong type (1-5)';
  SDataSetUnexpected = 'El Dataset no es de la clase esperada: %s'; //'DataSet is not of the expected class: %s';
  SReadBooleanField = 'El campo no puede leerse como tipo lgico o buleano'; //'Cannot read field as boolean';
  SReadFloatField = 'El campo no puede leerse como tipo punto flotante'; //'Cannot read field as float';
  SReadIntegerField = 'El campo no puede leerse como tipo entero'; //'Cannot read field as integer';
  SReadStringField = 'El campo no puede leerse como tipo cadena'; //'Cannot read field as string';
  SReadWideStringField = 'El campo no puede leerse como tipo WideString'; {added by fduenas: added WideString support}
  SReadVariantField = 'El campo no puede leerse como variant';
  SWriteBooleanField = 'El campo no puede asignarse valores como tipo lgico o buleano'; //'Cannot assign field as boolean';
  SWriteFloatField = 'El campo no puede asignarse valores como tipo float (punto flotante)'; //'Cannot assign field as float';
  SWriteIntegerField = 'El campo no puede asignarse valores como tipo entero'; //'Cannot assign field as integer';
  SWriteStringField = 'El campo no puede asignarse valores como tipo string (cadena)'; //'Cannot assign field as string';
  SWriteWideStringField = 'El campo no puede asignarse valores como tipo WideString'; {added by fduenas: added WideString support}
  SWriteVariantField = 'El campo no puede asignarse como variant';
  SIsInvalidFloatValue = 'valor de punto flotante invlido: %s'; //'Invalid floating point value %s';
  SIsInvalidIntegerValue = 'Valor entero invlido: %s'; //'Invalid integer value %s';
  SIsInvalidLargeIntValue = 'Valor entero largo invlido: %s'; //'Invalid integer value %s';
  SIsInvalidBoolValue = 'Valor lgico o buleano invlido: %s'; //'Invalid boolean value %s';
  SNotAnAggregate = ' Este no es un campo de agregado (aggregate) !'; //'This is not an aggregate field !';
  SInvalidFieldNo = 'Nmero de campo invlido: %d'; //'Invalid field number %d';
  STransfColumnsMismatch = 'El Nmero de columnas en SELECT no coincide con el de GROUP BY'; //'Number of columns in SELECT mismatch in GROUP BY';
  STransfOrderByMismatch = 'El Nmero de columnas en SELECT no coincide con el de ORDER BY'; //'Number of columns in SELECT mismatch in ORDER BY';
  STransfWrongColumnGroup = 'El orden de las columnas en GROUP BY debe coincidir con el de SELECT'; //'Column order in GROUP BY must match in SELECT';
  STransfWrongColumnoRDER = 'El orden de las columnas en ORDER BY debe coincidir con el de SELECT'; //'Column order in ORDER BY must match in SELECT';
  SFailOpenFile = 'Fallo al abrir o crear el archivo'; //'Failed to open or create file';
  SFailCreateMapping = 'Fallo al crear el mapeado de archivo'; //'Failed to create file mapping';
  SFailMapView = 'Fallo al mapear la vista del archivo'; //'Failed to map view of file';
  SBeyondEOF = 'Posicin ms all de EOF'; //'Position beyond EOF';
  SListError = 'Error en el ndice de la lista'; //'List index error';
  SSyntaxErrorMsg = ' %s Lnea: %d, Columna: %d, Identificador: %s'; //' %s at line : %d, Column: %d, token: %s';
  SParamsError = ' Los parmetros no fueron reemplazados !'; //'Params were not replaced !';
  SDuplicateAlias = 'El alias ya existe'; //'Alias already exists';
  SSubqueryInSelectsError = 'No se permiten subconsultas anidades en subcosultas del SELECT'; //'Not allowed nested subqueries in subqueries in SELECT';
  SWrongParameterQuotes = 'No es posible que coexistan ambas comillas, (") y ('')'; //'It is not possible to coexist both quotes (") and (''))';
  SWrongJoin = 'Hay ms de una tabla pero no existe un JOIN definido'; //'More than one table but no JOINing defined';
  SSubqueryKindWrong = 'En esta versin las subconsultas deben ser del tipo ANY o del tipo ALL, pero no ambos'; //'In this version all subqueries must be ANY or ALL, but not both';
  SWrongIntoTable = 'La tabla definida en la clasula INTO no existe'; //'The INTO table defined does not exists';
  SxqFieldNotFound = 'Campo no encontrado'; //'Field not found ';
  SCaseListMissingAlias = 'La sentencia CASE requiere un alias.'; //'CASE statement need an alias.';
  SCaseExprNotBoolean = ' La expresin no es del tipo lgico o booleano en la clasula CASE !'; //'Expresion is not of boolean type in CASE clause !';
  SJoinNotMismatch = 'No existe correspondencia entre las tablas referenciadas en el JOIN'; //'Tables referenced in JOIN does not correspond';
  SDupParamsAsFields = 'ParamsAsFields: nombre duplicado'; //'ParamsAsFields: duplicate name';
  SJoinFieldIncongruency= 'Un campo de una tabla no fue encontrado en expresion del JOIN';
  SJoinInvalidFieldName= 'Campo o tabla no encontrado en un JOIN';
  SEXPR_WRONGWHENEXPR = 'La expresin en el Case debe ser de tipo lgico'; //'Expression in Case must be boolean';
  SEXPR_WRONGTHENEXPR = 'Todas las expresiones en la seccin THEN deben de ser del mismo tipo'; //'Expressions in THEN section must be all of same type';
  SEXPR_UNKNOWNID = 'Identificador desconocido "%s"'; //'Unknown Identifier %s';
  SEXPR_OPERATORINCOMPAT = 'El operador %s no es compatible con %s'; //'Operator %s incompatible with %s';
  SEXPR_CANNOTCASTTOSTRING = 'No se puede leer %s como tipo String'; //'Cannot read %s as String';
  SEXPR_CANNOTCASTTOWIDESTRING = 'No se puede leer %s como tipo WideString';//'Cannot read %s as WideString';
  SEXPR_CANNOTCASTTOFLOAT = 'No se puede leer %s como tipo Float'; //'Cannot read %s as Float';
  SEXPR_CANNOTCASTTOINTEGER = 'No se puede leer %s como tipo Integer'; //'Cannot read %s as Integer';
  SEXPR_CANNOTCASTTOLARGEINTEGER = 'No se puede leer %s como tipo Entero Largo'; '//Cannot read %s as Large Integer';
  SEXPR_CANNOTCASTTOBOOLEAN = 'No se puede leer %s como tipo bolean'; //'Cannot read %s as boolean';
  SEXPR_WRONGUNARYOP = '%s no es un operador unario simple'; //'%s is not simple unary operator';
  SEXPR_WRONGBINARYOP = '%s no es un operador binario simple'; //'%s is not a simple binary operator';
  SEXPR_WRONGBOOLEANOP = 'no se puede aplicar %s a operadores lgicos'; //'cannot apply %s to boolean operands';
  SEXPR_WRONGRELATIONALOP = '%s no es un operador relacional'; //'%s is not relational operator';
  SEXPR_WRONGPARAMETER = 'Parmetro no vlido para %s'; //'Invalid parameter to %s';
  SEXPR_INVALIDPARAMETERTO = 'Parmetro no vlido para %s'; //'Invalid parameter to %s';
  SEXPR_WRONGPARAMETERCOUNT = '%s: El nmero de parmetros es incorrecto'; // '%s: Incorrect number of parameters';
  SEXPR_PARAMETERSTYPEDIFFERENT = '%s: Todos los parmetros deben de ser del mismo tipo';
  SEXPR_MATCHINVALIDMASK = '%s: Mscara Invlida "%s", "%s"';
{$ENDIF}

Implementation

End.
