/*
 *  Bootstrap Color Picker Sliders - v3.1.1
 *
 *  Bootstrap 3 optimized responsive color selector with HSV, HSL, RGB and CIE-Lch (which supports human perceived lightness) selectors and color swatches.
 *  http://www.virtuosoft.eu/code/bootstrap-colorpickersliders/
 *
 *  Made by István Ujj-Mészáros
 *  Under Apache License v2.0 License
 *
 *  Requirements:  *
 *      TinyColor: https://github.com/bgrins/TinyColor/
 *
 *  Using color math algorithms from EasyRGB Web site:/
 *      http://www.easyrgb.com/index.php?X=MATH */

!function(s){"function"==typeof define&&define.amd?define(["jquery"],s):"object"==typeof module&&module.exports?module.exports=function(e,r){return void 0===r&&(r="undefined"!=typeof window?require("jquery"):require("jquery")(e)),s(r),r}:s(jQuery)}(function(W){"use strict";W.fn.ColorPickerSliders=function(U){return this.each(function(){var l,t,i,a,n,s,e=!1,c=W(this),o=c.is("input"),r=!1,d="",p=!1,h=!1,u=101,v=!1,g=0,b=null,f=70,m=!1,k=0,w={tiny:null,hsla:null,rgba:null,hsv:null,cielch:null},y=144;function S(){a={actualswatch:!1,swatchescontainer:W(".cp-swatches",t),swatches:W(".cp-swatches ul",t),swatches_add:W(".cp-swatches button.add",t),swatches_remove:W(".cp-swatches button.remove",t),swatches_reset:W(".cp-swatches button.reset",t),all_sliders:W(".cp-sliders, .cp-preview input",t),hsvpanel:{sv:W(".cp-hsvpanel-sv",t),sv_marker:W(".cp-hsvpanel-sv .cp-marker-point",t),h:W(".cp-hsvpanel-h",t),h_marker:W(".cp-hsvpanel-h .cp-hsvmarker-vertical",t),a:W(".cp-hsvpanel-a span",t),a_marker:W(".cp-hsvpanel-a .cp-hsvmarker-vertical",t)},sliders:{hue:W(".cp-hslhue span",t),hue_marker:W(".cp-hslhue .cp-marker",t),saturation:W(".cp-hslsaturation span",t),saturation_marker:W(".cp-hslsaturation .cp-marker",t),lightness:W(".cp-hsllightness span",t),lightness_marker:W(".cp-hsllightness .cp-marker",t),opacity:W(".cp-opacity span",t),opacity_marker:W(".cp-opacity .cp-marker",t),red:W(".cp-rgbred span",t),red_marker:W(".cp-rgbred .cp-marker",t),green:W(".cp-rgbgreen span",t),green_marker:W(".cp-rgbgreen .cp-marker",t),blue:W(".cp-rgbblue span",t),blue_marker:W(".cp-rgbblue .cp-marker",t),cielightness:W(".cp-cielightness span",t),cielightness_marker:W(".cp-cielightness .cp-marker",t),ciechroma:W(".cp-ciechroma span",t),ciechroma_marker:W(".cp-ciechroma .cp-marker",t),ciehue:W(".cp-ciehue span",t),ciehue_marker:W(".cp-ciehue .cp-marker",t),preview:W(".cp-preview input",t),slider_button:W(".cp-sliderbutton",t)},all_pills:W(".cp-pills",t),pills:{hsvpanel:W(".cp-pill-hsvpanel",t),sliders:W(".cp-pill-sliders",t),swatches:W(".cp-pill-swatches",t)}},l.customswatches||(a.swatches_add.hide(),a.swatches_remove.hide(),a.swatches_reset.hide()),X(),N(),M()}function C(e,r){var s=tinycolor(e);return!!s.isValid()&&(w.tiny=s,w.hsla=s.toHsl(),w.rgba=s.toRgb(),w.hsv=s.toHsv(),w.cielch=W.fn.ColorPickerSliders.rgb2lch(w.rgba),l.flat||h?(t.removeClass("cp-unconvertible-cie-color"),N(r)):(r||q(),V()),!0)}function P(e){if(!l.flat){if(h)return c.popover("hide"),c.popover("show"),void M();!function(e){if(i instanceof jQuery)return;void 0===e&&(e=!1);switch(i=W('<div class="cp-popover-container"></div>').appendTo("body"),(t=W('<div class="cp-container"></div>').appendTo(i)).html(_()),l.size){case"sm":t.addClass("cp-container-sm");break;case"lg":t.addClass("cp-container-lg")}S(),e||F();if(c.popover({html:!0,animation:!1,trigger:"manual",title:l.title,placement:l.placement,container:i,content:function(){return t}}),c.popover("show"),l.slidersplusminus){var r,s;r=parseInt(W(".cp-container .cp-sliderbutton").css("width"),10),(s=W(".cp-popover-container .popover-content")).css("padding-left",parseInt(s.css("padding-left"),10)+r-6+"px"),s.css("padding-right",parseInt(s.css("padding-right"),10)+r-6+"px")}}(e),h=!0}}function x(){h=!1,i.remove(),i=null,c.popover("destroy")}function _(){var e=[],r="";if(l.sliders&&(!1!==l.order.opacity&&(e[l.order.opacity]="",l.slidersplusminus&&(e[l.order.opacity]+='<div class="cp-opacity cp-sliderbutton cp-sliderbutton-minus">-</div><div class="cp-opacity cp-sliderbutton cp-sliderbutton-plus">+</div>'),e[l.order.opacity]+='<div class="cp-slider cp-opacity cp-transparency"><span>'+l.labels.opacity+'</span><div class="cp-marker"></div></div>'),!1!==l.order.hsl&&(e[l.order.hsl]="",l.slidersplusminus&&(e[l.order.hsl]+='<div class="cp-hslhue cp-sliderbutton cp-sliderbutton-minus">-</div><div class="cp-hslhue cp-sliderbutton cp-sliderbutton-plus">+</div>'),e[l.order.hsl]+='<div class="cp-slider cp-hslhue cp-transparency"><span>'+l.labels.hslhue+'</span><div class="cp-marker"></div></div>',l.slidersplusminus&&(e[l.order.hsl]+='<div class="cp-hslsaturation cp-sliderbutton cp-sliderbutton-minus">-</div><div class="cp-hslsaturation cp-sliderbutton cp-sliderbutton-plus">+</div>'),e[l.order.hsl]+='<div class="cp-slider cp-hslsaturation cp-transparency"><span>'+l.labels.hslsaturation+'</span><div class="cp-marker"></div></div>',l.slidersplusminus&&(e[l.order.hsl]+='<div class="cp-hsllightness cp-sliderbutton cp-sliderbutton-minus">-</div><div class="cp-hsllightness cp-sliderbutton cp-sliderbutton-plus">+</div>'),e[l.order.hsl]+='<div class="cp-slider cp-hsllightness cp-transparency"><span>'+l.labels.hsllightness+'</span><div class="cp-marker"></div></div>'),!1!==l.order.lightness&&(e[l.order.lightness]="",l.slidersplusminus&&(e[l.order.lightness]+='<div class="cp-hsllightness cp-sliderbutton cp-sliderbutton-minus">-</div><div class="cp-hsllightness cp-sliderbutton cp-sliderbutton-plus">+</div>'),e[l.order.lightness]+='<div class="cp-slider cp-hsllightness cp-transparency"><span>'+l.labels.hsllightness+'</span><div class="cp-marker"></div></div>'),!1!==l.order.rgb&&(e[l.order.rgb]="",l.slidersplusminus&&(e[l.order.rgb]+='<div class="cp-rgbred  cp-sliderbutton cp-sliderbutton-minus">-</div><div class="cp-rgbred cp-sliderbutton cp-sliderbutton-plus">+</div>'),e[l.order.rgb]+='<div class="cp-slider cp-rgbred cp-transparency"><span>'+l.labels.rgbred+'</span><div class="cp-marker"></div></div>',l.slidersplusminus&&(e[l.order.rgb]+='<div class="cp-rgbgreen cp-sliderbutton cp-sliderbutton-minus">-</div><div class="cp-rgbgreen cp-sliderbutton cp-sliderbutton-plus">+</div>'),e[l.order.rgb]+='<div class="cp-slider cp-rgbgreen cp-transparency"><span>'+l.labels.rgbgreen+'</span><div class="cp-marker"></div></div>',l.slidersplusminus&&(e[l.order.rgb]+='<div class="cp-rgbblue cp-sliderbutton cp-sliderbutton-minus">-</div><div class="cp-rgbblue cp-sliderbutton cp-sliderbutton-plus">+</div>'),e[l.order.rgb]+='<div class="cp-slider cp-rgbblue cp-transparency"><span>'+l.labels.rgbblue+'</span><div class="cp-marker"></div></div>'),!1!==l.order.cie&&(e[l.order.cie]="",l.slidersplusminus&&(e[l.order.cie]+='<div class="cp-cielightness cp-sliderbutton cp-sliderbutton-minus">-</div><div class="cp-cielightness cp-sliderbutton cp-sliderbutton-plus">+</div>'),e[l.order.cie]+='<div class="cp-slider cp-cielightness cp-transparency"><span>'+l.labels.cielightness+'</span><div class="cp-marker"></div></div>',l.slidersplusminus&&(e[l.order.cie]+='<div class="cp-ciechroma cp-sliderbutton cp-sliderbutton-minus">-</div><div class="cp-ciechroma cp-sliderbutton cp-sliderbutton-plus">+</div>'),e[l.order.cie]+='<div class="cp-slider cp-ciechroma cp-transparency"><span>'+l.labels.ciechroma+'</span><div class="cp-marker"></div></div>',l.slidersplusminus&&(e[l.order.cie]+='<div class="cp-ciehue cp-sliderbutton cp-sliderbutton-minus">-</div><div class="cp-ciehue cp-sliderbutton cp-sliderbutton-plus">+</div>'),e[l.order.cie]+='<div class="cp-slider cp-ciehue cp-transparency"><span>'+l.labels.ciehue+'</span><div class="cp-marker"></div></div>'),!1!==l.order.preview&&(e[l.order.preview]='<div class="cp-preview cp-transparency"><input type="text" readonly="readonly"></div>')),l.grouping&&(1<l.hsvpanel+(l.sliders&&0<e.length)+!!l.swatches?r+='<ul class="cp-pills">':r+='<ul class="cp-pills hidden">',l.hsvpanel&&(r+='<li><a href="#" class="cp-pill-hsvpanel">HSV panel</a></li>'),l.sliders&&0<e.length&&(r+='<li><a href="#" class="cp-pill-sliders">Sliders</a></li>'),l.swatches&&(r+='<li><a href="#" class="cp-pill-swatches">Swatches</a></li>'),r+="</ul>"),l.hsvpanel&&(r+='<div class="cp-hsvpanel"><div class="cp-hsvpanel-sv"><span></span><div class="cp-marker-point"></div></div><div class="cp-hsvpanel-h"><span></span><div class="cp-hsvmarker-vertical"></div></div><div class="cp-hsvpanel-a cp-transparency"><span></span><div class="cp-hsvmarker-vertical"></div></div></div>'),l.sliders){r+='<div class="cp-sliders">';for(var s=0;s<e.length;s++)void 0!==e[s]&&(r+=e[s]);r+="</div>"}return l.swatches&&(r+='<div class="cp-swatches clearfix"><button type="button" class="add btn btn-default" title="'+l.titleswatchesadd+'"><span class="glyphicon glyphicon-floppy-save"></span></button><button type="button" class="remove btn btn-default" title="'+l.titleswatchesremove+'"><span class="glyphicon glyphicon-trash"></span></button><button type="button" class="reset btn btn-default" title="'+l.titleswatchesreset+'"><span class="glyphicon glyphicon-repeat"></span></button><ul></ul></div>'),r}function M(){t.on("contextmenu",function(e){return e.preventDefault(),!1}),W(document).on("colorpickersliders.changeswatches",function(){X()}),a.swatches.on("touchstart mousedown click","li span",function(e){C(W(this).css("background-color")),e.preventDefault()}),a.swatches_add.on("touchstart mousedown click",function(e){n.unshift(w.tiny.toRgbString()),A(),W(document).trigger("colorpickersliders.changeswatches"),e.preventDefault(),e.stopPropagation()}),a.swatches_remove.on("touchstart mousedown click",function(e){var r;-1!==(r=n.indexOf(w.tiny.toRgbString()))&&(n.splice(r,1),A(),W(document).trigger("colorpickersliders.changeswatches")),e.preventDefault(),e.stopPropagation()}),a.swatches_reset.on("touchstart touchend mousedown click",function(e){"click"!==e.type&&"touchend"!==e.type||confirm("Do you really want to reset the swatches? All customizations will be lost!")&&(L(),A(),W(document).trigger("colorpickersliders.changeswatches")),e.preventDefault(),e.stopImmediatePropagation()}),a.sliders.slider_button.on("click",function(e){var r;(e.preventDefault(),1<e.which)||(r=W(e.target).hasClass("cp-sliderbutton-plus")?1:W(e.target).hasClass("cp-sliderbutton-minus")?-1:0,W(e.target).hasClass("cp-opacity")&&T("hsla","a",s(w.hsla.a+r/100,0,1)),W(e.target).hasClass("cp-hslhue")&&T("hsla","h",s(w.hsla.h+r,0,360)),W(e.target).hasClass("cp-hslsaturation")&&T("hsla","s",s(w.hsla.s+r/100,0,1)),W(e.target).hasClass("cp-hsllightness")&&T("hsla","l",s(w.hsla.l+r/100,0,1)),W(e.target).hasClass("cp-rgbred")&&T("rgba","r",s(w.rgba.r+r,0,255)),W(e.target).hasClass("cp-rgbgreen")&&T("rgba","g",s(w.rgba.g+r,0,255)),W(e.target).hasClass("cp-rgbblue")&&T("rgba","b",s(w.rgba.b+r,0,255)),W(e.target).hasClass("cp-cielightness")&&T("cielch","l",s(w.cielch.l+r,0,u)),W(e.target).hasClass("cp-ciechroma")&&T("cielch","c",s(w.cielch.c+r,0,y)),W(e.target).hasClass("cp-ciehue")&&T("cielch","h",s(w.cielch.h+r,0,360)),N());function s(e,r,s){return e<r&&(e=r),s<e&&(e=s),e}}),a.sliders.hue.parent().on("touchstart mousedown",function(e){(e.preventDefault(),1<e.which)||(T("hsla","h",3.6*Z(v="hue",e)),N())}),a.sliders.saturation.parent().on("touchstart mousedown",function(e){(e.preventDefault(),1<e.which)||(T("hsla","s",Z(v="saturation",e)/100),N())}),a.sliders.lightness.parent().on("touchstart mousedown",function(e){(e.preventDefault(),1<e.which)||(T("hsla","l",Z(v="lightness",e)/100),N())}),a.sliders.opacity.parent().on("touchstart mousedown",function(e){(e.preventDefault(),1<e.which)||(T("hsla","a",Z(v="opacity",e)/100),N())}),a.sliders.red.parent().on("touchstart mousedown",function(e){(e.preventDefault(),1<e.which)||(T("rgba","r",2.55*Z(v="red",e)),N())}),a.sliders.green.parent().on("touchstart mousedown",function(e){(e.preventDefault(),1<e.which)||(T("rgba","g",2.55*Z(v="green",e)),N())}),a.sliders.blue.parent().on("touchstart mousedown",function(e){(e.preventDefault(),1<e.which)||(T("rgba","b",2.55*Z(v="blue",e)),N())}),a.hsvpanel.sv.on("touchstart mousedown",function(e){if(e.preventDefault(),!(1<e.which)){v="hsvsv";var r=j("sv",e);T("hsv","s",r.horizontal/100),T("hsv","v",(100-r.vertical)/100),N()}}),a.hsvpanel.h.on("touchstart mousedown",function(e){(e.preventDefault(),1<e.which)||(v="hsvh",T("hsv","h",3.6*j("h",e).vertical),N())}),a.hsvpanel.a.on("touchstart mousedown",function(e){(e.preventDefault(),1<e.which)||(v="hsva",T("hsv","a",(100-j("a",e).vertical)/100),N())}),a.sliders.cielightness.parent().on("touchstart mousedown",function(e){if(e.preventDefault(),!(1<e.which)){var r=Z(v="cielightness",e);T("cielch","l",u/100*r),N()}}),a.sliders.ciechroma.parent().on("touchstart mousedown",function(e){if(e.preventDefault(),!(1<e.which)){var r=Z(v="ciechroma",e);T("cielch","c",y/100*r),N()}}),a.sliders.ciehue.parent().on("touchstart mousedown",function(e){(e.preventDefault(),1<e.which)||(T("cielch","h",3.6*Z(v="ciehue",e)),N())}),a.sliders.preview.on("click",function(){this.select()}),W(document).on("touchmove mousemove",function(e){v&&((new Date).getTime()-k>f&&!m?z(v,e):O(v,e))}),W(document).on("touchend mouseup",function(e){1<e.which||v&&(v=!1,e.preventDefault())}),a.pills.hsvpanel.on("click",function(e){e.preventDefault(),R()}),a.pills.sliders.on("click",function(e){e.preventDefault(),E()}),a.pills.swatches.on("click",function(e){e.preventDefault(),H()}),l.flat||i.on("touchstart mousedown",".popover",function(e){return e.preventDefault(),e.stopPropagation(),!1})}function I(){return""!==d||(0===a.pills.hsvpanel.length&&(d+="_hsvpanel_"),0===a.pills.sliders.length&&(d+="_sliders_"),0===a.pills.swatches.length&&(d+="_swatches_")),d}function G(){return function(e){try{return JSON.parse(localStorage.getItem("cp-userdata-"+e))}catch(e){return null}}("config_activepill"+I())}function D(e){return function(e,r){try{localStorage.setItem("cp-userdata-"+e,JSON.stringify(r))}catch(e){}}("config_activepill"+I(),e)}function F(){switch(G()){case"hsvpanel":R();break;case"sliders":E();break;case"swatches":H();break;default:if(a.pills.hsvpanel.length){R();break}if(a.pills.sliders.length){E();break}if(a.pills.swatches.length){H();break}}}function R(){return 0!==a.pills.hsvpanel.length&&(W("a",a.all_pills).removeClass("active"),a.pills.hsvpanel.addClass("active"),t.removeClass("sliders-active swatches-active").addClass("hsvpanel-active"),D("hsvpanel"),N(!0),P(!0),!0)}function E(){return 0!==a.pills.sliders.length&&(W("a",a.all_pills).removeClass("active"),a.pills.sliders.addClass("active"),t.removeClass("hsvpanel-active swatches-active").addClass("sliders-active"),D("sliders"),N(!0),P(!0),!0)}function H(){return 0!==a.pills.swatches.length&&(W("a",a.all_pills).removeClass("active"),a.pills.swatches.addClass("active"),t.removeClass("hsvpanel-active sliders-active").addClass("swatches-active"),D("swatches"),N(!0),P(!0),!0)}function O(e,r){clearTimeout(b),b=setTimeout(function(){z(e,r)},f)}function z(e,r){var s;if(m)O(e,r);else{switch(m=!0,k=(new Date).getTime(),s="hsvsv"===e?j("sv",r):"hsvh"===e?j("h",r):"hsva"===e?j("a",r):Z(e,r),e){case"hsvsv":T("hsv","s",s.horizontal/100),T("hsv","v",(100-s.vertical)/100);break;case"hsvh":T("hsv","h",3.6*s.vertical);break;case"hsva":T("hsv","a",(100-s.vertical)/100);break;case"hue":T("hsla","h",3.6*s);break;case"saturation":T("hsla","s",s/100);break;case"lightness":T("hsla","l",s/100);break;case"opacity":T("hsla","a",s/100);break;case"red":T("rgba","r",2.55*s);break;case"green":T("rgba","g",2.55*s);break;case"blue":T("rgba","b",2.55*s);break;case"cielightness":T("cielch","l",u/100*s);break;case"ciechroma":T("cielch","c",y/100*s);break;case"ciehue":T("cielch","h",3.6*s)}N(),r.preventDefault(),m=!1}}function L(){n=[];for(var e=0;e<l.swatches.length;e++){var r=tinycolor(l.swatches[e]);r.isValid()&&n.push(r.toRgbString())}}function X(){if(l.swatches){if(l.customswatches){var e=!1;try{e=JSON.parse(localStorage.getItem("swatches-"+l.customswatches))}catch(e){}e?n=e:L()}else L();if(n instanceof Array){a.swatches.html("");for(var r=0;r<n.length;r++){var s=tinycolor(n[r]);if(s.isValid()){var t=W("<span></span>").css("background-color",s.toRgbString()),i=W('<div class="btn btn-default cp-swatch"></div>');i.append(t),a.swatches.append(W("<li></li>").append(i))}}}Y()}}function Y(){var s=!1;W("span",a.swatches).filter(function(){var e=W(this).css("background-color");if((e=tinycolor(e)).alpha=Math.round(100*e.alpha)/100,e.toRgbString()===w.tiny.toRgbString()){s=!0;var r=W(this).parent();r.is(a.actualswatch)||(a.actualswatch&&a.actualswatch.removeClass("actual"),(a.actualswatch=r).addClass("actual"))}}),s||a.actualswatch&&(a.actualswatch.removeClass("actual"),a.actualswatch=!1),a.actualswatch?(a.swatches_add.prop("disabled",!0),a.swatches_remove.prop("disabled",!1)):(a.swatches_add.prop("disabled",!1),a.swatches_remove.prop("disabled",!0))}function A(){localStorage.setItem("swatches-"+l.customswatches,JSON.stringify(n))}function T(e,r,s){switch(e){case"hsv":w.hsv[r]=s,w.tiny=tinycolor({h:w.hsv.h,s:w.hsv.s,v:w.hsv.v,a:w.hsv.a}),w.rgba=w.tiny.toRgb(),w.hsla=w.tiny.toHsl(),w.cielch=W.fn.ColorPickerSliders.rgb2lch(w.rgba);break;case"hsla":w.hsla[r]=s,w.tiny=tinycolor({h:w.hsla.h,s:w.hsla.s,l:w.hsla.l,a:w.hsla.a}),w.rgba=w.tiny.toRgb(),w.hsv=w.tiny.toHsv(),w.cielch=W.fn.ColorPickerSliders.rgb2lch(w.rgba),t.removeClass("cp-unconvertible-cie-color");break;case"rgba":w.rgba[r]=s,w.tiny=tinycolor({r:w.rgba.r,g:w.rgba.g,b:w.rgba.b,a:w.hsla.a}),w.hsla=w.tiny.toHsl(),w.hsv=w.tiny.toHsv(),w.cielch=W.fn.ColorPickerSliders.rgb2lch(w.rgba),t.removeClass("cp-unconvertible-cie-color");break;case"cielch":w.cielch[r]=s,w.rgba=W.fn.ColorPickerSliders.lch2rgb(w.cielch),w.tiny=tinycolor(w.rgba),w.hsla=w.tiny.toHsl(),w.hsv=w.tiny.toHsv(),l.erroneousciecolormarkers&&(w.rgba.isok?t.removeClass("cp-unconvertible-cie-color"):t.addClass("cp-unconvertible-cie-color"))}}function Z(e,r){var s=W.fn.ColorPickerSliders.calculateEventPositionPercentage(r,a.sliders[e]);return a.sliders[e+"_marker"].data("position",s),s}function j(e,r){var s=W.fn.ColorPickerSliders.calculateEventPositionPercentage(r,a.hsvpanel.sv,!0);return a.hsvpanel[e+"_marker"].data("position",s),s}function N(e){if(clearTimeout(s),Date.now=Date.now||function(){return+new Date},Date.now()-g<l.updateinterval)return r=e,void(s=setTimeout(function(){N(r)},l.updateinterval));var r;void 0===e&&(e=!1),g=Date.now(),!1===l.hsvpanel||l.grouping&&"hsvpanel"!==G()||(a.hsvpanel.sv.css("background",tinycolor("hsv("+w.hsv.h+",100%,100%)").toRgbString()),a.hsvpanel.sv_marker.css("left",100*w.hsv.s+"%").css("top",100-100*w.hsv.v+"%"),a.hsvpanel.h_marker.css("top",w.hsv.h/360*100+"%"),Q(a.hsvpanel.a,W.fn.ColorPickerSliders.getScaledGradientStops(w.hsla,"a",1,0,2),!0),a.hsvpanel.a_marker.css("top",100-100*w.hsv.a+"%")),!l.sliders||l.grouping&&"sliders"!==G()||(!1!==l.order.opacity&&function(){Q(a.sliders.opacity,W.fn.ColorPickerSliders.getScaledGradientStops(w.hsla,"a",0,1,2)),l.rendervalues&&a.sliders.opacity.html(l.labels.opacity+": "+(100*w.hsla.a).toFixed(0)+"%");a.sliders.opacity_marker.css("left",100*w.hsla.a+"%")}(),!1!==l.order.hsl&&(!function(){Q(a.sliders.hue,W.fn.ColorPickerSliders.getScaledGradientStops(w.hsla,"h",0,360,7)),l.rendervalues&&a.sliders.hue.html(l.labels.hslhue+": "+w.hsla.h.toFixed(0));a.sliders.hue_marker.css("left",w.hsla.h/360*100+"%")}(),function(){Q(a.sliders.saturation,W.fn.ColorPickerSliders.getScaledGradientStops(w.hsla,"s",0,1,2)),l.rendervalues&&a.sliders.saturation.html(l.labels.hslsaturation+": "+(100*w.hsla.s).toFixed(0)+"%");a.sliders.saturation_marker.css("left",100*w.hsla.s+"%")}(),B()),!1!==l.order.lightness&&B(),!1!==l.order.rgb&&(function(){Q(a.sliders.red,W.fn.ColorPickerSliders.getScaledGradientStops(w.rgba,"r",0,255,2)),l.rendervalues&&a.sliders.red.html(l.labels.rgbred+": "+w.rgba.r.toFixed(0));a.sliders.red_marker.css("left",w.rgba.r/255*100+"%")}(),function(){Q(a.sliders.green,W.fn.ColorPickerSliders.getScaledGradientStops(w.rgba,"g",0,255,2)),l.rendervalues&&a.sliders.green.html(l.labels.rgbgreen+": "+w.rgba.g.toFixed(0));a.sliders.green_marker.css("left",w.rgba.g/255*100+"%")}(),function(){Q(a.sliders.blue,W.fn.ColorPickerSliders.getScaledGradientStops(w.rgba,"b",0,255,2)),l.rendervalues&&a.sliders.blue.html(l.labels.rgbblue+": "+w.rgba.b.toFixed(0));a.sliders.blue_marker.css("left",w.rgba.b/255*100+"%")}()),!1!==l.order.cie&&(function(){var e=W.fn.ColorPickerSliders.getScaledGradientStops(w.cielch,"l",0,100,10,l.invalidcolorsopacity);e=J(e,"l"),Q(a.sliders.cielightness,e),l.rendervalues&&a.sliders.cielightness.html(l.labels.cielightness+": "+w.cielch.l.toFixed(0));a.sliders.cielightness_marker.css("left",w.cielch.l/u*100+"%")}(),function(){var e=W.fn.ColorPickerSliders.getScaledGradientStops(w.cielch,"c",0,y,5,l.invalidcolorsopacity);e=J(e,"c"),Q(a.sliders.ciechroma,e),l.rendervalues&&a.sliders.ciechroma.html(l.labels.ciechroma+": "+w.cielch.c.toFixed(0));a.sliders.ciechroma_marker.css("left",w.cielch.c/y*100+"%")}(),function(){var e=W.fn.ColorPickerSliders.getScaledGradientStops(w.cielch,"h",0,360,28,l.invalidcolorsopacity);e=J(e,"h"),Q(a.sliders.ciehue,e),l.rendervalues&&a.sliders.ciehue.html(l.labels.ciehue+": "+w.cielch.h.toFixed(0));a.sliders.ciehue_marker.css("left",w.cielch.h/360*100+"%")}()),!1!==l.order.preview&&function(){var e;switch(a.sliders.preview.css("background",W.fn.ColorPickerSliders.csscolor(w.rgba)),l.previewformat){case"hex":e=w.hsla.a<1?w.tiny.toRgbString():w.tiny.toHexString();break;case"hsl-rgb":e=w.tiny.toHslString()+" "+w.tiny.toRgbString();break;case"hsl":e=w.tiny.toHslString();break;case"rgb":default:e=w.tiny.toRgbString()}a.sliders.preview.val(e)}()),e||q(),(100-w.cielch.l)*w.cielch.a<l.previewcontrasttreshold?(a.all_sliders.css("color","#000"),o&&l.previewontriggerelement&&c.css("background",w.tiny.toRgbString()).css("color","#000")):(a.all_sliders.css("color","#fff"),o&&l.previewontriggerelement&&c.css("background",w.tiny.toRgbString()).css("color","#fff")),!l.swatches||l.grouping&&"swatches"!==G()||Y(),l.onchange(t,w),c.data("color",w)}function V(){o&&l.previewontriggerelement&&((100-w.cielch.l)*w.cielch.a<l.previewcontrasttreshold?c.css("background",w.tiny.toRgbString()).css("color","#000"):c.css("background",w.tiny.toRgbString()).css("color","#fff"))}function q(){r&&r.each(function(e,r){var s=W(r);switch(s.data("color-format")||l.previewformat){case"hex":w.hsla.a<1?s.val(w.tiny.toRgbString()):s.val(w.tiny.toHexString());break;case"hsl":s.val(w.tiny.toHslString());break;case"rgb":default:s.val(w.tiny.toRgbString())}})}function B(){Q(a.sliders.lightness,W.fn.ColorPickerSliders.getScaledGradientStops(w.hsla,"l",0,1,3)),l.rendervalues&&a.sliders.lightness.html(l.labels.hsllightness+": "+(100*w.hsla.l).toFixed(0)+"%"),a.sliders.lightness_marker.css("left",100*w.hsla.l+"%")}function J(e,r){if(1===l.invalidcolorsopacity||!l.finercierangeedges)return e;e.sort(function(e,r){return e.position-r.position});for(var s=[],t=1;t<e.length;t++)if(e[t].isok!==e[t-1].isok)for(var i=Math.round(e[t].position)-Math.round(e[t-1].position),a=W.fn.ColorPickerSliders.getScaledGradientStops(e[t].rawcolor,r,e[t-1].rawcolor[r],e[t].rawcolor[r],i,l.invalidcolorsopacity,e[t-1].position,e[t].position),n=0;n<a.length;n++)if(a[n].isok!==e[t-1].isok){s.push(a[n]),0<n&&s.push(a[n-1]);break}return W.merge(s,e)}function Q(e,r,s){switch(void 0===s&&(s=!1),r.sort(function(e,r){return e.position-r.position}),p){case"noprefix":W.fn.ColorPickerSliders.renderNoprefix(e,r,s);break;case"webkit":W.fn.ColorPickerSliders.renderWebkit(e,r,s);break;case"ms":W.fn.ColorPickerSliders.renderMs(e,r,s);break;case"svg":W.fn.ColorPickerSliders.renderSVG(e,r,s);break;case"oldwebkit":W.fn.ColorPickerSliders.renderOldwebkit(e,r,s)}}!function(){if(e)return;e=!0,"filter"===(p=W.fn.ColorPickerSliders.detectWhichGradientIsSupported())&&(p=!1);!p&&W.fn.ColorPickerSliders.svgSupported()&&(p="svg");void 0===U&&(U={}),l=W.extend({color:"hsl(342, 50%, 70%)",size:"default",placement:"auto",trigger:"focus",preventtouchkeyboardonshow:!0,title:"",hsvpanel:!1,sliders:!0,grouping:!0,swatches:["FFFFFF","C0C0C0","808080","000000","FF0000","800000","FFFF00","808000","00FF00","008000","00FFFF","008080","0000FF","000080","FF00FF","800080"],customswatches:"colorpickkersliders",connectedinput:!1,flat:!1,updateinterval:30,previewontriggerelement:!0,previewcontrasttreshold:15,previewformat:"rgb",erroneousciecolormarkers:!0,invalidcolorsopacity:1,finercierangeedges:!0,rendervalues:!1,slidersplusminus:!1,titleswatchesadd:"Add color to swatches",titleswatchesremove:"Remove color from swatches",titleswatchesreset:"Reset to default swatches",order:{},labels:{},onchange:function(){}},U),U.hasOwnProperty("order")?l.order=W.extend({opacity:!1,hsl:!1,lightness:!1,rgb:!1,cie:!1,preview:!1},U.order):l.order={opacity:0,hsl:1,rgb:2,cie:3,preview:4},U.hasOwnProperty("labels")||(U.labels={}),l.labels=W.extend({hslhue:"HSL-Hue",hslsaturation:"HSL-Saturation",hsllightness:"HSL-Lightness",rgbred:"RGB-Red",rgbgreen:"RGB-Green",rgbblue:"RGB-Blue",cielightness:"CIE-Lightness",ciechroma:"CIE-Chroma",ciehue:"CIE-Hue",opacity:"Opacity",preview:"Preview"},U.labels),l.order.hasOwnProperty("preview")&&!1!==l.order.preview||p||(l.order.preview=10);l.connectedinput instanceof jQuery?l.connectedinput.add(c):!1===l.connectedinput?l.connectedinput=c:l.connectedinput=W(l.connectedinput).add(c),o?(w.tiny=tinycolor(c.val()),w.tiny.isValid()||(w.tiny=tinycolor(l.color))):w.tiny=tinycolor(l.color),w.hsla=w.tiny.toHsl(),w.rgba=w.tiny.toRgb(),w.hsv=w.tiny.toHsv(),w.cielch=W.fn.ColorPickerSliders.rgb2lch(w.rgba),l.connectedinput&&(r=l.connectedinput instanceof jQuery?l.connectedinput:W(l.connectedinput)),V(),q(),l.flat&&l.flat&&(o?t=W('<div class="cp-container"></div>').insertAfter(c):(t=W('<div class="cp-container"></div>'),c.append(t)),t.append(_()),S(),F());!function(){c.on("colorpickersliders.updateColor",function(e,r){C(r)}),c.on("colorpickersliders.show",function(){P()}),c.on("colorpickersliders.hide",function(){x()}),l.flat||"focus"!==l.trigger||(void 0===c.attr("tabindex")&&c.attr("tabindex",-1),l.preventtouchkeyboardonshow&&(W(c).prop("readonly",!0).addClass("cp-preventtouchkeyboardonshow"),W(c).on("click",function(e){h&&(W(c).prop("readonly",!1),e.stopPropagation())})),o||W(c).on("click",function(e){P(),e.stopPropagation()}),W(c).on("focus",function(e){P(),e.stopPropagation()}),W(c).on("blur",function(e){x(),l.preventtouchkeyboardonshow&&W(c).prop("readonly",!0),e.stopPropagation()}));r&&r.on("keyup change",function(){var e=W(this);C(e.val(),!0)})}()}()})},W.fn.ColorPickerSliders.getEventCoordinates=function(e){return void 0!==e.pageX?{pageX:e.originalEvent.pageX,pageY:e.originalEvent.pageY}:void 0!==e.originalEvent.touches?{pageX:e.originalEvent.touches[0].pageX,pageY:e.originalEvent.touches[0].pageY}:void 0},W.fn.ColorPickerSliders.calculateEventPositionPercentage=function(e,r,s){void 0===s&&(s=!1);var t=W.fn.ColorPickerSliders.getEventCoordinates(e),i=r.width(),a=(t.pageX-r.offset().left)/i*100;if(a<0&&(a=0),100<a&&(a=100),s){var n=r.height(),l=(t.pageY-r.offset().top)/n*100;return l<0&&(l=0),100<l&&(l=100),{horizontal:a,vertical:l}}return a},W.fn.ColorPickerSliders.getScaledGradientStops=function(e,r,s,t,i,a,n,l){void 0===a&&(a=1),void 0===n&&(n=0),void 0===l&&(l=100);for(var c=[],o=t-s,d=!0,p=0;p<i;++p){var h,u=p/(i-1),v=W.fn.ColorPickerSliders.modifyColor(e,r,u*o+s);if(a<1){var g=W.fn.ColorPickerSliders.lch2rgb(v,a);d=g.isok,h=W.fn.ColorPickerSliders.csscolor(g,a)}else h=W.fn.ColorPickerSliders.csscolor(v,a);c[p]={color:h,position:u*(l-n)+n,isok:d,rawcolor:v}}return c},W.fn.ColorPickerSliders.getGradientStopsCSSString=function(e){for(var r="",s="",t="",i=0;i<e.length;i++){var a=e[i];r+=","+a.color+" "+a.position+"%",s+=",color-stop("+a.position+"%,"+a.color+")";var n=tinycolor(a.color);t+='<stop stop-color="'+n.toHexString()+'" stop-opacity="'+n.toRgb().a+'" offset="'+a.position/100+'"/>'}return{noprefix:r,oldwebkit:s,svg:t}},W.fn.ColorPickerSliders.renderNoprefix=function(e,r,s){var t;void 0===s&&(s=!1),t=s?"linear-gradient(to bottom":"linear-gradient(to right",t+=W.fn.ColorPickerSliders.getGradientStopsCSSString(r).noprefix+")",e.css("background-image",t)},W.fn.ColorPickerSliders.renderWebkit=function(e,r,s){var t;void 0===s&&(s=!1),t=s?"-webkit-linear-gradient(top":"-webkit-linear-gradient(left",t+=W.fn.ColorPickerSliders.getGradientStopsCSSString(r).noprefix+")",e.css("background-image",t)},W.fn.ColorPickerSliders.renderOldwebkit=function(e,r,s){var t;void 0===s&&(s=!1),t=s?"-webkit-gradient(linear, 0% 0%, 0 100%":"-webkit-gradient(linear, 0% 0%, 100% 0%",t+=W.fn.ColorPickerSliders.getGradientStopsCSSString(r).oldwebkit+")",e.css("background-image",t)},W.fn.ColorPickerSliders.renderMs=function(e,r,s){var t;void 0===s&&(s=!1),t=s?"-ms-linear-gradient(to bottom":"-ms-linear-gradient(to right",t+=W.fn.ColorPickerSliders.getGradientStopsCSSString(r).noprefix+")",e.css("background-image",t)},W.fn.ColorPickerSliders.renderSVG=function(e,r,s){void 0===s&&(s=!1);var t="";t=s?'<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 1 1" preserveAspectRatio="none"><linearGradient id="vsgg" gradientUnits="userSpaceOnUse" x1="0" y1="0" x2="0" y2="100%">':'<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 1 1" preserveAspectRatio="none"><linearGradient id="vsgg" gradientUnits="userSpaceOnUse" x1="0" y1="0" x2="100%" y2="0">',t+=W.fn.ColorPickerSliders.getGradientStopsCSSString(r).svg,t+='</linearGradient><rect x="0" y="0" width="1" height="1" fill="url(#vsgg)" /></svg>',t="url(data:image/svg+xml;base64,"+W.fn.ColorPickerSliders.base64encode(t)+")",e.css("background-image",t)},W.fn.ColorPickerSliders.base64encode=function(e){var r,s,t,i,a,n="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",l=0,c=0,o="",d=[];if(!e)return e;for(;r=(a=e.charCodeAt(l++)<<16|e.charCodeAt(l++)<<8|e.charCodeAt(l++))>>18&63,s=a>>12&63,t=a>>6&63,i=63&a,d[c++]=n.charAt(r)+n.charAt(s)+n.charAt(t)+n.charAt(i),l<e.length;);o=d.join("");var p=e.length%3;return(p?o.slice(0,p-3):o)+"===".slice(p||3)},W.fn.ColorPickerSliders.isGoodRgb=function(e){return!(258<e.r||258<e.g||258<e.b||e.r<-1||e.g<-1||e.b<-1)&&(e.r=Math.min(255,e.r),e.g=Math.min(255,e.g),e.b=Math.min(255,e.b),e.r=Math.max(0,e.r),e.g=Math.max(0,e.g),e.b=Math.max(0,e.b),!0)},W.fn.ColorPickerSliders.rgb2lch=function(e){var r=W.fn.ColorPickerSliders.CIELab2CIELCH(W.fn.ColorPickerSliders.XYZ2CIELab(W.fn.ColorPickerSliders.rgb2XYZ(e)));return e.hasOwnProperty("a")&&(r.a=e.a),r},W.fn.ColorPickerSliders.lch2rgb=function(e,r){void 0===r&&(r=1);var s=W.fn.ColorPickerSliders.XYZ2rgb(W.fn.ColorPickerSliders.CIELab2XYZ(W.fn.ColorPickerSliders.CIELCH2CIELab(e)));if(W.fn.ColorPickerSliders.isGoodRgb(s))return e.hasOwnProperty("a")&&(s.a=e.a),s.isok=!0,s;for(var t=W.extend({},e),i=t.c,a=-1,n=0;++n,t.c=a+(i-a)/2,s=W.fn.ColorPickerSliders.XYZ2rgb(W.fn.ColorPickerSliders.CIELab2XYZ(W.fn.ColorPickerSliders.CIELCH2CIELab(t))),W.fn.ColorPickerSliders.isGoodRgb(s)?a=t.c:i=t.c,.9<Math.abs(i-a)&&n<100;);return e.hasOwnProperty("a")&&(s.a=e.a),s.r=Math.max(0,s.r),s.g=Math.max(0,s.g),s.b=Math.max(0,s.b),s.r=Math.min(255,s.r),s.g=Math.min(255,s.g),s.b=Math.min(255,s.b),r<1&&(s.hasOwnProperty("a")?s.a=s.a*r:s.a=r),s.isok=!1,s},W.fn.ColorPickerSliders.modifyColor=function(e,r,s){var t=W.extend({},e);if(!e.hasOwnProperty(r))throw"Missing color property: "+r;return t[r]=s,t},W.fn.ColorPickerSliders.csscolor=function(e,r){void 0===r&&(r=1);var s=!1,t=W.extend({},e);return t.hasOwnProperty("c")&&(t=W.fn.ColorPickerSliders.lch2rgb(t,r)),t.hasOwnProperty("h")&&(s="hsla("+t.h+","+100*t.s+"%,"+100*t.l+"%,"+t.a+")"),t.hasOwnProperty("r")&&(s=t.a<1?"rgba("+Math.round(t.r)+","+Math.round(t.g)+","+Math.round(t.b)+","+t.a+")":"rgb("+Math.round(t.r)+","+Math.round(t.g)+","+Math.round(t.b)+")"),s},W.fn.ColorPickerSliders.rgb2XYZ=function(e){var r={},s=e.r/255,t=e.g/255,i=e.b/255;return.04045<s?s=Math.pow((s+.055)/1.055,2.4):s/=12.92,.04045<t?t=Math.pow((t+.055)/1.055,2.4):t/=12.92,.04045<i?i=Math.pow((i+.055)/1.055,2.4):i/=12.92,s*=100,t*=100,i*=100,r.x=.4124*s+.3576*t+.1805*i,r.y=.2126*s+.7152*t+.0722*i,r.z=.0193*s+.1192*t+.9505*i,r},W.fn.ColorPickerSliders.XYZ2CIELab=function(e){var r={},s=e.x/95.047,t=e.y/100,i=e.z/108.883;return s=.008856<s?Math.pow(s,.333333333):7.787*s+.137931034,t=.008856<t?Math.pow(t,.333333333):7.787*t+.137931034,i=.008856<i?Math.pow(i,.333333333):7.787*i+.137931034,r.l=116*t-16,r.a=500*(s-t),r.b=200*(t-i),r},W.fn.ColorPickerSliders.CIELab2CIELCH=function(e){var r={};return r.l=e.l,r.c=Math.sqrt(Math.pow(e.a,2)+Math.pow(e.b,2)),r.h=Math.atan2(e.b,e.a),0<r.h?r.h=r.h/Math.PI*180:r.h=360-Math.abs(r.h)/Math.PI*180,r},W.fn.ColorPickerSliders.CIELCH2CIELab=function(e){var r={};return r.l=e.l,r.a=Math.cos(.01745329251*e.h)*e.c,r.b=Math.sin(.01745329251*e.h)*e.c,r},W.fn.ColorPickerSliders.CIELab2XYZ=function(e){var r={};return r.y=(e.l+16)/116,r.x=e.a/500+r.y,r.z=r.y-e.b/200,.008856<Math.pow(r.y,3)?r.y=Math.pow(r.y,3):r.y=(r.y-.137931034)/7.787,.008856<Math.pow(r.x,3)?r.x=Math.pow(r.x,3):r.x=(r.x-.137931034)/7.787,.008856<Math.pow(r.z,3)?r.z=Math.pow(r.z,3):r.z=(r.z-.137931034)/7.787,r.x=95.047*r.x,r.y=100*r.y,r.z=108.883*r.z,r},W.fn.ColorPickerSliders.XYZ2rgb=function(e){var r={};return e.x=e.x/100,e.y=e.y/100,e.z=e.z/100,r.r=3.2406*e.x+-1.5372*e.y+-.4986*e.z,r.g=-.9689*e.x+1.8758*e.y+.0415*e.z,r.b=.0557*e.x+-.204*e.y+1.057*e.z,.0031308<r.r?r.r=1.055*Math.pow(r.r,.41666667)-.055:r.r=12.92*r.r,.0031308<r.g?r.g=1.055*Math.pow(r.g,.41666667)-.055:r.g=12.92*r.g,.0031308<r.b?r.b=1.055*Math.pow(r.b,.41666667)-.055:r.b=12.92*r.b,r.r=Math.round(255*r.r),r.g=Math.round(255*r.g),r.b=Math.round(255*r.b),r},W.fn.ColorPickerSliders.detectWhichGradientIsSupported=function(){var r=document.createElement("detectGradientSupport").style;try{if(r.backgroundImage="linear-gradient(to top left, #9f9, white)",-1!==r.backgroundImage.indexOf("gradient"))return"noprefix";if(r.backgroundImage="-webkit-linear-gradient(left top, #9f9, white)",-1!==r.backgroundImage.indexOf("gradient"))return"webkit";if(r.backgroundImage="-ms-linear-gradient(left top, #9f9, white)",-1!==r.backgroundImage.indexOf("gradient"))return"ms";if(r.backgroundImage="-webkit-gradient(linear, left top, right bottom, from(#9f9), to(white))",-1!==r.backgroundImage.indexOf("gradient"))return"oldwebkit"}catch(e){try{if(r.filter='progid:DXImageTransform.Microsoft.gradient(startColorstr="#ffffff",endColorstr="#000000",GradientType=0)',-1!==r.filter.indexOf("DXImageTransform"))return"filter"}catch(e){}}return!1},W.fn.ColorPickerSliders.svgSupported=function(){return!!document.createElementNS&&!!document.createElementNS("http://www.w3.org/2000/svg","svg").createSVGRect}});