# Changelog

## [Unreleased]

### Added

### Changed

### Deprecated

### Removed

### Fixed

### Security

## 3.4.0 - 2024-11-13

### Added

- (XAML): Improve syntax highlighting

### Changed

- (Editor/UI): Scrollbar now matches palette colours directly (`surface0` by default, `surface1` on hover.)

### Fixed

- (UI): Removed macOS scrollbar turning yellow on hover. I'm sorry to anyone who liked this behaviour, but it was not
  supposed to exist in the first place.
- (Editor): Search results now show up beside the scrollbar as `blue`.
- (UI): Highlight current branch in git log pane.

## 3.3.5 - 2024-11-01

### Fixed

- (Scala): Make predefined types (Int, Double, etc) distinguishable from unused.
- (UI): Theme informational text.
- (UI): Theme macOS project tabs.

## 3.3.4 - 2024-10-10

### Changed

- (Editor): Increase contrast of unused code by setting it to `overlay2`.

### Fixed

- (Editor): Selected identifiers now show up beside the scrollbar as `teal`.

## 3.3.3 - 2024-09-13

### Added

- Support 2024.3 EAP

## 3.3.2 - 2024-08-23

### Changed

- (UI): Increase contrast of "File Colors" on Frappé, Macchiato & Mocha

### Fixed

- (UI): Search contrast on the Search Everywhere popup when using Latte

## 3.3.1 - 2024-05-27

### Added

- (UI): Style segmented button
- Support 2024.2 EAP

## 3.3.0 - 2024-05-11

### Added

- (UI): Style new block terminal

### Changed

- (Editor): Increase whitespace contrast

## 3.2.3 - 2024-01-21

### Added

- Support 2024.1 EAP

## 3.2.2 - 2023-12-07

- (Misc): We now have an icon pack! Search the marketplace for "**Catppuccin Icons**" to install it!

### Fixed

- (UI): `TextField.selectionBackground` no longer matches `TextField.background`. Selected text should now clearly stand
  out compared to non-selected text.

## 3.2.1 - 2023-10-31

### Fixed

- Fix build on 2023.3 EAP

## 3.2.0 - 2023-10-28

### Added

- (UI): **Set all `foreground` elements to use `text` colour.** This really should have been set from the beginning,
  you may notice that UI text elements are lighter and contrast less with the background. (i.e. Mocha thus far has
  been using `#FFFFFF` instead of the intended text colour `#cdd6f4` in the user interface)
- (UI): Highlight `RunWidget` icons (More Actions, Spinning Icon) as `text`
- (UI): Highlight Android Plugin's `UI Designer` backgrounds

### Changed

- (UI): Try to unify `RadioButton`, `Slider`, `List`, `Label` and `Tab` backgrounds. This should hopefully fix some 
  of the little inconsistencies in the settings.
- (UI): Improve highlights for the Git Log panel. (`VersionControl.GitLog`)
- (UI): Improve highlights for the Marketplace Plugin panel. (`Settings` -> `Plugins`)

### Fixed

- (UI): Sync border with background for `TextField`, `ComboBox`, and `Spinner`.
- (Build): **Correctly register all theme `*.xml` files.** We are cautiously optimistic that this will reduce the
  chances of the [user interface](https://www.jetbrains.com/help/idea/user-interface-themes.html)
  and [editor](https://www.jetbrains.com/help/idea/configuring-colors-and-fonts.html) themes going out of sync. However,
  this may not be the case so please follow the instructions [here](https://github.com/catppuccin/jetbrains/issues/97)
  if your theme looks incorrect upon install.

## 3.1.1 - 2023-10-26

### Fixed

- (Build): **Set `id` field in `bundledColorScheme` for no-italics files.** This was brought to our attention by the
  JetBrains Marketplace Team from their automated testing, this should fix any runtime errors that may have been
  generated by this plugin.

## 3.1.0 - 2023-10-21

### Changed

- (UI): Highlight text in accented buttons as `crust` instead of `surface1` for increased contrast
- (UI)(Latte): Use `crust` instead of `base` for darker borders and increased contrast.
- (SDL, Logcat, Jade): Improve syntax highlighting

### Removed

- (Misc): incorrect image link in plugin description

### Fixed

- (Rust): Highlight variables as `text` instead of `peach`
- (Editor): Highlight first row of code completion popup
- (UI): Sync button background with panel background
- (UI)(Latte): Darken checkboxes to make radio buttons visible

## 3.0.0 - 2023-10-16

We have significantly improved the contrast between panels and
improved consistency in the "New UI."

**We have chosen to raise the minimum supported version for this
plugin to `2023.1`** as the development of themes in JetBrains
has become increasingly painful. The "New UI" manages to break
existing behaviour and introduce new keys that theme multiple
elements at once which is frustrating to deal with. We hope that
by supporting fewer IDE versions that our users will have a more
consistent and pleasant experience going forward.

If you find that anything has regressed since the previous version, please raise an issue in
our [issue tracker](https://github.com/catppuccin/jetbrains/issues) if it hasn't already been
raised.

### Added

- (UI): Add background color for plugin tags
- (UI): Refine user interface for "New UI"
- (General): Support 2023.3 EAP

### Fixed

- (Nix): Improve syntax highlighting
- (Go): Make references in comments distinguishable
- (Go): Fix template syntax highlighting
- (General): Highlight background of search results for consistency

## 2.2.0 - 2023-06-07

### Added

- Support 2023.2 EAP

## 2.1.0 - 2023-04-02

### Added

- Add styles to checkboxes and radio buttons
- Add selection background for tool window buttons
- Add styles to memory indicator
- Add styles to main toolbar
- Add styles to scrollbar on macOS
- Theme `Indent Guides` via Rainbow Brackets plugin

### Changed

- Braces, Brackets, Commas, Dots, Parenthesis & Semicolon now default to `overlay2` instead of `text`
- Hyperlinks are now `blue` instead of `rosewater`. Followed hyperlinks are now `lavender` instead of `mauve`
- Comments are now `overlay0` instead of `surface2`. This matches other Catppuccin IDEs and means that selection
  highlights have more contrast
- (Markdown): Add rainbow highlighted headings
- (Markdown): Inline HTML blocks now default to `text` instead of `red`
- (Markdown): List items now default to `text` instead of `teal`
- (VCS): Match diff colours with Catppuccin VSCode

### Fixed

- (#55): Add project selection color to welcome screen
- (#57): Fix terminal text colour on Latte
- (#60): Fix R Markdown Chunks

## 2.0.9 - 2023-02-13

### Added

- (#53): Highlight Python binary strings
- (#54): Apply Catppuccin to semantic highlights

### Changed

- (HTML): Align highlights with TOML/JSON/XML/YAML
- (Rust): Lower opacity of conditionally disabled code
- (Rust): Highlight parameters to be same as language default
- (Debugger): No background highlighting on normal breakpoints
- (Debugger): Current line that is stopped is background highlighted
- If you would like to edit the debugging highlights yourself, they are
  located in `Settings - Editor -> Color Scheme -> Debugger`

### Fixed

- Don't force italics on CSS Keywords

## 2.0.8 - 2023-01-26

### Added

- Support 2023.1 EAP

## 2.0.7 - 2023-01-02

### Added

- Improve Scala highlights

### Changed

- Update TOML keys to blue, aligning it with JSON/XML/YAML

### Fixed

- (#42): Make RunConfigurations readable in Latte
- (#39): Make quick-fix error messages readable

## 2.0.6 - 2022-11-27

### Added

- Support Erlang
- Highlight FileTree to be darker in New UI

### Fixed

- Revert changes from 2.0.5

## 2.0.5 - 2022-11-22

### Added

- (#27): Better support for New UI

### Changed

- (#35): Matching braces now have a border when hovered.

### Fixed

- Terminal colors now follow the Catppuccin style guide

## 2.0.4 - 2022-11-12

### Added

- [AndroidStudio] Add highlights for composable functions

### Changed

- (#31): Improved Ruby highlights
- Improve visibility of ignored files when using Latte

### Fixed

- (#32): Update button text is now readable
- (#28): Improve visibility of tabs
- (#29): GitHub Copilot suggestion highlights are now the same as comments

## 2.0.3 - 2022-11-03

### Fixed

- Cursor line highlights are now readable

## 2.0.2 - 2022-10-30

### Changed

- Warnings are not bold anymore
- When cursor is over identifier, highlights are now only bordered

### Fixed

- Comments are now readable when selected with cursor

## 2.0.1 - 2022-10-24

- Fixed file colour highlights on Latte
- Improved cursor selection background highlights on all flavours

## 2.0.0 - 2022-10-22

- All four flavours of Catppuccin v2 palette are now available!
- View your IDE in Latte, Frappe, Macchiato or Mocha!

## 1.0.9 - 2022-08-09

- row tree height fix

## 1.0.8 - 2022-06-20

- XAML support
- selectionInactiveBackground visibility fix

## 1.0.7 - 2022-06-03

- Compatibility with 2022.2

## 1.0.6 - 2022-04-30

- Make TODO and FIXME comments more visible

## 1.0.5 - 2022-04-07

- Compatibility with 2022.1

## 1.0.4 - 2022-02-27

- Added missing description in plugin.xml

## 1.0.3 - 2022-02-24

- First Marketplace release 🎉
- Fixed low contrast issues in various spots

## 1.0.1 - 2022-01-30

- Checkbox readability improved
- Editor color scheme uses colors from palette
