package com.siberika.idea.pascal.run;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;

import javax.swing.*;
import java.awt.*;

/**
 * Author: George Bakhtadze
 * Date: 06/01/2013
 */
public class PascalRunConfigurationForm implements PascalRunConfigurationParams {
    private JPanel rootPanel;
    private JTextField parametersEdit;
    private TextFieldWithBrowseButton workingDirEdit;
    private JCheckBox fixIOBufferingCBox;

    public PascalRunConfigurationForm(PascalRunConfiguration runConfiguration) {
        assert runConfiguration != null;
        workingDirEdit.addBrowseFolderListener("Choose Working Directory", "", runConfiguration.getProject(), BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR);
    }

    public JComponent getRootPanel() {
        return rootPanel;
    }

    @Override
    public String getParameters() {
        return parametersEdit.getText();
    }

    @Override
    public String getWorkingDirectory() {
        return workingDirEdit.getText();
    }

    @Override
    public boolean getFixIOBuffering() {
        return fixIOBufferingCBox.isSelected();
    }

    @Override
    public boolean getDebugMode() {
        return false;
    }

    @Override
    public void setParameters(String parameters) {
        this.parametersEdit.setText(parameters);
    }

    @Override
    public void setWorkingDirectory(String workingDirectory) {
        workingDirEdit.setText(workingDirectory);
    }

    @Override
    public void setFixIOBuffering(boolean value) {
        fixIOBufferingCBox.setSelected(value);
    }

    @Override
    public void setDebugMode(boolean value) {

    }

    {
// GUI initializer generated by IntelliJ IDEA GUI Designer
// >>> IMPORTANT!! <<<
// DO NOT EDIT OR ADD ANY CODE HERE!
        $$$setupUI$$$();
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * >>> IMPORTANT!! <<<
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        rootPanel = new JPanel();
        rootPanel.setLayout(new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1));
        final JLabel label1 = new JLabel();
        label1.setText("Parameters:");
        rootPanel.add(label1, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        parametersEdit = new JTextField();
        rootPanel.add(parametersEdit, new GridConstraints(1, 0, 1, 1, GridConstraints.ANCHOR_NORTH, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, new Dimension(14, 32), null, 0, false));
        final JLabel label2 = new JLabel();
        label2.setText("Working directory:");
        rootPanel.add(label2, new GridConstraints(2, 0, 1, 1, GridConstraints.ANCHOR_NORTHWEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        workingDirEdit = new TextFieldWithBrowseButton();
        rootPanel.add(workingDirEdit, new GridConstraints(3, 0, 1, 1, GridConstraints.ANCHOR_NORTH, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        fixIOBufferingCBox = new JCheckBox();
        fixIOBufferingCBox.setSelected(true);
        fixIOBufferingCBox.setText("Workaround buffered I/O");
        rootPanel.add(fixIOBufferingCBox, new GridConstraints(4, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
    }

    /**
     * @noinspection ALL
     */
    public JComponent $$$getRootComponent$$$() {
        return rootPanel;
    }
}
