/*
 * Decompiled with CFR 0.152.
 */
package JFlex.tests;

import JFlex.IntCharSet;
import JFlex.Interval;
import junit.framework.TestCase;

public class CharClassesTest
extends TestCase {
    public CharClassesTest(String arg0) {
        super(arg0);
    }

    public void testAdd1() {
        IntCharSet set = new IntCharSet(new Interval('a', 'h'));
        set.add(new Interval('o', 'z'));
        set.add(new Interval('A', 'Z'));
        set.add(new Interval('h', 'o'));
        CharClassesTest.assertEquals((String)"{ ['A'-'Z']['a'-'z'] }", (String)set.toString());
    }

    public void testAdd2() {
        IntCharSet set = new IntCharSet(new Interval('a', 'h'));
        set.add(new Interval('o', 'z'));
        set.add(new Interval('A', 'Z'));
        set.add(new Interval('i', 'n'));
        CharClassesTest.assertEquals((String)"{ ['A'-'Z']['a'-'z'] }", (String)set.toString());
    }

    public void testAdd3() {
        IntCharSet set = new IntCharSet(new Interval('a', 'h'));
        set.add(new Interval('o', 'z'));
        set.add(new Interval('A', 'Z'));
        set.add(new Interval('a', 'n'));
        CharClassesTest.assertEquals((String)"{ ['A'-'Z']['a'-'z'] }", (String)set.toString());
    }

    public void testMergeLast() {
        IntCharSet set = new IntCharSet(new Interval('a', 'k'));
        CharClassesTest.assertEquals((String)"{ ['a'-'k'] }", (String)set.toString());
        set.add('l');
        CharClassesTest.assertEquals((String)"{ ['a'-'l'] }", (String)set.toString());
    }

    public void testAddChar() {
        IntCharSet set = new IntCharSet(new Interval('a', 'h'));
        set.add(new Interval('o', 'z'));
        set.add('n');
        set.add('k');
        CharClassesTest.assertEquals((String)"{ ['a'-'h']['k']['n'-'z'] }", (String)set.toString());
        set.add('i');
        CharClassesTest.assertEquals((String)"{ ['a'-'i']['k']['n'-'z'] }", (String)set.toString());
        set.add('j');
        CharClassesTest.assertEquals((String)"{ ['a'-'k']['n'-'z'] }", (String)set.toString());
        set.add(new Interval('l', 'm'));
        CharClassesTest.assertEquals((String)"{ ['a'-'z'] }", (String)set.toString());
    }

    public void testCopy() {
        IntCharSet set = new IntCharSet(new Interval('a', 'z'));
        IntCharSet copy = set.copy();
        Interval i = set.getNext();
        i.end = (char)104;
        CharClassesTest.assertEquals((String)"{ ['a'-'h'] }", (String)set.toString());
        CharClassesTest.assertEquals((String)"{ ['a'-'z'] }", (String)copy.toString());
    }

    public void testCaseless() {
        IntCharSet set = new IntCharSet(new Interval('a', 'c'));
        set.add(new Interval('h', 'o'));
        CharClassesTest.assertEquals((String)"{ ['A'-'C']['H'-'O']['a'-'c']['h'-'o'] }", (String)set.getCaseless().toString());
    }
}

