/*
 * Decompiled with CFR 0.152.
 */
package JFlex.tests;

import JFlex.Options;
import JFlex.Skeleton;
import JFlex.anttask.JFlexTask;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public class AntTaskTests
extends TestCase {
    private JFlexTask task;

    public AntTaskTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Options.setDefaults();
        this.task = new JFlexTask();
    }

    public void testPackageAndClass() throws IOException {
        this.task.setFile(new File("src/JFlex/LexScan.flex"));
        this.task.findPackageAndClass();
        AntTaskTests.assertEquals((String)this.task.getPackage(), (String)"JFlex");
        AntTaskTests.assertEquals((String)this.task.getClassName(), (String)"LexScan");
    }

    public void testPackageAndClassDefaults() throws IOException {
        this.task.setFile(new File("examples/simple/simple.flex"));
        this.task.findPackageAndClass();
        AntTaskTests.assertEquals((String)this.task.getPackage(), null);
        AntTaskTests.assertEquals((String)this.task.getClassName(), (String)"Yylex");
    }

    public void testDestdir() throws IOException {
        this.task.setFile(new File("src/JFlex/LexScan.flex"));
        File dir = new File("src");
        this.task.setDestdir(dir);
        this.task.findPackageAndClass();
        this.task.normalizeOutdir();
        AntTaskTests.assertEquals((Object)Options.getDir(), (Object)new File(dir, "JFlex"));
    }

    public void testOutdir() throws IOException {
        this.task.setFile(new File("src/JFlex/LexScan.flex"));
        File dir = new File("src");
        this.task.setOutdir(dir);
        this.task.findPackageAndClass();
        this.task.normalizeOutdir();
        AntTaskTests.assertEquals((Object)Options.getDir(), (Object)dir);
    }

    public void testDefaultDir() throws IOException {
        this.task.setFile(new File("src/JFlex/LexScan.flex"));
        this.task.findPackageAndClass();
        this.task.normalizeOutdir();
        AntTaskTests.assertEquals((Object)Options.getDir(), (Object)new File("src/JFlex"));
    }

    public void testNomin() {
        AntTaskTests.assertTrue((!Options.no_minimize ? 1 : 0) != 0);
        this.task.setNomin(true);
        AntTaskTests.assertTrue((boolean)Options.no_minimize);
    }

    public void testSkipMinimization() {
        AntTaskTests.assertTrue((!Options.no_minimize ? 1 : 0) != 0);
        this.task.setSkipMinimization(true);
        AntTaskTests.assertTrue((boolean)Options.no_minimize);
    }

    public void testNobak() {
        AntTaskTests.assertTrue((!Options.no_backup ? 1 : 0) != 0);
        this.task.setNobak(true);
        AntTaskTests.assertTrue((boolean)Options.no_backup);
    }

    public void testCodeGen() {
        this.task.setSwitch(true);
        AntTaskTests.assertEquals((int)Options.gen_method, (int)2);
        this.task.setTable(true);
        AntTaskTests.assertEquals((int)Options.gen_method, (int)1);
        this.task.setPack(true);
        AntTaskTests.assertEquals((int)Options.gen_method, (int)0);
    }

    public void testSkel() {
        this.task.setVerbose(false);
        this.task.setSkeleton(new File("src/skeleton.nested"));
        AntTaskTests.assertTrue((Skeleton.line[3].indexOf("java.util.Stack") > 0 ? 1 : 0) != 0);
    }

    public void testVerbose() {
        this.task.setVerbose(false);
        AntTaskTests.assertTrue((!Options.verbose ? 1 : 0) != 0);
        this.task.setVerbose(true);
        AntTaskTests.assertTrue((boolean)Options.verbose);
    }

    public void testTime() {
        AntTaskTests.assertTrue((!Options.time ? 1 : 0) != 0);
        this.task.setTimeStatistics(true);
        AntTaskTests.assertTrue((boolean)Options.time);
        this.task.setTime(false);
        AntTaskTests.assertTrue((!Options.time ? 1 : 0) != 0);
    }

    public void testDot() {
        AntTaskTests.assertTrue((!Options.dot ? 1 : 0) != 0);
        this.task.setDot(true);
        AntTaskTests.assertTrue((boolean)Options.dot);
        this.task.setGenerateDot(false);
        AntTaskTests.assertTrue((!Options.dot ? 1 : 0) != 0);
    }

    public void testDump() {
        AntTaskTests.assertTrue((!Options.dump ? 1 : 0) != 0);
        this.task.setDump(true);
        AntTaskTests.assertTrue((boolean)Options.dump);
    }

    public void testJlex() {
        AntTaskTests.assertTrue((!Options.jlex ? 1 : 0) != 0);
        this.task.setJLex(true);
        AntTaskTests.assertTrue((boolean)Options.jlex);
    }
}

