/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.ErrorMessages;
import JFlex.Macros;
import JFlex.Out;
import JFlex.RegExp;
import JFlex.RegExp1;
import JFlex.RegExp2;
import JFlex.RegExps;
import java.io.File;

public final class SemCheck {
    private static Macros macros;
    private static char maxChar;

    public static void check(RegExps rs, Macros m, char max, File f) {
        macros = m;
        maxChar = max;
        int num = rs.getNum();
        for (int i = 0; i < num; ++i) {
            RegExp l;
            RegExp r = rs.getRegExp(i);
            if (SemCheck.checkLookAhead(r, l = rs.getLookAhead(i))) continue;
            Out.warning(f, ErrorMessages.LOOKAHEAD_ERROR, rs.getLine(i), -1);
        }
    }

    private static boolean checkLookAhead(RegExp r1, RegExp r2) {
        return r2 == null || SemCheck.length(r1) > 0;
    }

    private static int length(RegExp re) {
        switch (re.type) {
            case 34: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return -1;
                }
                int l2 = SemCheck.length(r.r2);
                if (l1 == l2) {
                    return l1;
                }
                return -1;
            }
            case 44: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return -1;
                }
                int l2 = SemCheck.length(r.r2);
                if (l2 < 0) {
                    return -1;
                }
                return l1 + l2;
            }
            case 32: 
            case 33: 
            case 35: {
                return -1;
            }
            case 39: 
            case 42: 
            case 43: 
            case 46: {
                return 1;
            }
            case 40: 
            case 45: {
                String content = (String)((RegExp1)re).content;
                return content.length();
            }
            case 37: 
            case 38: {
                return -1;
            }
            case 41: {
                return SemCheck.length(macros.getDefinition((String)((RegExp1)re).content));
            }
        }
        throw new Error("Unkown expression type " + re.type + " in " + re);
    }
}

