/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.DFA;
import JFlex.Emitter;
import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import JFlex.LexParse;
import JFlex.LexScan;
import JFlex.MacroException;
import JFlex.NFA;
import JFlex.Options;
import JFlex.Out;
import JFlex.ScannerException;
import JFlex.SilentExit;
import JFlex.Timer;
import JFlex.gui.MainFrame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class Main {
    public static final String version = "1.4.1";

    public static void generate(File inputFile) {
        Out.resetCounters();
        Timer totalTime = new Timer();
        Timer time = new Timer();
        LexScan scanner = null;
        LexParse parser = null;
        FileReader inputReader = null;
        totalTime.start();
        try {
            Out.println(ErrorMessages.READING, inputFile.toString());
            inputReader = new FileReader(inputFile);
            scanner = new LexScan(inputReader);
            scanner.setFile(inputFile);
            parser = new LexParse(scanner);
        }
        catch (FileNotFoundException e) {
            Out.error(ErrorMessages.CANNOT_OPEN, inputFile.toString());
            throw new GeneratorException();
        }
        try {
            NFA nfa = (NFA)parser.parse().value;
            Out.checkErrors();
            if (Options.dump) {
                Out.dump(ErrorMessages.get(ErrorMessages.NFA_IS) + Out.NL + nfa + Out.NL);
            }
            if (Options.dot) {
                nfa.writeDot(Emitter.normalize("nfa.dot", null));
            }
            Out.println(ErrorMessages.NFA_STATES, nfa.numStates);
            time.start();
            DFA dfa = nfa.getDFA();
            time.stop();
            Out.time(ErrorMessages.DFA_TOOK, time);
            dfa.checkActions(scanner, parser);
            nfa = null;
            if (Options.dump) {
                Out.dump(ErrorMessages.get(ErrorMessages.DFA_IS) + Out.NL + dfa + Out.NL);
            }
            if (Options.dot) {
                dfa.writeDot(Emitter.normalize("dfa-big.dot", null));
            }
            time.start();
            dfa.minimize();
            time.stop();
            Out.time(ErrorMessages.MIN_TOOK, time);
            if (Options.dump) {
                Out.dump(ErrorMessages.get(ErrorMessages.MIN_DFA_IS) + Out.NL + dfa);
            }
            if (Options.dot) {
                dfa.writeDot(Emitter.normalize("dfa-min.dot", null));
            }
            time.start();
            Emitter e = new Emitter(inputFile, parser, dfa);
            e.emit();
            time.stop();
            Out.time(ErrorMessages.WRITE_TOOK, time);
            totalTime.stop();
            Out.time(ErrorMessages.TOTAL_TIME, totalTime);
        }
        catch (ScannerException e) {
            Out.error(e.file, e.message, e.line, e.column);
            throw new GeneratorException();
        }
        catch (MacroException e) {
            Out.error(e.getMessage());
            throw new GeneratorException();
        }
        catch (IOException e) {
            Out.error(ErrorMessages.IO_ERROR, e.toString());
            throw new GeneratorException();
        }
        catch (OutOfMemoryError e) {
            Out.error(ErrorMessages.OUT_OF_MEMORY);
            throw new GeneratorException();
        }
        catch (GeneratorException e) {
            throw new GeneratorException();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException();
        }
    }

    public static Vector parseOptions(String[] argv) throws SilentExit {
        Vector<File> files = new Vector<File>();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-d") || argv[i].equals("--outdir")) {
                if (++i >= argv.length) {
                    Out.error(ErrorMessages.NO_DIRECTORY);
                    throw new GeneratorException();
                }
                Options.setDir(argv[i]);
                continue;
            }
            if (argv[i].equals("--skel") || argv[i].equals("-skel")) {
                if (++i >= argv.length) {
                    Out.error(ErrorMessages.NO_SKEL_FILE);
                    throw new GeneratorException();
                }
                Options.setSkeleton(new File(argv[i]));
                continue;
            }
            if (argv[i].equals("-jlex") || argv[i].equals("--jlex")) {
                Options.jlex = true;
                continue;
            }
            if (argv[i].equals("-v") || argv[i].equals("--verbose") || argv[i].equals("-verbose")) {
                Options.verbose = true;
                Options.progress = true;
                continue;
            }
            if (argv[i].equals("-q") || argv[i].equals("--quiet") || argv[i].equals("-quiet")) {
                Options.verbose = false;
                Options.progress = false;
                continue;
            }
            if (argv[i].equals("--dump") || argv[i].equals("-dump")) {
                Options.dump = true;
                continue;
            }
            if (argv[i].equals("--time") || argv[i].equals("-time")) {
                Options.time = true;
                continue;
            }
            if (argv[i].equals("--version") || argv[i].equals("-version")) {
                Out.println(ErrorMessages.THIS_IS_JFLEX, version);
                throw new SilentExit();
            }
            if (argv[i].equals("--dot") || argv[i].equals("-dot")) {
                Options.dot = true;
                continue;
            }
            if (argv[i].equals("--help") || argv[i].equals("-h") || argv[i].equals("/h")) {
                Main.printUsage();
                throw new SilentExit();
            }
            if (argv[i].equals("--info") || argv[i].equals("-info")) {
                Out.printSystemInfo();
                throw new SilentExit();
            }
            if (argv[i].equals("--nomin") || argv[i].equals("-nomin")) {
                Options.no_minimize = true;
                continue;
            }
            if (argv[i].equals("--pack") || argv[i].equals("-pack")) {
                Options.gen_method = 0;
                continue;
            }
            if (argv[i].equals("--table") || argv[i].equals("-table")) {
                Options.gen_method = 1;
                continue;
            }
            if (argv[i].equals("--switch") || argv[i].equals("-switch")) {
                Options.gen_method = 2;
                continue;
            }
            if (argv[i].equals("--nobak") || argv[i].equals("-nobak")) {
                Options.no_backup = true;
                continue;
            }
            if (argv[i].equals("--charat") || argv[i].equals("-charat")) {
                Options.char_at = true;
                continue;
            }
            if (argv[i].startsWith("-")) {
                Out.error(ErrorMessages.UNKNOWN_COMMANDLINE, argv[i]);
                Main.printUsage();
                throw new SilentExit();
            }
            File f = new File(argv[i]);
            if (f.isFile() && f.canRead()) {
                files.addElement(f);
                continue;
            }
            Out.error("Sorry, couldn't open \"" + f + "\"");
            throw new GeneratorException();
        }
        return files;
    }

    public static void printUsage() {
        Out.println("");
        Out.println("Usage: jflex <options> <input-files>");
        Out.println("");
        Out.println("Where <options> can be one or more of");
        Out.println("-d <directory>   write generated file to <directory>");
        Out.println("--skel <file>    use external skeleton <file>");
        Out.println("--switch");
        Out.println("--table");
        Out.println("--pack           set default code generation method");
        Out.println("--jlex           strict JLex compatibility");
        Out.println("--nomin          skip minimization step");
        Out.println("--nobak          don't create backup files");
        Out.println("--dump           display transition tables");
        Out.println("--dot            write graphviz .dot files for the generated automata (alpha)");
        Out.println("--verbose");
        Out.println("-v               display generation progress messages (default)");
        Out.println("--quiet");
        Out.println("-q               display errors only");
        Out.println("--time           display generation time statistics");
        Out.println("--version        print the version number of this copy of jflex");
        Out.println("--info           print system + JDK information");
        Out.println("--help");
        Out.println("-h               print this message");
        Out.println("");
        Out.println(ErrorMessages.THIS_IS_JFLEX, version);
        Out.println("Have a nice day!");
    }

    public static void generate(String[] argv) throws SilentExit {
        Vector files = Main.parseOptions(argv);
        if (files.size() > 0) {
            for (int i = 0; i < files.size(); ++i) {
                Main.generate((File)files.elementAt(i));
            }
        } else {
            new MainFrame();
        }
    }

    public static void main(String[] argv) {
        try {
            Main.generate(argv);
        }
        catch (GeneratorException e) {
            Out.statistics();
            System.exit(1);
        }
        catch (SilentExit e) {
            System.exit(1);
        }
    }
}

