/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;

class CountOptimisedDatabaseSubGraph
extends DatabaseSubGraph {
    private final TokenRead tokenRead;
    private final Read read;

    public CountOptimisedDatabaseSubGraph(Transaction transaction, KernelTransaction kernelTx) {
        super(transaction);
        this.tokenRead = kernelTx.tokenRead();
        this.read = kernelTx.dataRead();
    }

    @Override
    public long countsForNode(Label label) {
        return this.read.countsForNode(this.tokenRead.nodeLabel(label.name()));
    }

    @Override
    public long countsForRelationship(RelationshipType type, Label end) {
        return this.read.countsForRelationship(-1, this.tokenRead.relationshipType(type.name()), this.tokenRead.nodeLabel(end.name()));
    }

    @Override
    public long countsForRelationship(Label start, RelationshipType type) {
        return this.read.countsForRelationship(this.tokenRead.nodeLabel(start.name()), this.tokenRead.relationshipType(type.name()), -1);
    }

    @Override
    public long countsForRelationship(RelationshipType type) {
        return this.read.countsForRelationship(-1, this.tokenRead.relationshipType(type.name()), -1);
    }
}

