/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.collection;

import apoc.util.collection.AbstractResourceIterable;
import apoc.util.collection.Iterators;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;

public final class Iterables {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, C extends Collection<T>> C addAll(C collection, Iterable<? extends T> iterable) {
        try {
            Iterator<T> iterator = iterable.iterator();
            try {
                while (iterator.hasNext()) {
                    collection.add(iterator.next());
                }
            }
            finally {
                Iterators.tryCloseResource(iterator);
            }
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
        return collection;
    }

    @SafeVarargs
    public static <T, C extends T> Iterable<T> iterable(C ... items) {
        return Arrays.asList(items);
    }

    public static <T> T[] asArray(Class<T> componentType, Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        List<Object> list = Iterables.asList(iterable);
        return list.toArray((Object[])Array.newInstance(componentType, list.size()));
    }

    public static <T> ResourceIterable<T> asResourceIterable(final Iterable<T> iterable) {
        if (iterable instanceof ResourceIterable) {
            return (ResourceIterable)iterable;
        }
        return new AbstractResourceIterable<T>(){

            @Override
            protected ResourceIterator<T> newIterator() {
                return Iterators.asResourceIterator(iterable.iterator());
            }

            @Override
            protected void onClosed() {
                Iterables.tryCloseResource(iterable);
            }
        };
    }

    public static <T> T firstOrNull(Iterable<T> iterable) {
        try {
            T t = Iterators.firstOrNull(iterable.iterator());
            return t;
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    public static <T> T first(Iterable<T> iterable) {
        try {
            T t = Iterators.first(iterable.iterator());
            return t;
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    public static <T> T single(Iterable<T> iterable) {
        try {
            T t = Iterators.single(iterable.iterator());
            return t;
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    public static <T> long count(Iterable<T> iterable) {
        try {
            long l = Iterators.count(iterable.iterator());
            return l;
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    public static <T> List<T> asList(Iterable<T> iterable) {
        return Iterables.addAll(new ArrayList(), iterable);
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        return Iterables.addAll(new HashSet(), iterable);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        return (Stream)Iterators.stream(iterable.iterator()).onClose(() -> Iterables.tryCloseResource(iterable));
    }

    private static void tryCloseResource(Iterable<?> iterable) {
        if (iterable instanceof Resource) {
            Resource closeable = (Resource)iterable;
            closeable.close();
        }
    }
}

