/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class QueueUtil {
    public static final int WAIT = 1;
    public static final TimeUnit WAIT_UNIT = TimeUnit.SECONDS;

    public static <T> void put(BlockingQueue<T> queue, T item, long timeoutSeconds) {
        QueueUtil.put(queue, item, timeoutSeconds, true, () -> {});
    }

    public static <T> void put(BlockingQueue<T> queue, T item, long timeoutSeconds, boolean failWithExecption, Runnable checkDuringOffering) {
        try {
            long timeoutTimestamp = System.currentTimeMillis() + timeoutSeconds * 1000L;
            while (System.currentTimeMillis() <= timeoutTimestamp) {
                boolean success = queue.offer(item, 1L, WAIT_UNIT);
                if (success) {
                    return;
                }
                checkDuringOffering.run();
            }
            if (failWithExecption) {
                throw new RuntimeException("Error queuing item before timeout of " + timeoutSeconds + " seconds");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T take(BlockingQueue<T> queue, long timeoutSeconds, Runnable checkDuringPolling) {
        try {
            long started = System.currentTimeMillis();
            while (started + timeoutSeconds * 1000L > System.currentTimeMillis()) {
                T polled = queue.poll(1L, WAIT_UNIT);
                if (polled != null) {
                    return polled;
                }
                checkDuringPolling.run();
            }
            throw new RuntimeException("Error polling, timeout of " + timeoutSeconds + " seconds reached.");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

