/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.ApocConfig;
import apoc.export.util.CountingInputStream;
import apoc.export.util.CountingReader;
import apoc.export.util.ExportConfig;
import apoc.util.CompressionAlgo;
import apoc.util.MissingDependencyException;
import apoc.util.StreamConnection;
import apoc.util.SupportedProtocols;
import apoc.util.Util;
import apoc.util.hdfs.HDFSUtils;
import apoc.util.s3.S3URLConnection;
import apoc.util.s3.S3UploadUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.security.URLAccessChecker;

public class FileUtils {
    public static final String ERROR_READ_FROM_FS_NOT_ALLOWED = "Import file %s not enabled, please set apoc.import.file.allow_read_from_filesystem=true in your neo4j.conf";
    public static final String ACCESS_OUTSIDE_DIR_ERROR = "You're providing a directory outside the import directory defined into `server.directories.import`";

    public static String getFileUrl(String fileName) throws MalformedURLException {
        try {
            return new URL(fileName).getFile();
        }
        catch (MalformedURLException e) {
            if (e.getMessage().contains("no protocol")) {
                return fileName;
            }
            throw e;
        }
    }

    public static StreamConnection getStreamConnection(SupportedProtocols protocol, String urlAddress, Map<String, Object> headers, String payload, URLAccessChecker urlAccessChecker) throws IOException {
        switch (protocol) {
            case s3: {
                return FileUtils.openS3InputStream(urlAddress);
            }
            case hdfs: {
                return FileUtils.openHdfsInputStream(urlAddress);
            }
            case ftp: 
            case http: 
            case https: 
            case gs: {
                return Util.readHttpInputStream(urlAddress, headers, payload, 10, urlAccessChecker);
            }
        }
        try {
            return new StreamConnection.FileStreamConnection(URI.create(urlAddress));
        }
        catch (IllegalArgumentException iae) {
            return new StreamConnection.FileStreamConnection(FileUtils.getFileUrl(urlAddress));
        }
    }

    public static URLStreamHandler createURLStreamHandler(SupportedProtocols protocol) {
        URLStreamHandler handler = Optional.ofNullable(protocol.getUrlStreamHandlerClassName()).map(Util::createInstanceOrNull).map(urlStreamHandlerFactory -> ((URLStreamHandlerFactory)urlStreamHandlerFactory).createURLStreamHandler(protocol.name())).orElse(null);
        return handler;
    }

    public static SupportedProtocols of(String name) {
        try {
            return SupportedProtocols.valueOf(name);
        }
        catch (Exception e) {
            return SupportedProtocols.file;
        }
    }

    public static SupportedProtocols from(URL url) {
        return FileUtils.of(url.getProtocol());
    }

    public static SupportedProtocols from(String source) {
        try {
            URL url = new URL(source);
            return FileUtils.from(url);
        }
        catch (MalformedURLException e) {
            if (!e.getMessage().contains("no protocol")) {
                try {
                    return SupportedProtocols.valueOf(new URI(source).getScheme());
                }
                catch (Exception exception) {
                    if (e.getMessage().contains("unknown protocol") && Util.isWindows()) {
                        throw new RuntimeException(e.getMessage() + "\n Please note that for Windows absolute paths they have to be explicit by prepending `file:` or supplied without the drive, \n e.g. `file:C:/my/path/file` or `/my/path/file`, instead of `C:/my/path/file`");
                    }
                    throw new RuntimeException(e);
                }
            }
            return SupportedProtocols.file;
        }
    }

    public static CountingReader readerFor(Object input, String compressionAlgo, URLAccessChecker urlAccessChecker) throws IOException {
        return FileUtils.readerFor(input, null, null, compressionAlgo, urlAccessChecker);
    }

    public static CountingReader readerFor(Object input, Map<String, Object> headers, String payload, String compressionAlgo, URLAccessChecker urlAccessChecker) throws IOException {
        return FileUtils.inputStreamFor(input, headers, payload, compressionAlgo, urlAccessChecker).asReader();
    }

    public static CountingInputStream inputStreamFor(Object input, Map<String, Object> headers, String payload, String compressionAlgo, URLAccessChecker urlAccessChecker) throws IOException {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            String fileName = (String)input;
            ApocConfig.apocConfig().checkReadAllowed(fileName, urlAccessChecker);
            fileName = FileUtils.changeFileUrlIfImportDirectoryConstrained(fileName);
            return Util.openInputStream(fileName, headers, payload, compressionAlgo, urlAccessChecker);
        }
        if (input instanceof byte[]) {
            return FileUtils.getInputStreamFromBinary((byte[])input, compressionAlgo);
        }
        throw new RuntimeException("Only byte[] or url String allowed");
    }

    public static String changeFileUrlIfImportDirectoryConstrained(String url) throws IOException {
        if (FileUtils.isFile(url) && FileUtils.isImportUsingNeo4jConfig()) {
            if (!ApocConfig.apocConfig().getBoolean("apoc.import.file.allow_read_from_filesystem")) {
                throw new RuntimeException(String.format(ERROR_READ_FROM_FS_NOT_ALLOWED, url));
            }
            Path resolvedPath = FileUtils.resolvePath(url);
            return resolvedPath.normalize().toUri().toString();
        }
        return url;
    }

    private static Path resolvePath(String url) throws IOException {
        Path resolvedPath;
        Path urlPath = FileUtils.getPath(url);
        if (ApocConfig.apocConfig().isImportFolderConfigured() && FileUtils.isImportUsingNeo4jConfig()) {
            Path basePath = Paths.get(ApocConfig.apocConfig().getImportDir(), new String[0]);
            resolvedPath = basePath.resolve(urlPath = FileUtils.relativizeIfSamePrefix(urlPath, basePath)).toAbsolutePath().normalize();
            if (!FileUtils.pathStartsWithOther(resolvedPath, basePath)) {
                throw new IOException(ACCESS_OUTSIDE_DIR_ERROR);
            }
        } else {
            resolvedPath = urlPath;
        }
        return resolvedPath;
    }

    private static Path relativizeIfSamePrefix(Path urlPath, Path basePath) {
        if (FilenameUtils.getPrefixLength((String)urlPath.toString()) > 0 && !urlPath.startsWith(basePath.toAbsolutePath())) {
            urlPath = urlPath.getRoot().relativize(urlPath);
        }
        return urlPath;
    }

    private static Path getPath(String url) {
        Path urlPath;
        URL toURL = null;
        try {
            URI uri = URI.create(url.trim()).normalize();
            toURL = uri.toURL();
            urlPath = Paths.get(uri);
        }
        catch (Exception e) {
            urlPath = toURL != null ? Paths.get(StringUtils.isBlank(toURL.getFile()) ? toURL.getHost() : toURL.getFile(), new String[0]) : Paths.get(url, new String[0]);
        }
        return urlPath;
    }

    private static boolean pathStartsWithOther(Path resolvedPath, Path basePath) throws IOException {
        try {
            return resolvedPath.toFile().getCanonicalFile().toPath().startsWith(basePath.toRealPath(new LinkOption[0]));
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileException) {
                return resolvedPath.toFile().getCanonicalFile().toPath().startsWith(basePath);
            }
            return false;
        }
    }

    public static boolean isFile(String fileName) {
        return FileUtils.from(fileName) == SupportedProtocols.file;
    }

    public static OutputStream getOutputStream(String fileName) {
        return FileUtils.getOutputStream(fileName, ExportConfig.EMPTY);
    }

    public static OutputStream getOutputStream(String fileName, ExportConfig config) {
        if (fileName.equals("-")) {
            return null;
        }
        return FileUtils.getOutputStream(FileUtils.from(fileName), fileName, config);
    }

    public static OutputStream getOutputStream(SupportedProtocols protocol, String fileName, ExportConfig config) {
        if (fileName == null) {
            return null;
        }
        CompressionAlgo compressionAlgo = CompressionAlgo.valueOf(config.getCompressionAlgo());
        try {
            return new BufferedOutputStream(compressionAlgo.getOutputStream(switch (protocol) {
                case SupportedProtocols.s3 -> S3UploadUtils.writeFile(fileName);
                case SupportedProtocols.hdfs -> HDFSUtils.writeFile(fileName);
                default -> {
                    File file = FileUtils.isImportUsingNeo4jConfig() ? FileUtils.resolvePath(fileName).toFile() : new File(FileUtils.getFileUrl(fileName));
                    yield new FileOutputStream(file);
                }
            }));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isImportUsingNeo4jConfig() {
        return ApocConfig.apocConfig().getBoolean("apoc.import.file.use_neo4j_config");
    }

    public static StreamConnection openS3InputStream(String urlAddress) throws IOException {
        if (!SupportedProtocols.s3.isEnabled()) {
            throw new MissingDependencyException("Cannot find the S3 jars in the plugins folder. \nPlease put these files into the plugins folder :\n\naws-java-sdk-core-x.y.z.jar\naws-java-sdk-s3-x.y.z.jar\nhttpclient-x.y.z.jar\nhttpcore-x.y.z.jar\njoda-time-x.y.z.jar\n\nSee the documentation: https://neo4j.com/docs/apoc/current/import/web-apis/#_using_google_cloud_storage");
        }
        return S3URLConnection.openS3InputStream(new URL(urlAddress));
    }

    public static StreamConnection openHdfsInputStream(String urlAddress) throws IOException {
        if (!SupportedProtocols.hdfs.isEnabled()) {
            throw new MissingDependencyException("Cannot find the HDFS/Hadoop jars in the plugins folder. \n\nPlease, see the documentation: https://neo4j.com/docs/apoc/current/import/web-apis/#_using_google_cloud_storage");
        }
        return HDFSUtils.readFile(new URL(urlAddress));
    }

    public static File getLogDirectory() {
        File logs;
        String neo4jHome = ApocConfig.apocConfig().getString("server.directories.neo4j_home", "");
        String logDir = ApocConfig.apocConfig().getString("server.directories.logs", "");
        File file = logs = logDir.isEmpty() ? new File(neo4jHome, "logs") : new File(logDir);
        if (logs.exists() && logs.canRead() && logs.isDirectory()) {
            return logs;
        }
        return null;
    }

    public static CountingInputStream getInputStreamFromBinary(byte[] urlOrBinary, String compressionAlgo) {
        return CompressionAlgo.valueOf(compressionAlgo).toInputStream(urlOrBinary);
    }
}

