/*
 * Decompiled with CFR 0.152.
 */
package apoc.trigger;

import apoc.ApocConfig;
import apoc.trigger.TriggerHandler;
import apoc.trigger.TriggerInfo;
import apoc.util.Util;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Trigger {
    public static final String SYS_DB_NON_WRITER_ERROR = "This instance is not allowed to write to the system database.\nPlease open a session against a system database writer when using this procedure.\n";
    @Context
    public GraphDatabaseAPI db;
    @Context
    public TriggerHandler triggerHandler;

    private void preprocessDeprecatedProcedures() {
        String msgDeprecation = "Please note that the current procedure is deprecated,\nit is recommended to use the `apoc.trigger.install`, `apoc.trigger.drop`, `apoc.trigger.dropAll`, `apoc.trigger.stop`, and `apoc.trigger.start` procedures,\ninstead of, respectively, `apoc.trigger.add`, `apoc.trigger.remove`, `apoc.trigger.removeAll`, `apoc.trigger.pause`, and `apoc.trigger.resume`.";
        if (!Util.isWriteableInstance((GraphDatabaseAPI)ApocConfig.apocConfig().getSystemDb())) {
            throw new RuntimeException("This instance is not allowed to write to the system database.\nPlease open a session against a system database writer when using this procedure.\nPlease note that the current procedure is deprecated,\nit is recommended to use the `apoc.trigger.install`, `apoc.trigger.drop`, `apoc.trigger.dropAll`, `apoc.trigger.stop`, and `apoc.trigger.start` procedures,\ninstead of, respectively, `apoc.trigger.add`, `apoc.trigger.remove`, `apoc.trigger.removeAll`, `apoc.trigger.pause`, and `apoc.trigger.resume`.");
        }
    }

    @Admin
    @Deprecated
    @Procedure(name="apoc.trigger.add", mode=Mode.WRITE, deprecatedBy="apoc.trigger.install")
    @Description(value="Adds a trigger to the given Cypher statement.\nThe selector for this procedure is {phase:'before/after/rollback/afterAsync'}.")
    public Stream<TriggerInfo> add(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="selector") Map<String, Object> selector, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        this.preprocessDeprecatedProcedures();
        Util.validateQuery((GraphDatabaseService)this.db, statement, new QueryExecutionType.QueryType[0]);
        Map<String, Object> params = config.getOrDefault("params", Collections.emptyMap());
        Map<String, Object> removed = this.triggerHandler.add(name, statement, selector, params);
        if (removed != null) {
            return Stream.of(new TriggerInfo(name, (String)removed.get("statement"), (Map)removed.get("selector"), (Map)removed.get("params"), false, false), new TriggerInfo(name, statement, selector, params, true, false));
        }
        return Stream.of(new TriggerInfo(name, statement, selector, params, true, false));
    }

    @Admin
    @Deprecated
    @Procedure(name="apoc.trigger.remove", mode=Mode.WRITE, deprecatedBy="apoc.trigger.drop")
    @Description(value="Removes the given trigger.")
    public Stream<TriggerInfo> remove(@Name(value="name") String name) {
        this.preprocessDeprecatedProcedures();
        Map<String, Object> removed = this.triggerHandler.remove(name);
        if (removed == null) {
            return Stream.of(new TriggerInfo(name, null, null, false, false));
        }
        return Stream.of(new TriggerInfo(name, (String)removed.get("statement"), (Map)removed.get("selector"), (Map)removed.get("params"), false, false));
    }

    @Admin
    @Deprecated
    @Procedure(name="apoc.trigger.removeAll", mode=Mode.WRITE, deprecatedBy="apoc.trigger.dropAll")
    @Description(value="Removes all previously added triggers.")
    public Stream<TriggerInfo> removeAll() {
        this.preprocessDeprecatedProcedures();
        Map<String, Map<String, Object>> removed = this.triggerHandler.removeAll();
        if (removed == null) {
            return Stream.of(new TriggerInfo(null, null, null, false, false));
        }
        return removed.entrySet().stream().map(r -> TriggerInfo.from((Map)r.getValue(), false, (String)r.getKey()));
    }

    @Admin
    @Procedure(name="apoc.trigger.list", mode=Mode.READ)
    @Description(value="Lists all currently installed triggers for the session database.")
    public Stream<TriggerInfo> list() {
        return this.triggerHandler.list().entrySet().stream().map(e -> new TriggerInfo((String)e.getKey(), (String)((Map)e.getValue()).get("statement"), (Map)((Map)e.getValue()).get("selector"), (Map)((Map)e.getValue()).get("params"), true, ((Map)e.getValue()).getOrDefault("paused", false)));
    }

    @Admin
    @Deprecated
    @Procedure(name="apoc.trigger.pause", mode=Mode.WRITE, deprecatedBy="apoc.trigger.stop")
    @Description(value="Pauses the given trigger.")
    public Stream<TriggerInfo> pause(@Name(value="name") String name) {
        this.preprocessDeprecatedProcedures();
        Map<String, Object> paused = this.triggerHandler.updatePaused(name, true);
        return Stream.of(new TriggerInfo(name, (String)paused.get("statement"), (Map)paused.get("selector"), (Map)paused.get("params"), true, true));
    }

    @Admin
    @Deprecated
    @Procedure(name="apoc.trigger.resume", mode=Mode.WRITE, deprecatedBy="apoc.trigger.start")
    @Description(value="Resumes the given paused trigger.")
    public Stream<TriggerInfo> resume(@Name(value="name") String name) {
        this.preprocessDeprecatedProcedures();
        Map<String, Object> resume = this.triggerHandler.updatePaused(name, false);
        return Stream.of(new TriggerInfo(name, (String)resume.get("statement"), (Map)resume.get("selector"), (Map)resume.get("params"), true, false));
    }
}

