/*
 * Decompiled with CFR 0.152.
 */
package apoc.number;

import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class ArabicRoman {
    @UserFunction(value="apoc.number.romanToArabic")
    @Description(value="Converts the given Roman numbers to Arabic numbers.")
    public Number romanToArabic(@Name(value="romanNumber") String number) {
        if (number == null || number.isEmpty()) {
            return 0;
        }
        return RomanNumerals.toArabic(number.toUpperCase());
    }

    @UserFunction(value="apoc.number.arabicToRoman")
    @Description(value="Converts the given Arabic numbers to Roman numbers.")
    public String arabicToRoman(@Name(value="number") Object value) {
        Number number = this.validateNumberParam(value);
        if (number == null) {
            return null;
        }
        return RomanNumerals.getRoman(number.intValue());
    }

    private Number validateNumberParam(Object number) {
        return number instanceof Number ? (Number)((Number)number) : (Number)null;
    }

    static class RomanNumerals {
        private static String[] roman = new String[]{"M", "XM", "CM", "D", "XD", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};

        RomanNumerals() {
        }

        public static String getRoman(int number) {
            int[] arab = new int[]{1000, 990, 900, 500, 490, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
            StringBuilder result = new StringBuilder();
            int i = 0;
            while (number > 0 || arab.length == i - 1) {
                while (number - arab[i] >= 0) {
                    number -= arab[i];
                    result.append(roman[i]);
                }
                ++i;
            }
            return result.toString();
        }

        static int toArabic(String number) {
            if (number == null || number.isEmpty()) {
                return 0;
            }
            if (number.startsWith("M")) {
                return 1000 + RomanNumerals.toArabic(number.substring(1));
            }
            if (number.startsWith("CM")) {
                return 900 + RomanNumerals.toArabic(number.substring(2));
            }
            if (number.startsWith("D")) {
                return 500 + RomanNumerals.toArabic(number.substring(1));
            }
            if (number.startsWith("CD")) {
                return 400 + RomanNumerals.toArabic(number.substring(2));
            }
            if (number.startsWith("C")) {
                return 100 + RomanNumerals.toArabic(number.substring(1));
            }
            if (number.startsWith("XC")) {
                return 90 + RomanNumerals.toArabic(number.substring(2));
            }
            if (number.startsWith("L")) {
                return 50 + RomanNumerals.toArabic(number.substring(1));
            }
            if (number.startsWith("XL")) {
                return 40 + RomanNumerals.toArabic(number.substring(2));
            }
            if (number.startsWith("X")) {
                return 10 + RomanNumerals.toArabic(number.substring(1));
            }
            if (number.startsWith("IX")) {
                return 9 + RomanNumerals.toArabic(number.substring(2));
            }
            if (number.startsWith("V")) {
                return 5 + RomanNumerals.toArabic(number.substring(1));
            }
            if (number.startsWith("IV")) {
                return 4 + RomanNumerals.toArabic(number.substring(2));
            }
            if (number.startsWith("I")) {
                return 1 + RomanNumerals.toArabic(number.substring(1));
            }
            return 0;
        }
    }
}

