/*
 * Decompiled with CFR 0.152.
 */
package apoc.nodes;

import apoc.Pools;
import apoc.create.Create;
import apoc.nodes.NodesConfig;
import apoc.path.RelationshipTypeAndDirections;
import apoc.refactor.util.PropertiesManager;
import apoc.refactor.util.RefactorConfig;
import apoc.refactor.util.RefactorUtil;
import apoc.result.LongResult;
import apoc.result.NodeResult;
import apoc.result.PathResult;
import apoc.result.RelationshipResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualPath;
import apoc.result.VirtualPathResult;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphalgo.BasicEvaluationContext;
import org.neo4j.graphalgo.EvaluationContext;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanderBuilder;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;
import org.neo4j.storageengine.api.RelationshipSelection;

public class Nodes {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public KernelTransaction ktx;
    @Context
    public Pools pools;

    @Procedure(value="apoc.nodes.cycles")
    @Description(value="Detects all `PATH` cycles in the given `LIST<NODE>`.\nThis procedure can be limited on `RELATIONSHIP` values as well.")
    public Stream<PathResult> cycles(@Name(value="nodes") List<Node> nodes, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        NodesConfig conf = new NodesConfig(config);
        List<String> types = conf.getRelTypes();
        Stream<PathResult> paths = nodes.stream().flatMap(start -> {
            PathExpanderBuilder expanderBuilder;
            ResourceIterable relationships;
            boolean allRels = types.isEmpty();
            RelationshipType[] relTypes = (RelationshipType[])types.stream().map(RelationshipType::withName).toArray(RelationshipType[]::new);
            ResourceIterable resourceIterable = relationships = allRels ? start.getRelationships(Direction.OUTGOING) : start.getRelationships(Direction.OUTGOING, relTypes);
            if (allRels) {
                expanderBuilder = PathExpanderBuilder.allTypes((Direction)Direction.OUTGOING);
            } else {
                expanderBuilder = PathExpanderBuilder.empty();
                for (RelationshipType relType : relTypes) {
                    expanderBuilder = expanderBuilder.add(relType, Direction.OUTGOING);
                }
            }
            PathExpander pathExpander = expanderBuilder.build();
            PathFinder finder = GraphAlgoFactory.shortestPath((EvaluationContext)new BasicEvaluationContext(this.tx, this.db), (PathExpander)pathExpander, (int)conf.getMaxDepth());
            HashMap dups = new HashMap();
            return Iterables.stream(relationships).filter(relationship -> {
                List nodeDups = dups.computeIfAbsent(relationship.getStartNode().getElementId(), key -> new ArrayList());
                if (nodeDups.contains(relationship.getEndNode().getElementId())) {
                    return false;
                }
                nodeDups.add(relationship.getEndNode().getElementId());
                return true;
            }).flatMap(relationship -> {
                Path path = finder.findSinglePath(relationship.getEndNode(), start);
                if (path == null) {
                    return Stream.empty();
                }
                VirtualPath virtualPath = new VirtualPath((Node)start);
                virtualPath.addRel((Relationship)relationship);
                for (Relationship relPath : path.relationships()) {
                    virtualPath.addRel(relPath);
                }
                return Stream.of(virtualPath);
            });
        });
        return paths.map(PathResult::new);
    }

    @Procedure(name="apoc.nodes.link", mode=Mode.WRITE)
    @Description(value="Creates a linked list of the given `NODE` values connected by the given `RELATIONSHIP` type.")
    public void link(@Name(value="nodes") List<Node> nodes, @Name(value="type") String type, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        RefactorConfig conf = new RefactorConfig(config);
        Iterator<Node> it = nodes.iterator();
        if (it.hasNext()) {
            RelationshipType relType = RelationshipType.withName((String)type);
            Node node = it.next();
            while (it.hasNext()) {
                boolean createRelationship;
                Node next = it.next();
                boolean bl = createRelationship = !conf.isAvoidDuplicates() || conf.isAvoidDuplicates() && !this.connected(node, next, type);
                if (createRelationship) {
                    node.createRelationshipTo(next, relType);
                }
                node = next;
            }
        }
    }

    @Procedure(value="apoc.nodes.get")
    @Description(value="Returns all `NODE` values with the given ids.")
    public Stream<NodeResult> get(@Name(value="nodes") Object ids) {
        return Util.nodeStream((InternalTransaction)this.tx, ids).map(NodeResult::new);
    }

    @Procedure(name="apoc.nodes.delete", mode=Mode.WRITE)
    @Description(value="Deletes all `NODE` values with the given ids.")
    public Stream<LongResult> delete(@Name(value="nodes") Object ids, @Name(value="batchSize") long batchSize) {
        Iterator it = Util.nodeStream((InternalTransaction)this.tx, ids).iterator();
        long count = 0L;
        while (it.hasNext()) {
            List batch = Util.take(it, (int)batchSize);
            count += (long)Util.inTx(this.db, this.pools, txInThread -> {
                txInThread.execute("FOREACH (n in $nodes | DETACH DELETE n)", Util.map("nodes", batch)).close();
                return batch.size();
            }).intValue();
        }
        return Stream.of(new LongResult(count));
    }

    @Procedure(value="apoc.nodes.rels")
    @Description(value="Returns all `RELATIONSHIP` values with the given ids.")
    public Stream<RelationshipResult> rels(@Name(value="rels") Object ids) {
        return Util.relsStream((InternalTransaction)this.tx, ids).map(RelationshipResult::new);
    }

    @UserFunction(value="apoc.node.relationship.exists")
    @Description(value="Returns a `BOOLEAN` based on whether the given `NODE` has a connecting `RELATIONSHIP` (or whether the given `NODE` has a connecting `RELATIONSHIP` of the given type and direction).")
    public boolean hasRelationship(@Name(value="node") Node node, @Name(value="relTypes", defaultValue="") String types) {
        if (types == null || types.isEmpty()) {
            return node.hasRelationship();
        }
        long id = ((InternalTransaction)this.tx).elementIdMapper().nodeId(node.getElementId());
        try (NodeCursor nodeCursor = this.ktx.cursors().allocateNodeCursor(this.ktx.cursorContext());){
            this.ktx.dataRead().singleNode(id, nodeCursor);
            nodeCursor.next();
            TokenRead tokenRead = this.ktx.tokenRead();
            for (Pair<RelationshipType, Direction> pair : RelationshipTypeAndDirections.parse(types)) {
                int count;
                int typeId = tokenRead.relationshipType(pair.getLeft().name());
                Direction direction = pair.getRight();
                switch (direction) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case INCOMING: {
                        int n = org.neo4j.internal.kernel.api.helpers.Nodes.countIncoming((NodeCursor)nodeCursor, (int)typeId);
                        break;
                    }
                    case OUTGOING: {
                        int n = org.neo4j.internal.kernel.api.helpers.Nodes.countOutgoing((NodeCursor)nodeCursor, (int)typeId);
                        break;
                    }
                    case BOTH: {
                        int n = count = org.neo4j.internal.kernel.api.helpers.Nodes.countAll((NodeCursor)nodeCursor, (int)typeId);
                    }
                }
                if (count <= 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @UserFunction(value="apoc.nodes.connected")
    @Description(value="Returns true when a given `NODE` is directly connected to another given `NODE`.\nThis function is optimized for dense nodes.")
    public boolean connected(@Name(value="startNode") Node start, @Name(value="endNode") Node end, @Name(value="types", defaultValue="") String types) {
        if (start == null || end == null) {
            return false;
        }
        if (start.equals(end)) {
            return true;
        }
        long startId = ((InternalTransaction)this.tx).elementIdMapper().nodeId(start.getElementId());
        long endId = ((InternalTransaction)this.tx).elementIdMapper().nodeId(end.getElementId());
        List<Pair<RelationshipType, Direction>> pairs = types == null || types.isEmpty() ? null : RelationshipTypeAndDirections.parse(types);
        Read dataRead = this.ktx.dataRead();
        TokenRead tokenRead = this.ktx.tokenRead();
        CursorFactory cursors = this.ktx.cursors();
        try (NodeCursor startNodeCursor = cursors.allocateNodeCursor(this.ktx.cursorContext());){
            boolean bl;
            block16: {
                NodeCursor endNodeCursor = cursors.allocateNodeCursor(this.ktx.cursorContext());
                try {
                    dataRead.singleNode(startId, startNodeCursor);
                    if (!startNodeCursor.next()) {
                        throw new IllegalArgumentException("node with id " + startId + " does not exist.");
                    }
                    dataRead.singleNode(endId, endNodeCursor);
                    if (!endNodeCursor.next()) {
                        throw new IllegalArgumentException("node with id " + endId + " does not exist.");
                    }
                    bl = this.connected(startNodeCursor, endId, this.typedDirections(tokenRead, pairs));
                    if (endNodeCursor == null) break block16;
                }
                catch (Throwable throwable) {
                    if (endNodeCursor != null) {
                        try {
                            endNodeCursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                endNodeCursor.close();
            }
            return bl;
        }
    }

    @Procedure(value="apoc.nodes.collapse")
    @Description(value="Merges `NODE` values together in the given `LIST<NODE>`.\nThe `NODE` values are then combined to become one `NODE`, with all labels of the previous `NODE` values attached to it, and all `RELATIONSHIP` values pointing to it.")
    public Stream<VirtualPathResult> collapse(@Name(value="nodes") List<Node> nodes, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (nodes == null || nodes.isEmpty()) {
            return Stream.empty();
        }
        if (nodes.size() == 1) {
            return Stream.of(new VirtualPathResult(nodes.get(0), null, null));
        }
        LinkedHashSet<Node> nodeSet = new LinkedHashSet<Node>(nodes);
        RefactorConfig conf = new RefactorConfig(config);
        VirtualNode first = this.createVirtualNode(nodeSet, conf);
        if (first.getRelationships().iterator().hasNext()) {
            return StreamSupport.stream(first.getRelationships().spliterator(), false).map(relationship -> new VirtualPathResult(relationship.getStartNode(), (Relationship)relationship, relationship.getEndNode()));
        }
        return Stream.of(new VirtualPathResult(first, null, null));
    }

    private VirtualNode createVirtualNode(Set<Node> nodes, RefactorConfig conf) {
        Create create = new Create();
        Node first = nodes.iterator().next();
        List<String> labels = Util.labelStrings(first);
        if (conf.isCollapsedLabel()) {
            labels.add("Collapsed");
        }
        VirtualNode virtualNode = (VirtualNode)create.vNodeFunction(labels, first.getAllProperties());
        this.createVirtualRelationships(nodes, virtualNode, first, conf);
        nodes.stream().skip(1L).forEach(node -> {
            virtualNode.addLabels(node.getLabels());
            PropertiesManager.mergeProperties(node.getAllProperties(), (Entity)virtualNode, conf);
            this.createVirtualRelationships(nodes, virtualNode, (Node)node, conf);
        });
        if (conf.isCountMerge()) {
            virtualNode.setProperty("count", nodes.size());
        }
        return virtualNode;
    }

    private void createVirtualRelationships(Set<Node> nodes, VirtualNode virtualNode, Node node, RefactorConfig refactorConfig) {
        node.getRelationships().forEach(relationship -> {
            Node startNode = relationship.getStartNode();
            Node endNode = relationship.getEndNode();
            if (nodes.contains(startNode) && nodes.contains(endNode)) {
                if (refactorConfig.isSelfRel()) {
                    this.createOrMergeVirtualRelationship(virtualNode, refactorConfig, (Relationship)relationship, virtualNode, Direction.OUTGOING);
                }
            } else if (Objects.equals(startNode.getElementId(), node.getElementId())) {
                this.createOrMergeVirtualRelationship(virtualNode, refactorConfig, (Relationship)relationship, endNode, Direction.OUTGOING);
            } else {
                this.createOrMergeVirtualRelationship(virtualNode, refactorConfig, (Relationship)relationship, startNode, Direction.INCOMING);
            }
        });
    }

    private void createOrMergeVirtualRelationship(VirtualNode virtualNode, RefactorConfig refactorConfig, Relationship source, Node node, Direction direction) {
        ResourceIterable<Relationship> rels = virtualNode.getRelationships(direction, source.getType());
        Optional<Relationship> first = StreamSupport.stream(rels.spliterator(), false).filter(relationship -> relationship.getOtherNode((Node)virtualNode).equals(node)).findFirst();
        if (refactorConfig.isMergeVirtualRels() && first.isPresent()) {
            this.mergeRelationship(source, first.get(), refactorConfig);
        } else {
            if (direction == Direction.OUTGOING) {
                RefactorUtil.copyProperties((Entity)source, virtualNode.createRelationshipTo(node, source.getType()));
            }
            if (direction == Direction.INCOMING) {
                RefactorUtil.copyProperties((Entity)source, virtualNode.createRelationshipFrom(node, source.getType()));
            }
        }
    }

    private void mergeRelationship(Relationship source, Relationship target, RefactorConfig refactorConfig) {
        if (refactorConfig.isCountMerge()) {
            target.setProperty("count", (Object)((Integer)target.getProperty("count", (Object)0) + 1));
        }
        PropertiesManager.mergeProperties(source.getAllProperties(), (Entity)target, refactorConfig);
    }

    private boolean connected(NodeCursor start, long end, int[][] typedDirections) {
        try (RelationshipTraversalCursor relationship = this.ktx.cursors().allocateRelationshipTraversalCursor(this.ktx.cursorContext());){
            start.relationships(relationship, RelationshipSelection.selection((Direction)Direction.BOTH));
            while (relationship.next()) {
                if (relationship.otherNodeReference() != end) continue;
                if (typedDirections == null) {
                    boolean bl = true;
                    return bl;
                }
                int direction = relationship.targetNodeReference() == end ? 0 : 1;
                int[] types = typedDirections[direction];
                if (!this.arrayContains(types, relationship.type())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean arrayContains(int[] array, int element) {
        for (int j : array) {
            if (j != element) continue;
            return true;
        }
        return false;
    }

    private int[][] typedDirections(TokenRead ops, List<Pair<RelationshipType, Direction>> pairs) {
        if (pairs == null) {
            return null;
        }
        int from = 0;
        int to = 0;
        int[][] result = new int[2][pairs.size()];
        int outIdx = Direction.OUTGOING.ordinal();
        int inIdx = Direction.INCOMING.ordinal();
        for (Pair<RelationshipType, Direction> pair : pairs) {
            int type = ops.relationshipType(pair.getLeft().name());
            if (type == -1) continue;
            if (pair.getRight() != Direction.INCOMING) {
                result[outIdx][from++] = type;
            }
            if (pair.getRight() == Direction.OUTGOING) continue;
            result[inIdx][to++] = type;
        }
        result[outIdx] = Arrays.copyOf(result[outIdx], from);
        result[inIdx] = Arrays.copyOf(result[inIdx], to);
        return result;
    }

    @UserFunction(value="apoc.node.labels")
    @Description(value="Returns the labels for the given virtual `NODE`.")
    public List<String> labels(@Name(value="node") Node node) {
        if (node == null) {
            return null;
        }
        Iterator labels = node.getLabels().iterator();
        if (!labels.hasNext()) {
            return Collections.emptyList();
        }
        Label first = (Label)labels.next();
        if (!labels.hasNext()) {
            return Collections.singletonList(first.name());
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(first.name());
        labels.forEachRemaining(l -> result.add(l.name()));
        return result;
    }

    @UserFunction(value="apoc.node.id")
    @Description(value="Returns the id for the given virtual `NODE`.")
    public Long id(@Name(value="node") Node node) {
        return node == null ? null : Long.valueOf(node.getId());
    }

    @UserFunction(value="apoc.rel.id")
    @Description(value="Returns the id for the given virtual `RELATIONSHIP`.")
    public Long relId(@Name(value="rel") Relationship rel) {
        return rel == null ? null : Long.valueOf(rel.getId());
    }

    @UserFunction(value="apoc.rel.startNode")
    @Description(value="Returns the start `NODE` for the given virtual `RELATIONSHIP`.")
    public Node startNode(@Name(value="rel") Relationship rel) {
        return rel == null ? null : rel.getStartNode();
    }

    @UserFunction(value="apoc.rel.endNode")
    @Description(value="Returns the end `NODE` for the given virtual `RELATIONSHIP`.")
    public Node endNode(@Name(value="rel") Relationship rel) {
        return rel == null ? null : rel.getEndNode();
    }

    @UserFunction(value="apoc.rel.type")
    @Description(value="Returns the type for the given virtual `RELATIONSHIP`.")
    public String type(@Name(value="rel") Relationship rel) {
        return rel == null ? null : rel.getType().name();
    }

    @UserFunction(value="apoc.any.properties")
    @Description(value="Returns all properties of the given object.\nThe object can be a virtual `NODE`, a real `NODE`, a virtual `RELATIONSHIP`, a real `RELATIONSHIP`, or a `MAP`.")
    public Map<String, Object> properties(@Name(value="object") Object thing, @Name(value="keys", defaultValue="null") List<String> keys) {
        if (thing == null) {
            return null;
        }
        if (thing instanceof Map) {
            Map map = (Map)thing;
            if (keys != null) {
                map.keySet().retainAll(keys);
            }
            return map;
        }
        if (thing instanceof Entity) {
            if (keys == null) {
                return ((Entity)thing).getAllProperties();
            }
            return ((Entity)thing).getProperties(keys.toArray(new String[keys.size()]));
        }
        return null;
    }

    @UserFunction(value="apoc.any.property")
    @Description(value="Returns the property for the given key from an object.\nThe object can be a virtual `NODE`, a real `NODE`, a virtual `RELATIONSHIP`, a real `RELATIONSHIP`, or a `MAP`.")
    public Object property(@Name(value="object") Object thing, @Name(value="key") String key) {
        if (thing == null || key == null) {
            return null;
        }
        if (thing instanceof Map) {
            return ((Map)thing).get(key);
        }
        if (thing instanceof Entity) {
            return ((Entity)thing).getProperty(key, null);
        }
        return null;
    }

    @UserFunction(value="apoc.node.degree")
    @Description(value="Returns the total degrees of the given `NODE`.")
    public long degree(@Name(value="node") Node node, @Name(value="relTypes", defaultValue="") String types) {
        if (types == null || types.isEmpty()) {
            return node.getDegree();
        }
        long degree = 0L;
        for (Pair<RelationshipType, Direction> pair : RelationshipTypeAndDirections.parse(types)) {
            degree += (long)this.getDegreeSafe(node, pair.getLeft(), pair.getRight());
        }
        return degree;
    }

    @UserFunction(value="apoc.node.degree.in")
    @Description(value="Returns the total number of incoming `RELATIONSHIP` values connected to the given `NODE`.")
    public long degreeIn(@Name(value="node") Node node, @Name(value="relTypes", defaultValue="") String type) {
        if (type == null || type.isEmpty()) {
            return node.getDegree(Direction.INCOMING);
        }
        return node.getDegree(RelationshipType.withName((String)type), Direction.INCOMING);
    }

    @UserFunction(value="apoc.node.degree.out")
    @Description(value="Returns the total number of outgoing `RELATIONSHIP` values from the given `NODE`.")
    public long degreeOut(@Name(value="node") Node node, @Name(value="relTypes", defaultValue="") String type) {
        if (type == null || type.isEmpty()) {
            return node.getDegree(Direction.OUTGOING);
        }
        return node.getDegree(RelationshipType.withName((String)type), Direction.OUTGOING);
    }

    @UserFunction(value="apoc.node.relationship.types")
    @Description(value="Returns a `LIST<STRING>` of distinct `RELATIONSHIP` types for the given `NODE`.")
    public List<String> relationshipTypes(@Name(value="node") Node node, @Name(value="relTypes", defaultValue="") String types) {
        if (node == null) {
            return null;
        }
        List<String> relTypes = Iterables.stream(node.getRelationshipTypes()).map(RelationshipType::name).collect(Collectors.toList());
        if (types == null || types.isEmpty()) {
            return relTypes;
        }
        ArrayList<String> result = new ArrayList<String>(relTypes.size());
        for (Pair<RelationshipType, Direction> p : RelationshipTypeAndDirections.parse(types)) {
            String name = p.getLeft().name();
            if (!relTypes.contains(name) || !node.hasRelationship(p.getRight(), new RelationshipType[]{p.getLeft()})) continue;
            result.add(name);
        }
        return result;
    }

    @UserFunction(value="apoc.nodes.relationship.types")
    @Description(value="Returns a `LIST<STRING>` of distinct `RELATIONSHIP` types from the given `LIST<NODE>` values.")
    public List<Map<String, Object>> nodesRelationshipTypes(@Name(value="nodes") Object ids, @Name(value="types", defaultValue="") String types) {
        if (ids == null) {
            return null;
        }
        return Util.nodeStream((InternalTransaction)this.tx, ids).map(node -> {
            List<String> relationshipTypes = this.relationshipTypes((Node)node, types);
            if (relationshipTypes == null) {
                return null;
            }
            return Util.map("node", node, "types", relationshipTypes);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @UserFunction(value="apoc.node.relationships.exist")
    @Description(value="Returns a `BOOLEAN` based on whether the given `NODE` has connecting `RELATIONSHIP` values (or whether the given `NODE` has connecting `RELATIONSHIP` values of the given type and direction).")
    public Map<String, Boolean> relationshipExists(@Name(value="node") Node node, @Name(value="relTypes", defaultValue="") String types) {
        if (node == null || types == null || types.isEmpty()) {
            return null;
        }
        List<String> relTypes = Iterables.stream(node.getRelationshipTypes()).map(RelationshipType::name).toList();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Pair<RelationshipType, Direction> p : RelationshipTypeAndDirections.parse(types)) {
            String name = p.getLeft().name();
            boolean hasRelationship = relTypes.contains(name) && node.hasRelationship(p.getRight(), new RelationshipType[]{p.getLeft()});
            result.put(RelationshipTypeAndDirections.format(p), hasRelationship);
        }
        return result;
    }

    @UserFunction(value="apoc.nodes.relationships.exist")
    @Description(value="Returns a `BOOLEAN` based on whether or not the given `NODE` values have the given `RELATIONSHIP` values.")
    public List<Map<String, Object>> nodesRelationshipExists(@Name(value="nodes") Object ids, @Name(value="types", defaultValue="") String types) {
        if (ids == null) {
            return null;
        }
        return Util.nodeStream((InternalTransaction)this.tx, ids).map(node -> {
            Map<String, Boolean> existsMap = this.relationshipExists((Node)node, types);
            if (existsMap == null) {
                return null;
            }
            return Util.map("node", node, "exists", existsMap);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @UserFunction(value="apoc.nodes.isDense")
    @Description(value="Returns true if the given `NODE` is a dense node.")
    public boolean isDense(@Name(value="node") Node node) {
        try (NodeCursor nodeCursor = this.ktx.cursors().allocateNodeCursor(this.ktx.cursorContext());){
            long id = ((InternalTransaction)this.tx).elementIdMapper().nodeId(node.getElementId());
            this.ktx.dataRead().singleNode(id, nodeCursor);
            if (nodeCursor.next()) {
                boolean bl = nodeCursor.supportsFastDegreeLookup();
                return bl;
            }
            throw new IllegalArgumentException("node with id " + id + " does not exist.");
        }
    }

    @NotThreadSafe
    @UserFunction(value="apoc.any.isDeleted")
    @Description(value="Returns true if the given `NODE` or `RELATIONSHIP` no longer exists.")
    public boolean isDeleted(@Name(value="object") Object object) {
        String query;
        if (object == null) {
            return true;
        }
        if (object instanceof Node) {
            query = "MATCH (n) WHERE elementId(n) = $id RETURN COUNT(n) = 1 AS exists";
        } else if (object instanceof Relationship) {
            query = "MATCH ()-[r]->() WHERE elementId(r) = $id RETURN COUNT(r) = 1 AS exists";
        } else {
            throw new IllegalArgumentException("expected Node or Relationship but was " + object.getClass().getSimpleName());
        }
        return (Boolean)this.tx.execute(query, Map.of("id", ((Entity)object).getElementId())).next().get("exists") == false;
    }

    private int getDegreeSafe(Node node, RelationshipType relType, Direction direction) {
        if (relType == null) {
            return node.getDegree(direction);
        }
        return node.getDegree(relType, direction);
    }
}

