/*
 * Decompiled with CFR 0.152.
 */
package apoc.neighbors;

import apoc.path.RelationshipTypeAndDirections;
import apoc.result.ListResult;
import apoc.result.LongResult;
import apoc.result.NodeListResult;
import apoc.result.NodeResult;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class Neighbors {
    @Context
    public Transaction tx;

    private Iterable<Relationship> getRelationshipsByTypeAndDirection(Node node, Pair<RelationshipType, Direction> typesAndDirection) {
        if (typesAndDirection.getLeft() == null) {
            return typesAndDirection.getRight() == null ? Collections.emptyList() : node.getRelationships(typesAndDirection.getRight());
        }
        if (typesAndDirection.getRight() == null) {
            return typesAndDirection.getLeft() == null ? Collections.emptyList() : node.getRelationships(new RelationshipType[]{typesAndDirection.getLeft()});
        }
        return node.getRelationships(typesAndDirection.getRight(), new RelationshipType[]{typesAndDirection.getLeft()});
    }

    @Procedure(value="apoc.neighbors.tohop")
    @Description(value="Returns all `NODE` values connected by the given `RELATIONSHIP` types within the specified distance.\n`NODE` values are returned individually for each row.")
    public Stream<NodeResult> neighbors(@Name(value="node") Node node, @Name(value="relTypes", defaultValue="") String types, @Name(value="distance", defaultValue="1") Long distance) {
        if (distance < 1L) {
            return Stream.empty();
        }
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        long startNodeId = Util.getNodeId((InternalTransaction)this.tx, node.getElementId());
        Roaring64NavigableMap seen = new Roaring64NavigableMap();
        Roaring64NavigableMap nextA = new Roaring64NavigableMap();
        Roaring64NavigableMap nextB = new Roaring64NavigableMap();
        String nodeElementId = node.getElementId();
        long nodeId = Util.getNodeId((InternalTransaction)this.tx, nodeElementId);
        seen.addLong(nodeId);
        List<Pair<RelationshipType, Direction>> typesAndDirections = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
            for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                nextB.addLong(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
            }
        }
        int i = 1;
        while ((long)i < distance) {
            nextB.andNot(seen);
            seen.or(nextB);
            nextA.clear();
            Iterator<Long> iterator = nextB.iterator();
            while (iterator.hasNext()) {
                nodeElementId = Util.getNodeElementId((InternalTransaction)this.tx, iterator.next());
                node = this.tx.getNodeByElementId(nodeElementId);
                for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                    for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                        nextA.add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
                    }
                }
            }
            if ((long)(++i) < distance) {
                nextA.andNot(seen);
                seen.or(nextA);
                nextB.clear();
                iterator = nextA.iterator();
                while (iterator.hasNext()) {
                    nodeElementId = Util.getNodeElementId((InternalTransaction)this.tx, iterator.next());
                    node = this.tx.getNodeByElementId(nodeElementId);
                    for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                        for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                            nextB.add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
                        }
                    }
                }
            }
            ++i;
        }
        if (distance % 2L == 0L) {
            seen.or(nextA);
        } else {
            seen.or(nextB);
        }
        seen.removeLong(startNodeId);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(seen.iterator(), 4), false).map(x -> new NodeResult(this.tx.getNodeByElementId(Util.getNodeElementId((InternalTransaction)this.tx, x))));
    }

    @Procedure(value="apoc.neighbors.tohop.count")
    @Description(value="Returns the count of all `NODE` values connected by the given `RELATIONSHIP` values in the pattern within the specified distance.")
    public Stream<LongResult> neighborsCount(@Name(value="node") Node node, @Name(value="relTypes", defaultValue="") String types, @Name(value="distance", defaultValue="1") Long distance) {
        if (distance < 1L) {
            return Stream.empty();
        }
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        long startNodeId = Util.getNodeId((InternalTransaction)this.tx, node.getElementId());
        Roaring64NavigableMap seen = new Roaring64NavigableMap();
        Roaring64NavigableMap nextA = new Roaring64NavigableMap();
        Roaring64NavigableMap nextB = new Roaring64NavigableMap();
        String nodeElementId = node.getElementId();
        long nodeId = Util.getNodeId((InternalTransaction)this.tx, nodeElementId);
        seen.add(nodeId);
        List<Pair<RelationshipType, Direction>> typesAndDirections = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
            for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                nextB.add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
            }
        }
        int i = 1;
        while ((long)i < distance) {
            nextB.andNot(seen);
            seen.or(nextB);
            nextA.clear();
            Iterator<Long> iterator = nextB.iterator();
            while (iterator.hasNext()) {
                nodeElementId = Util.getNodeElementId((InternalTransaction)this.tx, iterator.next());
                node = this.tx.getNodeByElementId(nodeElementId);
                for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                    for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                        nextA.add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
                    }
                }
            }
            if ((long)(++i) < distance) {
                nextA.andNot(seen);
                seen.or(nextA);
                nextB.clear();
                iterator = nextA.iterator();
                while (iterator.hasNext()) {
                    nodeElementId = Util.getNodeElementId((InternalTransaction)this.tx, iterator.next());
                    node = this.tx.getNodeByElementId(nodeElementId);
                    for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                        for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                            nextB.add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
                        }
                    }
                }
            }
            ++i;
        }
        if (distance % 2L == 0L) {
            seen.or(nextA);
        } else {
            seen.or(nextB);
        }
        seen.removeLong(startNodeId);
        return Stream.of(new LongResult(seen.getLongCardinality()));
    }

    @Procedure(value="apoc.neighbors.byhop")
    @Description(value="Returns all `NODE` values connected by the given `RELATIONSHIP` types within the specified distance. Returns `LIST<NODE>` values, where each `PATH` of `NODE` values represents one row of the `LIST<NODE>` values.")
    public Stream<NodeListResult> neighborsByHop(@Name(value="node") Node node, @Name(value="relTypes", defaultValue="") String types, @Name(value="distance", defaultValue="1") Long distance) {
        if (distance < 1L) {
            return Stream.empty();
        }
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        Roaring64NavigableMap[] seen = new Roaring64NavigableMap[distance.intValue()];
        int i = 0;
        while ((long)i < distance) {
            seen[i] = new Roaring64NavigableMap();
            ++i;
        }
        String nodeElementId = node.getElementId();
        long nodeId = Util.getNodeId((InternalTransaction)this.tx, nodeElementId);
        List<Pair<RelationshipType, Direction>> typesAndDirections = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
            for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                seen[0].add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
            }
        }
        int i2 = 1;
        while ((long)i2 < distance) {
            Iterator<Long> iterator = seen[i2 - 1].iterator();
            while (iterator.hasNext()) {
                nodeElementId = Util.getNodeElementId((InternalTransaction)this.tx, iterator.next());
                node = this.tx.getNodeByElementId(nodeElementId);
                for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                    for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                        seen[i2].add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
                    }
                }
            }
            for (int j = 0; j < i2; ++j) {
                seen[i2].andNot(seen[j]);
                seen[i2].removeLong(nodeId);
            }
            ++i2;
        }
        return Arrays.stream(seen).map(x -> new NodeListResult(StreamSupport.stream(Spliterators.spliteratorUnknownSize(x.iterator(), 4), false).map(y -> this.tx.getNodeByElementId(Util.getNodeElementId((InternalTransaction)this.tx, y))).collect(Collectors.toList())));
    }

    @Procedure(value="apoc.neighbors.byhop.count")
    @Description(value="Returns the count of all `NODE` values connected by the given `RELATIONSHIP` types within the specified distance.")
    public Stream<ListResult> neighborsByHopCount(@Name(value="node") Node node, @Name(value="relTypes", defaultValue="") String types, @Name(value="distance", defaultValue="1") Long distance) {
        if (distance < 1L) {
            return Stream.empty();
        }
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        Roaring64NavigableMap[] seen = new Roaring64NavigableMap[distance.intValue()];
        int i = 0;
        while ((long)i < distance) {
            seen[i] = new Roaring64NavigableMap();
            ++i;
        }
        String nodeElementId = node.getElementId();
        long nodeId = Util.getNodeId((InternalTransaction)this.tx, nodeElementId);
        List<Pair<RelationshipType, Direction>> typesAndDirections = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
            for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                seen[0].add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
            }
        }
        int i2 = 1;
        while ((long)i2 < distance) {
            Iterator<Long> iterator = seen[i2 - 1].iterator();
            while (iterator.hasNext()) {
                nodeElementId = Util.getNodeElementId((InternalTransaction)this.tx, iterator.next());
                node = this.tx.getNodeByElementId(nodeElementId);
                for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                    for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                        seen[i2].add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
                    }
                }
            }
            for (int j = 0; j < i2; ++j) {
                seen[i2].andNot(seen[j]);
                seen[i2].removeLong(nodeId);
            }
            ++i2;
        }
        ArrayList<Object> counts = new ArrayList<Object>();
        int i3 = 0;
        while ((long)i3 < distance) {
            counts.add(seen[i3].getLongCardinality());
            ++i3;
        }
        return Stream.of(new ListResult(counts));
    }

    @Procedure(value="apoc.neighbors.athop")
    @Description(value="Returns all `NODE` values connected by the given `RELATIONSHIP` types at the specified distance.")
    public Stream<NodeResult> neighborsAtHop(@Name(value="node") Node node, @Name(value="relTypes", defaultValue="") String types, @Name(value="distance", defaultValue="1") Long distance) {
        if (distance < 1L) {
            return Stream.empty();
        }
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        Roaring64NavigableMap[] seen = new Roaring64NavigableMap[distance.intValue()];
        int i = 0;
        while ((long)i < distance) {
            seen[i] = new Roaring64NavigableMap();
            ++i;
        }
        String nodeElementId = node.getElementId();
        long nodeId = Util.getNodeId((InternalTransaction)this.tx, nodeElementId);
        List<Pair<RelationshipType, Direction>> typesAndDirections = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
            for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                seen[0].add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
            }
        }
        int i2 = 1;
        while ((long)i2 < distance) {
            Iterator<Long> iterator = seen[i2 - 1].iterator();
            while (iterator.hasNext()) {
                nodeElementId = Util.getNodeElementId((InternalTransaction)this.tx, iterator.next());
                node = this.tx.getNodeByElementId(nodeElementId);
                for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                    for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                        seen[i2].add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
                    }
                }
            }
            for (int j = 0; j < i2; ++j) {
                seen[i2].andNot(seen[j]);
                seen[i2].removeLong(nodeId);
            }
            ++i2;
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(seen[distance.intValue() - 1].iterator(), 4), false).map(y -> new NodeResult(this.tx.getNodeByElementId(Util.getNodeElementId((InternalTransaction)this.tx, y))));
    }

    @Procedure(value="apoc.neighbors.athop.count")
    @Description(value="Returns the count of all `NODE` values connected by the given `RELATIONSHIP` types at the specified distance.")
    public Stream<LongResult> neighborsAtHopCount(@Name(value="node") Node node, @Name(value="relTypes", defaultValue="") String types, @Name(value="distance", defaultValue="1") Long distance) {
        if (distance < 1L) {
            return Stream.empty();
        }
        if (types == null || types.isEmpty()) {
            return Stream.empty();
        }
        Roaring64NavigableMap[] seen = new Roaring64NavigableMap[distance.intValue()];
        int i = 0;
        while ((long)i < distance) {
            seen[i] = new Roaring64NavigableMap();
            ++i;
        }
        String nodeElementId = node.getElementId();
        long nodeId = Util.getNodeId((InternalTransaction)this.tx, nodeElementId);
        List<Pair<RelationshipType, Direction>> typesAndDirections = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
            for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                seen[0].add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
            }
        }
        int i2 = 1;
        while ((long)i2 < distance) {
            Iterator<Long> iterator = seen[i2 - 1].iterator();
            while (iterator.hasNext()) {
                nodeElementId = Util.getNodeElementId((InternalTransaction)this.tx, iterator.next());
                node = this.tx.getNodeByElementId(nodeElementId);
                for (Pair<RelationshipType, Direction> pair : typesAndDirections) {
                    for (Relationship r : this.getRelationshipsByTypeAndDirection(node, pair)) {
                        seen[i2].add(Util.getNodeId((InternalTransaction)this.tx, r.getOtherNode(node).getElementId()));
                    }
                }
            }
            for (int j = 0; j < i2; ++j) {
                seen[i2].andNot(seen[j]);
                seen[i2].removeLong(nodeId);
            }
            ++i2;
        }
        return Stream.of(new LongResult(seen[distance.intValue() - 1].getLongCardinality()));
    }
}

