/*
 * Decompiled with CFR 0.152.
 */
package apoc.meta;

import apoc.export.util.NodesAndRelsSubGraph;
import apoc.meta.ConstraintTracker;
import apoc.meta.MetaConfig;
import apoc.meta.SampleMetaConfig;
import apoc.meta.Tables4LabelsProfile;
import apoc.meta.Types;
import apoc.result.GraphResult;
import apoc.result.MapResult;
import apoc.result.VirtualGraph;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.CollectionUtils;
import apoc.util.MapUtil;
import apoc.util.collection.Iterables;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.cypher.export.CypherResultSubGraph;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Meta {
    @Context
    public Transaction tx;
    @Context
    public KernelTransaction kernelTx;
    @Context
    public Transaction transaction;
    @Context
    public Log log;

    @UserFunction(value="apoc.meta.cypher.isType")
    @Description(value="Returns true if the given value matches the given type.")
    public boolean isTypeCypher(@Name(value="value") Object value, @Name(value="type") String type) {
        return type.equalsIgnoreCase(this.typeCypher(value));
    }

    @UserFunction(value="apoc.meta.cypher.type")
    @Description(value="Returns the type name of the given value.")
    public String typeCypher(@Name(value="value") Object value) {
        Types type = Types.of(value);
        switch (type) {
            case ANY: {
                return value.getClass().getSimpleName();
            }
        }
        return type.toString();
    }

    @UserFunction(value="apoc.meta.cypher.types")
    @Description(value="Returns a `MAP` containing the type names of the given values.")
    public Map<String, Object> typesCypher(@Name(value="props") Object target) {
        Map properties = Collections.emptyMap();
        if (target instanceof Node) {
            properties = ((Node)target).getAllProperties();
        }
        if (target instanceof Relationship) {
            properties = ((Relationship)target).getAllProperties();
        }
        if (target instanceof Map) {
            properties = (Map)target;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(properties.size());
        properties.forEach((key, value) -> result.put((String)key, this.typeCypher(value)));
        return result;
    }

    @NotThreadSafe
    @Procedure(value="apoc.meta.stats")
    @Description(value="Returns the metadata stored in the transactional database statistics.")
    public Stream<MetaStats> stats() {
        return Stream.of(this.collectStats());
    }

    @NotThreadSafe
    @UserFunction(name="apoc.meta.nodes.count")
    @Description(value="Returns the sum of the `NODE` values with the given labels in the `LIST<STRING>`.")
    public long count(@Name(value="nodes", defaultValue="[]") List<String> nodes, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MetaConfig conf = new MetaConfig(config);
        SubGraph subGraph = DatabaseSubGraph.optimizedForCount(this.transaction, this.kernelTx);
        Stream<Label> labels = CollectionUtils.isEmpty(nodes) ? StreamSupport.stream(subGraph.getAllLabelsInUse().spliterator(), false) : nodes.stream().filter(Objects::nonNull).map(String::trim).map(Label::label);
        boolean isIncludeRels = CollectionUtils.isEmpty(conf.getIncludeRels());
        HashSet visitedNodes = new HashSet();
        return labels.flatMap(label -> isIncludeRels ? Stream.of(Long.valueOf(subGraph.countsForNode((Label)label))) : conf.getIncludeRels().stream().filter(Objects::nonNull).map(String::trim).map(rel -> {
            Direction direction;
            int lastCharIdx = rel.length() - 1;
            switch (rel.charAt(lastCharIdx)) {
                case '>': {
                    direction = Direction.OUTGOING;
                    rel = rel.substring(0, lastCharIdx);
                    break;
                }
                case '<': {
                    direction = Direction.INCOMING;
                    rel = rel.substring(0, lastCharIdx);
                    break;
                }
                default: {
                    direction = Direction.BOTH;
                }
            }
            return Pair.of(direction, rel);
        }).flatMap(pair -> this.transaction.findNodes(label).map(node -> {
            if (!visitedNodes.contains(node.getElementId()) && node.hasRelationship((Direction)pair.getLeft(), new RelationshipType[]{RelationshipType.withName((String)((String)pair.getRight()))})) {
                visitedNodes.add(node.getElementId());
                return 1L;
            }
            return 0L;
        }).stream())).reduce(0L, Math::addExact);
    }

    private MetaStats collectStats() {
        final LinkedHashMap<String, Long> relStatsCount = new LinkedHashMap<String, Long>();
        TokenRead tokenRead = this.kernelTx.tokenRead();
        Read read = this.kernelTx.dataRead();
        long relTypeCount = Iterables.count(this.tx.getAllRelationshipTypesInUse());
        long labelCount = Iterables.count(this.tx.getAllLabelsInUse());
        final LinkedHashMap<String, Long> labelStats = new LinkedHashMap<String, Long>((int)labelCount);
        final LinkedHashMap<String, Long> relStats = new LinkedHashMap<String, Long>(2 * (int)relTypeCount);
        this.collectStats(DatabaseSubGraph.optimizedForCount(this.transaction, this.kernelTx), new StatsCallback(){

            @Override
            public void label(String labelName, long count) {
                if (count > 0L) {
                    labelStats.put(labelName, count);
                }
            }

            @Override
            public void rel(String typeName, long count) {
                if (count > 0L) {
                    relStatsCount.merge(typeName, count, Long::sum);
                    relStats.put("()-[:" + typeName + "]->()", count);
                }
            }

            @Override
            public void rel(String typeName, String labelName, long out, long in) {
                if (out > 0L) {
                    relStats.put("(:" + labelName + ")-[:" + typeName + "]->()", out);
                }
                if (in > 0L) {
                    relStats.put("()-[:" + typeName + "]->(:" + labelName + ")", in);
                }
            }
        });
        return new MetaStats(labelCount, relTypeCount, tokenRead.propertyKeyCount(), read.countsForNode(-1), read.countsForRelationship(-1, -1, -1), labelStats, relStats, relStatsCount);
    }

    private void collectStats(SubGraph subGraph, StatsCallback cb) {
        Iterable<Label> labels = subGraph.getAllLabelsInUse();
        Iterable<RelationshipType> types = subGraph.getAllRelationshipTypesInUse();
        labels.forEach(label -> {
            long count = subGraph.countsForNode((Label)label);
            if (count > 0L) {
                String name = label.name();
                cb.label(name, count);
                types.forEach(type -> {
                    long relCountOut = subGraph.countsForRelationship((Label)label, (RelationshipType)type);
                    long relCountIn = subGraph.countsForRelationship((RelationshipType)type, (Label)label);
                    cb.rel(type.name(), name, relCountOut, relCountIn);
                });
            }
        });
        types.forEach(type -> {
            String name = type.name();
            cb.rel(name, subGraph.countsForRelationship((RelationshipType)type));
        });
    }

    @NotThreadSafe
    @Procedure(value="apoc.meta.data.of")
    @Description(value="Examines the given sub-graph and returns a table of metadata.")
    public Stream<MetaResult> dataOf(@Name(value="graph") Object graph, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        SubGraph subGraph;
        MetaConfig metaConfig = new MetaConfig(config);
        if (graph instanceof String) {
            Result result = this.tx.execute((String)graph);
            subGraph = CypherResultSubGraph.from(this.tx, result, metaConfig.isAddRelationshipsBetweenNodes());
        } else if (graph instanceof Map) {
            Map mGraph = (Map)graph;
            if (!mGraph.containsKey("nodes")) {
                throw new IllegalArgumentException("Graph Map must contains `nodes` field and `relationships` optionally");
            }
            subGraph = new NodesAndRelsSubGraph(this.tx, (Collection)mGraph.get("nodes"), (Collection)mGraph.get("relationships"));
        } else if (graph instanceof VirtualGraph) {
            VirtualGraph vGraph = (VirtualGraph)graph;
            subGraph = new NodesAndRelsSubGraph(this.tx, vGraph.nodes(), vGraph.relationships());
        } else {
            throw new IllegalArgumentException("Supported inputs are String, VirtualGraph, Map");
        }
        return this.collectMetaData(subGraph, metaConfig.getSampleMetaConfig()).values().stream().flatMap(x -> x.values().stream());
    }

    @NotThreadSafe
    @Procedure(value="apoc.meta.data")
    @Description(value="Examines the full graph and returns a table of metadata.")
    public Stream<MetaResult> data(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        SampleMetaConfig metaConfig = new SampleMetaConfig(config);
        return this.collectMetaData(DatabaseSubGraph.optimizedForCount(this.transaction, this.kernelTx), metaConfig).values().stream().flatMap(x -> x.values().stream());
    }

    @NotThreadSafe
    @Procedure(value="apoc.meta.schema")
    @Description(value="Examines the given sub-graph and returns metadata as a `MAP`.")
    public Stream<MapResult> schema(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Map<String, Object> relationships;
        MetaStats metaStats = this.collectStats();
        SampleMetaConfig metaConfig = new SampleMetaConfig(config);
        Map<MetadataKey, Map<String, MetaItem>> metaData = this.collectMetaData(DatabaseSubGraph.optimizedForCount(this.transaction, this.kernelTx), metaConfig);
        Map<String, Object> nodes = this.collectNodesMetaData(metaStats, metaData, relationships = this.collectRelationshipsMetaData(metaStats, metaData));
        Sets.SetView commonKeys = Sets.intersection(nodes.keySet(), relationships.keySet());
        if (!commonKeys.isEmpty()) {
            relationships = relationships.entrySet().stream().map(arg_0 -> Meta.lambda$schema$10((Collection)commonKeys, arg_0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        nodes.putAll(relationships);
        return Stream.of(new MapResult(nodes));
    }

    @NotThreadSafe
    @Procedure(value="apoc.meta.nodeTypeProperties")
    @Description(value="Examines the full graph and returns a table of metadata with information about the `NODE` values therein.")
    public Stream<Tables4LabelsProfile.NodeTypePropertiesEntry> nodeTypeProperties(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MetaConfig metaConfig = new MetaConfig(config);
        try {
            return this.collectTables4LabelsProfile(metaConfig).asNodeStream();
        }
        catch (Exception e) {
            this.log.debug("apoc.meta.nodeTypeProperties(): Failed to return stream", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @NotThreadSafe
    @Procedure(value="apoc.meta.relTypeProperties")
    @Description(value="Examines the full graph and returns a table of metadata with information about the `RELATIONSHIP` values therein.")
    public Stream<Tables4LabelsProfile.RelTypePropertiesEntry> relTypeProperties(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MetaConfig metaConfig = new MetaConfig(config);
        try {
            return this.collectTables4LabelsProfile(metaConfig).asRelStream();
        }
        catch (Exception e) {
            this.log.debug("apoc.meta.relTypeProperties(): Failed to return stream", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Tables4LabelsProfile collectTables4LabelsProfile(MetaConfig config) {
        Tables4LabelsProfile profile = new Tables4LabelsProfile();
        Schema schema = this.tx.schema();
        for (ConstraintDefinition cd : schema.getConstraints()) {
            List<Object> props;
            if (cd.isConstraintType(ConstraintType.NODE_PROPERTY_EXISTENCE)) {
                props = new ArrayList(10);
                if (ConstraintTracker.nodeConstraints.containsKey(cd.getLabel().name())) {
                    props = ConstraintTracker.nodeConstraints.get(cd.getLabel().name());
                }
                cd.getPropertyKeys().forEach(props::add);
                ConstraintTracker.nodeConstraints.put(cd.getLabel().name(), props);
                continue;
            }
            if (!cd.isConstraintType(ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE)) continue;
            props = new ArrayList(10);
            if (ConstraintTracker.relConstraints.containsKey(cd.getRelationshipType().name())) {
                props = ConstraintTracker.relConstraints.get(cd.getRelationshipType().name());
            }
            cd.getPropertyKeys().forEach(props::add);
            ConstraintTracker.relConstraints.put(cd.getRelationshipType().name(), props);
        }
        Map<String, Long> countStore = Meta.getLabelCountStore(this.transaction, this.kernelTx);
        Set<String> includeLabels = config.getIncludeLabels();
        Set<String> excludeLabels = config.getExcludeLabels();
        Set<String> includeRels = config.getIncludeRels();
        Set<String> excludeRels = config.getExcludeRels();
        for (Label label : this.tx.getAllLabelsInUse()) {
            String labelName = label.name();
            if (excludeLabels.contains(labelName) || !includeLabels.isEmpty() && !includeLabels.contains(labelName)) continue;
            long labelCount = countStore.get(labelName);
            long sample = Meta.getSampleForLabelCount(labelCount, config.getSample());
            ResourceIterator nodes = this.tx.findNodes(label);
            try {
                int count = 1;
                while (nodes.hasNext()) {
                    Set skips;
                    Node node = (Node)nodes.next();
                    if ((long)count++ % sample != 0L || (skips = StreamSupport.stream(node.getRelationshipTypes().spliterator(), false).map(rel -> excludeRels.contains(rel.name()) || !includeRels.isEmpty() && !includeRels.contains(rel.name())).collect(Collectors.toSet())).size() == 1 && ((Boolean)skips.iterator().next()).booleanValue()) continue;
                    profile.observe(node, config);
                }
            }
            finally {
                if (nodes == null) continue;
                nodes.close();
            }
        }
        return profile.finished();
    }

    private Map<MetadataKey, Map<String, MetaItem>> collectMetaData(SubGraph graph, SampleMetaConfig config) {
        LinkedHashMap<MetadataKey, Map<String, MetaItem>> metaData = new LinkedHashMap<MetadataKey, Map<String, MetaItem>>(100);
        Set<RelationshipType> types = Iterables.asSet(graph.getAllRelationshipTypesInUse());
        HashMap<String, Iterable<ConstraintDefinition>> relConstraints = new HashMap<String, Iterable<ConstraintDefinition>>(20);
        HashMap<String, Set<String>> relIndexes = new HashMap<String, Set<String>>();
        for (RelationshipType type : graph.getAllRelationshipTypesInUse()) {
            metaData.put(new MetadataKey(Types.RELATIONSHIP, type.name()), new LinkedHashMap(10));
            relConstraints.put(type.name(), graph.getConstraints(type));
            relIndexes.put(type.name(), this.getIndexedProperties(graph.getIndexes(type)));
        }
        for (Label label : graph.getAllLabelsInUse()) {
            LinkedHashMap<String, MetaItem> nodeMeta = new LinkedHashMap<String, MetaItem>(50);
            String labelName = label.name();
            metaData.put(new MetadataKey(Types.NODE, labelName), nodeMeta);
            Iterable<ConstraintDefinition> constraints = graph.getConstraints(label);
            Set<String> indexed = this.getIndexedProperties(graph.getIndexes(label));
            long labelCount = graph.countsForNode(label);
            long sample = Meta.getSampleForLabelCount(labelCount, config.getSample());
            Iterator<Node> nodes = graph.findNodes(label);
            int count = 1;
            while (nodes.hasNext()) {
                Node node = nodes.next();
                if ((long)count++ % sample != 0L) continue;
                this.addRelationships(metaData, nodeMeta, labelName, node, relConstraints, types, relIndexes);
                this.addProperties(nodeMeta, labelName, constraints, indexed, (Entity)node, node);
            }
        }
        return metaData;
    }

    private Set<String> getIndexedProperties(Iterable<IndexDefinition> indexes) {
        return Iterables.stream(indexes).map(IndexDefinition::getPropertyKeys).flatMap(Iterables::stream).collect(Collectors.toSet());
    }

    private static Map<String, Long> getLabelCountStore(Transaction tx, KernelTransaction kernelTx) {
        List labels = Iterables.stream(tx.getAllLabelsInUse()).map(Label::name).collect(Collectors.toList());
        TokenRead tokenRead = kernelTx.tokenRead();
        return labels.stream().collect(Collectors.toMap(e -> e, e -> kernelTx.dataRead().countsForNode(tokenRead.nodeLabel(e))));
    }

    public static long getSampleForLabelCount(long labelCount, long sample) {
        if (sample != -1L) {
            long max;
            long skipCount = labelCount / sample;
            long min = (long)Math.floor((double)skipCount - (double)skipCount * 0.1);
            if (min >= (max = (long)Math.ceil((double)skipCount + (double)skipCount * 0.1))) {
                return -1L;
            }
            long randomValue = ThreadLocalRandom.current().nextLong(min, max);
            return randomValue == 0L ? -1L : randomValue;
        }
        return sample;
    }

    private Map<String, Object> collectNodesMetaData(MetaStats metaStats, Map<MetadataKey, Map<String, MetaItem>> metaData, Map<String, Object> relationships) {
        LinkedHashMap<String, Object> nodes = new LinkedHashMap<String, Object>();
        HashMap<String, List<Map<String, Object>>> startNodeNameToRelationshipsMap = new HashMap<String, List<Map<String, Object>>>();
        for (MetadataKey metadataKey : metaData.keySet()) {
            Map<String, MetaItem> entityData = metaData.get(metadataKey);
            LinkedHashMap<String, Map<String, Object>> entityProperties = new LinkedHashMap<String, Map<String, Object>>();
            LinkedHashMap<String, Map<String, Object>> entityRelationships = new LinkedHashMap<String, Map<String, Object>>();
            List labels = new LinkedList();
            boolean isNode = metaStats.labels.keySet().stream().anyMatch(label -> metadataKey.key.equals(label));
            for (String entityDataKey : entityData.keySet()) {
                MetaItem metaItem = entityData.get(entityDataKey);
                if (metaItem.elementType.equals("relationship")) {
                    isNode = false;
                    break;
                }
                if (metaItem.unique) {
                    labels = metaItem.otherLabels;
                }
                if (!metaItem.type.equals("RELATIONSHIP")) {
                    entityProperties.put(entityDataKey, MapUtil.map("type", metaItem.type, "indexed", metaItem.index, "unique", metaItem.unique, "existence", metaItem.existence));
                    continue;
                }
                entityRelationships.put(metaItem.property, MapUtil.map("direction", "out", "count", metaItem.rightCount, "labels", metaItem.other, "properties", relationships.getOrDefault(metaItem.property, Map.of()).get("properties")));
                metaItem.other.forEach(o -> {
                    LinkedHashMap<String, Map<String, Object>> mirroredRelationship = new LinkedHashMap<String, Map<String, Object>>();
                    mirroredRelationship.put(metaItem.property, MapUtil.map("direction", "in", "count", metaItem.leftCount, "labels", new LinkedList<String>(Arrays.asList(metaItem.label)), "properties", relationships.getOrDefault(metaItem.property, Map.of()).get("properties")));
                    if (startNodeNameToRelationshipsMap.containsKey(o)) {
                        ((List)startNodeNameToRelationshipsMap.get(o)).add(mirroredRelationship);
                    } else {
                        LinkedList<LinkedHashMap<String, Map<String, Object>>> relList = new LinkedList<LinkedHashMap<String, Map<String, Object>>>();
                        relList.add(mirroredRelationship);
                        startNodeNameToRelationshipsMap.put((String)o, (List<Map<String, Object>>)relList);
                    }
                });
            }
            if (!isNode) continue;
            String key = metadataKey.key;
            nodes.put(key, MapUtil.map("type", "node", "count", metaStats.labels.get(key), "labels", labels, "properties", entityProperties, "relationships", entityRelationships));
        }
        this.setIncomingRelationships(nodes, startNodeNameToRelationshipsMap);
        return nodes;
    }

    private void setIncomingRelationships(Map<String, Object> nodes, Map<String, List<Map<String, Object>>> nodeNameToRelationshipsMap) {
        nodes.keySet().forEach(k -> {
            if (nodeNameToRelationshipsMap.containsKey(k)) {
                Map node = (Map)nodes.get(k);
                List relationshipsToAddList = (List)nodeNameToRelationshipsMap.get(k);
                relationshipsToAddList.forEach(relationshipNameToRelationshipMap -> {
                    Map actualRelationshipsList = (Map)node.get("relationships");
                    relationshipNameToRelationshipMap.keySet().forEach(relationshipName -> {
                        if (actualRelationshipsList.containsKey(relationshipName)) {
                            Map relToAdd = (Map)relationshipNameToRelationshipMap.get(relationshipName);
                            Map existingRel = (Map)actualRelationshipsList.get(relationshipName);
                            List labels = (List)existingRel.get("labels");
                            labels.addAll((List)relToAdd.get("labels"));
                        } else {
                            actualRelationshipsList.put(relationshipName, relationshipNameToRelationshipMap.get(relationshipName));
                        }
                    });
                });
            }
        });
    }

    private Map<String, Object> collectRelationshipsMetaData(MetaStats metaStats, Map<MetadataKey, Map<String, MetaItem>> metaData) {
        LinkedHashMap<String, Object> relationships = new LinkedHashMap<String, Object>();
        for (MetadataKey metadataKey : metaData.keySet()) {
            Map<String, MetaItem> entityData = metaData.get(metadataKey);
            LinkedHashMap<String, Map<String, Object>> entityProperties = new LinkedHashMap<String, Map<String, Object>>();
            boolean isRelationship = metaStats.relTypesCount.keySet().stream().anyMatch(rel -> metadataKey.key.equals(rel));
            for (String entityDataKey : entityData.keySet()) {
                MetaItem metaItem = entityData.get(entityDataKey);
                if (!metaItem.elementType.equals("relationship")) {
                    isRelationship = false;
                    break;
                }
                if (metaItem.type.equals("RELATIONSHIP")) continue;
                entityProperties.put(entityDataKey, MapUtil.map("type", metaItem.type, "array", metaItem.array, "existence", metaItem.existence, "indexed", metaItem.index));
            }
            if (!isRelationship) continue;
            String key = metadataKey.key;
            relationships.put(key, MapUtil.map("type", "relationship", "count", metaStats.relTypesCount.get(key), "properties", entityProperties));
        }
        return relationships;
    }

    private void addProperties(Map<String, MetaItem> properties, String labelName, Iterable<ConstraintDefinition> constraints, Set<String> indexed, Entity pc, Node node) {
        for (String prop : pc.getPropertyKeys()) {
            if (properties.containsKey(prop)) continue;
            MetaItem res = this.metaResultForProp(pc, labelName, prop);
            res.elementType(Types.of(pc).name());
            this.addSchemaInfo(res, prop, constraints, indexed, node);
            properties.put(prop, res);
        }
    }

    private void addRelationships(Map<MetadataKey, Map<String, MetaItem>> metaData, Map<String, MetaItem> nodeMeta, String labelName, Node node, Map<String, Iterable<ConstraintDefinition>> relConstraints, Set<RelationshipType> types, Map<String, Set<String>> relIndexes) {
        StreamSupport.stream(node.getRelationshipTypes().spliterator(), false).filter(type -> types.contains(type)).forEach(type -> {
            int out = node.getDegree(type, Direction.OUTGOING);
            if (out == 0) {
                return;
            }
            String typeName = type.name();
            Iterable constraints = (Iterable)relConstraints.get(typeName);
            Set indexes = (Set)relIndexes.get(typeName);
            if (!nodeMeta.containsKey(typeName)) {
                nodeMeta.put(typeName, new MetaItem(labelName, typeName));
            }
            int in = node.getDegree(type, Direction.INCOMING);
            Map typeMeta = (Map)metaData.get(new MetadataKey(Types.RELATIONSHIP, typeName));
            if (!typeMeta.containsKey(labelName)) {
                typeMeta.put(labelName, new MetaItem(typeName, labelName));
            }
            MetaItem relMeta = (MetaItem)nodeMeta.get(typeName);
            this.addOtherNodeInfo(node, labelName, out, in, (RelationshipType)type, relMeta, typeMeta, constraints, indexes);
        });
    }

    private void addOtherNodeInfo(Node node, String labelName, int out, int in, RelationshipType type, MetaItem relMeta, Map<String, MetaItem> typeMeta, Iterable<ConstraintDefinition> relConstraints, Set<String> indexes) {
        MetaItem relNodeMeta = typeMeta.get(labelName);
        relMeta.elementType(Types.of(node).name());
        relMeta.inc().rel(out, in);
        relNodeMeta.inc().rel(out, in);
        for (Relationship rel : node.getRelationships(Direction.OUTGOING, new RelationshipType[]{type})) {
            Node endNode = rel.getEndNode();
            List<String> labels = this.toStrings(endNode.getLabels());
            relMeta.other(labels);
            relNodeMeta.other(labels);
            this.addProperties(typeMeta, type.name(), relConstraints, indexes, (Entity)rel, node);
            relNodeMeta.elementType(Types.RELATIONSHIP.name());
        }
    }

    private void addSchemaInfo(MetaItem res, String prop, Iterable<ConstraintDefinition> constraints, Set<String> indexed, Node node) {
        if (indexed.contains(prop)) {
            res.index = true;
        }
        if (constraints == null) {
            return;
        }
        for (ConstraintDefinition constraint : constraints) {
            for (String key : constraint.getPropertyKeys()) {
                if (!key.equals(prop)) continue;
                switch (constraint.getConstraintType()) {
                    case UNIQUENESS: {
                        res.unique = true;
                        node.getLabels().forEach(l -> {
                            if (res.label != l.name()) {
                                res.addLabel(l.name());
                            }
                        });
                        break;
                    }
                    case RELATIONSHIP_UNIQUENESS: {
                        res.unique = true;
                        break;
                    }
                    case NODE_PROPERTY_EXISTENCE: 
                    case RELATIONSHIP_PROPERTY_EXISTENCE: {
                        res.existence = true;
                    }
                }
            }
        }
    }

    private MetaItem metaResultForProp(Entity pc, String labelName, String prop) {
        MetaItem res = new MetaItem(labelName, prop);
        Object value = pc.getProperty(prop);
        res.type(Types.of(value).name());
        res.elementType(Types.of(pc).name());
        if (value.getClass().isArray()) {
            res.array = true;
        }
        return res;
    }

    private List<String> toStrings(Iterable<Label> labels) {
        ArrayList<String> res = new ArrayList<String>(10);
        for (Label label : labels) {
            String name = label.name();
            res.add(name);
        }
        return res;
    }

    @NotThreadSafe
    @Procedure(value="apoc.meta.graph")
    @Description(value="Examines the full graph and returns a meta-graph.")
    public Stream<GraphResult> graph(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        SampleMetaConfig metaConfig = new SampleMetaConfig(config, false);
        return this.metaGraph(DatabaseSubGraph.optimizedForCount(this.transaction, this.kernelTx), null, null, true, metaConfig);
    }

    @NotThreadSafe
    @Procedure(value="apoc.meta.graph.of")
    @Description(value="Examines the given sub-graph and returns a meta-graph.")
    public Stream<GraphResult> graphOf(@Name(value="graph", defaultValue="{}") Object graph, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        SubGraph subGraph;
        MetaConfig metaConfig = new MetaConfig(config, false);
        if (graph instanceof String) {
            Result result = this.tx.execute("CYPHER runtime=pipelined " + (String)graph);
            subGraph = CypherResultSubGraph.from(this.tx, result, metaConfig.isAddRelationshipsBetweenNodes());
        } else if (graph instanceof Map) {
            Map mGraph = (Map)graph;
            if (!mGraph.containsKey("nodes")) {
                throw new IllegalArgumentException("Graph Map must contains `nodes` field and `relationships` optionally");
            }
            subGraph = new NodesAndRelsSubGraph(this.tx, (Collection)mGraph.get("nodes"), (Collection)mGraph.get("relationships"));
        } else if (graph instanceof VirtualGraph) {
            VirtualGraph vGraph = (VirtualGraph)graph;
            subGraph = new NodesAndRelsSubGraph(this.tx, vGraph.nodes(), vGraph.relationships());
        } else {
            throw new IllegalArgumentException("Supported inputs are String, VirtualGraph, Map");
        }
        return this.metaGraph(subGraph, null, null, true, metaConfig.getSampleMetaConfig());
    }

    private Stream<GraphResult> metaGraph(SubGraph subGraph, Collection<String> labelNames, Collection<String> relTypeNames, boolean removeMissing, SampleMetaConfig metaConfig) {
        TokenRead tokenRead = this.kernelTx.tokenRead();
        Map<String, Integer> typeMap = subGraph.relTypesInUse(tokenRead, relTypeNames);
        Iterable labels = CollectionUtils.isNotEmpty(labelNames) ? (Iterable)labelNames.stream().map(Label::label).collect(Collectors.toList()) : subGraph.getAllLabelsInUse();
        Iterable types = CollectionUtils.isNotEmpty(relTypeNames) ? (Iterable)relTypeNames.stream().map(RelationshipType::withName).collect(Collectors.toList()) : subGraph.getAllRelationshipTypesInUse();
        TreeMap vNodes = new TreeMap();
        HashMap<Pattern, Relationship> vRels = new HashMap<Pattern, Relationship>(typeMap.size() * 2);
        labels.forEach(label -> {
            long count = subGraph.countsForNode((Label)label);
            if (count > 0L) {
                this.mergeMetaNode((Label)label, vNodes, count);
            }
        });
        types.forEach(type -> labels.forEach(start -> labels.forEach(end -> {
            String startLabel = start.name();
            String endLabel = end.name();
            String relType = type.name();
            if (vRels.containsKey(Pattern.of(startLabel, relType, endLabel))) {
                return;
            }
            long relCountOut = subGraph.countsForRelationship((Label)start, (RelationshipType)type);
            if (relCountOut == 0L) {
                return;
            }
            long relCountIn = subGraph.countsForRelationship((RelationshipType)type, (Label)end);
            if (relCountIn > 0L) {
                Node startNode = (Node)vNodes.get(startLabel);
                Node endNode = (Node)vNodes.get(endLabel);
                long global = subGraph.countsForRelationship((RelationshipType)type);
                Relationship vRel = new VirtualRelationship(startNode, endNode, (RelationshipType)type).withProperties(MapUtil.map("type", relType, "out", relCountOut, "in", relCountIn, "count", global));
                vRels.put(Pattern.of(startLabel, relType, endLabel), vRel);
            }
        })));
        if (removeMissing) {
            this.filterNonExistingRelationships(vRels, metaConfig);
        }
        GraphResult graphResult = new GraphResult(new ArrayList<Node>(vNodes.values()), new ArrayList<Relationship>(vRels.values()));
        return Stream.of(graphResult);
    }

    private void filterNonExistingRelationships(Map<Pattern, Relationship> vRels, SampleMetaConfig metaConfig) {
        Set<Pattern> rels = vRels.keySet();
        HashMap<Pair<String, String>, Set<Pattern>> aggregated = new HashMap<Pair<String, String>, Set<Pattern>>();
        for (Pattern rel : rels) {
            this.combine(aggregated, Pair.of(rel.from, rel.type), rel);
            this.combine(aggregated, Pair.of(rel.type, rel.to), rel);
        }
        aggregated.values().stream().filter(c -> c.size() > 1).flatMap(Collection::stream).filter(p -> !this.relationshipExistsWithDegreeCheck((Pattern)p, (Relationship)vRels.get(p), metaConfig)).forEach(vRels::remove);
    }

    private boolean relationshipExistsWithDegreeCheck(Pattern p, Relationship relationship, SampleMetaConfig metaConfig) {
        double degreeTo;
        if (relationship == null) {
            return false;
        }
        double degreeFrom = (double)((Long)relationship.getProperty("out")).longValue() / (double)((Long)relationship.getStartNode().getProperty("count")).longValue();
        if (degreeFrom < (degreeTo = (double)((Long)relationship.getProperty("in")).longValue() / (double)((Long)relationship.getEndNode().getProperty("count")).longValue())) {
            return Meta.relationshipExists(this.tx, p.labelFrom(), p.labelTo(), p.relationshipType(), Direction.OUTGOING, metaConfig);
        }
        return Meta.relationshipExists(this.tx, p.labelTo(), p.labelFrom(), p.relationshipType(), Direction.INCOMING, metaConfig);
    }

    static boolean relationshipExists(Transaction tx, Label labelFromLabel, Label labelToLabel, RelationshipType relationshipType, Direction direction, SampleMetaConfig metaConfig) {
        try (ResourceIterator nodes = tx.findNodes(labelFromLabel);){
            long skipCount;
            long count = 0L;
            long l = skipCount = metaConfig.getSample() > 0L ? metaConfig.getSample() : 1L;
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                if (count % skipCount == 0L) {
                    long maxRels = metaConfig.getMaxRels();
                    for (Relationship rel : node.getRelationships(direction, new RelationshipType[]{relationshipType})) {
                        Node otherNode;
                        Node node2 = otherNode = direction == Direction.OUTGOING ? rel.getEndNode() : rel.getStartNode();
                        if (otherNode.hasLabel(labelToLabel)) {
                            boolean bl = true;
                            return bl;
                        }
                        if (maxRels == -1L || maxRels-- != 0L) continue;
                        break;
                    }
                }
                ++count;
            }
        }
        return false;
    }

    private void combine(Map<Pair<String, String>, Set<Pattern>> aggregated, Pair<String, String> p, Pattern rel) {
        if (!aggregated.containsKey(p)) {
            aggregated.put(p, new HashSet());
        }
        aggregated.get(p).add(rel);
    }

    @NotThreadSafe
    @Procedure(value="apoc.meta.graphSample")
    @Description(value="Examines the full graph and returns a meta-graph.\nUnlike `apoc.meta.graph`, this procedure does not filter away non-existing paths.")
    public Stream<GraphResult> graphSample(@Name(value="config", defaultValue="{}") @Deprecated Map<String, Object> config) {
        return this.metaGraph(DatabaseSubGraph.optimizedForCount(this.transaction, this.kernelTx), null, null, false, new SampleMetaConfig(null));
    }

    @NotThreadSafe
    @Procedure(value="apoc.meta.subGraph")
    @Description(value="Examines the given sub-graph and returns a meta-graph.")
    public Stream<GraphResult> subGraph(@Name(value="config") Map<String, Object> config) {
        MetaConfig metaConfig = new MetaConfig(config, false);
        return this.filterResultStream(metaConfig.getExcludeLabels(), this.metaGraph(DatabaseSubGraph.optimizedForCount(this.transaction, this.kernelTx), metaConfig.getIncludeLabels(), metaConfig.getIncludeRels(), true, metaConfig.getSampleMetaConfig()));
    }

    private Stream<GraphResult> filterResultStream(Set<String> excludes, Stream<GraphResult> graphResultStream) {
        if (excludes == null || excludes.isEmpty()) {
            return graphResultStream;
        }
        return graphResultStream.map(gr -> {
            Iterator<Node> it = gr.nodes.iterator();
            while (it.hasNext()) {
                Node node = it.next();
                if (!this.containsLabelName(excludes, node)) continue;
                it.remove();
            }
            Iterator<Relationship> it2 = gr.relationships.iterator();
            while (it2.hasNext()) {
                Relationship relationship = it2.next();
                if (!excludes.contains(relationship.getType().name()) && !this.containsLabelName(excludes, relationship.getStartNode()) && !this.containsLabelName(excludes, relationship.getEndNode())) continue;
                it2.remove();
            }
            return gr;
        });
    }

    private boolean containsLabelName(Set<String> excludes, Node node) {
        for (Label label : node.getLabels()) {
            if (!excludes.contains(label.name())) continue;
            return true;
        }
        return false;
    }

    private Node mergeMetaNode(Label label, Map<String, Node> labels, long increment) {
        String name = label.name();
        Node vNode = labels.get(name);
        if (vNode == null) {
            vNode = new VirtualNode(new Label[]{label}, Collections.singletonMap("name", name));
            labels.put(name, vNode);
        }
        if (increment > 0L) {
            vNode.setProperty("count", (Object)(((Number)vNode.getProperty("count", (Object)0L)).longValue() + increment));
        }
        return vNode;
    }

    private static /* synthetic */ Map.Entry lambda$schema$10(Collection commonKeys, Map.Entry e) {
        String key = (String)e.getKey();
        return commonKeys.contains(key) ? new AbstractMap.SimpleEntry(String.format("%s (%s)", key, Types.RELATIONSHIP.name()), e.getValue()) : e;
    }

    public static class MetaStats {
        public final long labelCount;
        public final long relTypeCount;
        public final long propertyKeyCount;
        public final long nodeCount;
        public final long relCount;
        public final Map<String, Long> labels;
        public final Map<String, Long> relTypes;
        public final Map<String, Long> relTypesCount;
        public final Map<String, Object> stats;

        public MetaStats(long labelCount, long relTypeCount, long propertyKeyCount, long nodeCount, long relCount, Map<String, Long> labels, Map<String, Long> relTypes, Map<String, Long> relTypesCount) {
            this.labelCount = labelCount;
            this.relTypeCount = relTypeCount;
            this.propertyKeyCount = propertyKeyCount;
            this.nodeCount = nodeCount;
            this.relCount = relCount;
            this.labels = labels;
            this.relTypes = relTypes;
            this.relTypesCount = relTypesCount;
            this.stats = MapUtil.map("labelCount", labelCount, "relTypeCount", relTypeCount, "propertyKeyCount", propertyKeyCount, "nodeCount", nodeCount, "relCount", relCount, "labels", labels, "relTypes", relTypes);
        }
    }

    static interface StatsCallback {
        public void label(String var1, long var2);

        public void rel(String var1, long var2);

        public void rel(String var1, String var2, long var3, long var5);
    }

    private record MetadataKey(Types type, String key) {
    }

    public static class MetaItem
    extends MetaResult {
        public long leftCount;
        public long rightCount;

        public MetaItem addLabel(String label) {
            this.otherLabels.add(label);
            return this;
        }

        public MetaItem(String label, String name) {
            this.label = label;
            this.property = name;
        }

        public MetaItem inc() {
            ++this.count;
            return this;
        }

        public MetaItem rel(long out, long in) {
            this.type = Types.RELATIONSHIP.name();
            if (out > 1L) {
                this.array = true;
            }
            this.leftCount += out;
            this.rightCount += in;
            this.left = this.leftCount / this.count;
            this.right = this.rightCount / this.count;
            return this;
        }

        public MetaItem other(List<String> labels) {
            for (String l : labels) {
                if (this.other.contains(l)) continue;
                this.other.add(l);
            }
            return this;
        }

        public MetaItem type(String type) {
            this.type = type;
            return this;
        }

        public MetaItem array(boolean array) {
            this.array = array;
            return this;
        }

        public MetaItem elementType(String elementType) {
            switch (elementType) {
                case "NODE": {
                    this.elementType = "node";
                    break;
                }
                case "RELATIONSHIP": {
                    this.elementType = "relationship";
                }
            }
            return this;
        }
    }

    static class Pattern {
        private final String from;
        private final String type;
        private final String to;

        private Pattern(String from, String type, String to) {
            this.from = from;
            this.type = type;
            this.to = to;
        }

        public static Pattern of(String labelFrom, String type, String labelTo) {
            return new Pattern(labelFrom, type, labelTo);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Pattern) {
                Pattern pattern = (Pattern)o;
                return this.from.equals(pattern.from) && this.type.equals(pattern.type) && this.to.equals(pattern.to);
            }
            return false;
        }

        public int hashCode() {
            return 31 * (31 * this.from.hashCode() + this.type.hashCode()) + this.to.hashCode();
        }

        public Label labelTo() {
            return Label.label((String)this.to);
        }

        public Label labelFrom() {
            return Label.label((String)this.from);
        }

        public RelationshipType relationshipType() {
            return RelationshipType.withName((String)this.type);
        }
    }

    public static class MetaResult {
        public String label;
        public String property;
        public long count;
        public boolean unique;
        public boolean index;
        public boolean existence;
        public String type;
        public boolean array;
        public List<Object> sample;
        public long left;
        public long right;
        public List<String> other = new ArrayList<String>();
        public List<String> otherLabels = new ArrayList<String>();
        public String elementType;
    }
}

