/*
 * Decompiled with CFR 0.152.
 */
package apoc.math;

class SimpleRegression {
    private double sumXX = 0.0;
    private double sumYY = 0.0;
    private double sumXY = 0.0;
    private long n = 0L;

    SimpleRegression() {
    }

    public void addData(double x, double y) {
        this.sumXX += x * x;
        this.sumYY += y * y;
        this.sumXY += x * y;
        ++this.n;
    }

    public double getSlope() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        if (Math.abs(this.sumXX) < 4.9E-323) {
            return Double.NaN;
        }
        return this.sumXY / this.sumXX;
    }

    public double getSumSquaredErrors() {
        return Math.max(0.0, this.sumYY - this.sumXY * this.sumXY / this.sumXX);
    }

    public double getTotalSumSquares() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        return this.sumYY;
    }

    public double getR() {
        double b1 = this.getSlope();
        double result = Math.sqrt(this.getRSquare());
        if (b1 < 0.0) {
            result = -result;
        }
        return result;
    }

    public double getRSquare() {
        double ssto = this.getTotalSumSquares();
        return (ssto - this.getSumSquaredErrors()) / ssto;
    }
}

